!--------------------------------------------------------------------------------------------------------------------------------
!
!   This file contains database updates used by the INTEGRA 9500.
!
!   Lines beginning with an exclamation marks (!) are comments.
!
!   The word VERSION is special and must appear in the far left column and must be uppercase.
!   It is followed by the software version number x.y.z.  Any SQL commands that follow it are
!   applied if the database version is earlier.
!
!   Once processed, the database version updated.
!
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     0.0.0

Create Table ApplicationIdentifiers
(
    ApplicationIdentifier   Text,
    Element                 Integer,
    Format                  Text,
    Description             Text,
    Primary Key             (ApplicationIdentifier, Element)
);

Create Table Applications
(
    ApplicationName         Text,
    SectorID                Integer,
    X1                      Integer,
    Y1                      Integer,
    X2                      Integer,
    Y2                      Integer,
    Primary Key             (ApplicationName, SectorID)
);

Create Table AuditTrail
(
    LclTime                 DateTime,
    GmtTime                 DateTime,
    OperatorID              Text,
    Message                 LongText
);

Create Table Calibration
(
    SerialNumber            Integer,
    CalibrationOk           Bit,
    BlackPixels             Image,
    WhitePixels             Image,
    GrayScaleFactor         Integer,
    GrayScaleOffset         Integer,
    MilsPerPixel            Real,
    LensSize                Real,
    LastCalDate             DateTime,
    Primary Key             (SerialNumber)
);

Create Table CalibrationHistory
(
    LclTime                 DateTime,
    GmtTime                 DateTime,
    OperatorID              Text,
    OperatorName            Text,
    Exposure                Real,
    Decodability            Text,
    Contrast                Text,
    Modulation              Text,
    Rmax                    Text,
    Vavg                    Text
);

Create Table Glossary
(
    Entry                   Text,
    Description             LongText,
    Primary Key             (Entry)
);

Create Table IsoCountries
(
    Code                    Text,
    Country                 Text,
    Primary Key             (Code)
);

Create Table IsoCurrencies
(
    Code                    Text,
    CurrencyName            Text,
    Primary Key             (Code)
);

Create Table Operators
(
    OperatorID              Text,
    OperatorName            Text,
    EncryptedPassword       Integer,
    Permissions             Integer,
    Primary Key             (OperatorID)
);

Create Table ProductLookup
(
    DecodedText             Text,
    Description             Text,
    Primary Key             (DecodedText)
);

Create Table ReleaseDetails
(
    Version                 Text,
    Comment                 LongText
);

Create Table ReleaseVersions
(
    Version                 Text,
    ReleaseDate             DateTime,
    Primary Key             (Version)
);

Create Table ReportData
(
    ReportID                Integer,
    Category                Integer,
    Sequence                Integer,
    ParameterName           Text,
    ParameterValue          LongText,
    Primary Key             (ReportID, Category, Sequence)
);

Create Table Reports
(
    ReportID                Integer,
    SectorID                Text,           ! not Integer in order to allow "All" and "Unknown"
    LclTime                 DateTime,
    GmtTime                 DateTime,
    X1                      Integer,
    Y1                      Integer,
    SizeX                   Integer,
    SizeY                   Integer,
    Thumbnail               Image,
    Primary Key             (ReportID)
);

Create Table Settings
(
    Category                Text,
    SettingName             Text,
    SettingValue            LongText,
    Primary Key             (Category, SettingName)
);


Alter Table ReleaseDetails  Add Constraint VersionLink      Foreign Key (Version)   References ReleaseVersions  (Version);
Alter Table ReportData      Add Constraint ParmatersLink    Foreign Key (ReportID)  References Reports          (ReportID);


Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("00"  , 0, ""      , "Indentification of a Logistic Unit");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("00"  , 1, "K18"   , "Serial Shipping Container Code (SSCC)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("01"  , 0, ""      , "Identification of a Fixed Measure Trade Item (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("01"  , 1, "K14"   , "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("019" , 0, ""      , "Identification of a Variable Measure Trade Item (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("019" , 1, "K14"   , "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("02"  , 0, ""      , "Identification of Trade Items Contained in a Logistic Unit - Fixed Measure");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("02"  , 1, "K14"   , "GTIN of the Contained Trade Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("029" , 0, ""      , "Identification of Trade Items Contained in a Logistic Unit - Variable Measure");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("029" , 1, "K14"   , "GTIN of the Contained Trade Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("10"  , 0, ""      , "Batch or Lot Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("10"  , 1, "X1-20" , "Batch or Lot Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("11"  , 0, ""      , "Production Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("11"  , 1, "D6"    , "Production Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("12"  , 0, ""      , "Due Date for Amount on Payment Slip");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("12"  , 1, "D6"    , "Due Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("13"  , 0, ""      , "Packaging Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("13"  , 1, "D6"    , "Packaging Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("15"  , 0, ""      , "Best Before Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("15"  , 1, "D6"    , "Best Before Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("17"  , 0, ""      , "Expiration Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("17"  , 1, "D6"    , "Expiration Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("20"  , 0, ""      , "Product Variant");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("20"  , 1, "N2"    , "Variant Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("21"  , 0, ""      , "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("21"  , 1, "X1-20" , "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("22"  , 0, ""      , "Secondary Data for Specific Health Industry Products");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("22"  , 1, "X1-29" , "Secondary Data Fileds (For Legacy Apps)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("23"  , 0, ""      , "Lot Number (Transitional Use)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("23"  , 1, "X1-20" , "Lot Number (Transitional Use)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("240" , 0, ""      , "Additional Product Identification Assigned by the Manufacturer");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("240" , 1, "X1-30" , "Addional Item Identification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("241" , 0, ""      , "Customer Part Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("241" , 1, "X1-30" , "Customer Part Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("250" , 0, ""      , "Secondary Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("250" , 1, "X1-30" , "Secondary Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("251" , 0, ""      , "Reference to Source Entity");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("251" , 1, "X1-30" , "Reference to Source Entity");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("252" , 0, ""      , "Global Identifier Serialised for Trade (GIST) ");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("252" , 1, "K30"   , "Global Identifier Serialised for Trade (GIST) ");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("30"  , 0, ""      , "Variable Count");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("30"  , 1, "N1-8"  , "Count of Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("310" , 0, ""      , "Trade Measure - Net weight (Kilograms)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("310" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("310" , 2, "N6"    , "Net weight (Kilograms)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("311" , 0, ""      , "Trade Measure - Length or first dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("311" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("311" , 2, "N6"    , "Length or first dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("312" , 0, ""      , "Trade Measure - Width, diameter, or second dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("312" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("312" , 2, "N6"    , "Width, diameter, or second dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("313" , 0, ""      , "Trade Measure - Depth, thickness, height, or third dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("313" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("313" , 2, "N6"    , "Depth, thickness, height, or third dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("314" , 0, ""      , "Trade Measure - Area (Square metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("314" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("314" , 2, "N6"    , "Area (Square metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("315" , 0, ""      , "Trade Measure - Net volume (Litres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("315" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("315" , 2, "N6"    , "Net volume (Litres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("316" , 0, ""      , "Trade Measure - Net volume (Cubic metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("316" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("316" , 2, "N6"    , "Net volume (Cubic metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("320" , 0, ""      , "Trade Measure - Net weight (Pounds)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("320" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("320" , 2, "N6"    , "Net weight (Pounds)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("321" , 0, ""      , "Trade Measure - Length or first dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("321" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("321" , 2, "N6"    , "Length or first dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("322" , 0, ""      , "Trade Measure - Length or first dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("322" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("322" , 2, "N6"    , "Length or first dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("323" , 0, ""      , "Trade Measure - Length or first dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("323" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("323" , 2, "N6"    , "Length or first dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("324" , 0, ""      , "Trade Measure - Width, diameter, or second dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("324" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("324" , 2, "N6"    , "Width, diameter, or second dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("325" , 0, ""      , "Trade Measure - Width, diameter, or second dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("325" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("325" , 2, "N6"    , "Width, diameter, or second dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("326" , 0, ""      , "Trade Measure - Width, diameter, or second dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("326" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("326" , 2, "N6"    , "Width, diameter, or second dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("327" , 0, ""      , "Trade Measure - Depth, thickness, height, or third dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("327" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("327" , 2, "N6"    , "Depth, thickness, height, or third dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("328" , 0, ""      , "Trade Measure - Depth, thickness, height, or third dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("328" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("328" , 2, "N6"    , "Depth, thickness, height, or third dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("329" , 0, ""      , "Trade Measure - Depth, thickness, height, or third dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("329" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("329" , 2, "N6"    , "Depth, thickness, height, or third dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("350" , 0, ""      , "Trade Measure - Area (Square inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("350" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("350" , 2, "N6"    , "Area (Square inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("351" , 0, ""      , "Trade Measure - Area (Square feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("351" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("351" , 2, "N6"    , "Area (Square feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("352" , 0, ""      , "Trade Measure - Area (Square yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("352" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("352" , 2, "N6"    , "Area (Square yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("356" , 0, ""      , "Trade Measure - Net weight (Troy ounces)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("356" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("356" , 2, "N6"    , "Net weight (Troy ounces)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("357" , 0, ""      , "Trade Measure - Net weight (or volume) (Ounces)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("357" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("357" , 2, "N6"    , "Net weight (or volume) (Ounces)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("360" , 0, ""      , "Trade Measure - Net volume (Quarts)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("360" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("360" , 2, "N6"    , "Net volume (Quarts)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("361" , 0, ""      , "Trade Measure - Net volume (Gallons (U.S.))");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("361" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("361" , 2, "N6"    , "Net volume (Gallons (U.S.))");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("364" , 0, ""      , "Trade Measure - Net volume (Cubic inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("364" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("364" , 2, "N6"    , "Net volume (Cubic inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("365" , 0, ""      , "Trade Measure - Net volume (Cubic feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("365" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("365" , 2, "N6"    , "Net volume (Cubic feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("366" , 0, ""      , "Trade Measure - Net volume (Cubic yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("366" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("366" , 2, "N6"    , "Net volume (Cubic yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("330" , 0, ""      , "Logistic Measure - Logistic weight (Kilograms)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("330" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("330" , 2, "N6"    , "Logistic weight (Kilograms)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("331" , 0, ""      , "Logistic Measure - Length or first dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("331" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("331" , 2, "N6"    , "Length or first dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("332" , 0, ""      , "Logistic Measure - Width, diameter, or second dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("332" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("332" , 2, "N6"    , "Width, diameter, or second dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("333" , 0, ""      , "Logistic Measure - Depth, thickness, height, or third dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("333" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("333" , 2, "N6"    , "Depth, thickness, height, or third dimension (Metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("334" , 0, ""      , "Logistic Measure - Area (Square metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("334" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("334" , 2, "N6"    , "Area (Square metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("335" , 0, ""      , "Logistic Measure - Logistic volume (Litres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("335" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("335" , 2, "N6"    , "Logistic volume (Litres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("336" , 0, ""      , "Logistic Measure - Logistic volume (Cubic metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("336" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("336" , 2, "N6"    , "Logistic volume (Cubic metres)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("340" , 0, ""      , "Logistic Measure - Logistic weight (Pounds)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("340" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("340" , 2, "N6"    , "Logistic weight (Pounds)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("341" , 0, ""      , "Logistic Measure - Length or first dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("341" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("341" , 2, "N6"    , "Length or first dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("342" , 0, ""      , "Logistic Measure - Length or first dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("342" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("342" , 2, "N6"    , "Length or first dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("343" , 0, ""      , "Logistic Measure - Length or first dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("343" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("343" , 2, "N6"    , "Length or first dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("344" , 0, ""      , "Logistic Measure - Width, diameter, or second dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("344" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("344" , 2, "N6"    , "Width, diameter, or second dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("345" , 0, ""      , "Logistic Measure - Width, diameter, or second dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("345" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("345" , 2, "N6"    , "Width, diameter, or second dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("346" , 0, ""      , "Logistic Measure - Width, diameter, or second dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("346" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("346" , 2, "N6"    , "Width, diameter, or second dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("347" , 0, ""      , "Logistic Measure - Depth, thickness, height, or third dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("347" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("347" , 2, "N6"    , "Depth, thickness, height, or third dimension (Inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("348" , 0, ""      , "Logistic Measure - Depth, thickness, height, or third dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("348" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("348" , 2, "N6"    , "Depth, thickness, height, or third dimension (Feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("349" , 0, ""      , "Logistic Measure - Depth, thickness, height, or third dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("349" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("349" , 2, "N6"    , "Depth, thickness, height, or third dimension (Yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("353" , 0, ""      , "Logistic Measure - Area (Square inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("353" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("353" , 2, "N6"    , "Area (Square inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("354" , 0, ""      , "Logistic Measure - Area (Square feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("354" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("354" , 2, "N6"    , "Area (Square feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("355" , 0, ""      , "Logistic Measure - Area (Square yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("355" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("355" , 2, "N6"    , "Area (Square yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("362" , 0, ""      , "Logistic Measure - Logistic volume (Quarts)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("362" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("362" , 2, "N6"    , "Logistic volume (Quarts)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("363" , 0, ""      , "Logistic Measure - Logistic volume (Gallons (U.S.))");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("363" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("363" , 2, "N6"    , "Logistic volume (Gallons (U.S.))");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("367" , 0, ""      , "Logistic Measure - Logistic volume (Cubic inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("367" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("367" , 2, "N6"    , "Logistic volume (Cubic inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("368" , 0, ""      , "Logistic Measure - Logistic volume (Cubic feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("368" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("368" , 2, "N6"    , "Logistic volume (Cubic feet)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("369" , 0, ""      , "Logistic Measure - Logistic volume (Cubic yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("369" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("369" , 2, "N6"    , "Logistic volume (Cubic yards)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("337" , 0, ""      , "Kilograms Per Square Metre");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("337" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("337" , 2, "N6"    , "Kilograms Per Square Metre");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("37"  , 0, ""      , "Count of Trade Items Contained in a Logistic Unit");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("37"  , 1, "N1-6"  , "Count of Trade Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("390" , 0, ""      , "Amount Payable - Single Monetary Area");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("390" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("390" , 2, "N1-15" , "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391" , 0, ""      , "Amount Payable and ISO CurrencyName Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391" , 2, "M3"    , "ISO CurrencyName Code & Country & CurrencyName");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391" , 3, "N4-18" , "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("392" , 0, ""      , "Amount Payable for a Variable Measure Trade Item ?Single Monetary Area");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("392" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("392" , 2, "N1-15" , "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393" , 0, ""      , "Amount Payable for a Variable Measure Trade Item and ISO CurrencyName Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393" , 2, "M3"    , "ISO CurrencyName Code & Country & CurrencyName");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393" , 3, "N4-18" , "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("400" , 0, ""      , "Customer's Purchase Order Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("400" , 1, "X1-30" , "Customer's Purchase Order Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("401" , 0, ""      , "Consignment Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("401" , 1, "X1-30" , "Consignment Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("402" , 0, ""      , "Shipment Identification Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("402" , 1, "K17"   , "Shipment Identification Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("403" , 0, ""      , "Routing Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("403" , 1, "X1-30" , "Routing Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("410" , 0, ""      , "Ship to - Deliver to EAN.UCC Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("410" , 1, "K13"   , "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("411" , 0, ""      , "Bill to - Invoice to EAN.UCC Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("411" , 1, "K13"   , "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("412" , 0, ""      , "Purchased from EAN.UCC Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("412" , 1, "K13"   , "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("413" , 0, ""      , "Ship for - Deliver for - Forward to EAN.UCC Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("413" , 1, "K13"   , "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("414" , 0, ""      , "Identification of a Physical Location - EAN.UCC Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("414" , 1, "K13"   , "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("415" , 0, ""      , "EAN.UCC Global Location Number of the Invoicing Party");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("415" , 1, "K13"   , "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("420" , 0, ""      , "Ship to - Deliver to Postal Code Within a Single Postal Authority");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("420" , 1, "X1-20" , "Postal Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("421" , 0, ""      , "Ship to - Deliver to Postal Code with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("421" , 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("421" , 2, "X4-12" , "Postal Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("422" , 0, ""      , "Country of Origin of a Trade Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("422" , 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("423" , 0, ""      , "Country of Initial Processing");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("423" , 1, "Y3-15" , "ISO Country Code(s) & Countries");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("424" , 0, ""      , "Country of Processing");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("424" , 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("425" , 0, ""      , "Country of Disassembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("425" , 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("426" , 0, ""      , "Country Covering full Process Chain");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("426" , 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7001", 0, ""      , "NATO Stock Number (NSN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7001", 1, "N13"   , "NATO Stock Number (NSN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7002", 0, ""      , "UN/ECE Meat Carcasses and Cuts Classification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7002", 1, "X1-30" , "UN/ECE Product Classification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7030", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7030", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7030", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7031", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7031", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7031", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7032", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7032", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7032", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7033", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7033", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7033", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7034", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7034", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7034", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7035", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7035", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7035", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7036", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7036", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7036", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7037", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7037", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7037", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7038", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7038", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7038", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7039", 0, ""      , "Approval Number of Processor with Three-Digit ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7039", 1, "Y3"    , "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7039", 2, "X4-30" , "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 0, ""      , "Roll Products - Width, Length, Core Diameter, Direction, Splices");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 1, "N4"    , "Slit Width in milimetres");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 2, "N5"    , "Actual Length in Metres");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 3, "N3"    , "Internal Core Diameter in Milimetres");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 4, "N1"    , "Winding Direction (Face out = 0, Face in = 1, Undefined = 9)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 5, "N1"    , "Number of Splices (0 to 8 = Actual Number, 9 = Unknown)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8002", 0, ""      , "Cellular Mobile Telephone Identifier");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8002", 1, "X1-20" , "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 0, ""      , "EAN.UCC Global Returnable Asset Identifier (GRAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 1, "K14"   , "Global Returnable Asset Identifier (GRAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 2, "X0-15" , "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8004", 0, ""      , "EAN.UCC Global Individual Asset Identifier (GIAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8004", 1, "X1-30" , "Global Individual Asset Identifier (GIAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8005", 0, ""      , "Price Per Unit of Measure");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8005", 1, "N6"    , "Price Per Unit of Measure");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 0, ""      , "Identification of the Components of a Trade Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 1, "N14"   , "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 2, "N2"    , "Relative Number of Components Within the Assembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 3, "N2"    , "Total Number of Components in the Assembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8007", 0, ""      , "International Bank Account Number (IBAN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8007", 1, "X1-30" , "International Bank Account Number (IBAN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8008", 0, ""      , "Date and Time of Production");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8008", 1, "D8-12" , "Date and Time of Production");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 0, ""      , "EAN.UCC Global Service Relation Number (GSRN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 1, "K18"   , "Global Service Relation Number (GSRN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8020", 0, ""      , "Payment Slip Reference Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8020", 1, "X1-25" , "Payment Slip Reference Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 0, ""      , "UCC/EAN-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 1, "N1"    , "UCC Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 2, "N5"    , "Offer Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 0, ""      , "UCC/EAN-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 1, "N1"    , "UCC Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 2, "N5"    , "Offer Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 3, "D4"    , "Expiration Date (MMYY)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 0, ""      , "UCC/EAN-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 1, "N1"    , "UCC Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("90"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("90"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("91"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("91"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("92"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("92"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("93"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("93"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("94"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("94"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("95"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("95"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("96"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("96"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("97"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("97"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("98"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("98"  , 1, "X1-30" , "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("99"  , 0, ""      , "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("99"  , 1, "X1-30" , "Data Field");

Insert Into Glossary (Entry, Description) Values
(
    "AG",
    "This is the Average Grade.  This is somewhat harsher than a true average.  It uses the following 5 Values: L1, L2, QZL1, QZL2, and OCTASA."
);

Insert Into Glossary (Entry, Description) Values
(
    "Axial nonuniformity",
    "This measures how the X-axis grid is different from the Y-axis grid."
);

Insert Into Glossary (Entry, Description) Values
(
    "Blemish",
    "A blemish is an unwanted mark or void that causes any part of a barcode symbol to not be decodable."
);

Insert Into Glossary (Entry, Description) Values
(
    "Cell height",
    "This is the average height of a module in mils."
);

Insert Into Glossary (Entry, Description) Values
(
    "Cell size",
    "This is the average size of a module in mils."
);

Insert Into Glossary (Entry, Description) Values
(
    "Cell width",
    "This is the average width of a module in mils."
);

Insert Into Glossary (Entry, Description) Values
(
    "Contrast",
    "This is the difference between the highest and the lowest reflectance Values found within a barcode symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Corrections",
    "This is the number of codewords that had to be corrected.  This may be smaller than the actual number of modules that are in error.  For example, if two errors occur in the same codeword, then corrections will be 1 since only one codeword had to be corrected.  The fact that it contained two bit errors does not matter."
);

Insert Into Glossary (Entry, Description) Values
(
    "CTR",
    "This is the Clock Track Regularity.  This is the best modulation limit that causes no more than 2 errors in a consecutive set of 5 modules.  This value shown is the worst one seen for the entire symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Data CW",
    "This is the number of codewords that contain user data.  All other codewords are used for error correction."
);

Insert Into Glossary (Entry, Description) Values
(
    "Decodability",
    "This is a measurement of printing accuracy.  Software measures the difference between a perfect barcode image and the actual image.  This is a measurement of time."
);

Insert Into Glossary (Entry, Description) Values
(
    "Decode",
    "This specifies whether or not the computer could determine the information encoded in the barcode symbol.  The number located to the right is the number of successful decodes achieved within the area of interest."
);

Insert Into Glossary (Entry, Description) Values
(
    "Defects",
    "Defects are a measurement of deviation in contrast found within a bar / space element.  In order to detect a defect error, the barcode symbol must be decodable."
);

Insert Into Glossary (Entry, Description) Values
(
    "Edge Determ",
    "A barcode symbol is made up of many bar / space elements.  The edge of a bar / space element is determined to be the midpoint between a bar / space transition.  If more than one bar / space transition exists between adjoining elements, then the barcode image would fail for Edge Determination."
);

Insert Into Glossary (Entry, Description) Values
(
    "Eff Aperture Ref",
    "Software will automatically choose one of the following 5 different aperture sizes: 03mm, 05mm, 06mm, 10mm, and 20mm.  The one selected depends upon whether ISO or General EAN/UCC has been selected, and also the symbology and the X dimension of the symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Fixed pattern damage",
    "This is the worst of the following: L1, L2, QZL1, QZL2, OCTASA, and AG."
);

Insert Into Glossary (Entry, Description) Values
(
    "Grid nonuniformity",
    "This is the largest distance between the actual center of a module and the ideal center of a module."
);

Insert Into Glossary (Entry, Description) Values
(
    "GT",
    "The global threshold (GT) is half-way between the minimum (Rmin) and the maximum (Rmax)."
);

Insert Into Glossary (Entry, Description) Values
(
    "L1",
    "This is the grade of the left portion of the solid L-shaped finder pattern.  The number of modules is equal to the size of the symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "L2",
    "This is the grade of the bottom portion of the solid L-shaped finder pattern."
);

Insert Into Glossary (Entry, Description) Values
(
    "Min Reflect",
    "The lowest reflectance value within a barcode symbol must be no more than half of the highest reflectance value within a barcode symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Minimum EC",
    "The lowest edge contrast within a barcode symbol must be at least 15% in order to pass."
);

Insert Into Glossary (Entry, Description) Values
(
    "Modulation",
    "This is ratio of the minimum edge contrast to the symbol contrast."
);

Insert Into Glossary (Entry, Description) Values
(
    "OCTASA",
    "This is the Overall Clock Track and Adjacent Solid Area.  This is the worst of the following: TR (converted to a grade), CTR, and SFP."
);

Insert Into Glossary (Entry, Description) Values
(
    "Quiet zone",
    "The quiet zone is an area to the left and right of the barcode that must remain clear of any marks.  Usually, this area is 10 times the X dimension, but the actual number depends upon the symbology."
);

Insert Into Glossary (Entry, Description) Values
(
    "QZL1",
    "This is the quiet zone to the left of L1.  It also includes the module above and left of the top-most module in L1.  It also include the module below and left of the bottom-most module in L1."
);

Insert Into Glossary (Entry, Description) Values
(
    "QZL2",
    "This is the quiet zone below L2.  It also includes the module below and left of the left-most module in L2.  It also includes the module below and right of the right-most module in L2."
);

Insert Into Glossary (Entry, Description) Values
(
    "Rmin",
    "This is the smallest reflectance value seen throughout the barcode."
);

Insert Into Glossary (Entry, Description) Values
(
    "Rmax",
    "This is the largest reflectance value seen throughout the barcode."
);

Insert Into Glossary (Entry, Description) Values
(
    "SFP",
    "This is the Solid Fixed Pattern.  This is the worst value seen for the entire symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Symbology",
    "Here is a list of supported symbologies: Code 39, ITF (I 2 of 5), EAN/UCC-128, Code 128, Codabar, UCC-12 (UPC-A), UPC-E, EAN/UCC-8, EAN/UCC-13, RSS-14 (linear), RSS-stacked, RSS-limited, RSS-CCA, CCB, CCC, Pharmacode, PDF-417, Data Matrix ECC-200 (104x104 max), Data Matrix ECC-200 rectangular, PDF417, Micro-PDF417."
);

Insert Into Glossary (Entry, Description) Values
(
    "Total CW",
    "This is the total number of codewords in the symbol.  Each codeword consists of 8 modules (bits).  Usually, all of the modules for a codeword are located near each other, but there are exceptions."
);

Insert Into Glossary (Entry, Description) Values
(
    "TR",
    "This is the Transition Ratio.  This is the worst value seen for the entire symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Unused EC",
    "This is the amount of Unused Error Correction in %.  100% means no error correction was used.  This number is determined from the formula: UEC = 100 - 100 * Corrections / (Total CW - Data CW)."
);

Insert Into Glossary (Entry, Description) Values
(
    "X print growth",
    "This measures the ratio of the width of the dark cells to the width of the light cells.  50% means they are the same."
);

Insert Into Glossary (Entry, Description) Values
(
    "Xdim",
    "This is the size of the smallest element (1X) in the symbol."
);

Insert Into Glossary (Entry, Description) Values
(
    "Y print growth",
    "This measures the ratio of the height of the dark cells to the height of the light cells."
);

Insert Into IsoCountries (Code, Country) Values ("004", "Afghanistan");
Insert Into IsoCountries (Code, Country) Values ("008", "Albania");
Insert Into IsoCountries (Code, Country) Values ("010", "Antarctica");
Insert Into IsoCountries (Code, Country) Values ("012", "Algeria");
Insert Into IsoCountries (Code, Country) Values ("016", "American Samoa");
Insert Into IsoCountries (Code, Country) Values ("020", "Andorra");
Insert Into IsoCountries (Code, Country) Values ("024", "Angola");
Insert Into IsoCountries (Code, Country) Values ("028", "Antigua and Barbuda");
Insert Into IsoCountries (Code, Country) Values ("031", "Azerbaijan");
Insert Into IsoCountries (Code, Country) Values ("032", "Argentina");
Insert Into IsoCountries (Code, Country) Values ("036", "Australia");
Insert Into IsoCountries (Code, Country) Values ("040", "Austria");
Insert Into IsoCountries (Code, Country) Values ("044", "Bahamas");
Insert Into IsoCountries (Code, Country) Values ("048", "Bahrain");
Insert Into IsoCountries (Code, Country) Values ("050", "Bangladesh");
Insert Into IsoCountries (Code, Country) Values ("051", "Armenia");
Insert Into IsoCountries (Code, Country) Values ("052", "Barbados");
Insert Into IsoCountries (Code, Country) Values ("056", "Belgium");
Insert Into IsoCountries (Code, Country) Values ("060", "Bermuda");
Insert Into IsoCountries (Code, Country) Values ("064", "Bhutan");
Insert Into IsoCountries (Code, Country) Values ("068", "Bolivia");
Insert Into IsoCountries (Code, Country) Values ("070", "Bosnia and Herzegovina");
Insert Into IsoCountries (Code, Country) Values ("072", "Botswana");
Insert Into IsoCountries (Code, Country) Values ("074", "Bouvet Island");
Insert Into IsoCountries (Code, Country) Values ("076", "Brazil");
Insert Into IsoCountries (Code, Country) Values ("084", "Belize");
Insert Into IsoCountries (Code, Country) Values ("086", "British Indian Ocean Territory");
Insert Into IsoCountries (Code, Country) Values ("090", "Solomon Islands");
Insert Into IsoCountries (Code, Country) Values ("092", "Virgin Islands, British");
Insert Into IsoCountries (Code, Country) Values ("096", "Brunei Darussalam");
Insert Into IsoCountries (Code, Country) Values ("100", "Bulgaria");
Insert Into IsoCountries (Code, Country) Values ("104", "Myanmar");
Insert Into IsoCountries (Code, Country) Values ("108", "Burundi");
Insert Into IsoCountries (Code, Country) Values ("112", "Belarus");
Insert Into IsoCountries (Code, Country) Values ("116", "Cambodia");
Insert Into IsoCountries (Code, Country) Values ("120", "Cameroon");
Insert Into IsoCountries (Code, Country) Values ("124", "Canada");
Insert Into IsoCountries (Code, Country) Values ("132", "Cape Verde");
Insert Into IsoCountries (Code, Country) Values ("136", "Cayman Islands");
Insert Into IsoCountries (Code, Country) Values ("140", "Central African Republic");
Insert Into IsoCountries (Code, Country) Values ("144", "Sri Lanka");
Insert Into IsoCountries (Code, Country) Values ("148", "Chad");
Insert Into IsoCountries (Code, Country) Values ("152", "Chile");
Insert Into IsoCountries (Code, Country) Values ("156", "China, mainland");
Insert Into IsoCountries (Code, Country) Values ("158", "Taiwan (Republic of China)");
Insert Into IsoCountries (Code, Country) Values ("162", "Christmas Island");
Insert Into IsoCountries (Code, Country) Values ("166", "Cocos (Keeling) Islands");
Insert Into IsoCountries (Code, Country) Values ("170", "Colombia");
Insert Into IsoCountries (Code, Country) Values ("174", "Comoros");
Insert Into IsoCountries (Code, Country) Values ("175", "Mayotte");
Insert Into IsoCountries (Code, Country) Values ("178", "Congo, Republic of the");
Insert Into IsoCountries (Code, Country) Values ("180", "Congo, The Democratic Republic Of The");
Insert Into IsoCountries (Code, Country) Values ("184", "Cook Islands");
Insert Into IsoCountries (Code, Country) Values ("188", "Costa Rica");
Insert Into IsoCountries (Code, Country) Values ("191", "Croatia");
Insert Into IsoCountries (Code, Country) Values ("192", "Cuba");
Insert Into IsoCountries (Code, Country) Values ("196", "Cyprus");
Insert Into IsoCountries (Code, Country) Values ("203", "Czech Republic");
Insert Into IsoCountries (Code, Country) Values ("204", "Benin");
Insert Into IsoCountries (Code, Country) Values ("208", "Denmark");
Insert Into IsoCountries (Code, Country) Values ("212", "Dominica");
Insert Into IsoCountries (Code, Country) Values ("214", "Dominican Republic");
Insert Into IsoCountries (Code, Country) Values ("218", "Ecuador");
Insert Into IsoCountries (Code, Country) Values ("222", "El Salvador");
Insert Into IsoCountries (Code, Country) Values ("226", "Equatorial Guinea");
Insert Into IsoCountries (Code, Country) Values ("231", "Ethiopia");
Insert Into IsoCountries (Code, Country) Values ("232", "Eritrea");
Insert Into IsoCountries (Code, Country) Values ("233", "Estonia");
Insert Into IsoCountries (Code, Country) Values ("234", "Faroe Islands");
Insert Into IsoCountries (Code, Country) Values ("238", "Falkland Islands");
Insert Into IsoCountries (Code, Country) Values ("239", "South Georgia and the South Sandwich Islands");
Insert Into IsoCountries (Code, Country) Values ("242", "Fiji");
Insert Into IsoCountries (Code, Country) Values ("246", "Finland");
Insert Into IsoCountries (Code, Country) Values ("248", "Åland Islands");
Insert Into IsoCountries (Code, Country) Values ("250", "France");
Insert Into IsoCountries (Code, Country) Values ("254", "French Guiana");
Insert Into IsoCountries (Code, Country) Values ("258", "French Polynesia");
Insert Into IsoCountries (Code, Country) Values ("260", "French Southern Territories");
Insert Into IsoCountries (Code, Country) Values ("262", "Djibouti");
Insert Into IsoCountries (Code, Country) Values ("266", "Gabon");
Insert Into IsoCountries (Code, Country) Values ("268", "Georgia");
Insert Into IsoCountries (Code, Country) Values ("270", "Gambia");
Insert Into IsoCountries (Code, Country) Values ("275", "Palestinian Territory, Occupied");
Insert Into IsoCountries (Code, Country) Values ("276", "Germany");
Insert Into IsoCountries (Code, Country) Values ("288", "Ghana");
Insert Into IsoCountries (Code, Country) Values ("292", "Gibraltar");
Insert Into IsoCountries (Code, Country) Values ("296", "Kiribati");
Insert Into IsoCountries (Code, Country) Values ("300", "Greece");
Insert Into IsoCountries (Code, Country) Values ("304", "Greenland");
Insert Into IsoCountries (Code, Country) Values ("308", "Grenada");
Insert Into IsoCountries (Code, Country) Values ("312", "Guadeloupe");
Insert Into IsoCountries (Code, Country) Values ("316", "Guam");
Insert Into IsoCountries (Code, Country) Values ("320", "Guatemala");
Insert Into IsoCountries (Code, Country) Values ("324", "Guinea");
Insert Into IsoCountries (Code, Country) Values ("328", "Guyana");
Insert Into IsoCountries (Code, Country) Values ("332", "Haiti");
Insert Into IsoCountries (Code, Country) Values ("334", "Heard Island and McDonald Islands");
Insert Into IsoCountries (Code, Country) Values ("336", "Vatican City State");
Insert Into IsoCountries (Code, Country) Values ("340", "Honduras");
Insert Into IsoCountries (Code, Country) Values ("344", "Hong Kong");
Insert Into IsoCountries (Code, Country) Values ("348", "Hungary");
Insert Into IsoCountries (Code, Country) Values ("352", "Iceland");
Insert Into IsoCountries (Code, Country) Values ("356", "India");
Insert Into IsoCountries (Code, Country) Values ("360", "Indonesia");
Insert Into IsoCountries (Code, Country) Values ("364", "Iran, Islamic Republic of");
Insert Into IsoCountries (Code, Country) Values ("368", "Iraq");
Insert Into IsoCountries (Code, Country) Values ("372", "Ireland, Republic of");
Insert Into IsoCountries (Code, Country) Values ("376", "Israel");
Insert Into IsoCountries (Code, Country) Values ("380", "Italy");
Insert Into IsoCountries (Code, Country) Values ("384", "Côte d'Ivoire");
Insert Into IsoCountries (Code, Country) Values ("388", "Jamaica");
Insert Into IsoCountries (Code, Country) Values ("392", "Japan");
Insert Into IsoCountries (Code, Country) Values ("398", "Kazakhstan");
Insert Into IsoCountries (Code, Country) Values ("400", "Jordan");
Insert Into IsoCountries (Code, Country) Values ("404", "Kenya");
Insert Into IsoCountries (Code, Country) Values ("408", "Korea, Democratic People's Republic of");
Insert Into IsoCountries (Code, Country) Values ("410", "Korea, Republic of");
Insert Into IsoCountries (Code, Country) Values ("414", "Kuwait");
Insert Into IsoCountries (Code, Country) Values ("417", "Kyrgyzstan");
Insert Into IsoCountries (Code, Country) Values ("418", "Lao People's Democratic Republic");
Insert Into IsoCountries (Code, Country) Values ("422", "Lebanon");
Insert Into IsoCountries (Code, Country) Values ("426", "Lesotho");
Insert Into IsoCountries (Code, Country) Values ("428", "Latvia");
Insert Into IsoCountries (Code, Country) Values ("430", "Liberia");
Insert Into IsoCountries (Code, Country) Values ("434", "Libyan Arab Jamahiriya");
Insert Into IsoCountries (Code, Country) Values ("438", "Liechtenstein");
Insert Into IsoCountries (Code, Country) Values ("440", "Lithuania");
Insert Into IsoCountries (Code, Country) Values ("442", "Luxembourg");
Insert Into IsoCountries (Code, Country) Values ("446", "Macao");
Insert Into IsoCountries (Code, Country) Values ("450", "Madagascar");
Insert Into IsoCountries (Code, Country) Values ("454", "Malawi");
Insert Into IsoCountries (Code, Country) Values ("458", "Malaysia");
Insert Into IsoCountries (Code, Country) Values ("462", "Maldives");
Insert Into IsoCountries (Code, Country) Values ("466", "Mali");
Insert Into IsoCountries (Code, Country) Values ("470", "Malta");
Insert Into IsoCountries (Code, Country) Values ("474", "Martinique");
Insert Into IsoCountries (Code, Country) Values ("478", "Mauritania");
Insert Into IsoCountries (Code, Country) Values ("480", "Mauritius");
Insert Into IsoCountries (Code, Country) Values ("484", "Mexico");
Insert Into IsoCountries (Code, Country) Values ("492", "Monaco");
Insert Into IsoCountries (Code, Country) Values ("496", "Mongolia");
Insert Into IsoCountries (Code, Country) Values ("498", "Moldova, Republic of");
Insert Into IsoCountries (Code, Country) Values ("500", "Montserrat");
Insert Into IsoCountries (Code, Country) Values ("504", "Morocco");
Insert Into IsoCountries (Code, Country) Values ("508", "Mozambique");
Insert Into IsoCountries (Code, Country) Values ("512", "Oman");
Insert Into IsoCountries (Code, Country) Values ("516", "Namibia");
Insert Into IsoCountries (Code, Country) Values ("520", "Nauru");
Insert Into IsoCountries (Code, Country) Values ("524", "Nepal");
Insert Into IsoCountries (Code, Country) Values ("528", "Netherlands");
Insert Into IsoCountries (Code, Country) Values ("530", "Netherlands Antilles");
Insert Into IsoCountries (Code, Country) Values ("533", "Aruba");
Insert Into IsoCountries (Code, Country) Values ("540", "New Caledonia");
Insert Into IsoCountries (Code, Country) Values ("548", "Vanuatu");
Insert Into IsoCountries (Code, Country) Values ("554", "New Zealand");
Insert Into IsoCountries (Code, Country) Values ("558", "Nicaragua");
Insert Into IsoCountries (Code, Country) Values ("562", "Niger");
Insert Into IsoCountries (Code, Country) Values ("566", "Nigeria");
Insert Into IsoCountries (Code, Country) Values ("570", "Niue");
Insert Into IsoCountries (Code, Country) Values ("574", "Norfolk Island");
Insert Into IsoCountries (Code, Country) Values ("578", "Norway");
Insert Into IsoCountries (Code, Country) Values ("580", "Northern Mariana Islands");
Insert Into IsoCountries (Code, Country) Values ("581", "United States Minor Outlying Islands");
Insert Into IsoCountries (Code, Country) Values ("583", "Micronesia, Federated States of");
Insert Into IsoCountries (Code, Country) Values ("584", "Marshall Islands");
Insert Into IsoCountries (Code, Country) Values ("585", "Palau");
Insert Into IsoCountries (Code, Country) Values ("586", "Pakistan");
Insert Into IsoCountries (Code, Country) Values ("591", "Panama");
Insert Into IsoCountries (Code, Country) Values ("598", "Papua New Guinea");
Insert Into IsoCountries (Code, Country) Values ("600", "Paraguay");
Insert Into IsoCountries (Code, Country) Values ("604", "Peru");
Insert Into IsoCountries (Code, Country) Values ("608", "Philippines");
Insert Into IsoCountries (Code, Country) Values ("612", "Pitcairn");
Insert Into IsoCountries (Code, Country) Values ("616", "Poland");
Insert Into IsoCountries (Code, Country) Values ("620", "Portugal");
Insert Into IsoCountries (Code, Country) Values ("624", "Guinea-Bissau");
Insert Into IsoCountries (Code, Country) Values ("626", "Timor-Leste");
Insert Into IsoCountries (Code, Country) Values ("630", "Puerto Rico");
Insert Into IsoCountries (Code, Country) Values ("634", "Qatar");
Insert Into IsoCountries (Code, Country) Values ("638", "Réunion");
Insert Into IsoCountries (Code, Country) Values ("642", "Romania");
Insert Into IsoCountries (Code, Country) Values ("643", "Russian Federation");
Insert Into IsoCountries (Code, Country) Values ("646", "Rwanda");
Insert Into IsoCountries (Code, Country) Values ("654", "Saint Helena");
Insert Into IsoCountries (Code, Country) Values ("659", "Saint Kitts and Nevis");
Insert Into IsoCountries (Code, Country) Values ("660", "Anguilla");
Insert Into IsoCountries (Code, Country) Values ("662", "Saint Lucia");
Insert Into IsoCountries (Code, Country) Values ("666", "Saint-Pierre and Miquelon");
Insert Into IsoCountries (Code, Country) Values ("670", "Saint Vincent and the Grenadines");
Insert Into IsoCountries (Code, Country) Values ("674", "San Marino");
Insert Into IsoCountries (Code, Country) Values ("678", "São Tomé and Príncipe");
Insert Into IsoCountries (Code, Country) Values ("682", "Saudi Arabia");
Insert Into IsoCountries (Code, Country) Values ("686", "Senegal");
Insert Into IsoCountries (Code, Country) Values ("690", "Seychelles");
Insert Into IsoCountries (Code, Country) Values ("694", "Sierra Leone");
Insert Into IsoCountries (Code, Country) Values ("702", "Singapore");
Insert Into IsoCountries (Code, Country) Values ("703", "Slovakia");
Insert Into IsoCountries (Code, Country) Values ("704", "Viet Nam");
Insert Into IsoCountries (Code, Country) Values ("705", "Slovenia");
Insert Into IsoCountries (Code, Country) Values ("706", "Somalia");
Insert Into IsoCountries (Code, Country) Values ("710", "South Africa");
Insert Into IsoCountries (Code, Country) Values ("716", "Zimbabwe");
Insert Into IsoCountries (Code, Country) Values ("724", "Spain");
Insert Into IsoCountries (Code, Country) Values ("732", "Western Sahara");
Insert Into IsoCountries (Code, Country) Values ("736", "Sudan");
Insert Into IsoCountries (Code, Country) Values ("740", "Suriname");
Insert Into IsoCountries (Code, Country) Values ("744", "Svalbard and Jan Mayen");
Insert Into IsoCountries (Code, Country) Values ("748", "Swaziland");
Insert Into IsoCountries (Code, Country) Values ("752", "Sweden");
Insert Into IsoCountries (Code, Country) Values ("756", "Switzerland");
Insert Into IsoCountries (Code, Country) Values ("760", "Syrian Arab Republic");
Insert Into IsoCountries (Code, Country) Values ("762", "Tajikistan");
Insert Into IsoCountries (Code, Country) Values ("764", "Thailand");
Insert Into IsoCountries (Code, Country) Values ("768", "Togo");
Insert Into IsoCountries (Code, Country) Values ("772", "Tokelau");
Insert Into IsoCountries (Code, Country) Values ("776", "Tonga");
Insert Into IsoCountries (Code, Country) Values ("780", "Trinidad and Tobago");
Insert Into IsoCountries (Code, Country) Values ("784", "United Arab Emirates");
Insert Into IsoCountries (Code, Country) Values ("788", "Tunisia");
Insert Into IsoCountries (Code, Country) Values ("792", "Turkey");
Insert Into IsoCountries (Code, Country) Values ("795", "Turkmenistan");
Insert Into IsoCountries (Code, Country) Values ("796", "Turks and Caicos Islands");
Insert Into IsoCountries (Code, Country) Values ("798", "Tuvalu");
Insert Into IsoCountries (Code, Country) Values ("800", "Uganda");
Insert Into IsoCountries (Code, Country) Values ("804", "Ukraine");
Insert Into IsoCountries (Code, Country) Values ("807", "Macedonia, The Former Yugoslav Republic of");
Insert Into IsoCountries (Code, Country) Values ("818", "Egypt");
Insert Into IsoCountries (Code, Country) Values ("826", "United Kingdom");
Insert Into IsoCountries (Code, Country) Values ("834", "Tanzania, United Republic Of");
Insert Into IsoCountries (Code, Country) Values ("840", "United States");
Insert Into IsoCountries (Code, Country) Values ("850", "Virgin Islands, U.S.");
Insert Into IsoCountries (Code, Country) Values ("854", "Burkina Faso");
Insert Into IsoCountries (Code, Country) Values ("858", "Uruguay");
Insert Into IsoCountries (Code, Country) Values ("860", "Uzbekistan");
Insert Into IsoCountries (Code, Country) Values ("862", "Venezuela");
Insert Into IsoCountries (Code, Country) Values ("876", "Wallis and Futuna");
Insert Into IsoCountries (Code, Country) Values ("882", "Samoa");
Insert Into IsoCountries (Code, Country) Values ("887", "Yemen");
Insert Into IsoCountries (Code, Country) Values ("891", "Serbia and Montenegro");
Insert Into IsoCountries (Code, Country) Values ("894", "Zambia");

Insert Into IsoCurrencies (Code, CurrencyName) Values ("AED", "United Arab Emirates dirham");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("AFN", "Afghan afghani");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ALL", "Albanian lek");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("AMD", "Armenian dram");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ANG", "Netherlands Antillian guilder");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("AOA", "Angolan kwanza");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ARS", "Argentine peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("AUD", "Australian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("AWG", "Aruban guilder");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("AZM", "Azerbaijani manat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BAM", "Bosnia-Herzegovina convertible mark");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BBD", "Barbadian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BDT", "Bangladeshi taka");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BGN", "Bulgarian lev");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BHD", "Bahraini dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BIF", "Burundi franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BMD", "Bermuda dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BND", "Brunei dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BOB", "Bolivian boliviano");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BOV", "Bolivian Mvdol");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BRL", "Brazilian real");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BSD", "Bahamian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BTN", "Bhutan ngultrum");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BWP", "Botswana pula");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BYR", "Belarusian ruble");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("BZD", "Belize dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CAD", "Canadian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CDF", "Congolese franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CHF", "Swiss franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CLF", "Chilean Unidades de fomento");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CLP", "Chilean peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CNY", "Yuan renminbi");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("COP", "Colombian peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("COU", "Colombian unidad de valor real");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CRC", "Costa Rican colón");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CSD", "Serbian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CUC", "Cuban convertible peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CUP", "Cuban peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CVE", "Cape Verde escudo");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CYP", "Cyprus pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("CZK", "Czech koruna");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("DJF", "Djibouti franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("DKK", "Danish krone");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("DOP", "Dominican peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("DZD", "Algerian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("EEK", "Estonian kroon");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("EGP", "Egyptian pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ERN", "Eritrea nakfa");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ETB", "Ethiopian birr");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("EUR", "European Union euro");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("FJD", "Fijian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("FKP", "Falkland Islands pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GBP", "Great British Pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GEL", "Georgian lari");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GHC", "Ghana cedi");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GIP", "Gibraltar pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GMD", "Gambian dalasi");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GNF", "Guinea franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GTQ", "Guatemalan quetzal");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("GYD", "Guyanese dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("HKD", "Hong Kong dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("HNL", "Honduran lempira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("HRK", "Croatian kuna");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("HTG", "Haitian gourde");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("HUF", "Hungarian forint");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("IDR", "Indonesian rupiah");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ILS", "New Israeli shekel");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("INR", "Indian rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("IQD", "Iraqi dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("IRR", "Iranian Rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ISK", "Icelandic króna");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("JMD", "Jamaican dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("JOD", "Jordanian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("JPY", "Japanese yen");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KES", "Kenyan shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KGS", "Kyrgyzstan som");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KHR", "Cambodian riel");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KMF", "Comorian franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KPW", "North Korean won");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KRW", "South Korean won");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KWD", "Kuwaiti dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KYD", "Cayman Islands dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("KZT", "Kazakhstan tenge");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LAK", "Lao kip");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LBP", "Lebanese pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LKR", "Sri Lankan rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LRD", "Liberian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LSL", "Lesotho loti");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LTL", "Lithuanian litas");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LVL", "Latvian lat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("LYD", "Libyan dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MAD", "Moroccan dirham");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MDL", "Moldovan leu");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MGA", "Malagasy ariary");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MKD", "Macedonian denar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MMK", "Myanmar kyat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MNT", "Mongolian tugrik");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MOP", "Macau pataca");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MRO", "Mauritanian ouguiya");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MTL", "Maltese lira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MUR", "Mauritius rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MVR", "Maldives rufiyaa");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MWK", "Malawi kwacha");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MXN", "Mexican peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MXV", "Mexican Unidad de Inversión");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MYR", "Malaysian ringgit");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("MZM", "Mozambique metical");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("NAD", "Namibian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("NGN", "Nigerian naira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("NIO", "Nicaraguan córdoba");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("NOK", "Norwegian krone");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("NPR", "Nepalese rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("NZD", "New Zealand dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("OMR", "Omani rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PAB", "Panamanian balboa");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PEN", "Peruvian nuevo sol");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PGK", "Papua New Guinea kina");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PHP", "Philippine peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PKR", "Pakistani rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PLN", "Polish z?oty");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("PYG", "Paraguayan guaran?");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("QAR", "Qatari rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("RON", "Romanian new leu");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("RUB", "Russian ruble");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("RWF", "Rwandan franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SAR", "Saudi Arabian riyal");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SBD", "Solomon Islands dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SCR", "Seychelles rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SDD", "Sudanese dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SEK", "Swedish krona");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SGD", "Singapore dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SHP", "Saint Helena pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SIT", "Slovene tolar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SKK", "Slovak koruna");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SLL", "Sierra Leonean leone");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SOS", "Somali shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SRD", "Suriname dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("STD", "São Tomé and Príncipe dobra");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SVC", "Salvadoran colón");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SYP", "Syrian pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("SZL", "Swaziland lilangeni");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("THB", "Thai baht");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TJS", "Tajikistani somoni");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TMM", "Turkmen manat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TND", "Tunisian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TOP", "Tongan Pa'anga");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TPE", "Timor Escudo");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TRY", "New Turkish lira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TTD", "Trinidad and Tobago dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TWD", "New Taiwan dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("TZS", "Tanzanian shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("UAH", "Ukrainian hryvnia");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("UGX", "Ugandan shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("USD", "United States dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("USN", "United States dollar (Next day)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("USS", "United States dollar (Same day)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("UYU", "Uruguayan peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("UZS", "Uzbekistani som");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("VEB", "Venezuelan bolívar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("VND", "Viet Nam dong");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("VUV", "Vanuatu vatu");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("WST", "Samoa Tala");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XAF", "CFA franc BEAC");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XAG", "Silver ounce");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XAU", "Gold ounce");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XBA", "European Composite Unit (EURCO)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XBB", "European Monetary Unit (E.M.U.-6)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XBC", "European Unit of Account 9 (E.U.A.-9)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XBD", "European Unit of Account 17 (E.U.A.-17)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XCD", "East Caribbean dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XDR", "Special Drawing Rights");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XFO", "Gold-franc (Special settlement currency)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XFU", "UIC franc (Special settlement currency)");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XOF", "CFA franc BCEAO");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XPD", "Palladium ounce");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XPF", "CFP franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XPT", "Platinum ounce");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XTS", "Code reserved for testing purposes");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("XXX", "No currency");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("YER", "Yemeni rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ZAR", "South African rand");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ZMK", "Zambian kwacha");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("ZWD", "Zimbabwe dollar");


Insert Into ProductLookup (DecodedText, Description) Values ("012345678905",  "UPC-A master grade");
Insert Into ProductLookup (DecodedText, Description) Values ("5012345678900", "EAN-13 master grade");

Insert Into Operators (OperatorID, OperatorName, EncryptedPassword, Permissions) Values
(
    "Admin", "LVS Administrator", 83012420, 127
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     1.5.0

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('1.5.0', #30-Jul-2004#);
Insert Into ReleaseDetails  (Version, Comment) Values ('1.5.0', "First commercial release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     1.7.2

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('1.7.2', #12-Sep-2004#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Fix wrong output directory");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Enhanced Remake.bat to run InstallShield and create Zip file");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Change Gradeline so partial PDF won't trump RSS14");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Don't show modulation option for DM");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Show CC-C");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Rename I 2 of 5 to ITF");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Allow 73% to 77% before 'need Cal'");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Require 3 characters for Codabar");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Fix aperture to work with 25mm and 12.5mm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Add glossary");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Include DLL files whenever getting new source");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Add DataMatrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Add RSS code with linkage");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Fix division by 0 by forcing EdgeGT to be non-integer");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.2', "Change version number to 1.72");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     1.7.4

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('1.7.4', #12-Oct-2004#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "Add white balancing");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "Fix PDF quiet zone error");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "New datamatrix show job function");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "Autoprint feature added");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "Made Data Matrix faster");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "Add tool tips for Print button");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.4', "Change version number to 1.74");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     1.7.5

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('1.7.5', #16-Nov-2004#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.5', "Add rectangular Datamatrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.5', "Fix X/Y reversal");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.5', "Fix Typo");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.5', "Change Date format to International Standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.5', "Rename several forms");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.7.5', "Change version number to 1.75");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     1.9.0

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('1.9.0', #25-Nov-2004#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.0', "Add missing install file");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.0', "Auto light tracker feature added");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.0', "USER permissions added");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.0', "Change version to 1.90");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     1.9.1

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('1.9.1', #30-Nov-2004#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.1', "Improved security of password");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.1', "Fix quick loops");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.1', "Change in DLL Version No. 1.92h");
Insert Into ReleaseDetails  (Version, Comment)     Values ('1.9.1', "Change version to 1.91");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.0.1

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.0.1',  #7-Dec-2004#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Support for multiple sectors in the FOV added as an optional feature");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Increase range of exposure setting to100");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Made Data Matrix less sluggish");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Fixed Pass/Fail issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Add 8mil aperture rule for DM");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Read upside down PDF");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.1', "Change version to 2.0.1");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.0.2

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.0.2',  #3-Jan-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Undo 8 mil aperture for DM");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Change quiet zone algorithm to fix UPC-E with supplemental add-on");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Support 8.5mm lens");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Add manual white balancing (factory)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Skip DataMatrix if PDF is successful");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Fix Xdim problem with supplemental encodations");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Store white balance in INI file");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Avoid scaling right-half image two times");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Fix Xdim issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Allow company name change to verification report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.2', "Change version to 2.0.2");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.0.3

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.0.3', #28-Feb-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Swap over when converting cal history - GMT vs Local time");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Implement new splicing algorithm (not released due to problems 25mm lens)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Don't flicker on SRP screen");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Add spaces so really long text strings will wrap in report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Allow company name change to verification report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Implement factory settings 'password of the day'");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "No longer show new password while it is being entered.");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Fix calibration history report create date");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Handle calibration files differently");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Fix password of the day with leading zero");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "The operator is shown on the report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Multi-sector pass/fail changed");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Add space for signatures to Grade Summary Report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.0.3', "Change version to 2.0.3");
        
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.0

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.0', #26-May-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Change version to 2.1.0 (major change; 2.0.4 to 2.0.9 numbers skipped)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Move all information to single SQL database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Record unit and camera serial numbers on each report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Allow each sector to have its own aperture setting");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Automatically archive all images and reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Implement audit trail logging and reporting");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Change UCC-12 to UPC-A");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Change UCC-8 to UPC-E");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Display the current logged in user at top of screen");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Report Second signature instead of Supervisor signature");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Let quiet zone error reduce overall grade");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Implement full-screen SRP view");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Implement English vs. Metric");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Check password for at least 8 characters and at least one digit");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Remember sector positions when exiting the program");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.0', "Implement software version history report");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1', #6-Jun-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1', "Fix problem where zoom image has tilted");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1a', #9-Jun-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1a', "Add Calibration OK message");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1b', #1-Jul-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1b', "Check bitmap file size and type on import");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1b', "Add reference field");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1b', "Don't save full images in database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1b', "Continue calibration until contrast is within 1%");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1b', "Add Delete old reports button");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1c', #5-Jul-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1c', "Add Automatic/Manual grading");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1c', "Add Archive checkbox");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1c', "Ask before deleting images");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1d', #6-Jul-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1d', "Show percentage for Rmin, Rmax, GT and ECmin");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1d', "Use a space instead of a slash for supplemental encodations");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1d', "Add print button to SRP tab");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1e', #7-Jul-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1e', "Implement application identifier database");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1f', #8-Jul-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1f', "Change Data Matrix modulation algorithm");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1g', #18-Jul-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1g', "Support 6 megapixel camera");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1h', #1-Aug-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1h', "Fix bug when changing permissions for new operator");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1h', "Fix several AI-related bugs");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1h', "Change dimensional analysis units to microns");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1h', "Convert 8-digit UPC-E to 12-digit format on Structure tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1h', "Create product lookup database");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1i', #3-Aug-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1i', "Add distributor information");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1i', "Show OCR instead of Rmin");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.1k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.1k', #4-Aug-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1k', "Add key to SRP printed report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.1k', "Add print button to data structure tab");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.2

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.2',  #4-Aug-2005#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.2f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.2f', #19-Aug-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.2f', "Allow longer messages in audit trail");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.2f', "Improve data matrix algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.2f', "Add variable sharpening feature");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.3a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.3a', #28-Sep-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.3a', "Fix Manual grading button");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.3h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.3h', #20-Oct-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.3h', "Restore 64/0.8 for 1280 camera");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.3i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.3i', #21-Oct-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.3i', "Implement multi-language support");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.3q

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.3q', #15-Nov-2005#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.3q', "Support MySQL");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4', #31-Jan-2006#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4b', #2-Feb-2006#);

Alter Table Reports Add Column Reference Text;
Alter Table Reports Add Column OverallGrade Text;
Alter Table Reports Add Column DecodedText LongText;
Update Reports Set Reference    = "";
Update Reports Set OverallGrade = "";
Update Reports Set DecodedText  = "";
Update Reports, ReportData Set Reports.Reference    = ReportData.ParameterValue Where Reports.ReportID = ReportData.ReportID And ReportData.ParameterName = "Reference";
Update Reports, ReportData Set Reports.OverallGrade = ReportData.ParameterValue Where Reports.ReportID = ReportData.ReportID And ReportData.ParameterName = "Overall grade";
Update Reports, ReportData Set Reports.DecodedText  = ReportData.ParameterValue Where Reports.ReportID = ReportData.ReportID And ReportData.ParameterName = "Decoded text";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4c', #26-Jun-2006#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4d', #2-Aug-2006#);


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4e', #13-Aug-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.4e', "Add Chinese support");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4f', #14-Aug-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.4f', "Fix missing translation in HTML reports");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4g', #10-Sep-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.4g', "Define application standards in the database");
Create Table ApplicationStandards
(
    ShortName       Text,
    LongName        Text,
    Status          Integer,
    Primary Key     (ShortName)
);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("GenSpec",    "General UCC/EAN Specifications", 2);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Iso",        "ISO/IEC 15415/15416",            1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("MilStd",     "MIL-STD-130M",                   1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Pharmacode", "Pharmacode",                     1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("GS1",        "GS1",                            1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("DHL",        "DHL",                            1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("ALDI",       "ALDI",                           1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PZN",        "PZN (German Pharmacode)",        1);
Update ApplicationIdentifiers Set Description = "Secondary Data Fields (For Legacy Apps)" Where ApplicationIdentifier = "22" And Element = 1;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4i', #13-Sep-2006#);
Delete From ApplicationStandards Where ShortName = "GenSpec";
Delete From ApplicationStandards Where ShortName = "GS1";
Update ApplicationStandards Set Status = 1 Where Status = 2;
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("GS1", "GS1 General Specifications", 2);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4j', #14-Sep-2006#);


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4k', #17-Sep-2006#);
Create Table StructureTags
(
    EmbeddedData    Text,
    Description     Text,
    TagValue        Text,
    Primary Key     (EmbeddedData)
);
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<230>", "Latch to C40",                 "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<231>", "Latch to Base 256 Encodation", "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<232>", "Func1",                        "<Func1>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<233>", "Structured Append",            "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<234>", "Reader programming",           "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<235>", "Upper Shift",                  "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<236>", "Macro 05",                     "])><RS>05<GS>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<237>", "Macro 06",                     "])><RS>06<GS>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<238>", "Latch to ANSI X12",            "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<239>", "Latch to Text Encodation",     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<240>", "Latch to EDIFACT Encodation",  "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<241>", "ECI",                          "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<254>", "Unlatch",                      "");

Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<900>", "Latch to Text Compaction",     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<901>", "Latch to Byte Compaction",     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<902>", "Latch to Mode Compaction",     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<903>", "UCC/EAN-128 emulation",        "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<904>", "UCC/EAN-128 emulation",        "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<905>", "UCC/EAN-128 emulation",        "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<906>", "Linked UCC/EAN-128",           "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<907>", "Linked UCC/EAN-128",           "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<908>", "Code 128 emulation",           "]C2");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<909>", "Code 128 emulation",           "]C2");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<910>", "Code 128 emulation",           "]C0");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<911>", "Code 128 emulation",           "]C0");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<912>", "Linked UCC/EAN-128",           "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<913>", "Shift to Byte Compaction",     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<914>", "Linked UCC/EAN-128",           "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<915>", "Linked UCC/EAN-128",           "]C1");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<916>", "Macro 05",                     "])><RS>05<GS>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<917>", "Macro 06",                     "])><RS>06<GS>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<918>", "Reserved",                     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<919>", "Reserved",                     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<920>", "Reserved",                     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<921>", "Reader initializaton",         "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<922>", "Terminator codeword",          "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<923>", "Sequence tag",                 "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<924>", "Latch to Byte Compaction",     "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<925>", "User-defined ECI",             "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<926>", "General-purpose ECI",          "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<927>", "ECI",                          "feature not supported");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<928>", "Structured Append marker",     "feature not supported");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4l

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4l', #18-Sep-2006#);
Delete From StructureTags Where EmbeddedData = "<920>";
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<920>", "CC-B Indicator", "Implied <Func1>");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4m', #25-Oct-2006#);
Delete From ApplicationStandards Where ShortName = "PZN";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PZN-big",    "PZN-big    (German Pharmacode)", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PZN-normal", "PZN-normal (German Pharmacode)", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PZN-small",  "PZN-small  (German Pharmacode)", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4n', #29-Oct-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.4n', "Fix PDF417 Codeword PQ");
Update ApplicationStandards Set ShortName = "ISO" Where ShortName = "Iso";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.4o

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.4o', #30-Oct-2006#);
Update ApplicationStandards Set ShortName = "ISO" Where ShortName = "Iso";


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5', #31-Oct-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Implement missing encodation schemes for Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Implement multiple new application identifiers");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Implement sideways PDF417/CC decoding");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Correct Data Matrix correlation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Combine all DLLs into a single DLL");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Implement database backup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Implement browse backup database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Improve structure to show embedded elements");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5', "Detect and display check digit errors");
Update ApplicationStandards Set LongName = "Laetus Pharmacode" Where ShortName = "Pharmacode";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5a', #9-Nov-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5a', "Disable codeword PQ")

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5b', #21-Nov-2006#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5b', "Enable codeword PQ");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5b', "Improve reading of Data Matrix codes with dots");
Alter Table Calibration Add Column LightingMode Text;
Update Calibration Set LightingMode = "660";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5d', #17-Jan-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5d', "Total revamp of Data Matrix");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5e', #27-Jan-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5e', "More changes to Data Matrix algorithm");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5f', #27-Jan-2007#);
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<903+>", "Group separator", "<GS>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<904+>", "Group separator", "<GS>");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<905+>", "Group separator", "<GS>");
Update StructureTags Set TagValue = "]L3" Where TagValue = "]C1";
Update StructureTags Set TagValue = "]C1" Where EmbeddedData = "<903>";
Update StructureTags Set TagValue = "]C1" Where EmbeddedData = "<904>";
Update StructureTags Set TagValue = "]C1" Where EmbeddedData = "<905>";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5g', #9-Feb-2007#);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("MultiRotation", "Multi-rotation Data Matrix", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5h', #4-Mar-2007#);
Update StructureTags Set Description = "Latch to Numeric Compaction" Where Description = "Latch to Mode Compaction";
Update ApplicationIdentifiers Set Description = "Identification of a Logistic Unit" Where Description = "Indentification of a Logistic Unit";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5i', #11-Mar-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5i', "Add calendar for deleting reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5i', "Fix manual grading bug");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5i', "Improve traditional measurements");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5i', "Implement 20Z check for Data Matrix");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5j', #14-Mar-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5j', "Add PDF Codeword yield");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5j', "Include CsvView");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5j', "Improve traditional measurements");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5k', #19-Mar-2007#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5l

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5l', #20-Mar-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5l', "Make traditional work with split RSS codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5l', "Revamp Data Matrix");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5m', #20-Mar-2007#);


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5n', #21-Mar-2007#);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("GS1Report", "GS1 with custom report", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Italian",   "Italian Pharmacode", 1);


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5p

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5p', #22-Mar-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5p', "Implement Italian Pharmacode");
Delete From StructureTags Where EmbeddedData = "<920>";
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<920>", "CC Indicator", "Implied <Func1>");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5q

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5q', #23-Mar-2007#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     2.1.5r

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('2.1.5r', #25-Mar-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('2.1.5r', "Fix problem with wrong grades for multi-rotation Data Matrix");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0', #28-Mar-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0', "Roll up previous changes into major release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0a', #15-May-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0a', "Improve program sluggishness");
Alter Table Calibration Drop Column LensSize;
Alter Table Calibration Add Column MirrorMode Text;
Alter Table Calibration Add Column MostRecent Bit;
Update Calibration Set SerialNumber = -10 * SerialNumber Where SerialNumber > 0;
Update Calibration Set MostRecent = True;
Update StructureTags Set TagValue = "[)><RS>05<GS>" Where TagValue = "])><RS>05<GS>";
Update StructureTags Set TagValue = "[)><RS>06<GS>" Where TagValue = "])><RS>06<GS>";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0b', #16-May-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0b', "Fix bug where MostRecent was set as numeric");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0b', "Fix bug where calibration would have red areas in LVS mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0b', "Add [Ctrl-R] for imported images");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0b', "Fix problem with international dates and SQL");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0c', #28-May-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0c', "Rename RSS to DataBar");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0c', "Implement DataBar expanded");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0c', "Implement Miniature Pharmacode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0c', "Implement AS9132");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("AS9132",         "AS9132-A / AIM DPM Cat 0", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("MiniPharmacode", "Miniature Pharmacode",     1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0d', #28-May-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0d', "Fix Pharmacode issues");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0e', #28-May-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0e', "Fix several DataBar bugs");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0f', #28-May-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0f', "Fix bug in Voter.MostCommonList");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0g', #5-Jun-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0g', "Add FTP upload feature");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0g', "Fixed several translation bugs");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0h', #5-Jun-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0h', "Fix subscript error for Italian Pharmacode");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0i', #6-Jun-2007#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0j', #7-Jun-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0j', "Fixed more translation issues");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.0k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.0k', #12-Jun-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0k', "Relax Pharmacode decodability rules");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.0k', "Tag exported images with MilsPerPixel");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.1

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.1', #12-Jun-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.1', "Update translation files");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.2

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.2', #18-Jun-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2', "Fix MicroPDF/CC bug");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2', "Fix problem with French/Canadian regional setting and Calibrate");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.2a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.2a', #15-Jul-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2a', "Support QR Code");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.2b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.2b', #29-Jul-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2b', "Build using VC 2005");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2b', "Use variable exposure for LVS calibration");
Alter Table Calibration Add Column FlipMode Text;
Alter Table Calibration Add Column Exposure Real;
Update Calibration Set Exposure = 50;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.2c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.2c', #6-Aug-2007#);


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.2d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.2d', #6-Aug-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2d', "Add data identifiers");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("AIAG", "AIAG / JAMA / JAPIA / ODETTE", 1);
Alter Table Operators Add Column WhenPasswordSet DateTime;
Update Operators Set WhenPasswordSet = #TodaysDate#;
Create Table DataIdentifiers
(
    DataIdentifier          Text,
    Description             Text,
    Primary Key             (DataIdentifier)
);
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "B", "Container Type");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "D", "Date YYMMDD");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5D", "Date YYMMDD followed by an ANSI X12.3 Data Element Number 374 Qualifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6D", "Date YYYYMMDD followed by an ANSI X12.3 Data Element Number 374 Qualifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12D", "Date YYYYMMDD");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "I", "VIN - Vehicle Identification Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1J", "Unique license plate number assigned to a transport unit that is the lowest level of packaging, the unbreakable unit, as defined in ISO/IEC 15459.1");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5J", "Unique license plate number assigned to a mixed transport unit that contains unlike items on a single customer transaction and may or may not have associated EDIdata.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6J", "Unique license plate number assigned to a master transport unit that contains like items on a single customer transaction and may or may not have associated EDIdata.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "K", "Purchase Order Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5K", "Reference number assigned by the Customer to identify a Shipment Authorization (Release) against an established Purchase Order");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15K", "Pull Signal - Kanban, DON or RAN number assigned by the Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4L", "Country of Origin - two-character code from the ISO 3166 standard country code list");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20L", "Additional location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21L", "Additional location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22L", "Additional location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23L", "Additional location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24L", "Additional location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "P", "Part number, assigned by the Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1P", "Part number, assigned by the Supplier/Manufacturer Global Transport Label Standard for the Automotive Industry");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2P", "Code assigned to specify the revision level of the part e.g., Engineering Change Level, revision or edition");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "Q", "Quantity (integer numeric) (Unit of measure is assumed to be each unless otherwise agreed upon by the Supplier and the Customer)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7Q", "Quantity and unit of measure in the format: Quantity followed by the two-character Unit of Measure code as defined in Data Element number 355 of the ANSI X12.3 Data Element Dictionary standard");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2S", "Shipment ID number. If you are using EDI, this corresponds to the SID (Data Element 396 of ANSI X12.3, as used in the 856 Shipment Notification transaction).");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3S", "Package Identification assigned by the Supplier to the lowest level of packaging (container) that has a package ID code.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4S", "Package Identification assigned by the Supplier to packaging containing multiple containers of like items on a single customer order. (Master Load)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5S", "Package Identification assigned by the Supplier to packaging containing multiple containers of unlike items on a single customer order. (Mixed Load)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "T", "Traceability number assigned to a unique batch or group of items (lot, heat, batch) by the Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1T", "Traceability number assigned to a unique batch or group of items (lot, heat, batch) by the Supplier/Manufacturer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "V", "Supplier Code assigned by the Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12V", "DUNS number of the Manufacturer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "W", "Work Order number assigned by the Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "Z", "Mutually defined between customer and supplier (title to reflect mutually agreed meaning) If a DI is not found in the ANSI MH10.8.2 this DI may be appropriate.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.2e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.2e', #14-Aug-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2e', "Allow multiple custom reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2e', "Correct for PDF tilt");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.2e', "Support Micro QR Code");
Alter Table Operators Drop Column WhenPasswordSet;
Alter Table Operators Add Column PasswordSetDate DateTime;
Update Operators Set PasswordSetDate = #TodaysDate#;
Delete From ApplicationStandards Where ShortName = "GS1Report";
Alter Table Calibration Add Column BarSpaceCorrection Real;
Update Calibration Set BarSpaceCorrection = 0;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3', #19-Aug-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3', "Create new release");
Update ApplicationStandards Set ShortName = "MultiDataMatrix" Where ShortName = "MultiRotation";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("MultiQRCode", "Multi-rotation QR Code", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3a', #18-Sep-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3a', "Fix QR Code mirror problem");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3a', "Fix Micro QR Code problems");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3a', "Add {Thumbnail} to custom reports");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3b', #20-Sep-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3b', "Fix Chinese translation issues");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3c', #27-Sep-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3c', "Add Auto application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3c', "Accept button push");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3c', "Increate white-balance bucketsize");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3c', "Make structure tab errors F grade");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Auto", "Automatic GS1 or ISO", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3d', #11-Oct-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3d', "Include UPC-E expansion on screen and report");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3e', #22-Oct-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3e', "Compute Data Matrix Clock Track Damage");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3e', "Fix calibration bug where uncorrected image used instead of corrected image");
Insert Into Glossary (Entry, Description) Values
(
    "CTD",
    "This is the Clock Track Damage.  This is the worst grade of all clock track segments as defined in ISO/IEC 16022-2006."
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3f', #25-Oct-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3f', "Allow 2-digit ITF");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3f', "Disable screen saver while logged in");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.3g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.3g', #29-Oct-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3g', "Fix 120DPI issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.3g', "Add Japanese Codabar");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("JapaneseCodabar", "Japanese Codabar", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4', #1-Nov-2007#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4', "Add option to export all records");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4', "Change Metric to on/off");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4', "Use Visual Basic COM port");
Insert Into Settings (Category, SettingName, SettingValue) Values ('Serial', 'CommPort',   '1');
Insert Into Settings (Category, SettingName, SettingValue) Values ('Serial', 'Settings',   '9600,n,8,1');
Insert Into Settings (Category, SettingName, SettingValue) Values ('Serial', 'Handshaking','0');
Update Glossary
    Set Description = "A=6- B=7-8 C=9-10 D=11-12 F=13+^This measures how the X-axis grid is different from the Y-axis grid."
    Where Entry = "Axial nonuniformity";
Update Glossary
    Set Description = "A=12- B=13-37 C=38-62 D=63-87 F=88+^A blemish is an unwanted mark or void that causes any part of a barcode symbol to not be decodable."
    Where Entry = "Blemish";    
Update Glossary
    Set Description = "A=70+ B=55-69 C=40-54 D=20-39 F=19-^This is the difference between the highest and the lowest reflectance Values found within a barcode symbol."
    Where Entry = "Contrast";
Update Glossary
    Set Description = "A=62+ B=50-61 C=37-49 D=25-36 F=24-^This is a measurement of printing accuracy.  Software measures the difference between a perfect barcode image and the actual image.  This is a measurement of time."
    Where Entry = "Decodability";
Update Glossary
    Set Description = "A=15- B=20-24 C=25-29 D=30-34 F=35+^Defects are a measurement of deviation in contrast found within a bar / space element.  In order to detect a defect error, the barcode symbol must be decodable."
    Where Entry = "Defects";
Update Glossary
    Set Description = "A=38- B=39-50 C=51-62 D=63-75 F=76+^This is the largest distance between the actual center of a module and the ideal center of a module."
    Where Entry = "Grid nonuniformity"; 
Update Glossary
    Set Description = "A=70+ B=60-69 C=50-59 D=40-49 F=39-^This is ratio of the minimum edge contrast to the symbol contrast."
    Where Entry = "Modulation";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4a', #21-Jan-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4a', "Fix problem with DataBar expanded variable bits");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4a', "Fix erroneous light bar warning with DataBar symbologies");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4a', "Change overexposure detection algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4a', "Fix bug where language change loses company name and last cal date");
Update ApplicationIdentifiers Set Format = "N1-15" Where Format = "N4-18";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4b', #24-Jan-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4b', "Fix one pixel aperture variance with Data Matrix");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4c', #12-Feb-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4c', "Fix problem with Data Matrix C40 Upper Shift");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4c', "Include updated Japanese translation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4c', "Include improved translate algorithm from 7000");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4c', "Add [Ctrl+Shift+P] to send print screen to printer");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4c', "Fix zoom image check box to maximize image");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4c', "Use actual video picture for thumbnail when generating live reports");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4d', #26-Feb-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4d', "Don't gray out lines during calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4d', "Fix incorrect message about light bars on dark background for PDF");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4e', #26-Mar-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4e', "Get another image after manual grading click");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4e', "Improve QRCode version detection");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4e', "Incorporate ExportOverride.vbd");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4e', "Fix glossary translation issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4e', "Show Rmin/Rmax for PDF and QRCode");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4f', #2-Apr-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4f', "Store ParamaterName Overall grade untranslated");
Update ReportData Set ParameterName = "Overall grade" Where ParameterName = "Gesamtauswertung";
Update ReportData Set ParameterName = "Overall grade" Where ParameterName = "Grado absoluto";
Update ReportData Set ParameterName = "Overall grade" Where ParameterName = "Note générale";
Update ReportData Set ParameterName = "Overall grade" Where ParameterName = "Giudizio Complessivo";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4g', #25-Apr-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4g', "Fix bug with one deviant pixel during lens cap check");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4h', #1-May-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4h', "Fix problem where sometimes CC would not read");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4h', "Improve Data Matrix reading on speckled backgrounds");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4i', #8-May-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4i', "Fix problem where bar growth not reported for some symbologies");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4j', #14-May-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4j', "Fix glossary translation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4k', #29-May-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4k', "Ignore upper/lowercase differences for translation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4k', "Fix DHL/AI problem");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4k', "Change format for AI 37 to N1-8");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4k', "Fix CC number of cols identification");
Update ApplicationIdentifiers Set Format = "N1-8" Where ApplicationIdentifier = "37" And Element = 1;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4l

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4l', #24-Jun-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4l', "Fix CC/PDF inconsistent grade issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4l', "Protect distributor button");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4l', "Add IFAH application standard");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("IFAH", "IFAH", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4m', #21-Jul-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Major improvements to Data Matrix algorithm for grid nonuniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Fix error in formula for axial nonuniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Force grade to F on structure error on any category");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Use double instead of integer for slightly better grade rounding");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Log L1 angle for data matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Use only 1X/3X for traditional bar measurements of Pharmacode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Always check AI for GS1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Allow user to change reference when logging in");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Ask user to compact database after delete old reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "In manual grading mode, collect additional images after redraw");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4m', "Improve stitching images with very large bars");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.4n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.4n', #24-Jul-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4n', "Add Aztec Code");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.4n', "Make sure AI date is YYMMDD");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Aztec", "Aztec Code", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5', #25-Jul-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5', "Change Grid Nonuniformity to measure from centers rather than the symbol edge");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "410"  And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "411"  And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "412"  And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "413"  And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "414"  And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "415"  And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8003" And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8004" And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8018" And Element = 0;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8100" And Element <= 1;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8101" And Element <= 1;
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8102" And Element <= 1;

Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("410" , 0, ""      , "Ship to - Deliver to GS1 Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("411" , 0, ""      , "Bill to - Invoice to GS1 Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("412" , 0, ""      , "Purchased from GS1 Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("413" , 0, ""      , "Ship for - Deliver for - Forward to GS1 Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("414" , 0, ""      , "Identification of a Physical Location - GS1 Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("415" , 0, ""      , "GS1 Global Location Number of the Invoicing Party");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 0, ""      , "GS1 Global Returnable Asset Identifier (GRAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8004", 0, ""      , "GS1 Global Individual Asset Identifier (GIAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 0, ""      , "GS1 Global Service Relation Number (GSRN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 0, ""      , "GS1-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 1, "N1"    , "GS1 Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 0, ""      , "GS1-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 1, "N1"    , "GS1 Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 0, ""      , "GS1-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 1, "N1"    , "GS1 Prefix");

Delete From Glossary Where Entry = "Eff Aperture Ref";
Delete From Glossary Where Entry = "Symbology";

Insert Into Glossary (Entry, Description) Values
(
    "Eff Aperture Ref",
    "Software will automatically choose one of the following 5 different aperture sizes: 03mm, 05mm, 06mm, 10mm, and 20mm.  The one selected depends upon whether ISO or General EAN/UCC has been selected, and also the symbology and the X dimension of the symbol."
);
Insert Into Glossary (Entry, Description) Values
(
    "Symbology",
    "Here is a list of supported symbologies: Code 39, ITF (I 2 of 5), Code 128, Codabar, GS1-128, UPC-A, UPC-E, EAN/JAN-8, EAN/JAN-13, DataBar-14 (linear), DataBar-stacked, DataBar-limited, DataBar-CCA, CCB, CCC, Pharmacode, PDF-417, Data Matrix ECC-200 (104x104 max), Data Matrix ECC-200 rectangular, PDF417, Micro-PDF417, QRCode, Aztec Code."
);

Update StructureTags Set Description = "GS1-128 emulation" Where Description = "UCC/EAN-128 emulation";
Update StructureTags Set Description = "Linked GS1-128"    Where Description = "Linked UCC/EAN-128";
 
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5a', #8-Aug-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5a', "Update setup screen with new reference if changed at login");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5a', "Improve Aztec Code decoding");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5a', "Fix problem with ITF-14 requiring explicit AI");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5a', "Don't warn about ITF-14 check digit problems unless GS1 specified");
Update Glossary
    Set Description = "A=15- B=16-20 C=21-25 D=26-30 F=31+^Defects are a measurement of deviation in contrast found within a bar / space element.  In order to detect a defect error, the barcode symbol must be decodable."
    Where Entry = "Defects";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5b', #25-Aug-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Improve Aztec Code decoding");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Only keep COM1 open while logged in");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Fix QRCode Kanji issue with Japanese regional settings");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Show embedded CR/LF in structure tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Only check AI date if format is D6");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Don't look for AIs in 2D unless GS1 is selected");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5b', "Fix CC decode problem where Y11A0327 would not decode but Y12A0327 would");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5c', #22-Oct-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5c', "Multiple improvements to Aztec Code decoding");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5c', "Implement AutoTest feature");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5c', "Handle Data Matrix symbols surrounded by boxes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5c', "Don't skip structure error warning if there are other less severe warnings");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5c', "Change FTP upload site");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5d', #19-Nov-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5d', "Use 5x5 sharpen matrix for 16mm lens with 1280x1024 camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5d', "Fine tune according to timing patterns for QRCode sample grid");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5e', #12-Dec-2008#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5e', "Add 10-line grading button to SRP screen");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5e', "Reread calibration from database every second instead of using % change");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5e', "Implement AI 8110");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5e', "Implement override aperture for 2D");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5e', "Fix problem with white dot preventing decode of QRCode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5e', "Correct and update glossary");

Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  0, ""      , "North America Coupon Code Identification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  1, "V6-12" , "Primary GS1 Company Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  2, "N6"    , "Offer Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  3, "V1-5"  , "Save Value");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  4, "Q1-5"  , "Primary Purchase Requirement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  5, "N1"    , "Primary Purchase Requirement Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110",  6, "X3"    , "Primary Purchase Family Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 10, "F1"    , "Data Field 1 - Second Qualifying Purchase");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 11, "N1"    , "Additional Purchase Rules Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 12, "Q1-5"  , "2nd Purchase Requirement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 13, "N1"    , "2nd Purchase Replacement Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 14, "X3"    , "2nd Purchase Family Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 15, "V6-12" , "2nd Purchase GS1 Company Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 20, "F2"    , "Data Field 2 - Third Qualifying Purchase");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 21, "Q1-5"  , "3rd Purchase Requirement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 22, "N1"    , "3rd Purchase Replacement Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 23, "X3"    , "3rd Purchase Family Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 24, "V6-12" , "3rd Purchase GS1 Company Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 30, "F3"    , "Data Field 3 - Expiration Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 31, "D6"    , "Expiration Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 40, "F4"    , "Data Field 4 - Start Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 41, "D6"    , "Start Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 50, "F5"    , "Data Field 5 - Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 51, "V6-15" , "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 60, "F6"    , "Data Field 6 - Retailer Identification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 61, "V7-13" , "Retailer GS1 Company Prefix or GLN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 90, "F9"    , "Data Field 9 - Miscellaneous Elements");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 91, "N1"    , "Save Value Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 92, "N1"    , "Save Value Applies to Which Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 93, "N1"    , "Store Coupon Flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 94, "N1"    , "Don't Multiply Flag");

Delete From Glossary Where Entry = "Decode";
Delete From Glossary Where Entry = "Fixed pattern damage";
Delete From Glossary Where Entry = "Cell height";
Delete From Glossary Where Entry = "Cell size";
Delete From Glossary Where Entry = "Cell width";
Delete From Glossary Where Entry = "TR";

Insert Into Glossary (Entry, Description) Values
(
    "Cell height",
    "This is the average height of a module in mils (or mm)."
);
Insert Into Glossary (Entry, Description) Values
(
    "Cell size",
    "This is the average size of a module in mils (or mm)."
);
Insert Into Glossary (Entry, Description) Values
(
    "Cell width",
    "This is the average width of a module in mils (or mm)."
);
Insert Into Glossary (Entry, Description) Values
(
    "Decode",
    "This specifies whether or not the symbol could be decoded based on the applicable reference decode algorithm. For linear codes, the number of successful decoded lines is also shown"
);
Insert Into Glossary (Entry, Description) Values
(
    "Fixed pattern damage",
    "This is the worst grade of all the fixed patterns. Fixed patterns vary according to the symbology. Consult the applicable Symbology Standard for more information"
);
Insert Into Glossary (Entry, Description) Values
(
    "TR",
    "This is the transition ratio. It is the worst grade measured for all the clock tracks (internal and external) together with their adjacent solid areas."
);
Insert Into Glossary (Entry, Description) Values
(
    "Segment A1",
    "This is the top left finder pattern when the symbol is oriented at 0 degrees. For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Segment A2",
    "This is the top right finder pattern when the symbol is oriented at 0 degrees. For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Segment A3",
    "This is the bottom left finder pattern when the symbol is oriented at 0 degrees. For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Segment B1",
    "This is the top timing pattern when the symbol is oriented at 0 degrees. For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Segment B2",
    "This is the left timing pattern when the symbol is oriented at 0 degrees. For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Segment C",
    "These are the small alignment patterns. For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Format info",
    "This is the area adjacent to the finder patterns where the format information is stored.  For more detailed information, consult ISO 18004"
);
Insert Into Glossary (Entry, Description) Values
(
    "Angle",
    "This is the orientation of the symbol expressed as the clockwise rotation in degrees from 0 degrees."
);

Insert Into Glossary (Entry, Description) Values
(
    "L1 Angle",
    "This is the orientation of the symbol expressed as the clockwise rotation in degrees from 0 degrees."
);
Insert Into Glossary (Entry, Description) Values
(
    "Fixed pattern damage A",
    "This is the bullseye finder pattern together with the associated orientation patterns."
);
Insert Into Glossary (Entry, Description) Values
(
    "Fixed pattern damage B",
    "This is the reference grid that is encoded in full range symbols."
);
Insert Into Glossary (Entry, Description) Values
(
    "Codeword yield",
    "Codeword Yield is the number of validly decoded codewords expressed as a percentage of the maximum number of codewords that could have been decoded (after adjusting for tilt)."
);
Insert Into Glossary (Entry, Description) Values
(
    "Codeword PQ",
    "Codeword Print Quality is a complex formula based on Modulation, Decodability and Defect measured using the rules defined in ISO 15416."
);
Insert Into Glossary (Entry, Description) Values
(
    "Row height",
    "This is the height of each row expressed in Mils (or mm)."
);
Insert Into Glossary (Entry, Description) Values
(
    "Erasures",
    "Very similar to an error except that in multi-row symbols each row has an address pattern so you know if a row (or part of a row) is missing (erased)."
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5f', #28-Jan-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5f', "Fix HTML report when decoded text has lots of data");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5f', "Require FUNC1 for all variable length, AI=402, and AI>=422");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5f', "Add dimensional values to 10-line grading");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5f', "Include quiet zone info on SRP printout");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5g', #11-Feb-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5g', "Fix incorrect warnings about missing Func1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5g', "Fix issue where database was reread during calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5g', "Fix overlapping quiet zone messages");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5h', #27-Feb-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5h', "Support Hanxin code");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Hanxin", "Chinese Sensible (Han Xin) Code", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5i', #13-Mar-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5i', "Make initial GT determination in Data Matrix more deterministic");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5i', "Fune tune Data Matrix sampling grid before computing modulation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5j', #19-Mar-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5j', "Don't complain about missing <Func1> if preceded by either <Code> or <Shift>");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5j', "Reset override aperture to zero if turned off");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5j', "Fix override aperture computation to match automatic computation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5k', #25-Mar-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5k', "Improve Data Matrix grid layout for uneven codes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5l

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5l', #11-Apr-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5l', "Increase compatibility with MySQL");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5l', "Only enforce fixed-length Func1 rule on last element in AI");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5l', "Redo entire AI table to match Jan 2009 GS1 specification");

Delete from ApplicationIdentifiers;

Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("00",   0,  "",      "SSCC (Serial Shipping Container Code)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("00",   1,  "K18",   "SSCC (Serial Shipping Container Code)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("01",   0,  "",      "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("01",   1,  "K14",   "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("02",   0,  "",      "GTIN of Contained Trade Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("02",   1,  "K14",   "GTIN of Contained Trade Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("10",   0,  "",      "Batch or Lot Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("10",   1,  "X1-20", "Batch or Lot Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("11",   0,  "",      "Production Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("11",   1,  "D6",    "Production Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("12",   0,  "",      "Due Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("12",   1,  "D6",    "Due Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("13",   0,  "",      "Packaging Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("13",   1,  "D6",    "Packaging Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("15",   0,  "",      "Best Before Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("15",   1,  "D6",    "Best Before Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("17",   0,  "",      "Expiration Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("17",   1,  "D6",    "Expiration Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("20",   0,  "",      "Variant Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("20",   1,  "N2",    "Variant Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("21",   0,  "",      "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("21",   1,  "X1-20", "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("22",   0,  "",      "Secondary Data Fields");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("22",   1,  "X1-29", "Secondary Data Fields");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("240",  0,  "",      "Additional Item Identification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("240",  1,  "X1-30", "Additional Item Identification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("241",  0,  "",      "Customer Part Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("241",  1,  "X1-30", "Customer Part Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("242",  0,  "",      "Made-to-Order Variation Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("242",  1,  "N1-6",  "Made-to-Order Variation Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("250",  0,  "",      "Secondary Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("250",  1,  "X1-30", "Secondary Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("251",  0,  "",      "Reference to Source Entity");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("251",  1,  "X1-30", "Reference to Source Entity");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("253",  0,  "",      "Global Document Type Identifier (GDTI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("253",  1,  "K13",   "Global Document Type Identifier (GDTI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("253",  2,  "N0-17", "Serial Component");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("254",  0,  "",      "GLN Extension Component");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("254",  1,  "X1-20", "GLN Extension Component");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("30",   0,  "",      "Count of Items (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("30",   1,  "N1-8",  "Count of Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("310",  0,  "",      "Net weight, kilograms (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("310",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("310",  2,  "N6",    "Net weight, kilograms");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("311",  0,  "",      "Length of first dimension, meters (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("311",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("311",  2,  "N6",    "Length or first dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("312",  0,  "",      "Width, diameter, or second dimension, meters (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("312",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("312",  2,  "N6",    "Width, diameter, or second dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("313",  0,  "",      "Depth, thickness, height, or third dimension, meters (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("313",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("313",  2,  "N6",    "Depth, thickness, height, or third dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("314",  0,  "",      "Area, square meters (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("314",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("314",  2,  "N6",    "Area, square meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("315",  0,  "",      "Net volume, liters (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("315",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("315",  2,  "N6",    "Net volume, liters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("316",  0,  "",      "Net volume, cubic meters (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("316",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("316",  2,  "N6",    "Net volume, cubic meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("320",  0,  "",      "Net weight, pounds (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("320",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("320",  2,  "N6",    "Net weight, pounds");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("321",  0,  "",      "Length of first dimension, inches (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("321",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("321",  2,  "N6",    "Length of first dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("322",  0,  "",      "Length of first dimension, feet (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("322",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("322",  2,  "N6",    "Length of first dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("323",  0,  "",      "Length of first dimension, yards (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("323",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("323",  2,  "N6",    "Length of first dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("324",  0,  "",      "Width, diameter, or second dimension, inches (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("324",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("324",  2,  "N6",    "Width, diameter, or second dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("325",  0,  "",      "Width, diameter, or second dimension, feet (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("325",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("325",  2,  "N6",    "Width, diameter, or second dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("326",  0,  "",      "Width, diameter, or second dimension, yards (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("326",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("326",  2,  "N6",    "Width, diameter, or second dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("327",  0,  "",      "Depth, thickness, height, or third dimension, inches (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("327",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("327",  2,  "N6",    "Depth, thickness, height, or third dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("328",  0,  "",      "Depth, thickness, height, or third dimension, feet (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("328",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("328",  2,  "N6",    "Depth, thickness, height, or third dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("329",  0,  "",      "Depth, thickness, height, or third dimension, yards (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("329",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("329",  2,  "N6",    "Depth, thickness, height, or third dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("330",  0,  "",      "Logistic weight, kilograms");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("330",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("330",  2,  "N6",    "Logistic weight, kilograms");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("331",  0,  "",      "Length or first dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("331",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("331",  2,  "N6",    "Length or first dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("332",  0,  "",      "Width, diameter, or second dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("332",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("332",  2,  "N6",    "Width, diameter, or second dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("333",  0,  "",      "Depth, thickness, height, or third dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("333",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("333",  2,  "N6",    "Depth, thickness, height, or third dimension, meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("334",  0,  "",      "Area, square meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("334",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("334",  2,  "N6",    "Area, square meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("335",  0,  "",      "Logistic volume, liters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("335",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("335",  2,  "N6",    "Logistic volume, liters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("336",  0,  "",      "Logistic volume, cubic meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("336",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("336",  2,  "N6",    "Logistic volume, cubic meters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("337",  0,  "",      "Kilograms per square metre");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("337",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("337",  2,  "N6",    "Kilograms per square metre");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("340",  0,  "",      "Logistic weight, pounds");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("340",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("340",  2,  "N6",    "Logistic weight, pounds");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("341",  0,  "",      "Length or first dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("341",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("341",  2,  "N6",    "Length or first dimension, inches)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("342",  0,  "",      "Length or first dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("342",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("342",  2,  "N6",    "Length or first dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("343",  0,  "",      "Length or first dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("343",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("343",  2,  "N6",    "Length or first dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("344",  0,  "",      "Width, diameter, or second dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("344",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("344",  2,  "N6",    "Width, diameter, or second dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("345",  0,  "",      "Width, diameter, or second dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("345",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("345",  2,  "N6",    "Width, diameter, or second dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("346",  0,  "",      "Width, diameter, or second dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("346",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("346",  2,  "N6",    "Width, diameter, or second dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("347",  0,  "",      "Depth, thickness, height, or third dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("347",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("347",  2,  "N6",    "Depth, thickness, height, or third dimension, inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("348",  0,  "",      "Depth, thickness, height, or third dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("348",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("348",  2,  "N6",    "Depth, thickness, height, or third dimension, feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("349",  0,  "",      "Depth, thickness, height, or third dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("349",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("349",  2,  "N6",    "Depth, thickness, height, or third dimension, yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("350",  0,  "",      "Area, square inches (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("350",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("350",  2,  "N6",    "Area, square inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("351",  0,  "",      "Area, square feet (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("351",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("351",  2,  "N6",    "Area, square feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("352",  0,  "",      "Area, square yards (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("352",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("352",  2,  "N6",    "Area, square yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("353",  0,  "",      "Area, square inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("353",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("353",  2,  "N6",    "Area, square inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("354",  0,  "",      "Area, square feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("354",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("354",  2,  "N6",    "Area, square feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("355",  0,  "",      "Area, square yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("355",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("355",  2,  "N6",    "Area, square yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("356",  0,  "",      "Net weight, troy ounces (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("356",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("356",  2,  "N6",    "Net weight, troy ounces");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("357",  0,  "",      "Net weight (or volume), ounces (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("357",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("357",  2,  "N6",    "Net weight (or volume), ounces");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("360",  0,  "",      "Net volume, quarts (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("360",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("360",  2,  "N6",    "Net volume, quarts");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("361",  0,  "",      "Net volume, gallons U.S. (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("361",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("361",  2,  "N6",    "Net volume, gallons U.S.");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("362",  0,  "",      "Logistic volume, quarts");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("362",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("362",  2,  "N6",    "Logistic volume, quarts");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("363",  0,  "",      "Logistic volume, gallons U.S.");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("363",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("363",  2,  "N6",    "Logistic volume, gallons U.S.");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("364",  0,  "",      "Net volume, cubic inches (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("364",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("364",  2,  "N6",    "Net volume, cubic inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("365",  0,  "",      "Net volume, cubic feet (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("365",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("365",  2,  "N6",    "Net volume, cubic feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("366",  0,  "",      "Net volume, cubic yards (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("366",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("366",  2,  "N6",    "Net volume, cubic yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("367",  0,  "",      "Logistic volume, cubic inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("367",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("367",  2,  "N6",    "Logistic volume, cubic inches");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("368",  0,  "",      "Logistic volume, cubic feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("368",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("368",  2,  "N6",    "Logistic volume, cubic feet");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("369",  0,  "",      "Logistic volume, cubic yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("369",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("369",  2,  "N6",    "Logistic volume, cubic yards");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("37",   0,  "",      "Count of Trade Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("37",   1,  "N1-8",  "Count of Trade Items");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("390",  0,  "",      "Applicable Amount Payable, local currency");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("390",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("390",  2,  "N1-15", "Applicable Amount Payable, local currency");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391",  0,  "",      "Applicable Amount Payable with ISO Currency Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391",  2,  "M3",    "ISO CurrencyName Code & Country & CurrencyName");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("391",  3,  "N1-15", "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("392",  0,  "",      "Applicable Amount Payable, single monetary area (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("392",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("392",  2,  "N1-15", "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393",  0,  "",      "Applicable Amount Payable with ISO Currency Code (Variable Measure Trade Item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393",  1,  "P1",    "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393",  2,  "M3",    "ISO CurrencyName Code & Country & CurrencyName");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("393",  3,  "N1-15", "Applicable Amount Payable");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("400",  0,  "",      "Customer's Purchase Order Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("400",  1,  "X1-30", "Customer's Purchase Order Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("401",  0,  "",      "Consignment Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("401",  1,  "X1-30", "Consignment Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("402",  0,  "",      "Shipment Identification Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("402",  1,  "K17",   "Shipment Identification Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("403",  0,  "",      "Routing Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("403",  1,  "X1-30", "Routing Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("410",  0,  "",      "Ship to - Deliver to Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("410",  1,  "K13",   "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("411",  0,  "",      "Bill to - Invoice to Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("411",  1,  "K13",   "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("412",  0,  "",      "Purchased from Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("412",  1,  "K13",   "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("413",  0,  "",      "Ship for - Deliver for - Forward to Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("413",  1,  "K13",   "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("414",  0,  "",      "Identification of a Physical Location - Global Location Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("414",  1,  "K13",   "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("415",  0,  "",      "Global Location Number of the Invoicing Party");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("415",  1,  "K13",   "Location Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("420",  0,  "",      "Ship to - Deliver to Postal Code Within a Single Postal Authority");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("420",  1,  "X1-20", "Postal Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("421",  0,  "",      "Ship to - Deliver to Postal Code with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("421",  1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("421",  2,  "X4-12", "Postal Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("422",  0,  "",      "Country of Origin of a Trade Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("422",  1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("423",  0,  "",      "Country of Initial Processing");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("423",  1,  "Y3-15", "ISO Country Code(s) & Countries");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("424",  0,  "",      "Country of Processing");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("424",  1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("425",  0,  "",      "Country of Disassembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("425",  1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("426",  0,  "",      "Country Covering full Process Chain");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("426",  1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7001", 0,  "",      "NATO Stock Number (NSN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7001", 1,  "N13",   "NATO Stock Number (NSN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7002", 0,  "",      "UN/ECE Meat Carcasses and Cuts Classification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7002", 1,  "X1-30", "UN/ECE Product Classification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7003", 0,  "",      "Expiration Date and Time");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7003", 1,  "D10",   "Expiration Date and Time");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7030", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7030", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7030", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7031", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7031", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7031", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7032", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7032", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7032", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7033", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7033", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7033", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7034", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7034", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7034", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7035", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7035", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7035", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7036", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7036", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7036", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7037", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7037", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7037", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7038", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7038", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7038", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7039", 0,  "",      "Approval Number of Processor with ISO Country Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7039", 1,  "Y3",    "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7039", 2,  "X0-27", "Approval Number of Processor");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 0,  "",      "Roll Products (Width, Length, Core Diameter, Direction, Splices)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 1,  "N4",    "Slit Width in milimeters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 2,  "N5",    "Actual Length in Metres");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 3,  "N3",    "Internal Core Diameter in Milimeters");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 4,  "N1",    "Winding Direction (Face out = 0, Face in = 1, Undefined = 9)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8001", 5,  "N1",    "Number of Splices (0 to 8 = Actual Number, 9 = Unknown)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8002", 0,  "",      "Cellular Mobile Telephone Identifier");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8002", 1,  "X1-20", "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 0,  "",      "Global Returnable Asset Identifier (GRAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 1,  "K14",   "Global Returnable Asset Identifier (GRAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8003", 2,  "X0-16", "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8004", 0,  "",      "Global Individual Asset Identifier (GIAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8004", 1,  "X1-30", "Global Individual Asset Identifier (GIAI)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8005", 0,  "",      "Price Per Unit of Measure");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8005", 1,  "N6",    "Price Per Unit of Measure");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 0,  "",      "Identification of the Components of a Trade Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 1,  "N14",   "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 2,  "N2",    "Relative Number of Components Within the Assembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8006", 3,  "N2",    "Total Number of Components in the Assembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8007", 0,  "",      "International Bank Account Number (IBAN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8007", 1,  "X1-30", "International Bank Account Number (IBAN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8008", 0,  "",      "Date and Time of Production");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8008", 1,  "D8-12", "Date and Time of Production");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 0,  "",      "Global Service Relation Number (GSRN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 1,  "K18",   "Global Service Relation Number (GSRN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8020", 0,  "",      "Payment Slip Reference Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8020", 1,  "X1-25", "Payment Slip Reference Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 0,  "",      "GS1-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 1,  "N1",    "GS1 Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8100", 2,  "N5",    "Offer Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 0,  "",      "GS1-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 1,  "N1",    "GS1 Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 2,  "N5",    "Offer Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8101", 3,  "D4",    "Expiration Date (MMYY)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 0,  "",      "GS1-128 Coupon Extended Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 1,  "Z1",    "Filler code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8102", 2,  "N1",    "UCC Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 0,  "",      "Coupon Code Identification for Use in North America");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 1,  "V6-12", "Primary GS1 Company Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 2,  "N6",    "Offer Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 3,  "V1-5",  "Save Value");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 4,  "Q1-5",  "Primary Purchase Requirement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 5,  "N1",    "Primary Purchase Requirement Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 6,  "X3",    "Primary Purchase Family Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 10, "F1",    "Data Field 1 - Second Qualifying Purchase");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 11, "N1",    "Additional Purchase Rules Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 12, "Q1-5",  "2nd Purchase Requirement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 13, "N1",    "2nd Purchase Replacement Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 14, "X3",    "2nd Purchase Family Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 15, "V6-12", "2nd Purchase GS1 Company Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 20, "F2",    "Data Field 2 - Third Qualifying Purchase");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 21, "Q1-5",  "3rd Purchase Requirement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 22, "N1",    "3rd Purchase Replacement Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 23, "X3",    "3rd Purchase Family Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 24, "V6-12", "3rd Purchase GS1 Company Prefix");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 30, "F3",    "Data Field 3 - Expiration Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 31, "D6",    "Expiration Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 40, "F4",    "Data Field 4 - Start Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 41, "D6",    "Start Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 50, "F5",    "Data Field 5 - Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 51, "V6-15", "Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 60, "F6",    "Data Field 6 - Retailer Identification");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 61, "V7-13", "Retailer GS1 Company Prefix or GLN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 90, "F9",    "Data Field 9 - Miscellaneous Elements");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 91, "N1",    "Save Value Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 92, "N1",    "Save Value Applies to Which Item");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 93, "N1",    "Store Coupon Flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8110", 94, "N1",    "Don't Multiply Flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("90",   0,  "",      "Information Mutually Agreed Between Trading Partners");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("90",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("91",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("91",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("92",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("92",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("93",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("93",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("94",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("94",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("95",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("95",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("96",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("96",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("97",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("97",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("98",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("98",   1,  "X1-30", "Data Field");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("99",   0,  "",      "Company Internal Information");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("99",   1,  "X1-30", "Data Field");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5m', #14-Apr-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5m', "Fix bug with CC decoding stopped prematurely after (11) or (17)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5m', "Add warning about AI 90 binary encodation not supported yet");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5n', #20-Apr-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5n', "Add MaxiCode symbology");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5o

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5o', #21-Apr-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5o', "Make AztecCode and MaxiCode reading more robust");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5o', "Fix problem where certain Data Matrix codes would cause the software to lock up");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5p

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5p', #27-Jun-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5p', "Fix incorrect structure error for MMYY");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5q

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5q', #13-Jul-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5q', "Fix hard-break bug where nbsp appeared in HTML report");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5q', "Include Layman's Guide to IOS Verification");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5r

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5r', #23-Jul-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5r', "Implement confirm reference before print");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5r', "Unify 9500 Data Matrix algorithm with the one used in the 7000");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5s

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5s', #28-Jul-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5s', "Allow Override aperture for 1D");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5s', "Redo ISO currency tables");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5s', "Fix problems where edge determination errors caused phantom quiet zone errors");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5s', "Complain if supplemental encodation is more than 12X away from main code");

Delete From IsoCurrencies;
Insert Into IsoCurrencies (Code, CurrencyName) Values ("008", "Lek");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("012", "Algerian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("032", "Argentine peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("036", "Australian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("044", "Bahamian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("048", "Bahraini dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("050", "Bangladeshi taka");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("051", "Armenian dram");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("052", "Barbados dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("060", "Bermudian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("064", "Ngultrum");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("068", "Boliviano");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("072", "Pula");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("084", "Belize dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("090", "Solomon Islands dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("096", "Brunei dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("104", "Kyat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("108", "Burundian franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("116", "Riel");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("124", "Canadian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("132", "Cape Verde escudo");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("136", "Cayman Islands dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("144", "Sri Lanka rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("152", "Chilean peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("156", "Chinese Yuan");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("170", "Colombian peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("174", "Comoro franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("188", "Costa Rican colon");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("191", "Croatian kuna");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("192", "Cuban peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("203", "Czech Koruna");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("208", "Danish krone");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("214", "Dominican peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("230", "Ethiopian birr");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("232", "Nakfa");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("233", "Kroon");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("238", "Falkland Islands pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("242", "Fiji dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("262", "Djibouti franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("270", "Dalasi");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("292", "Gibraltar pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("320", "Quetzal");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("324", "Guinea franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("328", "Guyana dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("332", "Haiti gourde");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("340", "Lempira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("344", "Hong Kong dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("348", "Forint");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("352", "Iceland krona");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("356", "Indian rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("360", "Rupiah");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("364", "Iranian rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("368", "Iraqi dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("376", "Israeli new sheqel");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("388", "Jamaican dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("392", "Japanese yen");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("398", "Tenge");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("400", "Jordanian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("404", "Kenyan shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("408", "North Korean won");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("410", "South Korean won");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("414", "Kuwaiti dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("417", "Som");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("418", "Kip");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("422", "Lebanese pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("426", "Lesotho loti");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("428", "Latvian lats");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("430", "Liberian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("434", "Libyan dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("440", "Lithuanian litas");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("446", "Pataca");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("454", "Kwacha");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("458", "Malaysian ringgit");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("462", "Rufiyaa");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("478", "Ouguiya");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("480", "Mauritius rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("484", "Mexican peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("496", "Tugrik");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("498", "Moldovan leu");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("504", "Moroccan dirham");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("512", "Rial Omani");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("516", "Namibian dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("524", "Nepalese rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("532", "Netherlands Antillean guilder");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("533", "Aruban guilder");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("548", "Vatu");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("554", "New Zealand dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("558", "Cordoba oro");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("566", "Naira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("578", "Norwegian krone");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("586", "Pakistan rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("590", "Balboa");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("598", "Kina");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("600", "Guarani");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("604", "Nuevo sol");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("608", "Philippine peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("634", "Qatari rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("643", "Russian rouble");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("646", "Rwanda franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("654", "Saint Helena pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("678", "Dobra");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("682", "Saudi riyal");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("690", "Seychelles rupee");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("694", "Leone");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("702", "Singapore dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("704", "Vietnamese dong");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("706", "Somali shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("710", "South African rand");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("748", "Lilangeni");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("752", "Swedish krona/kronor");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("756", "Swiss franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("760", "Syrian pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("764", "Baht");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("776", "Pa'anga");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("780", "Trinidad and Tobago dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("784", "United Arab Emirates dirham");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("788", "Tunisian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("800", "Uganda shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("807", "Denar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("818", "Egyptian pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("826", "Pound sterling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("834", "Tanzanian shilling");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("840", "US dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("858", "Peso Uruguayo");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("860", "Uzbekistan som");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("882", "Samoan tala");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("886", "Yemeni rial");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("894", "Kwacha");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("901", "New Taiwan dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("931", "Cuban convertible peso");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("932", "Zimbabwe dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("934", "Manat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("936", "Cedi");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("937", "Venezuelan bolívar fuerte");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("938", "Sudanese pound");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("941", "Serbian dinar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("943", "Metical");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("944", "Azerbaijanian manat");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("946", "Romanian new leu");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("949", "Turkish lira");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("951", "East Caribbean dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("953", "CFP franc");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("968", "Surinam dollar");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("969", "Malagasy ariary");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("970", "Unidad de Valor Real");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("971", "Afghani");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("972", "Somoni");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("973", "Kwanza");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("974", "Belarussian ruble");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("975", "Bulgarian lev");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("976", "Franc Congolais");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("977", "Convertible marks");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("978", "euro");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("980", "Hryvnia");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("981", "Lari");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("984", "Bolivian Mvdol");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("985", "Zloty");
Insert Into IsoCurrencies (Code, CurrencyName) Values ("986", "Brazilian real");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5t

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5t', #9-Aug-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5t', "Change calibration procedure to use all white image for light balancing");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5u

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5u', #21-Aug-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5u', "During calibration, examine light curves to find point at which exposure causes curve to go non-linear");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5u', "Allow screens to be resized, and automatically scale controls and fonts to match");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5u', "Fix bug where certain CCA symbol would not read");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5v

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5v', #24-Aug-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5v', "Remember form size in database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5v', "Improve Data Matrix edge detection to avoid no reads on fuzzy symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5v', "Fix another bug where certain CCA symbol would not read");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5v', "Avoid processing loop if invalid decimal placement");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5v', "Improve Data Matrix edge detection to handle fuzzy solid pattern along with sharp clock track");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5w

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5w', #16-Oct-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5w', "Show Bar Code Not Detected instead of 0/xx/660 in HTML file");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5w', "Fix quiet zone measurement error");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5w', "Restore fine tune grid for Data Matrix to avoid inconsistent grading on poor quality symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5w', "Add application standard French CIP-ACL");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5w', "Fix bug where QRCode would occasionally not find a perfectly good symbol");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("CIP-ACL", "French CIP-ACL", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5x

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5x', #16-Nov-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5x', "Fix VbdView unable to handle Japanese characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5x', "Change new non-linear lighting detection rules to apply when FOV > 4 inches");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5x', "Require either 039008 or 039009 for French CIP-ACL");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5x', "Fix problem where override aperture not remembered in database");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.5y

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.5y', #29-Dec-2009#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Fix incorrect display of tabs and labels with Japanese");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Fix incorrect character set in MSFlexGrid controls");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Remove feature to restore English-only font character set for certain controls");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Save pictures in improved calibration log");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Make translations case insensitive");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "When testing FOV, remember reading could be in inches or mm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Implement Windows lockdown");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Warn if UPC/EAN exceeds 200%");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Fix bug where QZ error reported for DataBar");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Fix subscript out of range for DataBar Expanded");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Fix crash when screen minimized");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Auto-discriminate AztecCode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Show individual measurements for modulation when selected");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.5y', "Fix wrong radius in AztecCode (caused lockup or modulation=0)");
Delete From ApplicationStandards Where ShortName = "CIP-ACL";
Delete From ApplicationStandards Where ShortName = "Aztec";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("CIP",       "French CIP",          1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6', #17-Feb-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Implement new application standard Japan Post");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Improve warnings about missing linkage flags and/or CC codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Fix wrong aperture bug with MIL-STD-130M");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Update copyright year");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Disable access after 3 wrong passwords");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Implement optional automatic login");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Display bar height in inches");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Add label about best results if centered");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Make number of signatures configurable");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Rename Func1 as FNC1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Don't save form position if closing and minimized");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Translate warnings in structure tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Update translation files");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Improve tie-breaker logic for DataBar expanded versus PDF417");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Improve de-tilt logic for PDF417 for work better with jagged codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Switch to Visual Studio 2008 (from 2005)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Use new installation procedure instead of MultiRun");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Fix bug which caused PDF codes to get an F grade for defects on leading/trailing edge");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Include PDF manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6', "Remove (TM) after INTEGRA");
Delete From ApplicationStandards Where ShortName = "JapanPost";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("JapanPost", "Japan Post", 1);
Alter Table Operators Add Column FailedAttempts Integer;
Update Operators Set FailedAttempts = 0;
Update ApplicationStandards Set LongName = "MIL-STD-130N" Where ShortName = "MilStd";
Insert Into Settings (Category, SettingName, SettingValue) Values ('Etc', 'Signatures', '2');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6a', #1-Mar-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6a', "Use latest LvsSetup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6a', "Improve AztecCode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6a', "Add error message if Xdim < 75% for EAN/UPC");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6a', "Translate message about color key in report");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6b', #24-Mar-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6b', "Ignore cameras with serial number 0");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6b', "Make minor tweaks to Data Matrix fine tuning");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6b', "Change Func1 to FNC1 in database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6b', "Don't be fooled by embedded angle brackets when processing AIs");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6b', "Avoid array is locked error when changing tabs during processing");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6b', "Increase 'blind spot' when field of view is 5.8 inches or more");
Delete From StructureTags Where EmbeddedData = "<232>";
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<232>", "FNC1", "<FNC1>");
Delete From StructureTags Where EmbeddedData = "<920>";
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<920>", "CC Indicator", "Implied <FNC1>");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6c', #15-Apr-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6c', "Change working directory in shortcut icons to be empty and therefore compatible with Vista and Windows 7");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6c', "Don't rely on current directory being the same as the application directory");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6d', #29-Apr-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6d', "Change SetExposure logic to avoid processing wrong image");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6d', "Change calibration scoring to prefer 50ms");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6d', "Change calibration scoring to use fractional portions of decodability and modulation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6e', #30-May-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6e', "Add experimental support for non-Lumenera cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6e', "Fix bug in Data Matrix where extra <NUL> would appear after <FNC1>");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6f', #11-Jun-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6f', "Remove experimental support for non-Lumenera cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6f', "Fix bug where non-English systems could not run VbdView");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6f', "Include bar growth for DataBar14");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6g', #16-Jun-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6g', "Include bar growth for DataBar Expanded");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6h', #7-Jul-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6h', "On installation copy MDB file to correct directory");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6h', "Add DirectShow interface for generic USB cameras");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6i', #13-Jul-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6i', "Add warning about FNC4");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6i', "Add warning about unprintable characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6i', "Treat characters between 128 and 159 as unprintable characters");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6j', #26-Jul-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6j', "Improve DirectShow single-core operation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6k', #4-Aug-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6k', "Replace DirectShow with OV interface");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6k', "Migrate QRCode improvements for locating finder pattern from 7000");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6k', "Fix crash after 3 failed attempts to login");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6L

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6L', #5-Aug-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6L', "Allow manual override of gain for testing");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6m', #6-Aug-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6m', "Give warning if unprintable characters include a space");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6n', #15-Sep-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6n', "Improve functionality with OV sensor");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6o

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6o', #20-Sep-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6o', "Turn off more OV camera automatic settings");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6p

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6p', #29-Sep-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6p', "Add more image adjustments for OV camera");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6q

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6q', #5-Oct-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6q', "Add more image adjustments for OV camera");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6r

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6r', #20-Oct-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6r', "Add more image adjustments for OV camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6r', "Fix DataBar Expanded implied latch to numeric mode after FNC1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6r', "Add FNC1 logic to QRCode");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6s

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6s', #29-Oct-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6s', "Don't fail UPC/EAN if < 75% -- just give warning");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6s', "Add new setting ExcludeAllOnExport");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6s', "Add new setting IncludePrintStructure");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6s', "Use quiet-zone rules from ISO/IEC 15420:2009(E)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6s', "Reset percent full warning when database gets smaller");
Insert Into Settings (Category, SettingName, SettingValue) Values ('Export', 'ExcludeAllOnExport',    '0');
Insert Into Settings (Category, SettingName, SettingValue) Values ('Print',  'IncludePrintStructure', '0');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6t

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6t', #18-Nov-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6t', "Use Microsoft Visual C++ 2010 instead of 2008");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6t', "Give better warning if FNC1 missing from Code 128 when set to GS1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6t', "Accept mirrored and inverted Aztec Codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6t', "Improve Data Matrix clock track detection algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6t', "Separate 2D debug directories into DMDebug, QRDebug, AZDebug, etc.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6u

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6u', #7-Dec-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6u', "Use AIM DPM global threshold algorithm for Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6u', "Include latest Data Matrix clock track detection algorithm");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6v

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6v', #19-Dec-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6v', "Show crosshair in center when using multi rotation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6v', "Don't complain about FNC1 when using multi rotation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6v', "Add USPS Code 128 application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6v', "Support 2048x1536 color camera");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("USPS128", "USPS Code 128", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6w

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6w', #30-Dec-2010#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6w', "Fix typo which caused USPS structure to be shifted by 2 digits");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6w', "Work-around VB bug which prevented feature activation from working");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6w', "Fix bug in Data Matrix where automatic thresholding failed");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6w', "Fix bug in Data Matrix where multi-region symbols did not read");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6w', "Remove logic to support OV sensor");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6x

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6x', #21-Jan-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6x', "Fix additional errors in latest Data Matrix changes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6y

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6y', #14-Mar-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6y', "Change calibration to support color camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6y', "Fix bug in AI 8110 which didn't include room for the VLI itself");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6y', "Add USPS Intelligent Mail Barcode");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Intelligent", "USPS Intelligent Mail Barcode", 1);
Delete From Calibration;
Drop Table Calibration;
Create Table Calibration
(
    SerialNumber            Integer,
    CalibrationOk           Bit,
    Exposure            Integer,
    AnalogGain              Real,
    BalanceImage            Image,
    DigitalGain             Real,
    DigitalShift            Integer,
    Gamma                   Real,
    Sharpen                 Integer,
    ApertureScaling         Real,
    MatrixSize              Integer,
    MilsPerPixel            Real,
    LightingMode            Text,
    MirrorMode              Bit,
    FlipMode                Bit,
    MostRecent              Bit,
    BarSpaceCorrection      Real,
    LastCalDate             DateTime,
    Primary Key             (SerialNumber)
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6z

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6z', #13-Apr-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Support 2-letter suffixes on version");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Fix right-most pixel on 1280x1024 cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Don't draw lane detail in red when unprintable characters detected");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Don't adjust sharpen during calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Show field of view rounded to 0.25 instead of 0.1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Gray out bottom lines when FOV >= 5.8 inches");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Update to Lumenera 5.0.4");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Update to latest LvsSetup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Change calibration [Reset] defaults");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6z', "Implement DataBar Expanded blemish");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6za

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6za', #18-Apr-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6za', "Add message Results are not valid -- uncalibrated image");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6za', "Add message Light bars on dark background invalid for linear codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6za', "Fix bar/spaces occasionally backwards on SRP view");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6za', "Add optional 3-signature boxes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.6zb

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.6zb', #29-Apr-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6zb', "Fix gray out of bottom lines when FOV > 6.2");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6zb', "Fix issue where upgrade wouldn't work - uninstall was needed");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.6zb', "Fix fiasco created by Microsoft's change to msado28.tbl on Windows 7 SP1");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7', #8-Aug-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Reduce gray out when FOV > 6.2");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Show FOV rounded to one decimal");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Relax rules slightly to avoid one or more pixels are too dark");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Require calibration line to be through pass area before continuing");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Decode a partial DataBar Expanded in both directions and pick the longer result");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Don't generate unprintable warning for UPC/EAN with supplemental encodations");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Redo stitching algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Add Auto-sector capability");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Treat UPC/EAN > 200% as a warning");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Fix button enables on Archive tab when exiting browse mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Add setting Report.SingleColumn");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Improve AztecCode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Add factory calibration ranging feature");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Speed up Data Matrix clock track identification algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Allow LvsSetup to merge data on CD with existing database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Use proper directory on Windows 7 for export override and custom reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7', "Fix problem with 2 signatures");
Insert Into Settings (Category, SettingName, SettingValue) Values ('Report', 'SingleColumn', '0');

Delete From Calibration;
Drop Table Calibration;
Create Table Calibration
(
    SerialNumber            Integer,
    CalibrationOk           Bit,
    Exposure                Integer,
    AnalogGain              Real,
    BalanceImage            Image,
    DigitalGain             Real,
    DigitalShift            Integer,
    Gamma                   Real,
    SmallXdim               Real,
    LargeXdim               Real,
    SmallSharpen            Integer,
    LargeSharpen            Integer,
    SmallApertureScaling    Real,
    LargeApertureScaling    Real,
    MatrixSize              Integer,
    MilsPerPixel            Real,
    LightingMode            Text,
    MirrorMode              Bit,
    FlipMode                Bit,
    MostRecent              Bit,
    BarSpaceCorrection      Real,
    LastCalDate             DateTime,
    Primary Key             (SerialNumber)
);

Create Table CalibrationSetup
(
    FieldOfView             Real,
    MegaPixels              Real,
    SmallApertureScaling    Real,
    LargeApertureScaling    Real,
    SmallSharpen            Integer,
    LargeSharpen            Integer,
    SmallXdim               Real,
    LargeXdim               Real
);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (2.8, 1.3, 0.75, 0.80, 35, 35,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (3.0, 1.3, 0.75, 0.80, 35, 35,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (3.3, 1.3, 0.55, 0.75, 55, 30,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (3.4, 1.3, 0.55, 0.75, 55, 30,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (4.5, 1.3, 0.80, 0.80, 35, 30,  7.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (4.8, 1.3, 0.60, 0.85, 60, 48,  9.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.0, 1.3, 0.60, 0.85, 60, 48,  9.0, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.3, 1.3, 0.55, 0.75, 65, 35,  9.7, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.5, 1.3, 0.55, 0.75, 65, 35,  9.7, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.8, 1.3, 0.55, 0.80, 60, 35, 10.0, 20.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (6.0, 1.3, 0.55, 0.80, 60, 35, 10.0, 20.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (6.1, 1.3, 0.55, 0.80, 60, 35, 10.0, 20.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (2.8, 2.1, 1.00, 1.10, 40, 40,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (3.0, 2.1, 1.00, 1.10, 45, 45,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (3.3, 2.1, 1.00, 1.00, 35, 40,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (3.5, 2.1, 1.00, 1.05, 40, 40,  6.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (4.5, 2.1, 0.65, 1.20, 55, 45,  7.0, 13.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (4.8, 2.1, 0.60, 1.10, 55, 40,  9.0, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.0, 2.1, 0.55, 1.00, 60, 40,  9.0, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.3, 2.1, 0.65, 1.00, 60, 30,  9.0, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.5, 2.1, 0.60, 0.80, 50, 35,  9.0, 15.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.8, 2.1, 0.75, 0.80, 60, 30, 10.0, 20.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (6.0, 2.1, 0.75, 0.90, 60, 30, 10.0, 20.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (6.3, 2.1, 0.65, 1.00, 65, 25, 10.0, 20.0);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7a', #7-Sep-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7a', "Support 9570");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7a', "Support IC Camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7a', "Improve USPS IMB");
Delete From Calibration;
Drop Table Calibration;
Create Table Calibration
(
    SerialNumber            Integer,
    CalibrationOk           Bit,
    Exposure                Integer,
    AnalogGain              Real,
    SensorGain1             Integer,
    SensorGain2             Integer,
    SensorGain3             Integer,
    AllWhite                Image,
    AllBlack                Image,
    DigitalGain             Real,
    DigitalShift            Integer,
    Gamma                   Real,
    SmallXdim               Real,
    LargeXdim               Real,
    SmallSharpen            Integer,
    LargeSharpen            Integer,
    SmallApertureScaling    Real,
    LargeApertureScaling    Real,
    MatrixSize              Integer,
    Boost                   Integer,
    MilsPerPixel            Real,
    LightingMode            Text,
    MirrorMode              Bit,
    FlipMode                Bit,
    MostRecent              Bit,
    BarSpaceCorrection      Real,
    LastCalDate             DateTime,
    Primary Key             (SerialNumber)
);
Delete From ApplicationStandards Where ShortName = "Intelligent";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Intelligent", "USPS IMB", 1);
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7004", 0, ""    , "Active Potency");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7004", 1, "N1-4", "Potency");
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (4.5, 5.5, 0.80, 0.80, 80,  80, 10.0, 20.0);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim) Values (5.4, 3.6, 1.00, 1.30, 60, 100, 13.0, 20.0);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7b', #16-Sep-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7b', "Improve driver installation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7c', #30-Sep-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7c', "Include MatrixSize in CalibrationSetup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7c', "Fix Lumenera line scan calibration");
Alter Table CalibrationSetup Add Column MatrixSize Integer;
Update CalibrationSetup Set MatrixSize = 7;
Update CalibrationSetup Set MatrixSize = 9 Where FieldOfView < 5 And MegaPixels > 5;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7d', #14-Oct-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7d', "Add UV Fluorescence testing");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("UV", "UV Fluorescence testing", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7e', #17-Oct-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7e', "Warn user if using ISO and code looks like GS1 without FNC1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7e', "Allow QR Codes to read when finder patterns are very jagged");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7f', #18-Oct-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7f', "Improve Data Matrix edge algorithm");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7g', #19-Oct-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7g', "Add Post Matrix");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PostSize",   "Postmatrix Code (PMC) with size checking", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PostNoSize", "Postmatrix Code (PMC) without size checking", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7h', #3-Nov-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7h', "Add 2D Detail report via SRP tab");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7i', #4-Nov-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7i', "Split UV into two separate application standards");
Delete From ApplicationStandards Where ShortName = "UV";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("UVwarn",  "UV Fluorescence testing with warning", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("UVgrade", "UV Fluorescence testing with grading", 1);
Insert Into Glossary (Entry, Description) Values
(
    "Fluorescence",
    "This measures how well UV light is reflected back into the camera.  20% is considered to be the absolute minimum to be acceptable."
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7j', #14-Nov-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7j', "Upgrade to Lumenera software v6.0.0");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7j', "Make Windows lockdown compatible with Windows 7");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7k', #3-Dec-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7k', "Report fluorescence if UV mode and no decode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7k', "Use different filename for temporary thumbnails to prevent report from displaying wrong picture");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7k', "Make IC camera exposure configurable according to FOV");
Drop Table CalibrationSetup;
Create Table CalibrationSetup
(
    FieldOfView             Real,
    MegaPixels              Real,
    Exposure                Integer,
    SmallApertureScaling    Real,
    LargeApertureScaling    Real,
    SmallSharpen            Integer,
    LargeSharpen            Integer,
    SmallXdim               Real,
    LargeXdim               Real,
    MatrixSize              Integer
);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (2.8, 1.3, 30, 0.75, 0.80, 35, 35,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, 1.3, 30, 0.75, 0.80, 35, 35,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.3, 1.3, 30, 0.55, 0.75, 55, 30,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.4, 1.3, 30, 0.55, 0.75, 55, 30,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.5, 1.3, 30, 0.80, 0.80, 35, 30,  7.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.8, 1.3, 30, 0.60, 0.85, 60, 48,  9.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.0, 1.3, 30, 0.60, 0.85, 60, 48,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.3, 1.3, 30, 0.55, 0.75, 65, 35,  9.7, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.5, 1.3, 30, 0.55, 0.75, 65, 35,  9.7, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.8, 1.3, 30, 0.55, 0.80, 60, 35, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.0, 1.3, 30, 0.55, 0.80, 60, 35, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.1, 1.3, 30, 0.55, 0.80, 60, 35, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (2.8, 2.1, 30, 1.00, 1.10, 40, 40,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, 2.1, 30, 1.00, 1.10, 45, 45,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.3, 2.1, 30, 1.00, 1.00, 35, 40,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.5, 2.1, 30, 1.00, 1.05, 40, 40,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.5, 2.1, 30, 0.65, 1.20, 55, 45,  7.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.8, 2.1, 30, 0.60, 1.10, 55, 40,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.0, 2.1, 30, 0.55, 1.00, 60, 40,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.3, 2.1, 30, 0.65, 1.00, 60, 30,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.5, 2.1, 30, 0.60, 0.80, 50, 35,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.8, 2.1, 30, 0.75, 0.80, 60, 30, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.0, 2.1, 30, 0.75, 0.90, 60, 30, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.3, 2.1, 30, 0.65, 1.00, 65, 25, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, 5.5, 45, 0.80, 0.90, 50, 50,  6.0, 13.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.5, 5.5, 53, 0.80, 1.00, 70, 70,  8.0, 20.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.2, 5.5, 53, 0.80, 1.00, 80, 80, 10.0, 20.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7L

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7L', #6-Dec-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7L', "Log application standard selection to audit trail");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7L', "Show camera size in megapixels on setup screen");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7L', "Detect pixel shift on Lumenera line scan camera");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7m', #7-Dec-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7m', "Support PostNet");
Delete From ApplicationStandards Where ShortName = "Intelligent";
Delete From ApplicationStandards Where ShortName = "JapanPost";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Postal", "Postal (Intelligent Mail, PostNet, Japan Post)", 1);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.4, 3.6, 30, 1.00, 1.00, 40, 40, 10.0, 20.0, 9);
Create Table PostalSetup
(
    Symbology               Text,
    ParameterName           Text,
    MinSpec                 Real,
    MinWarning              Real,
    MinError                Real,
    MaxSpec                 Real,
    MaxWarning              Real,
    MaxError                Real
);
! The following entries are in inches:
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("PostNet", "TallHeight",   0.1150, 0.0936, 0.0860, 0.1350, 0.1716, 0.1872);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("PostNet", "ShortHeight",  0.0400, 0.0390, 0.0234, 0.0600, 0.0702, 0.0780);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("PostNet", "Width",        0.0150, 0.0078, 0.0039, 0.0250, 0.0351, 0.0429);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("PostNet", "BarSpace",     0.0120, 0.0078, 0.0039, 0.0400, 0.0429, 0.0468);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("PostNet", "Pitch",        0.0416, 0.0251, 0.0273, 0.0500, 0.0546, 0.0624);
Insert Into PostalSetup (Symbology, ParameterName, MaxSpec, MaxWarning, MaxError) Values ("PostNet", "Baseline", 0.0150, 0.0156, 0.0234);
! The following entries are in inches:
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("IMB",     "TallHeight",   0.1250, 0.1213, 0.1187, 0.1650, 0.2063, 0.2310);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("IMB",     "MediumHeight", 0.0820, 0.0738, 0.0697, 0.1110, 0.1143, 0.1166);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("IMB",     "ShortHeight",  0.0390, 0.0370, 0.0234, 0.0570, 0.0627, 0.0656);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("IMB",     "Width",        0.0150, 0.0078, 0.0039, 0.0250, 0.0351, 0.0429);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("IMB",     "BarSpace",     0.0120, 0.0078, 0.0039, 0.0400, 0.0429, 0.0468);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("IMB",     "Pitch",        0.0416, 0.0251, 0.0273, 0.0500, 0.0546, 0.0624);
Insert Into PostalSetup (Symbology, ParameterName, MaxSpec, MaxWarning, MaxError) Values ("IMB", "Baseline", 0.0150, 0.0156, 0.0234);
! The following entries are in millimeters:
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("Japan",   "TallHeight",   3.4000, 2.7200, 2.5500, 3.6000, 4.5000, 5.0400);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("Japan",   "MediumHeight", 2.2250, 1.8700, 1.5900, 2.4750, 3.0400, 2.9588);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("Japan",   "ShortHeight",  1.0500, 1.0200, 0.6300, 1.3500, 1.5800, 1.7550);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("Japan",   "Width",        0.5000, 0.2500, 0.1250, 0.7000, 0.9800, 1.2040);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("Japan",   "BarSpace",     0.4500, 0.3000, 0.1500, 0.6000, 0.6435, 0.7020);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("Japan",   "Pitch",        0.9500, 0.8016, 0.6234, 1.3000, 1.4196, 1.6224);
Insert Into PostalSetup (Symbology, ParameterName, MaxSpec, MaxWarning, MaxError) Values ("Japan", "Baseline", 0.5000, 0.6000, 0.7000);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7n', #20-Dec-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7n', "Improve Aztec Code grid layout");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7n', "Fix wrong serial number displayed for 5MP camera");
Delete From CalibrationSetup;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (2.80, 1.3, 30, 0.75, 0.80, 35, 35,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.00, 1.3, 30, 0.75, 0.80, 35, 35,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.30, 1.3, 30, 0.55, 0.75, 55, 30,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.40, 1.3, 30, 0.55, 0.75, 55, 30,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.50, 1.3, 30, 0.80, 0.80, 50, 50,  7.0, 13.0, 5);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.80, 1.3, 30, 0.80, 0.80, 60, 50,  9.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.00, 1.3, 30, 0.60, 0.85, 60, 50,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.30, 1.3, 30, 0.55, 0.75, 65, 50,  9.7, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.50, 1.3, 30, 0.55, 0.75, 65, 35,  9.7, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.80, 1.3, 30, 0.55, 0.80, 60, 35, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.00, 1.3, 30, 0.55, 0.80, 60, 35, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.10, 1.3, 30, 0.55, 0.80, 60, 45, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (2.80, 2.1, 30, 1.00, 1.10, 40, 40,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.00, 2.1, 30, 1.00, 1.10, 45, 45,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.30, 2.1, 30, 1.00, 1.00, 35, 40,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.50, 2.1, 30, 1.00, 1.05, 40, 40,  6.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.50, 2.1, 30, 0.60,  .80, 55, 40,  7.0, 13.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.80, 2.1, 30, 0.60,  .80, 55, 40,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.00, 2.1, 30, 0.55, 1.00, 60, 40,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.30, 2.1, 30, 0.65, 1.00, 60, 30,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.50, 2.1, 30, 0.60, 0.80, 50, 35,  9.0, 15.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.80, 2.1, 30, 0.75, 0.80, 60, 30, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.00, 2.1, 30, 0.75, 0.90, 60, 30, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.30, 2.1, 30, 0.65, 1.00, 65, 25, 10.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.00, 5.5, 20, 0.90, 0.90, 60, 60,  6.0, 13.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.50, 5.5, 22, 0.85, 0.85, 60, 60,  8.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.25, 5.5, 24, 0.45, 1.00, 80, 70, 13.0, 20.0, 7);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.40, 3.6, 30, 1.00, 1.00, 40, 40, 10.0, 20.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.7o

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.7o', #25-Dec-2011#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.7o', "Change default gamma");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8', #7-Jan-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8', "Minor changes to default calibration setup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8', "Fix subscript out of range when box is tight on DataBar-14 code");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8', "Add 3 extra pixels for bounding box during automatic sectoring");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8', "Change installation procedure to include latest drivers");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8', "Release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8a', #16-Jan-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8a', "Unify Aztec Code, Data Matrix, and QR Code algorithms with 7000 software");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8b', #22-Jan-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8b', 'Change 9570 initial cutoff from 1" to 0.5"');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8b', 'Ignore any 9570 data after 8" of scanning');
Delete From CalibrationSetup Where MegaPixels = 3.6;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.40, 3.6, 30, 1.00, 1.00, 60, 60, 10.0, 20.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.00, 5.5, 22, 0.85, 0.85, 60, 60,  8.0, 20.0, 7);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8c', #23-Jan-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8c', "Implement PPN-code application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8c', "Fix problems with SRP and wide images");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PPN", "PPN-code", 1);
Alter Table DataIdentifiers Add Column PPNCharSet Integer;
Alter Table DataIdentifiers Add Column MinSize Integer;
Alter Table DataIdentifiers Add Column MaxSize Integer;
Update DataIdentifiers Set PPNCharSet = 0;
Update DataIdentifiers Set MinSize = 0;
Update DataIdentifiers Set MaxSize = 0;
Delete From DataIdentifiers Where DataIdentifier = "9N";
Delete From DataIdentifiers Where DataIdentifier = "1T";
Delete From DataIdentifiers Where DataIdentifier = "D";
Delete From DataIdentifiers Where DataIdentifier = "S";
Delete From DataIdentifiers Where DataIdentifier = "16D";
Delete From DataIdentifiers Where DataIdentifier = "8P";
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("9N",  "Pharmacy Product Number (PPN)",   36,  4, 22);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("1T",  "Batch number",                    38,  1, 20);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("D",   "Expiry date",                     10,  6,  6);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("S",   "Serial number",                   36,  1, 20);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("16D", "Date of manufacture",             10,  8,  8);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("8P",  "Global Trade Item Number (GTIN)", 10, 14, 14);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8d', #22-Feb-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8d', "Implement optional QR Code full QZ checking");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8d', "Implement QZ selection of either ISO 15420-2000 or 15420-2009");
Insert Into Settings (Category, SettingName, SettingValue) Values ("QuietZone", "QRCode",    "1X");
Insert Into Settings (Category, SettingName, SettingValue) Values ("QuietZone", "UPCEANISO", "2009");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8e', #28-Feb-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8e', "Allow QR Codes for GS1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8e', "Fix bug where embedded NUL characters caused string truncation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8e', "Add AI 8200");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8e', "Fix decoding issues with MaxiCode");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8200", 0, ""     , "Extended Packaging URL");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8200", 1, "X1-70", "Extended Packaging URL");
Update CalibrationSetup Set LargeSharpen = 70 Where FieldOfView = 4.5 and MegaPixels = 5.5;
Update CalibrationSetup Set SmallSharpen = 70 Where FieldOfView = 4.5 and MegaPixels = 5.5;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8f', #13-Mar-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8f', "Give error for extraneous characters such as <NUL> for GS1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8f', "For auto sector and a 9570, try multiple position rather than just center");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8f', "Use aperture of 6 for GS1-128 coupons");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8f', "Fix 2D analysis for Post Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8f', "Implement GS1 %% rules for QR Code 2005");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8g', #9-Apr-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8g', "Save/restore lens correction");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8g', "Allow 9570 setup using either EAN or UPC side of calibration label");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8g', "Avoid uncalibrated image error when using flip");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("710" , 0, ""      , "National Healthcare Reimbursement Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("710" , 1, "X1-20" , "Germany IFA");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("711" , 0, ""      , "National Healthcare Reimbursement Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("711" , 1, "X1-20" , "France CIP");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("712" , 0, ""      , "National Healthcare Reimbursement Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("712" , 1, "X1-20" , "Spain National Code");
Update CalibrationSetup Set MatrixSize           =  7    Where FieldOfView = 3.00 And MegaPixels = 5.5;
Update CalibrationSetup Set SmallApertureScaling =  0.75 Where FieldOfView = 6.00 And MegaPixels = 1.3;
Update CalibrationSetup Set LargeApertureScaling =  1.00 Where FieldOfView = 6.00 And MegaPixels = 1.3;
Update CalibrationSetup Set SmallSharpen         = 90    Where FieldOfView = 6.00 And MegaPixels = 1.3;
Update CalibrationSetup Set LargeSharpen         = 45    Where FieldOfView = 6.00 And MegaPixels = 1.3;
Update CalibrationSetup Set MatrixSize           =  5    Where FieldOfView = 6.00 And MegaPixels = 1.3;
Update CalibrationSetup Set SmallApertureScaling =  0.75 Where FieldOfView = 6.10 And MegaPixels = 1.3;
Update CalibrationSetup Set LargeApertureScaling =  1.00 Where FieldOfView = 6.10 And MegaPixels = 1.3;
Update CalibrationSetup Set SmallSharpen         = 90    Where FieldOfView = 6.10 And MegaPixels = 1.3;
Update CalibrationSetup Set LargeSharpen         = 45    Where FieldOfView = 6.10 And MegaPixels = 1.3;
Update CalibrationSetup Set MatrixSize           =  5    Where FieldOfView = 6.10 And MegaPixels = 1.3;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8h', #23-Apr-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8h', "Make updates for latest MySQL versions");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8h', "Fix problems when ProgramData is drive other than C:");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8h', "Change sector outlines to black after motion when manual grading");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8i', #26-Apr-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8i', "Support Almel-based 9570 handheld scanner");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8j', #30-May-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8j', "Make lens correction part of database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8j', "Change installation to set correct working directory and always run from CD");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8j', "Allow product lookup to work with embedded spaces");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8j', "Detect and report overspeed condition");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8j', "Only include structure information on report if on grading screen");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8j', "Fix error with embedded GS characters");
Update CalibrationSetup Set MatrixSize           =  9    Where FieldOfView = 3.00 And MegaPixels = 5.5;
Create Table LensCorrection
(
    Correction	Image
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8k', #31-May-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8k', "Don't translate SQL history");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8k', "Fix wrong file for {Thumbnail} in custom report");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8L

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8L', #18-Jun-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8L', "Fix problem with certain Aztec code sizes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8L', "Don't assume <GS1> means AIs in use");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8m', #01-Jul-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8m', "Don't let Code 128 start codes cause invalid character sequence");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8m', "Warn operator if unprogrammed Atmel-based 9570 detected");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8n
Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8n', #14-Aug-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8n', "Improve Data Matrix L pattern detection");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8n', "Include all warnings in custom report and not just the first one");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8n', "Fix PDF tilt");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8n', "Fix angle reported by QR Code");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8n', "Only convert to Kanji if Kanji mode selected for QR Code");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8n', "Fix quiet zone issue with EAN fail calibration label on 5mp camera");
Update CalibrationSetup Set LargeSharpen = 30 Where FieldOfView = 4.0 and MegaPixels = 5.5;
Update CalibrationSetup Set MatrixSize   =  9 Where FieldOfView = 4.0 and MegaPixels = 5.5;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8o
Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8o', #6-Sep-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8o', "Support HW trigger on 5mp camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8o', "Fix multiple Aztec Code issues");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8o', "Fix broken QR Code Kanji");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8p
Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8p', #21-Sep-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8p', "Add Braille application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8p', "Add FPMAJ application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8p', "Fix shift bug in Maxicode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8p', "Display Kanji on Structure tab if applicable");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8p', "Support UTF-8 encoding in Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8p', "Only show binary data in hex for Post Matrix");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("Braille", "Braille", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("FPMAJ", "FPMAJ", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8q

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8q', #2-Oct-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8q', "Add Reference table to database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8q', "Remember blank reference in database");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8q', "Allow PDF417 and Data Matrix for AIAG");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8q', "Implement additional AIAG checks");
Insert Into Settings (Category, SettingName, SettingValue) Values ('Etc', 'MaxReferenceHistory', '10');
Create Table ReferenceData
(
    ReferenceText		Text,
    ReferenceDateTime	DateTime,
    Primary Key         (ReferenceText)
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8r

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8r', #4-Oct-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8r', "Update 9570 manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8r', 'Fix minimum AIAG QZ to be 0.25" and not 0.5"');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8r', "Don't allow <GS> in place of <FNC1> for 1D GS1 symbols");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8s

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8s', #30-Oct-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8s', "Fix mis-decode of upside down DataBar limited symbol");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8s', "Add additional reference");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8s', "Change USPS service type code from 2 digits to 3 digits");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8s', "Implement special quiet zone checking for FPMAJ");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8t

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8t', #1-Nov-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8t', "Remember application standard with multi-sector setup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8t', "Add more checking for USPS-128 compliance");
Create Table ApplicationXref
(
    ApplicationName         Text,
    ShortName               Text
);
Delete From ApplicationStandards Where ShortName = "UVwarn";
Delete From ApplicationStandards Where ShortName = "UVgrade";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8u

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8u', #9-Nov-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8u', "Minor changes for FPMAJ");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8u', "Show multiple warnings at once");
Update ReportData Set ParameterName = "Additional reference" Where ParameterName = "AdditionalReference"

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8v

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8v', #13-Nov-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8v', "Fix time stamp bug with reference data");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8w

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8w', #14-Nov-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8w', "Fix text property is read-only error");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8x

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8x', #15-Nov-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8x', "Support multiple 5mp cameras at once");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8x', "Update Lumenera line scan drivers");
Alter Table CalibrationHistory Add Column SerialNumber Text;
Alter Table CalibrationHistory Add Column FieldOfView Real;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8y

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8y', #16-Nov-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8y', "Fix PDF417 flaky reading");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8y', "Avoid crash if QR Code bit stream is improperly formed");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8y', "Improve Data Matrix reading of poor GNU symbols");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8z

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8z', #3-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Detect and warn if negative image used for DataBar symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Add HDMA application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Allow EAN-13 for FPMAJ but use 10X quiet zone");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Improve code page selection for different locales");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Include 0405.dat for Czech");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Flip trigger polarity on 9580");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Only collect images on 9580 when trigger button held");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Lower exposure when learning 9580 white balance");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8z', "Fix false blemish error on DataBar-14");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("HDMA", "HDMA Guidelines", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8aa

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8aa', #5-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8aa', "Make 9580 live whenever on calibration tab");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8bb

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8bb', #14-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8bb', "Implement Unicode-like controls and reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8bb', "Fix broken product lookup update");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8bb', "Fix default exposure for 9580");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8bb', "Use 12X quiet zone for auto sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8bb', "Include DataBar-14 for auto sector");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8cc

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8cc', #21-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8cc', "Fix Czech translation issues");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8cc', "Improve auto-sector functionality");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8cc', "Improve MaxiCode sample grid placement");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8dd

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8dd', #21-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8dd', "More MaxiCode improvements");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8ee

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8ee', #21-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ee', "Fix problem where I9500.exe kept running");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ee', "More MaxiCode improvements");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8ff

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8ff', #26-Dec-2012#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ff', "More MaxiCode improvements");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ff', "Don't fail Data Matrix code with embedded FNC1 and not set for GS1");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8gg

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8gg', #9-Jan-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8gg', "More MaxiCode improvements");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8gg', "Don't suppress structure warnings if there are other fatal warnings");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8gg', "Don't override permissions for automatic login operator");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8hh

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8hh', #16-Jan-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Fix Software History sort order");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Rename ECC-200 to Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Include GS1 prefix on symbology name when applicable");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Fix improper warnings on GS1 QR Codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Show software version in title bar");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Fix additional translation issues");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8hh', "Update 0411.dat");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8ii

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8ii', #21-Jan-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ii', "Avoid error 438 when using single/multiple sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ii', "Collapse UniCombos before screen resize");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ii', "Translate audit trail entries");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ii', "Allow up to 360 days before requiring calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8ii', "Attempt to correct tilt on unreadable CC codes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8jj

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8jj', #26-Jan-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8jj', "Implement ShowPoundForFNC1");
Insert Into Settings (Category, SettingName, SettingValue) Values ('Etc', 'ShowPoundForFNC1', '0');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8kk

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8kk', #29-Jan-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8kk', "Include structure tab to serial port if applicable");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8kk', "Check decodability of DataBar Limited guard bars");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8kk', "Set language charset default to be 1 to fix QR codes with embedded special characters");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.8LL

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.8LL', #7-Feb-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8LL', "Update 0411.dat");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8LL', "Eliminate GS1 QZ options");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8LL', "Add AI 255 Global Coupon Number");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8LL', "Fix 9580 exposure issues");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.8LL', "Include latest KeySetup.exe");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("255" , 0, ""   , "Global Coupon Number (GCN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("255" , 1, "K13", "Company Prefix and Coupon Reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("255" , 2, "N12", "Serial Number");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9', #7-Jun-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Release");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Set printer font character set as needed");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Implement 13X bar height rule for FPMAJ");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Fix issue with zip codes > 99xxx");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Fix wrong check digit for USPS Code 128");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Improve MaxiCode output to match 16023");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Change Data Matrix wiggle factor for poor ANU/GNU codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Change focus algorithm to be full screen width for IC camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Require 5X right quiet zone for DataBar Limited for all symbologies and not just FPMAJ");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Fix MaxiCode apostrophe vs. comma bug");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Make ITF rules more strict to avoid being fooled by certain MicroPDF patterns");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Implement Serial RawMode");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Update FPMAJ rules");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Don't read negated PDF, MicroPDF, and CC codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Flip FPMAJ 13X rule to be a minimum, not a maximum");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Implement HIBC application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Shortcut keys");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Implement automatic exposure reduction for 5Mp cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Ignore QZ border where it should be ignored");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Fix broken 10mm height rule");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Fix error 9 on Japanese XP systems");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Make AI 22 obsolete");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Revamp Data Matrix sampling grad algorithm to match reference decode algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9', "Make DecimalGrading (for Data Matrix only) optional and default to off");

Alter Table ApplicationStandards Add Column ShortCutKey Text;
Update ApplicationStandards Set ShortCutKey = "A" Where ShortName = "Auto";
Update ApplicationStandards Set ShortCutKey = "F" Where ShortName = "FPMAJ";
Update ApplicationStandards Set ShortCutKey = "G" Where ShortName = "GS1";
Update ApplicationStandards Set ShortCutKey = "I" Where ShortName = "ISO";
Update ApplicationStandards Set ShortCutKey = "P" Where ShortName = "Postal";
Update ApplicationStandards Set ShortCutKey = "U" Where ShortName = "USPS128";

Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("GS1NTIN", "GS1 NTIN", 1);
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8018";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("243" , 0, ""     , "Packaging Component Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("243" , 1, "X1-20", "Packaging Component Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("427" , 0, ""     , "Country Subdivision of Origin");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("427" , 1, "X1-3" , "Country Subdivision of Origin");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8017", 0, ""     , "Global Service Relation Number (GSRN) provider");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8017", 1, "K18"  , "Global Service Relation Number (GSRN) provider");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 0, ""     , "Global Service Relation Number (GSRN) recipient");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8018", 1, "K18"  , "Global Service Relation Number (GSRN) recipient");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8019", 0, ""     , "Service Relation Instance Number (SRIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8019", 1, "N1-10", "Service Relation Instance Number (SRIN)");
Insert Into Settings (Category, SettingName, SettingValue) Values ("Serial", "RawMode", 0);

Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("HIBC", "Health Industry Bar Code (HIBC)", 1);
Create Table HIBCIdentifiers
(
    DataIdentifier          Text,
    Description             Text,
    Primary Key             (DataIdentifier)
);
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1A", "Patient");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1B", "Patient Care Record");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1C", "Specimen Container");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1D", "Direct Patient Image Item");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1E", "Business Record");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1F", "Medical Administration Record");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1G", "Library Reference material");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1H", "Devices and Materials");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1I", "Identification Card");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1J", "Product Container");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1K", "Asset");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1L", "Surgical Instrument");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1M", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1N", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1O", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1P", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1Q", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1R", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1S", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1T", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1U", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1V", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1W", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1X", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1Y", "Expansion Flag Character");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("1Z", "User Defined");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2A", "Labeler Identification Code (LIC)");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2B", "Service Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2C", "Patient Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2D", "Specimen Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2E", "Personnel Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2F", "Administrable Product Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2G", "Implantable Product Information");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2H", "Hospital Item Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2I", "Medical Procedure Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2J", "Reimbursement Category");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2K", "Blood Product Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2L", "Demographic Data");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2M", "Date/Time");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2N", "Asset Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2O", "Purchase Order Number");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2P", "Dietary Item Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2Q", "Manufacturer Serial Number");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2R", "Library Materials Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2S", "Business Control Number");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2T", "Episode of Care Identification");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2U", "Health Industry Number (HIN)");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2V", "Patient Visit ID");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2W", "Reserved for future definition by HIBCC");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2X", "XML Document");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2Y", "Expansion Flag Character");
Insert Into HIBCIdentifiers (DataIdentifier,  Description) Values ("2Z", "User Defined");

Delete From CalibrationSetup Where MegaPixels = 5.5;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.00, 5.5, 40, 0.90, 0.90, 60, 55,  6.0, 13.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.00, 5.5, 40, 0.85, 0.85, 60, 45,  8.0, 20.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (4.50, 5.5, 40, 0.80, 0.80, 50, 45,  8.0, 20.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (6.25, 5.5, 40, 0.45, 1.00, 80, 70, 13.0, 20.0, 7);
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "22";

Insert Into Settings (Category, SettingName, SettingValue) Values ('Grading', 'DecimalGrading', '1');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9a', #18-Jun-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9a', "Update 0411.dat");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9a', "Fix shortcut key translation issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9a', "Don't allow overwriting combo data");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9a', "Rebuild options combo with language change");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9a', "Force popup acknowledge");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9b', #19-Jun-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9b', "Adjust exposure when upgrading");
Update Calibration Set Exposure = 1000 / Exposure Where Exposure < 30;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9c', #8-Jul-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9c', "Improve Unicode/UTF-8 processing");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9c', "Always exit the program even if logged in");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9c', "Don't automatically log off when going back to the Welcome tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9c', "Change PZN-8 check digit algorithm to match PZN-7");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9d', #17-Jul-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9d', "Fix PDF conversion bug");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9e', #23-Jul-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9e', "Handle HTML strings with embedded ampersands");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9e', "Support LclTime and other fields from the table Reports when substituting on DOC files");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9f', #5-Aug-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9f', "Fix round-off error in GNU computation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9f', "Improve exposure search algorithm to jump in variable steps");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9f', "Add AllowLightingChange override");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9g', #4-Sep-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9g', "Improve calibration GoDark logic");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9g', "Change COM raw mode output format");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9g', "Eliminate Prepare9575.frm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9g', "Improve consistency on poor quality Data Matrix symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9g', "Require at least 4 digits for ITF");
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, -5.5, 49, 0.9, 0.95, 70, 65, 6.0, 13.0, 9);
Update ApplicationIdentifiers Set Format = "N0-12" Where ApplicationIdentifier = "255" and Element = 2;
Delete From CalibrationSetup Where MegaPixels = 3.6;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.40, 3.6, 30, 1.00, 1.00, 50, 50, 10.0, 20.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9h', #13-Sep-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9h', "Fix problem with final characters of Data Matrix EDIFACT");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9h', "Try harder to read poor quality QR Codes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9i', #27-Sep-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9i', "Revamp handling of database almost full");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9i', "Try harder to read poor quality Data Matrix codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9i', "Fix right-clicking report grid when in French");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9i', "Fix problem where certain DataBar Limited codes would not read");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9j', #28-Oct-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9j', "Implement LVS internal use application standards");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9j', "Fix DTPicker control when language other than native is selected");
! The following entries are in millimeters:
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("EIB",   "TallHeight",   4.22, 4.13, 4.04, 5.84, 6.02, 6.20);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("EIB",   "MediumHeight", 2.62, 2.43, 2.24, 3.68, 3.77, 3.86);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("EIB",   "ShortHeight",  1.02, 0.93, 0.84, 1.52, 1.71, 1.90);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("EIB",   "Width",        0.38, 0.35, 0.32, 0.63, 0.66, 0.69);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("EIB",   "BarSpace",     0.47, 0.42, 0.37, 0.87, 0.92, 0.97);
Insert Into PostalSetup (Symbology, ParameterName, MinSpec, MinWarning, MinError, MaxSpec, MaxWarning, MaxError) Values ("EIB",   "Pitch",        0.94, 0.90, 0.86, 1.48, 1.52, 1.56);
Insert Into PostalSetup (Symbology, ParameterName, MaxSpec, MaxWarning, MaxError) Values ("EIB", "Baseline", 0.5000, 0.6000, 0.7000);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9k', #6-Dec-2013#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9k', "Implement EIB (Royal Mail)");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9k', "Don't allow [Enter] on startup to ask to import image");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9k', "Add HIBC warning if initial plus (+) in decoded text");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9k', "Change default database location to allow sharing by multiple Windows logins");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9k', "Support embedded <GS> in QR Codes");
Update ApplicationStandards Set LongName = "Postal (EIB, IMB, Japan Post, PostNet)" Where ShortName = "Postal";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9L

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9L', #24-Jan-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9L', "Enhance factory calibration procedure for 9580");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9L', "Include IC USB 3.0 compatible drivers");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9L', "Skip <Count x> and <Mode x> when scanning for FNC1");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9L', "Fix problem when Data Matrix quiet zone was very close to 1X");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9L', "Fix language/DBCS issues");
Delete From CalibrationSetup Where MegaPixels = -5.5;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, -5.5, 136, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9m', #3-Feb-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9m', "Allow 9570 and Atmel-based 9570 to both be plugged in at the same time");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9m', "Fix error 5 when authorizing new codes in Atmel-based 9570");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9n', #11-Feb-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9n', "Detect Atmel-based 9570 overspeed");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9o

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9o', #15-Feb-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9o', "Delete old versions of Atmel Flip");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9o', "Fix initialization problem with Atmel Flip");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9P

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9P', #20-Feb-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9P', "Enable/disable automatically starting with Windows");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9P', "Improve structure tab column width algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9P', "Implement Enhanced Application Identifier Verification");

Create Table EAIVFields
(
    ApplicationIdentifier   Text,
    Element                 Integer,
    Mask                    Text,
    EAIVType                Text,
    EAIVData                Text,
    Field                   Text,
    Description             Text,
    Primary Key             (ApplicationIdentifier, Element)
);

Create Table EAIVDisables
(
    ApplicationIdentifier   Text,
    Primary Key             (ApplicationIdentifier)
);

Create Table EAIVCharacterSets
(
    SetName                 Text,
    SetCharacters           Text,
    Primary Key             (SetName)
);

Create Table EAIVDictionaries
(
    DictionaryName          Text,
    DictionaryChoices       Text,
    Primary Key             (DictionaryName)
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9Q

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9Q', #10-Mar-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9Q', "Fix problem where change connection string mishandled quotes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9Q', "Improve consistency on poor quality Data Matrix symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9Q', "Delete VirtualStore registry entries when upgrading from older versions");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9R

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9R', #24-Mar-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9R', "Fix problem where poor quality codes wouldn't read at certain aperture settings");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9R', "Fix typo which prevents Data Matrix decimal grading from being read at start up");
Insert Into EAIVCharacterSets (SetName, SetCharacters) Values ("Numeric",      "0123456789");
Insert Into EAIVCharacterSets (SetName, SetCharacters) Values ("Alpha",        "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
Insert Into EAIVCharacterSets (SetName, SetCharacters) Values ("Alphanumeric", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");

Drop Table EAIVFields;
Create Table EAIVFields
(
    ApplicationIdentifier   Text,
    Element                 Integer,
    Field                   Text,
    Type                    Text,
    Setting                 Text,
    Primary Key             (ApplicationIdentifier, Element)
);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9s

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9s', #16-Apr-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9s', "Enhance Data Matrix consistency on poor quality codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9s', "Fix overflow/lockup with 288-digit barcodes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9s', "Fix PZN check digit problem");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9s', "Fix calibration issue with GS1-128 and 9505");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9s', "Include 9580 manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9s', "Fix 9580 contrast issue");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9t

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9t', #22-Apr-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9t', "Fix 9570 calibration issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9t', "Change default exposure for 9580");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9t', "Rename application standard AS9132");
Update ApplicationStandards Set LongName = "AS9132 / ISO TR29158 Cat 0" Where ShortName = "AS9132";
Delete From CalibrationSetup Where MegaPixels = -5.5;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, -5.5, 110, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9u

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9u', #28-Apr-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9u', "Correct minor 1D synthetic aperture issue");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9u', "Update Japanese translation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9u', "Add offset control on 9570 sensors");
Alter Table Calibration Drop Column SensorGain1;
Alter Table Calibration Drop Column SensorGain2;
Alter Table Calibration Drop Column SensorGain3;
Delete From CalibrationSetup Where MegaPixels = 3.6;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.40, 3.6, 30, 1.00, 1.00, 60, 60, 10.0, 20.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9v

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9v', #6-May-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9v', "Correct QR Code bug which miscalculated unused EC");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9v', "Copy lens correction from recovery");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9v', "Fix QRCode problem showing Japanese characters on Chinese systems");
Delete From LensCorrection;
Delete From Settings Where Category = "Recovery";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9w

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9w', #12-May-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9w', "Avoid degree symbol since it won't work with other languages");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9w', "Fix LEDs on Lumenera-based 9570 readheads");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9w', "Don't let corrupted recovery files prevent program startup");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9w', "Show Axial Nonuniformity to one decimal place");
Alter Table LensCorrection Add Column SerialNumber Integer;
Update LensCorrection Set SerialNumber = 0;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9x

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9x', #31-May-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9x', "Improve Data Matrix consistency on questionable quality codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9x', "Avoid case of misreading DataBar Limited as UPC-E");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9x', "Don't loop on codes ending with a single angle bracket '<'");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9x', "Fix misreading special UTF-8 German characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9x', "Don't restart program when shutting down");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9x', "Remove experimental Braille application standard");
Delete From ApplicationStandards Where ShortName = "Braille";
Update ApplicationStandards Set LongName = "HIBC Provider" Where ShortName = "HIBC";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9y

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9y', #8-Jul-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Support multiple dongles at once");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Change default minimum passing score to 1.5");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Implement IncludePrintStructure=2 and 3");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Attempt to auto-detect codepage for translation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Wrap up EAIV");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Improve Ctrl-G operation");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Fix finder ambiguity problem with DataBar Expanded");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Generate non-fatal warning if ECI used");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Change installer to try C:\Temp before using TMP environment variable");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Implement database setting SeparateDecodedText");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Show ANSI and Kanji conversions on structure tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9y', "Change placement of video picture to be more precice and not obscure nearby objects");
Insert Into Settings (Category, SettingName, SettingValue) Values ('Report', 'SeparateDecodedText', '0');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9z

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9z', #24-Jul-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Fix problem where activation codes could not be added when non-English selected");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Fix problem where funny characters appeared in Data Matrix codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Relax dynamic Xdim limit so poor decodability UPC codes still read");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Implement basic multi-user lock");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Implement AI changes from Gen Spec v14");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Support Microsoft SQL Server");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9z', "Make printing of VBD files work in other languages");
Update ApplicationIdentifiers Set Format = "X1-34" Where ApplicationIdentifier = "8007" And Element = 1;
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("16"  , 0, ""      , "Sell By Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("16"  , 1, "D6"    , "Sell By Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("713" , 0, ""      , "National Healthcare Reimbursement Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("713" , 1, "X1-20" , "Brasil National Code");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9aa

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9aa', #31-Jul-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9aa', 'Require operator permission for EAIV Setup');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9aa', 'Fix EAIV Date Range sign error');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9aa', 'Make sure EAIV mask has the correct number of characters');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9aa', 'Rename EIB to Mailmark');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9aa', 'Enforce C40 throughout for Mailmark CMDM codes');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9aa', 'Reduce application standard pulldown font so it fits on a standard screen');
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("ITF2", "ITF including 2 digits", 1);
Update ApplicationStandards Set LongName = "Postal (IMB, Japan Post, Mailmark, PostNet)" Where ShortName = "Postal";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9bb

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9bb', #21-Aug-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Only allow one calibration per serial number');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Support different settings for white light calibration');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Improve error handling in truncated PDF417 symbols');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Adjust PDF417 UEC algorithm');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Add new features for Product Lookup');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Revamp HIBC');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9bb', 'Try harder to read unreadable QRCodes');
Alter Table Calibration Drop Column MostRecent;
Update Calibration    Set SerialNumber = -SerialNumber / 10 Where SerialNumber < 0;
Update LensCorrection Set SerialNumber = -SerialNumber / 10 Where SerialNumber < 0;
Alter Table CalibrationSetup Add Column LightingMode Text;
Update CalibrationSetup Set LightingMode = '660';
Delete From CalibrationSetup Where MegaPixels = -5.5;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, -5.5, '660', 40, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (FieldOfView, MegaPixels, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (3.0, -5.5, 'W',   55, 0.90, 0.90, 35, 30, 6.0, 13.0, 9);
Update ApplicationStandards Set LongName = "HIBC" Where ShortName = "HIBC";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9cc

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9cc', #4-Sep-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9cc', 'Correct calibration misadjustment');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9cc', 'Fix problem where barcode data was translated by mistake');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9cc', 'Fix problem where ITF codes might not read');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9cc', 'Use better error messages if codes read at some aperture settings but not others');
Update CalibrationSetup Set SmallSharpen = 40 Where MegaPixels = 5.5 And FieldOfView = 3.0;
Update CalibrationSetup Set LargeSharpen = 35 Where MegaPixels = 5.5 And FieldOfView = 3.0;
Update CalibrationSetup Set SmallSharpen = 40 Where MegaPixels = 5.5 And FieldOfView = 4.0;
Update CalibrationSetup Set LargeSharpen = 35 Where MegaPixels = 5.5 And FieldOfView = 4.0;
Update CalibrationSetup Set SmallSharpen = 25 Where MegaPixels = 5.5 And FieldOfView = 4.5;
Update CalibrationSetup Set LargeSharpen = 35 Where MegaPixels = 5.5 And FieldOfView = 4.5;
Insert Into Settings (Category, SettingName, SettingValue) Values ('Grading', 'DontFailIfStructureError', '0');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9dd

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9dd', #21-Oct-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9dd', 'Implement DPM');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9dd', 'Fix bug where very wide space might render UPC-A code unreadable');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9dd', 'Relax label height requirement during calibration');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9dd', 'Update manual for Appendix J');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9dd', 'Undo video picture placement change');
Delete From ApplicationStandards Where ShortName = 'AS9132';
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ('DPM0', 'DPM Cat 0 (AS9132)',        1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ('DPM2', 'DPM Cat 2 (ISO/IEC 29158)', 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9ee

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9ee', #24-Oct-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ee', 'Disable DPM Cat 2 until it is complete');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ee', 'Fix crash when using Czech and SRP buttons');
Delete From ApplicationStandards Where ShortName = 'DPM2';

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9ff

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9ff', #15-Dec-2014#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ff', 'Accept % as substitute for <GS> when switching modes in QR Codes');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ff', 'Circumvent possible anomaly in SQL Server');
Update CalibrationSetup Set SmallSharpen = 35 Where MegaPixels =  5.5 And FieldOfView = 4.5;
Update CalibrationSetup Set LargeSharpen = 30 Where MegaPixels =  5.5 And FieldOfView = 4.5;
Update CalibrationSetup Set SmallSharpen = 60 Where MegaPixels = -5.5 And LightingMode = '660';
Update CalibrationSetup Set LargeSharpen = 55 Where MegaPixels = -5.5 And LightingMode = '660';

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9gg

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9gg', #27-Jan-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9gg', 'Change copyright to 2015');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9gg', 'Update camera drivers');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9gg', 'Fix math error in GNU');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9gg', 'Fix subtle bug in retry logic for QRCode');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9gg', 'Try to interpret ANSI characters in Data Matrix codes with byte encodation');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9gg', 'Change QRCode to honor DecimalGrading=0');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9hh

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9hh', #10-Feb-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', 'Implement language lock');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', 'Implement latest AI changes from GenSpec V1.5');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', 'Include calibration date on stitched report');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', "Don't honor operator failed attempt lock if all operators are locked out");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', "Don't let operator accidentally use contrast label during calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', "Leave camera on after inactivity timeout");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9hh', "Allow C40 in Mailmark customer fields");
Update ApplicationIdentifiers Set Description = "Deprecated Coupon Extended Code" Where ApplicationIdentifier >= "8100" And ApplicationIdentifier <= "8102" And Element = 0;
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7005", 0, ""      , "Catch Area");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7005", 1, "X1-12" , "Catch Area");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7006", 0, ""      , "First Freeze Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7006", 1, "D6"    , "First Freeze Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7007", 0, ""      , "Harvest Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7007", 1, "D6"    , "Harvest Start Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7007", 2, "D6"    , "Harvest End Date (YYMMDD)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7008", 0, ""      , "Species for Fishery Purposes");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7008", 1, "X1-3"  , "Species for Fishery Purposes Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7009", 0, ""      , "Fishing Gear Type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7009", 1, "X1-10" , "Fishing Gear Type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7010", 0, ""      , "Production Method");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7010", 1, "X1-2"  , "Production Method");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8010", 0, ""      , "Component / Part Identifier");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8010", 1, "X1-30" , "Component / Part Identifier");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8011", 0, ""      , "Component / Part Identifier Serial Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8011", 1, "N1-12" , "Component / Part Identifier Serial Number");
Delete From CalibrationSetup Where MegaPixels = 3.6;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.40, 3.6, 30, 0.80, 0.80, 35, 35, 10.0, 20.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9ii

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9ii', #19-Mar-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ii', 'Detect and correct occasional deviant pixels');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ii', 'Fix problems reading and storing gain and offsets for 9570s');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ii', "Don't be confused by <239> before <FNC1>");
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ii', 'Fix reporting of MicroQRCode version');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9ii', 'Change default of 0 to include print structure');
Delete From CalibrationSetup Where MegaPixels = 3.6;
Insert Into CalibrationSetup (FieldOfView, MegaPixels, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (5.40, 3.6, '660', 30, 1.00, 1.00, 60, 60, 10.0, 20.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9jj

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9jj', #31-Mar-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9jj', 'Fix AI 7007');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9jj', 'Fix HIBC to support $$/');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9jj', 'Use more reliable method for correcting FPMAJ tilt');
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7007";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7007", 0, ""      , "Harvest Date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7007", 1, "D6-12" , "Harvest Start Date (YYMMDD)");
Update CalibrationSetup Set SmallSharpen = 50 Where LightingMode = "660" And MegaPixels =  5.5 And FieldOfView = 3.0;
Update CalibrationSetup Set SmallSharpen = 50 Where LightingMode = "660" And MegaPixels =  5.5 And FieldOfView = 4.5;
Update CalibrationSetup Set SmallSharpen = 70 Where LightingMode = "660" And MegaPixels = -5.5 And FieldOfView = 3.0;
Update CalibrationSetup Set SmallSharpen = 50 Where LightingMode = "660" And MegaPixels =  3.6;
Update CalibrationSetup Set LargeSharpen = 45 Where LightingMode = "660" And MegaPixels =  5.5 And FieldOfView = 3.0;
Update CalibrationSetup Set LargeSharpen = 45 Where LightingMode = "660" And MegaPixels =  5.5 And FieldOfView = 4.5;
Update CalibrationSetup Set LargeSharpen = 65 Where LightingMode = "660" And MegaPixels = -5.5 And FieldOfView = 3.0;
Update CalibrationSetup Set LargeSharpen = 50 Where LightingMode = "660" And MegaPixels =  3.6;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9kk

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9kk', #27-May-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Implement Reflectance Margin for Data Matrix and for QR Code');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Implement GS1 limits tables');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Fix wrong message about superfluous code change');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Remove 75% to 200% limit on UPC/EAN and use GS1 limits tables instead');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Implement ActiveDirectory support');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Record GS1 Data and GS1 Pass/Fail in database');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Change ISO aperture rules to use smaller value at transition points');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Fix 2D Override aperture bug');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Fix backward message when one aperture works but the correct one does not');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Fix Active Directory Log Entries');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Disable Change Password Button');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Separate EAN and JAN symbologies');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9kk', 'Replace BatchISP with dfu-programmer');

Create Table GS1SpecificationTables
(
    SpecificationTable  Integer,
    Description         Text,
    Primary Key         (SpecificationTable)
);

Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 1, 'Table 1 - Trade Items Scanned in General Retail POS and not General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 2, 'Table 2 - Trade Items Scanned in General Distribution Only');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 3, 'Table 3 - Trade Items Scanned at General Retail POS and General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 4, 'Table 4 - Trade Items - Packages/Containers Not Scanned at POS or General Retail');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 5, 'Table 5 - Trade Items Scanned in General Distribution that are Logistics Units');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 6, 'Table 6 - Regulated Healthcare Non-Retail Consumer Trade Items Not Scanned in General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 8, 'Table 8 - Trade Items Scanned in Pharmacy (Retail or Non-Retail) and General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 9, 'Table 9 - GS1 Keys GDTI, GRAI, GIAI and GLN');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (10, 'Table 10 - Regulated Healthcare Retail Consumer Trade Items Not Scanned in General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (11, 'Table 11 - GS1 GSRNs');

Create Table GS1Limits
(
    SpecificationTable  Integer,
    Symbology           Text,
    MinXdim             Real,
    MaxXdim             Real,
    MinHeight           Real,
    MinLeftQZ           Real,
    MinRightQZ          Real,
    MinOverallGrade     Real,
    Aperture            Integer
);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "EAN-13",                              0.264,   0.660,   69.2,      11,        7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "EAN-8",                               0.264,   0.660,   55.2,      7,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "UPC-A",                               0.264,   0.660,   69.2,      9,         9,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "UPC-E",                               0.264,   0.660,   69.2,      9,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Omnidirectional",         0.264,   0.660,   46,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Stacked Omnidirectional", 0.264,   0.660,   46,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Expanded",                0.264,   0.660,   34,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Expanded Stacked",        0.264,   0.660,   71,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 Data Matrix",                     0.396,   0.743,   0,         1,         1,          1.5,             12);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 QR Code",                         0.396,   0.743,   0,         4,         4,          1.5,             12);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "EAN-13",                              0.495,   0.660,   69.2,      11,        7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "EAN-8",                               0.495,   0.660,   55.2,      7,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "UPC-A",                               0.495,   0.660,   69.2,      9,         9,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "UPC-E",                               0.495,   0.660,   69.2,      9,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "ITF-14",                              0.495,   0.634,   -1.25,     10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "ITF-14",                              0.635,   1.016,   -1.25,     10,        10,         0.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1-128",                             0.495,   1.016,   -1.25,     10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Omnidirectional",         0.495,   0.660,   33,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Stacked Omnidirectional", 0.495,   0.660,   69,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Expanded",                0.495,   0.660,   34,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Expanded Stacked",        0.495,   0.660,   71,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Stacked",                 0.495,   0.660,   13,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Limited",                 0.495,   0.660,   10,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Truncated",               0.495,   0.660,   13,        0,         0,          1.5,             10);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "EAN-13",                              0.495,   0.660,   69.2,      11,        7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "EAN-8",                               0.495,   0.660,   55.2,      7,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "UPC-A",                               0.495,   0.660,   69.2,      9,         9,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "UPC-E",                               0.495,   0.660,   69.2,      9,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Omnidirectional",         0.495,   0.660,   46,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Stacked Omnidirectional", 0.495,   0.660,   95,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Expanded",                0.495,   0.660,   34,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Expanded Stacked",        0.495,   0.660,   71,        0,         0,          1.5,             06);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "EAN-13",                              0.264,   0.660,   69.2,      11,        7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "EAN-8",                               0.264,   0.660,   55.2,      7,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "UPC-A",                               0.264,   0.660,   69.2,      9,         9,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "UPC-E",                               0.264,   0.660,   69.2,      9,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Omnidirectional",         0.264,   0.660,   33,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Stacked Omnidirectional", 0.264,   0.660,   69,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Expanded",                0.264,   0.660,   34,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Expanded Stacked",        0.264,   0.660,   71,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Stacked",                 0.264,   0.660,   13,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Limited",                 0.264,   0.660,   10,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Truncated",               0.264,   0.660,   13,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "ITF-14",                              0.250,   0.495,   -0.5,      10,        10,         1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1-128",                             0.250,   0.495,   -0.5,      10,        10,         1.5,             06);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(5,                  "GS1-128",                             0.495,   0.940,   -1.25,     10,        10,         1.5,             10);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1-128",                             0.170,   0.495,   -0.5,      10,        10,         1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 Data Matrix",                     0.255,   0.495,   0,         1,         1,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Omnidirectional",         0.170,   0.660,   33,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Truncated",               0.170,   0.660,   13,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Stacked",                 0.170,   0.660,   13,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Stacked Omnidirectional", 0.170,   0.660,   69,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Limited",                 0.170,   0.660,   10,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Expanded",                0.170,   0.660,   34,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Expanded Stacked",        0.170,   0.660,   71,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "EAN-13",                              0.170,   0.660,   69.2,      11,        7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "EAN-8",                               0.170,   0.660,   55.2,      7,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "UPC-A",                               0.170,   0.660,   69.2,      9,         9,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "UPC-E",                               0.170,   0.660,   69.2,      9,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "ITF-14",                              0.170,   0.495,   -0.5,      10,        10,         1.5,             06);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1-128",                             0.495,   1.016,   -1.25,     10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 Data Matrix",                     0.750,   1.520,   0,         1,         1,          1.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "EAN-13",                              0.495,   0.660,   69.2,      11,        7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "EAN-8",                               0.495,   0.660,   55.2,      7,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "UPC-A",                               0.495,   0.660,   69.2,      9,         9,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "UPC-E",                               0.495,   0.660,   69.2,      9,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "ITF-14",                              0.495,   1.016,   -1.25,     10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Omnidirectional",         0.495,   0.660,   33,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Truncated",               0.495,   0.660,   13,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Stacked",                 0.495,   0.660,   13,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Stacked Omnidirectional", 0.495,   0.660,   69,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Limited",                 0.495,   0.660,   10,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Expanded",                0.495,   0.660,   34,        0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Expanded Stacked",        0.495,   0.660,   71,        0,         0,          1.5,             10);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(9,                  "GS1-128",                             0.250,   0.495,   -0.5,      10,        10,         1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(9,                  "GS1 Data Matrix",                     0.380,   0.495,   0,         1,         1,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(9,                  "GS1 QR Code",                         0.380,   0.495,   0,         4,         4,          1.5,             08);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1-128",                             0.264,   0.660,   -0.5,      10,        10,         1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 Data Matrix",                     0.396,   0.990,   0,         1,         1,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Omnidirectional",         0.264,   0.660,   33,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Truncated",               0.264,   0.660,   13,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Stacked",                 0.264,   0.660,   13,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Stacked Omnidirectional", 0.264,   0.660,   69,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Limited",                 0.264,   0.660,   10,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Expanded",                0.264,   0.660,   34,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Expanded Stacked",        0.264,   0.660,   71,        0,         0,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "EAN-13",                              0.264,   0.660,   69.2,      11,        7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "EAN-8",                               0.264,   0.660,   55.2,      7,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "UPC-A",                               0.264,   0.660,   69.2,      9,         9,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "UPC-E",                               0.264,   0.660,   69.2,      9,         7,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "ITF-14",                              0.264,   0.660,   -0.5,      10,        10,         1.5,             06);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1-128",                             0.170,   0.495,   -0.5,      10,        10,         1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1 Data Matrix",                     0.255,   0.495,   0,         1,         1,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1 QR Code",                         0.255,   0.495,   0,         4,         4,          1.5,             08);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(-1,                 "ITF-14",                              0.635,   2.000,   0,         10,        10,         0.5,             20);

Insert Into Settings (Category, SettingName, SettingValue) Values ('GS1', 'Table',  '1');
Insert Into Settings (Category, SettingName, SettingValue) Values ('GS1', 'Action', '2');

Delete From Glossary Where Entry = "Decodability";
Delete From Glossary Where Entry = "Modulation";
Insert Into Glossary (Entry, Description) Values
(
    "Decodability",
    "This is a measurement of printing accuracy.  Software measures the difference between a perfect bar code image and the actual image.   In other words, decodability is a measurement of how closely bars and spaces match their perfect width and position."
);
Insert Into Glossary (Entry, Description) Values
(
    "1D Modulation",
    "A=70+ B=60-69 C=50-59 D=40-49 F=39-^This is ratio of the minimum edge contrast to the symbol contrast."
);
Insert Into Glossary (Entry, Description) Values
(
    "2D Modulation",
    "Modulation measures the uniformity of reflectance of the dark and light modules."
);
Insert Into Glossary (Entry, Description) Values
(
    "Reflectance margin",
    "Reflectance margin is similar to modulation, but takes into account if a module is on the wrong side of the global threshold."
);
Insert Into Glossary (Entry, Description) Values
(
    "Symbol height",
    "For stacked 1D (linear) symbols, this is the height of the symbol as measured from the topmost decodable scan line to the bottommost decodable scan line.  GS1 has specific requirements for symbol height."
);
Insert Into Glossary (Entry, Description) Values
(
    "Shortest row height",
    "For stacked 1D (linear) symbols, this is the height of the shortest row measured as a ratio to Xdim.  Shorter rows make successful reading of the symbol less likely."
);

Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryCheck', '0');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryDomain', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowAddChangeOperator', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowCalibration', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowChangeArchive',  '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowChangeSetup', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowCreateEdit', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowFullISO', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllowPassFailISO', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSAllUsers', '');
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryLVSOrgUnit', '');

Update PostalSetup Set Symbology = "Mailmark" Where Symbology = "EIB";
Delete From ApplicationStandards Where ShortName = "Auto";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9LL

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9LL', #24-Jun-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9LL', 'Restore warning message about missing FNC1');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9LL', 'Bundle dfu-programmer.exe instead of Atmel Flip');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9LL', 'Fix AI 7007 to work with a single date');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9LL', 'Show message No Calibration Card instead of Calibration Needed if applicable');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9LL', 'Avoid extraneous warnings about ignoring GS1 label height');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9mm

Insert Into ReleaseVersions (Version, ReleaseDate) Values ('3.0.9mm', #29-Jun-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9mm', 'Fix typo in MaxReferenceHistory');
Insert Into ReleaseDetails  (Version, Comment)     Values ('3.0.9mm', 'Implement FAQ button');
Update ApplicationStandards Set LongName = 'DPM Cat 0 (TR29158)' Where ShortName = 'DPM0';

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9nn

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9nn", #15-Jul-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Don't check for contrast label if calibrating with GS128 label");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Only enable GS1 table selection for application standards whose names start with the 3 characters GS1");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Change report tables to be 50% of the page width and to do a better job breaking up text");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Add logic to translate new GS1 pulldowns");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Don't show question marks for GS1Data for EAN, UPC, and ITF-14");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Support EAIV translation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Fix DataGrid resizing issue when pushing Ctrl-F");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Fix incorrect structure errors for JAN-8 and JAN-13");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9nn", "Turn off setup screen features if operator is not authorized");
Update Settings Set Category = "Parameters EAN-13" Where Category = "Parameters EAN/JAN-13";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9no

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9no", #17-Jul-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9no", "Fix bug to allow Active Directory to use an Org Unit that are not flat");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9no", "Fix Active Directory Domain to allow for tree subdomains");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9oo

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9oo", #21-Jul-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9oo", "Adjust calibration parameters for 9570");
Update CalibrationSetup Set SmallApertureScaling = 0.80 Where MegaPixels = 3.6;
Update CalibrationSetup Set LargeApertureScaling = 0.80 Where MegaPixels = 3.6;
Update CalibrationSetup Set SmallSharpen         = 50   Where MegaPixels = 3.6;
Update CalibrationSetup Set LargeSharpen         = 45   Where MegaPixels = 3.6;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9op

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9op", #21-Jul-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9op", "Changes to ActiveDirectory domain connection test");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9pp

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9pp", #27-Jul-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9pp", "Include BatchISP in install directory");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9qq

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9qq", #20-Aug-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9qq", "Adjust 9570 communications timing");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9qq", "Change default gamma setting for 9570");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9qq", "Avoid crash/lockup with GS1 Table 8 on SQL Server systems");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9rr

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9rr", #2-Sep-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9rr", "Fix subtle bug with linkage flag and HIBC");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9ss

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9ss", #10-Sep-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9ss", "Reload recovery databases that predate current serial number design");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9ss", "Remove unreliable message about unprintable characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9ss", "Restore display of UPC/EAN percentage");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9tt

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9tt", #13-Oct-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9tt", "Support new 9580 handle hardware");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9tt", "Fix bugs that prevented large QR Codes from reading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9tt", "Redo multiple security device logic");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9tt", "Log browsing database");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9tt", "Add AllowedUserChanges table");

Create Table AllowedUserChanges
(
    SettingName		Text,
    MinValue		Integer,
    MaxValue            Integer,
    Primary Key         (SettingName)
);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("CommPort",               0, 99);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("DecimalGrading",         0,  1);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("ExcludeAllOnExport",     0,  1);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("IncludePrintStructure", -1,  1);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("Signatures",             0,  3);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("SingleColumn",           0,  1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9uu

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9uu", #24-Nov-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Update translation files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Fix missing leading zeroes on Maxicode zip code");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Avoid divide by zero error on certain QRCodes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Improve format pattern detection in QRCode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Fix importing 24-bit color images");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Fix encoder direction problem when reopening 9570");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "ActiveDirectory changed format for entry of LVS Allusers Group");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "ActiveDirectory changes format for entry of LVS Org Unit");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "ActiveDirectory allows subGroups in LVS AllUsers Group");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "ActiveDirectory allows subGroups in LVS Permission Groups");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Embed HTML images using Base64 encoding to avoid stale image in report");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Fix translation duplication issue when phrase ends with numbers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Don't use Base64 encoding during calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Fixed login failures when using ActiveDirectory ");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9uu", "Fix Logins with userIDs created with ActiveDirectory, when AD is disabled ");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     3.0.9vv

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("3.0.9vv", #30-Dec-2015#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Fix implied 01 logic to ignore DataBar Expanded");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Don't apply 2-character ANSI rules when GS1 in use");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Fix lockup when Japanese selected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Solve sluggish response on 9510 and 9580 cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Fix ambiguity issues when both green and black dongles detected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Don't undo overrides during calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Fix occasional QRCode not being read");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Fix missing implied (01) for DataBar Omnidirectional");
Insert Into ReleaseDetails  (Version, Comment)     Values ("3.0.9vv", "Fix typo in 0407.dat which prevented it from working");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0", #6-Jan-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0", "Rebrand as Microscan");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0", "Set modulation to 0 for scan lines which fail edge determination");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0a", #13-Jan-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0a", "Improve Data Matrix locator algorithm");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0b", #18-Jan-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0b", "Correct bug in new Data Matrix locator algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0b", "Correct bug in Active Directory CreateUsersFromAD");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0b", "Add ActiveDirectory Log file and form setting to enable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0b", "Add Progress bar with creating operators from Active Directory");
Insert Into Settings (Category, SettingName, SettingValue) Values ('ActiveDirectory', 'ActiveDirectoryEnableLog', 0);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0c", #24-Jan-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0c", "Correct bug in Active Directory CreateUsersFromAD");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0c", "Add ActiveDirectory Log file and form setting to enable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0c", "Add Progress bar when creating operators from Active Directory");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0c", "Fix unwritable UniCombo controls");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0c", "Rename old registry values");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0c", "Fix HTML characters in Manufactured By field");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0d", #27-Jan-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0d", "Support new red/white light 9580 camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0d", "Change default exposure for 9580 from 40 to 70ms");
Update CalibrationSetup Set Exposure = 70 Where MegaPixels = -5.5;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0e", #2-Feb-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0e", "Preserve ActiveDirectory settings when copying database");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0e", "Include proper AIs in report for composite symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0e", "Include separate structure reports for 1D and 2D if applicable");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0f", #4-Feb-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0f", "Bump revision letter");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0g", #10-Mar-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Improve Microscan logo");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Fix SQL Statement error in ActiveDirectoryIntegration, Use the UPPER function for MySQL and MSSQL");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Fix MySQL error, MaxValue is reserved keyword, add delimiters when engine type is MySQL");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Fix ConfirmEngineType to catch Microsoft SQL 2014");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Revert translation files pending redesign");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Restore internal designations of Atmel-based 9570 units");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Include rebranded manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0g", "Fixed error in ExportReferenceCommand with using a MS SQL Database");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0h", #25-Apr-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Fixed incorrect error about missing leader bars in Data Matrix codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Fixed missing AI (30) in AI report");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Added AI (394) Percentage discount of a coupon");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Added AI (8012) Software version");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Added AI (8111) Loyalty points of a coupon");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Add 2D symbologies to GS1 table 4");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Add 2D symbologies to GS1 table 7");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Change GS1-128 Table 11 aperture to 5");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Use data identifiers for MIL-STD-130N");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Remove obsolete manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Fix problem misidentifying older 9580 units");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Try harder to read UPC/EAN codes with a wrong check digit");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Clean up and sort translation files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0h", "Fix Active Directory bug when there are no users in the LVS All Users group");

Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("394" , 0, ""     , "Percentage discount of a coupon");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("394" , 1, "N4"   , "Percentage discount of a coupon");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8012", 0, ""     , "Software version");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8012", 1, "X1-20", "Software version");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8111", 0, ""     , "Loyalty points of a coupon");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8111", 1, "N4"   , "Loyalty points of a coupon");

Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (7, 'Table 7 - Direct part marking');

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 Data Matrix",                     0.380,   0.495,   0,         1,         1,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 QR Code",                         0.380,   0.495,   0,         4,         4,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7,                  "GS1 Data Matrix",                     0.254,   0.615,   0,         1,         1,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7,                  "GS1 QR Code",                         0.254,   0.615,   0,         4,         4,          1.5,             06);
Update GS1Limits Set Aperture = 5 Where SpecificationTable = 11 And Symbology = "GS1-128";

Delete From DataIdentifiers;

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "A", "Reserved");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "B", "Container Information");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1B", "Returnable container identification code assigned by the container owner");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2B", "Gas Cylinder Container Identification Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3B", "Motor Freight Transport Equipment Identification Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4B", "Standard Carrier Alpha Code (SCAC)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5B", "Receptacle Asset Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7B", "Identification of a returnable container owner followed by a unique container identification");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8B", "Identification of a returnable container owner assigned in cooperation with BIC");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9B", "Container Type");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10B", "Container Ownership Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11B", "Van Number (complete number minus check digit)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12B", "Check digit of Van Number identified in 11B");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13B", "Container Number Code (last 5 digits of number not counting check digit)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25B", "Identification of a party to a transaction as identified in 18V, followed by the serial number to an RTI");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "C", "Field Continuation");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1C", "Continuation of Traceability Code (Category 20) assigned by Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2C", "Continuation of Serial Number (Category 19) assigned by Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3C", "Continuation of Free Text (Category 26) mutually defined between Supplier/Carrier/Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4C", "Continuation of Transaction Reference (Category 11) mutually defined between Supplier/Carrier/Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5C", "Continuation of Item Code (Category 16) Assigned by Supplier");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "D", "Date");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5D", "ISO format YYMMDD immediately followed by an ANSI X12.3 Data Element Number 374 Qualifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6D", "ISO format YYYYMMDD immediately followed by an ANSI X12.3 Data Element Number 374 Qualifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9D", "Date (structure and significance mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20D", "Inspection Date (DDMMMYYYY)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21D", "Required Delivery Date (DDD Julian) or DOD MIL STAMP Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22D", "Record Date Time Stamp (YYYYMMDDTTTT)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23D", "Date, represented in modified UTC compliant form");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24D", "Qualified date, comprising the concatenation of an ISO/IEC 15459 issuing agency code");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "E", "Environmental Factors");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1E", "Air pressure - (altitude)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10E", "Cumulative Time Temperature index");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11E", "Time Temperature Index - Next Higher Assembly");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "F", "Looping");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1F", "My 'parent' is . . . (for use with returnable packaging)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2F", "My 'children' are . . . (for use with returnable packaging)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3F", "I have ______ children . . . (for with for returnable packaging)");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "G", "Reserved");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "H", "Human Resources");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1H", "Employee Identification Code assigned by employer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3H", "ID Number for non-employee (internally assigned or mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4H", "National Social Security Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5H", "Last Name");

Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10H", "Personal Identification Code (first initial, Last initial, last four of SSN)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11H", "First name and middle initial");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "I", "Reserved");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2I", "Abbreviated VIN Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3I", "Reserved - Prior assignment");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "J", "License Plate");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6J", "Unique license plate number assigned to a master transport unit");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7J", "Vehicle Registration License Plate Number");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "K", "Transaction Reference Used In Trading Relationships");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1K", "Order number assigned by Supplier to identify a Purchasing Transaction");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2K", "Bill of Lading/Waybill/Shipment Identification Code assigned by Supplier/Shipper");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3K", "Bill of Lading/Waybill/Shipment Identification Code assigned by Carrier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4K", "Line number of the order assigned by Customer to identify a Purchasing Transaction (See Annex C.9)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5K", "Reference number assigned by the Customer to identify a Shipment Authorization (Release) against an established Purchase Order");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6K", "PRO# Assigned by Carrier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7K", "Carrier Mode in Free Text format mutually defined between Customer and Supplier (e.g., Air, Truck, Boat, Rail)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8K", "Contract Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9K", "Generic Transaction Reference Code (internally assigned or mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10K", "Invoice Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11K", "Packing List Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12K", "SCAC (Standard Carrier Alpha Code)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14K", "Combined Order Number and Line Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15K", "KANBAN Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16K", "DELINS Number: code assigned to identify a document which contains delivery information");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17K", "Check Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18K", "Structured Reference (See Annex C.10)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19K", "Foreign Military Sales Case Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20K", "License identifier, being a globally unique identifier for a license or contract under which items are generated");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21K", "Customer data, being data that from a customer perspective, is related to or associated with an item or transaction, or to a batch or related items or transactions");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22K", "Transaction authentication information");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25K", "Global unique identification of groupings of transport units assigned by the carrier, defined as: Identification of a Party to a Transaction as identified in 18V, followed by the Bill of Lading or Shipment Identification Code.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26K", "Global unique identification of groupings of transport units assigned by the shipper, defined as: Identification of a Party to a Transaction as identified in 18V, followed by the Bill of Lading or Shipment Identification Code.");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "L", "Location Reference");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1L", "Location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2L", "'Ship To:' Location code defined by an industry standard or mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3L", "'Ship From:' Location code defined by an industry standard or mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4L", "Country of Origin, two-character ISO 3166 country code. With agreement of trading partners and when the Country of Origin is mixed, Country Code 'AA' shall be used.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5L", "'Ship For:' Location code defined by an industry standard or mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6L", "Route Code assigned by the supplier to designate a specific transportation path");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8L", "Port of Embarkation - Mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9L", "Port of Debarkation - Mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20L", "First Level (internally assigned) American National Standard ANSI MH10.8.2-2010(a revision of MH10.8.2-2002, 2006) Data Identifier and Application Identifier Standard");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21L", "Second Level (internally assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22L", "Third Level (internally assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23L", "Fourth Level (internally assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24L", "Fifth Level (internally assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26L", "Location code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("51L", "Ship From");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("52L", "Ship To");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("54L", "Ship From");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("55L", "Ship To");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "M", "Reserved");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10M", "Army form 2410 data. Format is data value preceded by the block number of the form 2410");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11M", "Army form 2408 data. Format is data value preceded by the block number of the form 2408");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12M", "Army form 2407 data. Format is data value preceded by the block number of the form 2407");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13M", "Air Force Form 95 data. Format is data value preceded by the block number of the form 95");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14M", "Navy Form 4790 data. Format is data value preceded by the block number of the form 2410");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "N", "Industry Assigned Codes");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1N", "Product Characteristic Data defined by the Chemical Industry Data Exchange (CIDX)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3N", "Coding Structure in Accordance with Format Defined by Electronic Industries Association Japan (EIAJ)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4N", "Coding Structure and Formats in Accordance with GS1 Application Identifiers (AI plus data) (GS1)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5N", "Coding Structure and Formats in Accordance with AIAG Recommendations. The full Data Identifier is in the form 5Nxx where the 'xx' is found in the full code list that can be found athttp://www.autoid.org/ANSI_MH10_SC8/5N_DI_Table/5N_DI_Table.htm");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6N", "U.S. DOD Requisition and Issue Procedure Codes. The format is the MILSTRIP code the appropriate followed by the data value associated with that code. (The full list of codes is available athttp://www.dla.mil/j6/dlmso/eLibrary/Manuals/MILSTRIP/Reissue200");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7N", "U.S. Defense Transportation Regulation codes. The format is the DTR code followed by the appropriate data value associated with that code. (The full list of codes is available athttp://www.transcom.mil/j5/pt/dtr_part_ii.html in appendices Through YY)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8N", "Production animal identification codes. The format is the production animal code followed by the appropriate data value associated with that code. ");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "O", "Reserved");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "P", "Item Information");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1P", "Item Identification Code assigned by Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2P", "Code assigned to specify the revision level for an Item (e.g. Engineering change level, edition, or revision)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3P", "Combined manufacturer identification code/item code under the");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4P", "Item Code portion of GS1 formats");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5P", "Freight Classification Item Number assigned by Carrier for purposes of rating hazardous materials (e.g., Motor Freight, Air, Boat, Rail Classification)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6P", "Combined supplier identification and item code (internally assigned or mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7P", "Common Language Equipment Identification (CLEI) assigned by the manufacturer to some telecommunications equipment");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9P", "Combined manufacturer identification code (9-digit DUNS number assigned by Dun & Bradstreet) and the item code/part number (assigned by the manufacturer).");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10P", "Hazardous Material Code as defined by ANSI X12.3 in the format Data Element 208 (1-character code qualifier) followed by Data Element 209 (Hazardous Material Code)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12P", "Document Type (e.g., Pick List, Design Drawing, etc.) (internally assigned or mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13P", "VMRS System Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14P", "VMRS System and Assembly Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15P", "VMRS System, Assembly, & Part Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16P", "VMRS System, Assembly, or Part Code (User Modified");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17P", "Combined GS1 supplier identification and item code assigned by the supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18P", "Combined VMRS supplier ID and supplier assigned part number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19P", "Component of an Item (One product contained in multiple packages) The following five DIs can be used to provide for Item identification (Item ID), which is different than or in addition to Item ID provided by 'P'.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20P", "First Level (Customer Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21P", "Second Level (Customer Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22P", "Third Level (Customer Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23P", "Fourth Level (Customer Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24P", "Fifth Level (Customer Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25P", "Identification of a party to a transaction as identified in 18V, followed by the supplier assigned part number.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26P", "Part Number of next higher assembly");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30P", "First Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31P", "Second Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("32P", "Third Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("33P", "Fourth Level (Supplier Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("34P", "Fifth Level (Supplier Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("40P", "A code assigned by a customer to the identification number of the manufacturer's Material Safety Data Sheet (MSDS) document that describes the uses, hazards, and chemical composition of a hazardous material.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("50P", "Manufacturer-assigned item identifier - Manufacturer-assigned item identifier comprising an item number assigned by the item manufacturer, followed by a plus (+) sign, followed - if required to uniquely identify - by a manufacturer-assigned item version.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("51P", "Globally unique item identifier comprising the Identification of a party to a transaction as identified in 18V, followed by a plus (+) sign, followed by the Manufacturer-assigned item identifier as defined with. ");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "Q", "Measurement");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1Q", "Theoretical Length/Weight (numeric only)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2Q", "Actual Weight (numeric only) an2 3Q Unit of Measure, as defined by the two character ANSI X12.3 Data Element Number 355 Unit of Measurement Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4Q", "Gross Amount");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5Q", "Net Amount");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6Q", "Where multiple containers comprise a single product (the contents of each container must be combined with the content of the other containers to constitute a single product) the Data Identifier '6Q'shall be used to link the various containers.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7Q", "Quantity, Amount, or Number of Pieces in the format: Quantity followed by the two character ANSI X12.3 Data Element Number 355Unit of Measurement Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9Q", "Piece Weight: weight of a single item");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11Q", "Tare Weight: weight of an empty container");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12Q", "Monetary Value established by the Supplier in the format of: the value followed by an ISO 4217 data element code for representing unit of value of currencies and funds (e.g., 12Q2.50USD) (2.50Monetary Value in USA Dollars) significance mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13Q", "# of # ('this is the nth piece of x pieces in this shipment') Presented in the format 'n/x', where the '/' (slash) is used as a delimiter between two values. See Annex C.6.3 for further information");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14Q", "Beginning Secondary Quantity");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15Q", "Ending Secondary Quantity");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16Q", "Number of pieces in Van");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17Q", "Number of shipments in van");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18Q", "Cube expressed in cubic meters or cubic feet followed by the ANSI X12.3 data element number 355 unit of measure code (CR of CF). No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19Q", "Width expressed in linear meters or linear feet followed by the ANSI X12.3 data element number 355 unit of measure code (LC or LF). No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20Q", "Height expressed in linear meters or linear feet followed by the ANSI X12.3 data element number 355 unit of measure code (LC or LF). No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21Q", "Length expressed in linear meters or linear feet followed by the ANSI X12.3 data element number 355 unit of measure code (LC or LF). No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22Q", "Net weight of shipment expressed in pounds or kilograms (kilos) followed by the ANSI X12.3 data element number 355 unit of measure (LB or KG). No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23Q", "Van length expressed in linear meters or linear feet followed by the ANSI X12.3 data element number 355 unit of measure (LC or LF). No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24Q", "Inside cube of a van expressed in cubic meters or cubic feet followed American National Standard ANSI MH10.8.2-2010 Data Identifier and Application Identifier StandardV10a 20by the ANSI X12.3 data element number 355 of unit measure code (CR or CF).");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25Q", "Net explosive weight (a computed value of explosive equivalent expressed in pound of TNT). The measure of NEW is used internationally for explosive safety quantity distance arc computations. No implied decimal point.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26Q", "Packaging Level, specifying the hierarchical level of packaging in accordance with HIBC (Health Industry Bar Code) specifications");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "R", "Miscellaneous");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1R", "Return Authorization Code (RMA) assigned by the Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2R", "Return Code assigned by the Customer");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "S", "Traceability Number for an Entity");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1S", "Additional code assigned by the Supplier to an entity for its lifetime (e.g., traceability number, computer serial number)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2S", "Advance Shipment Notification (ASN) Shipment ID (SID)corresponds to ANSI ASC X12 Data Element 396");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3S", "Unique Package Identification assigned by Supplier (lowest level of packaging which has a package ID code; shall contain like items)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4S", "Package Identification assigned by Supplier to master packaging containing like items on a single customer order (See Annex C.7)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5S", "Package Identification assigned by Supplier to master packaging containing unlike items on a single customer order (See Annex C.7)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6S", "Package Identification assigned by Supplier to master packaging containing like items over multiple customer orders (See Annex C.7)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7S", "Package Identification assigned by Supplier to master packaging containing unlike items over multiple customer orders (See AnnexC.7)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9S", "Package Identification, Generic (mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10S", "Machine, cell, or tool ID code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11S", "Fixed asset ID code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12S", "Document Number (internally assigned or mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13S", "Container Security Seal");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14S", "4th Class Non-identical parcel post manifesting");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15S", "Serial Number Assigned by the Vendor Entity, that can only be used in conjunction with '13V'");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16S", "Version Number, e.g., Software Version");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17S", "Combined 6-digit GS1 supplier identification and unique package identification assigned by the supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18S", "CAGE Code & Serial Number unique within CAGE American National Standard ANSI MH10.8.2-2010(a revision of MH10.8.2-2002, 2006) Data Identifier and Application Identifier Standard");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19S", "Combined Dun & Bradstreet company identification of the supplier followed by a unique package identification assigned by the supplier, in the format nn...nn+nn...n where a plus symbol (+) is used as a delimiter between the DUNS Number and UPI");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20S", "Traceability code for an entity assigned by the customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21S", "Combined U.S. D.O.T. Tire Manufacturer Plant Code and unique tire identification assigned by the supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22S", "Electronic Serial Number for Cellular Mobile Telephones");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25S", "Identification of a party to a transaction as identified in 18V, followed by the supplier assigned serial number.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26S", "Equipment identifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27S", "Item number within batch");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("28S", "Batch-and-item number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30S", "Additional traceability code for an entity assigned by the supplier in addition to or different from the traceability code(s) provided by 'S' or'1S'");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31S", "Beginning Serial Number for serial numbers in sequence");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("32S", "Ending Serial Number for serial numbers in sequence");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("33S", "Serial number of Next higher assembly");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("34S", "Serial number or Part number of End Item");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("35S", "Bumper Number (Used in Unit DOD Move)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("36S", "Pallet Identifier (Used for loaded 463L air pallets)");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "T", "Traceability Number for Groups of Entities");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1T", "Traceability Number assigned by the Supplier to identify/trace a unique group of entities (e.g., lot, batch, heat)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3T", "Exclusive Assignment (U.S. EPA vehicle identification for emissions testing)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20T", "First Level (Customer Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21T", "Second Level (Customer Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22T", "Third Level (Customer Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23T", "Fourth Level (Customer Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24T", "Fifth Level (Customer Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25T", "Identification of a party to a transaction as identified in 18V, followed by the supplier assigned traceability number.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26T", "Batch identifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27T", "Batch number, issued under the control of an identified party");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30T", "First Level (Supplier Assigned) identifier into these components. A transport unit identifier constructed from the same two components and a '27S' item number contains no such separator and cannot be decomposed. ANSI MH10.8.2-2010 Data and Application ID");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31T", "Second Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("32T", "Third Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("33T", "Fourth Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("34T", "Fifth Level (Supplier Assigned)");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "U", "UPU/MH 10/SC8 Agreed Upon Codes");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5U", "Specification of a postal service and associated process data in accordance with UPU standard S25 data construct 'Service Data'");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6U", "Licensing post data, in accordance with the specification in UPU standard S25.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15U", "Specification of supplementary postal service and associated process data in accordance with UPU standard S25 data construct' Supplementary Service Data'.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16U", "Postal administration identifications, being the identification, expressed in accordance with the specification in UPU standard S25, of one or more postal administrations involved in the processing of a mail item or batch.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17U", "UPU location code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18U", "Qualified UPU location code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19U", "License plate with service data and location code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("55U", "OCR Data Locator");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "V", "Party To The Transaction");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1V", "Supplier Code assigned by Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3V", "Fabricator Code as assigned by the appropriate GS1 authority");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4V", "Carrier Identification Code assigned by an industry standard mutually defined by the Supplier, Carrier, and Customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5V", "Financial Institution Identification Code (mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6V", "Manufacturer's identification code (mutually defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7V", "Code assigned to a party which has financial liability for an entity or group of entities (e.g., owner of inventory) (mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8V", "Customer code assigned by the customer");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9V", "Customer code assigned by the supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11V", "Organization with budget responsibility for an entity, process, or procedure (e.g., shop, division, department) (internally assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15V", "Carrier-assigned shipper number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16V", "VMRS Supplier ID");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18V", "Identification of a party to a transaction in which the data format consists of two concatenated segments. The first segment is the unique code assigned to an issuing agency by NEN, reference ISO/IEC 15459, the second segment is a unique entity ID.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19V", "Specification of a party's role(s), in a transaction, consisting of one or more code values from EDIFACT Code List 3035 'Party Qualifier', separated by plus (+) characters.");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20V", "Identification of a party to a transaction as identified in 18V, followed by a plus (+) character followed by one or more code values from EDIFACT Code List 3035 'Party Qualifier', separated by plus (+) characters.");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "W", "Activity Reference");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1W", "Operation Sequence Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2W", "Operation Code/Work Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3W", "Combined Work Order Number and Operation Sequence Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4W", "Status Code (internally assigned or mutually defined)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5W", "Work Unit Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6W", "Nomenclature");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10W", "Form Control Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11W", "Quality Assurance Inspector - Last Name");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12W", "Telephone number of the person/activity completing the form");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "X", "Reserved");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "Y", "Internal Applications");

Insert Into DataIdentifiers (DataIdentifier, Description) Values (  "Z", "Mutually Defined");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1Z", "Mutually Defined between Carrier and Supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2Z", "Mutually Defined between Customer and Carrier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3Z", "Free Text");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4Z", "Mutually Defined between Carrier and Trading Partner");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10Z", "Structured Free Text (Header Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11Z", "(Line 1 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12Z", "(Line 2 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13Z", "(Line 3 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14Z", "(Line 4 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15Z", "(Line 5 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16Z", "(Line 6 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17Z", "(Line 7 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18Z", "(Line 8 Data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19Z", "(Line 9 Data)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0j", #7-Jun-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0j", "Fixed issue when using SQL dB, file access error 75 for windows users without admin rights");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0k

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0k", #26-Aug-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0k", "Fix HIBC issue - Unrecognized data identifier");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0k", "Changes to Speedup creation of users from Active Directory");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0L

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0L", #2-Sep-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0L", "Placeholder for unrelease version");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0m

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0m", #19-Sep-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0m", "Finish DPM2 implemenation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0m", "Remember AutoPrint setting and don't reset when changing tabs");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0m", "Implement new background/multithread model for slower operations");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0m", "Fix HIBC link character");

Delete From ApplicationStandards Where ShortName = 'DPM0';
Delete From ApplicationStandards Where ShortName = 'DPM2';
Delete From ApplicationStandards Where ShortName = 'MilStd';
Insert Into ApplicationStandards (ShortName, LongName, Status)              Values ('DPM',   'DPM (ISO/IEC TR29158)',    1);
Insert Into ApplicationStandards (ShortName, LongName, Status)              Values ('TEI',   'DPM + MIL-STD-130N',       1);
Insert Into ApplicationStandards (ShortName, LongName, Status, ShortCutKey) Values ('UII',   'DPM + UII + MIL-STD-130N', 1, 'D');
Insert Into ApplicationStandards (ShortName, LongName, Status)              Values ('MIL1D', 'MIL-STD-130N Linear (1D)', 1);

Alter Table Calibration Add Column DigitalGain2D  Real;
Alter Table Calibration Add Column DigitalShift2D Real;
Update Calibration Set DigitalGain2D  = DigitalGain;
Update Calibration Set DigitalShift2D = DigitalShift;
Alter Table DataIdentifiers Add Column DPMCharSet Text;

Delete From DataIdentifiers Where DataIdentifier = "7L";
Delete From DataIdentifiers Where DataIdentifier = "4N";
Delete From DataIdentifiers Where DataIdentifier = "I";
Delete From DataIdentifiers Where DataIdentifier = "22S";
Delete From DataIdentifiers Where DataIdentifier = "25S";
Delete From DataIdentifiers Where DataIdentifier = "18S";
Delete From DataIdentifiers Where DataIdentifier = "12V";
Delete From DataIdentifiers Where DataIdentifier = "17V";
Delete From DataIdentifiers Where DataIdentifier = "18V";
Delete From DataIdentifiers Where DataIdentifier = "3V";
Delete From DataIdentifiers Where DataIdentifier = "S";
Delete From DataIdentifiers Where DataIdentifier = "1P";
Delete From DataIdentifiers Where DataIdentifier = "1T";
Delete From DataIdentifiers Where DataIdentifier = "30P";
Delete From DataIdentifiers Where DataIdentifier = "30T";

Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ( "7L",  6,  6, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "6-character Department of Defense Activity Code (DoDAAC)");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ( "4N",  1, 30, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "Coding Structure and Formats in Accordance with GS1 Application Identifiers (AI plus data) (GS1)");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values (  "I", 17, 17, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "VIN - Vehicle Identification Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("22S",  1, 20, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "Electronic Serial Number for Cellular Mobile Telephones");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("25S",  3, 46, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "Identification of a party to a transaction as identified in 18V, followed by the supplier assigned serial number.");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("18S",  5, 20, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "CAGE Code & Serial Number unique within CAGE American National Standard ANSI MH10.8.2-2010(a revision of MH10.8.2-2002, 2006) Data Identifier and Application Identifier Standard");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("12V",  9, 13, "0123456789",                             "DUNS number identifying manufacturer");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("17V",  5,  5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "U.S. DoD CAGE Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("18V",  3, 16, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "Identification of a party to a transaction in which the data format consists of two concatenated segments. The first segment is the unique code assigned to an issuing agency by NEN, reference ISO/IEC 15459, the second segment is a unique entity ID.");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ( "3V",  6, 13, "0123456789",                             "Fabricator Code as assigned by the appropriate GS1 authority");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values (  "S",  1, 30, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "Traceability Number for an Entity");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ( "1P",  1, 32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "Item Identification Code assigned by Supplier");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ( "1T",  1, 32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "Traceability Number assigned by the Supplier to identify/trace a unique group of entities (e.g., lot, batch, heat)");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("30P",  1, 32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "First Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("30T",  1, 32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "First Level (Supplier Assigned) identifier into these components. A transport unit identifier constructed from the same two components and a '27S' item number contains no such separator and cannot be decomposed. ANSI MH10.8.2-2010 Data and Application ID");

Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("UID ", 7, 45, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Unique IDentifier");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("USN ", 6, 20, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Universal Serial Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("UST ", 6, 20, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Universal Serial Tracking number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("CAG ", 5,  5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "TEI for Commercial And Government Entity");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("DUN ", 9,  9, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "TEI for Data Universal Numbering system");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("EUC ", 6, 13, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "TEI for GS1 Company Prefix");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("MFR ", 5,  5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "TEI for Manufacturer");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SPL ", 5,  5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",   "TEI for Supplier");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SER ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Serial Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("UCN ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Unique Component ID Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("PNO ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Original Part Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SEQ ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Sequential Serial Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("LOT ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Lot Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("BII ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Batch Item Identifier");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("PNR ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/", "TEI for Current Part Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("LTN ", 1, 15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-",  "TEI for Enterprise Lot Number");

Create Table UiiAssembly
(
    ConstructType           Text,
    Prefix                  Text,
    Optional                Text,
    Assembly                Text,
    Primary Key             (Assembly)
);

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("IUID Equivalent", "",   "",    "(8002)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("IUID Equivalent", "",   "",    "(8003)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("IUID Equivalent", "",   "",    "(8004)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(18S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "",   "",    "(25S)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "",    "(17V)+(1P)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "UN", "",    "(12V)+(1P)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "",   "",     "(3V)+(1P)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "LD", "",     "(7L)+(1P)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "",   "",    "(18V)+(1P)+(S)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "",    "(17V)+(1T)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "UN", "",    "(12V)+(1T)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "",   "",     "(3V)+(1T)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "LD", "",     "(7L)+(1T)+(S)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "",   "",    "(18V)+(1T)+(S)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("IUID Equivalent", "",   "",    "(I)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("IUID Equivalent", "",   "",    "(22S)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(MFR)+(SER)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(SPL)+(UCN)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(CAG)+(SER)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(CAG)+(UCN)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "UN", "",    "(DUN)+(SER)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "UN", "",    "(DUN)+(UCN)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "",   "",    "(EUC)+(SER)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "",   "",    "(EUC)+(UCN)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "",   "",    "(UID)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(USN)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #1",    "D",  "",    "(UST)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "LOT", "(MFR)+(PNO)+(LOT)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "LOT", "(SPL)+(PNO)+(LOT)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "LOT", "(CAG)+(PNO)+(LOT)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "UN", "LOT", "(DUN)+(PNO)+(LOT)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "",   "LOT", "(EUC)+(PNO)+(LOT)+(SEQ)");

Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "BII", "(MFR)+(LTN)+(BII)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "BII", "(SPL)+(LTN)+(BII)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "D",  "BII", "(CAG)+(LTN)+(BII)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "UN", "BII", "(DUN)+(LTN)+(BII)+(SEQ)");
Insert Into UiiAssembly (ConstructType, Prefix, Optional, Assembly) Values ("Construct #2",    "",   "BII", "(EUC)+(LTN)+(BII)+(SEQ)");

Update CalibrationSetup Set Exposure = 180 Where MegaPixels = -5.5;
Update AllowedUserChanges Set MaxValue = 3 Where SettingName = "IncludePrintStructure";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.0.0n

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.0.0n", #23-Sep-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.0.0n", "Implement GS1 Table 7");

Insert Into GS1Limits
(SpecificationTable, Symbology,                               MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(71,                 "GS1 Data Matrix",                       0.254,   0.615,   0,         1,         1,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                               MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(71,                 "GS1 QR Code",                           0.254,   0.615,   0,         4,         4,          1.5,             06);
Insert Into GS1Limits
(SpecificationTable, Symbology,                               MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(72,                 "GS1 Data Matrix Ink Based",             0.254,   0.615,   0,         1,         1,          1.5,             08);
Insert Into GS1Limits
(SpecificationTable, Symbology,                               MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(73,                 "GS1 Data Matrix DPM-A (connected)",     0.100,   0.300,   0,         1,         1,          1.5,             03);
Insert Into GS1Limits
(SpecificationTable, Symbology,                               MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(74,                 "GS1 Data Matrix DPM-B (not connected)", 0.200,   0.495,   0,         1,         1,          1.5,             06);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0", #27-Sep-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0", "Instead of beeping, delay operations where possible");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0", "Fix problems when switching cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0", "Fix problems when interrupting processing");

Drop Table GS1SpecificationTables;
Create Table GS1SpecificationTables
(
    SpecificationTable  Decimal(3,1),
    Description         Text,
    Primary Key         (SpecificationTable)
);
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 1,   'Table 1 - Trade Items Scanned in General Retail POS and not General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 2,   'Table 2 - Trade Items Scanned in General Distribution Only');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 3,   'Table 3 - Trade Items Scanned at General Retail POS and General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 4,   'Table 4 - Trade Items - Packages/Containers Not Scanned at POS or General Retail');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 5,   'Table 5 - Trade Items Scanned in General Distribution that are Logistics Units');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 6,   'Table 6 - Regulated Healthcare Non-Retail Consumer Trade Items Not Scanned in General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 7.1, 'Table 7.1 - DPM (non-medical)');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 7.2, 'Table 7.2 - DPM (medical, ink)');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 7.3, 'Table 7.3 - DPM (medical, direct A, connected)');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 7.4, 'Table 7.4 - DPM (medical, direct B, not connected)');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 8,   'Table 8 - Trade Items Scanned in Pharmacy (Retail or Non-Retail) and General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values ( 9,   'Table 9 - GS1 Keys GDTI, GRAI, GIAI and GLN');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (10,   'Table 10 - Regulated Healthcare Retail Consumer Trade Items Not Scanned in General Distribution');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (11,   'Table 11 - GS1 GSRNs');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0a

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0a", #5-Oct-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Fix calibration not working in Manual grading mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Don't accept Defects symbol in calibration mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Plot Micro QRCode format cells properly");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Show yellow border while trigger is held");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Show green crosshair on 9580 while moving");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Avoid error when review report earlier than the latest report");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0a", "Show 9585 as a choice on optional features");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0b

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0b", #11-Oct-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0b", "Implement non-integral exposure");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0b", "Grade tilted DPM but issue warning if applicable");
Delete From ApplicationStandards Where ShortName = "UVWarn";
Delete From ApplicationStandards Where ShortName = "UVGrade";
! Changing the Primary Key in a way that works with Jet, MySQL, and SQL Server is simply too difficult.
! Ressurrect the following kludge: The serial number in calibration has an extra digit at the end which is the lighting mode
Update Calibration Set SerialNumber = 10 * SerialNumber + 6 Where SerialNumber > 0;
Update Calibration Set SerialNumber = 10 * SerialNumber + 0 Where SerialNumber < 0;
Update Calibration Set LightingMode = "6" Where LightingMode = "660";
Update Calibration Set LightingMode = "0" Where LightingMode = "W";
Update Calibration Set Exposure = Exposure / 10 Where Exposure > 100;
Update CalibrationSetup Set Exposure = Exposure / 10 Where Exposure > 100;
Update CalibrationSetup Set LightingMode = "6" Where LightingMode = "660";
Update CalibrationSetup Set LightingMode = "0" Where LightingMode = "W";
Flush;
Alter Table Calibration Drop Column DigitalGain2D;
Alter Table Calibration Drop Column DigitalShift2D;
Alter Table Calibration Alter Column LightingMode Integer;
Alter Table CalibrationSetup Alter Column LightingMode Integer;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0c

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0c", #18-Oct-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0c", "Fix comma vs. period for GS1SpecificationTables");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0c", "Try to read QRCode when set for DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0c", "Fix MicroPDF vs. ITF misread");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0c", "Record structure information in database so it can be recalled and reprinted");
Alter Table GS1Limits Alter Column SpecificationTable Decimal(3,1);
Update GS1Limits Set SpecificationTable = SpecificationTable / 10 Where SpecificationTable > 70;
Delete From GS1Limits Where SpecificationTable = 7;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0d

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0d", #20-Oct-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0d", "Fix stitching with 9510/9580/9585");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0d", "Update CompactLvsDB to include Microscan in search");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0d", "Don't allow Data Matrix when set for MIL-STD-130N Linear (1D)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0e

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0e", #4-Nov-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0e", "Don't report 'D' for dome lighting on non-9580 systems");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0e", "Fix update problem with MySQL");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0e", "Update manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0e", "Fix problem with reference reports and SQL Server");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0e", "Reload calibration when changing application standards");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0e", "Eliminate image jumping once image is stable");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0f

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0f", #7-Nov-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0f", "Fix calibration not being reloaded when shortcut key used to change application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0f", "Update 0410 Italian translation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0g

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0g", #27-Dec-2016#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0g", "Accept GS1-128 calibration card");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0g", "Fix problem with calibration with bright images");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0g", "Fix symbology errors on tables 7.2, 7.3, and 7.4");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0g", "Improve system responsiveness during focus calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0g", "Avoid overflow error while minimized");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0g", "Avoid overly bright images when upgrading from older versions");
Update GS1Limits Set Symbology = "GS1 Data Matrix" Where SpecificationTable >= 7.2 And SpecificationTable <= 7.4;
Alter Table Calibration Alter Column Exposure Decimal(4,1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0h

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0h", #10-Jan-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0h", "Fix exposure decimal places");
Alter Table Calibration Alter Column Exposure Decimal(5,2);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0i

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0i", #13-Jan-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0i", "Remove logic to detect contrast label during calibration since it is unreliable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0i", "Fix bug related to blank passwords and ActiveDirectory");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0i", "Update Polish translation file");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.1.0j

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.1.0j", #23-Jan-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.1.0j", "Fix overly bright images when upgrading which only affects certain 9580s");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1001", #24-Jan-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Upgrade to Visual Studio 2015 runtime");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Use Inno Setup instead of InstallShield");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Use dfu-programmer instead of Atmel Flip");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Implement more sophisticated event handler");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Show HIBC structure if DPM and first character is a '+'");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Improve build info displayed when double-clicking version");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Drop support of Lumenera cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Support Taiwan languuage and character set");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1001", "Include changes from GS1 General Specifications V1.7");

Delete From StructureTags Where EmbeddedData = "<232>";
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<232>",  "FNC1", "");
Insert Into StructureTags (EmbeddedData, Description, TagValue) Values ("<FNC1>", "FNC1", "");

Flush;
Alter Table CalibrationSetup Add Column CameraModel Integer;
Update CalibrationSetup Set CameraModel = 9510 Where MegaPixels =  5.5;
Update CalibrationSetup Set CameraModel = 9570 Where MegaPixels =  3.6;
Update CalibrationSetup Set CameraModel = 9580 Where MegaPixels = -5.5;
Delete From CalibrationSetup Where MegaPixels = 1.3;
Delete From CalibrationSetup Where MegaPixels = 2.1;
Alter Table CalibrationSetup Drop Column MegaPixels;

Alter Table Calibration Drop Column AnalogGain;

Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("416",  0, "",      "GLN of the production or service location");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("416",  1, "K13",   "GLN of the production or service location");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("425" , 2, "N0-12", "ISO Country Code & Country");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7020", 0, "",      "Refurbishment lot ID");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7020", 1, "X1-20", "Refurbishment lot ID");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7021", 0, "",      "Functional status");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7021", 1, "X1-20", "Functional status");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7022", 0, "",      "Revision status");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7022", 1, "X1-20", "Revision status");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7023", 0, "",      "Global Individual Asset Identifier of an assembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7023", 1, "X1-30", "Global Individual Asset Identifier of an assembly");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8112", 0, "",      "Paperless coupon code North America");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8112", 1, "X1-70", "Paperless coupon code North America");

Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 6, 10, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 0,  6, 0.90, 0.90, 35, 30, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 1, 11);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 2, 11);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 3, 11);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 4, 11);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 7,  7);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 8,  7);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure) Values (9585, 3, 9,  4);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1002", #30-Jan-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1002", "Ignore auto-sector mode when sector is manually redrawn");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1003", #2-Feb-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1003", "Fix lockup during 9570 calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1003", "Fix bug when changing tabs while busy");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1003", "Show additional lighting information");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1003", "Detect and ignore images with USB drop outs");
Update CalibrationSetup Set SmallSharpen = 60 Where CameraModel = 9585 And SmallSharpen = 70;
Update CalibrationSetup Set LargeSharpen = 55 Where CameraModel = 9585 And LargeSharpen = 65;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1004", #3-Feb-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1004", "Fix import/export image");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1004", "Avoid error with Control Element 5 does not exist");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1005", #6-Feb-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1005", "Learn white balance before graph paper");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1005", "Require stable exposure on all lighting modes before beeping and processing");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1006", #7-Feb-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1006", "Tweak auto exposure algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1006", "Erase stored images when trigger pressed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1006", "Fix 2D analysis image shifting");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1007", #8-Feb-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1007", "Don't let default values override learned values during calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1008", #13-Feb-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1008", "Don't allow operator to calibrate on wrong symbol (without guard bars on either side)");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1008", "Implement new clock track tracking algorithm for DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1009", #3-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1009", "Don't redraw box when drawn manually");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1009", "Don't change lighting mode behind the scenes on calibraton tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1009", "Fix typo which showed 5.5 MP instead of 5 MP");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1009", "Implement new DPM camera logic");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1010

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1010", #4-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1010", "Allow clock track finder to require fewer dots");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1010", "Change clock track finder tolerance from 10% to 20%");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1011

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1011", #5-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1011", "If only one lighting mode, hunt using that mode only");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1011", "Require stable image before looking for clock track");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1011", "Require final stable image with no funny lines due to USB issues");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1012

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1012", #7-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1012", "Simultaneously grade DPM results while scanning lighting modes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1012", "Allow non-integral scaling of video image");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1013

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1013", #7-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1013", "Use 500ms timeout to confirm image is stable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1013", "Spend longer searching for clock track");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1013", "Restore lights when trigger released");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1014

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1014", #7-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1014", "Use more complex rules for 500ms timeout in hunt mode");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1015

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1015", #8-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1015", "Fix exposure stuck before finding clock track");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1015", "Require no less than 20% duty cycle on clock track for DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1016

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1016", #9-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1016", "Go back to full resolution hunt mode instead of binning mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1016", "Fix bug where changed DLL not detected by version checking");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1016", "Improve finding outline around clock track");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1016", "Reduce hunt timeout from 500ms to 200ms");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1017

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1017", #9-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1017", "Avoid error when DPM Data Matrix code is exceptionally tiny");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1017", "Don't change image size after end of DPM grading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1017", "Fix 2D analysis after DPM grading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1017", "Show message while waiting for trigger");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1018

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1018", #10-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1018", "Work harder to read small codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1018", "Show progress while holding trigger");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1019

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1019", #10-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1019", "Remove limit on number of clock track lines during fast detection");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1019", "Change messages during DPM operation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1020

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1020", #14-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1020", "Fix wrong vertical line color in DPM debug log");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1020", "Replace camera polling with an interrupt-driven system");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1021

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1021", #16-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1021", "Fix issues doing calibration simultaneously with image collection");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1021", "Add new DPM messages to translation files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1021", "Change stability rules so spurious USB drops don't cause issues");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1022

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1022", #21-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Fix leftover Stop statement from debugging");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Restart log at each trigger pull");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Increase padding area for quick clock track finder");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Try both blurred and unblurred images when quick searching for clock track");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Fix problem where calibration chose wrong exposure values");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Allow screen size change while focus indicator is running");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Restore yellow border on in-motion live view");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Changing scaling rules to eliminate crosshatching");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1022", "Change background color of [ Lighting options ] as a memory aid");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1023

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1023", #22-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1023", "Fix bug which caused exceptionally large zoomed image");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1024

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1024", #22-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1024", "Don't get stuck when cycling lights");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1024", "Don't clear image when switching tabs");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1024", "Avoid Error 10 by delaying keycode operations");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1024", "Avoid wrong Uncalibrated Image message");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1025

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1025", #23-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1025", "Avoid wrong Uncalibrated Image message again");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1025", "Don't show blurred image instead of actual image");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1025", "Include missing grades when DPM scanning");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1025", "Fix DPM unused error correction error");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1025", "Include reports with debug logging");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1026

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1026", #23-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1026", "Fix lockup during calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1027

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1027", #24-Mar-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1027", "Fix blurred image problem yet again");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1027", "Avoid error when switching to/from calibration with DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1027", "Get stitching to work using new design");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1028

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1028", #10-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1028", "Fix tolerance issue when grading DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1028", "Correct issue where date of calibration would vary slightly from log");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1028", "Automatically reorient DPM symbols to be close to a 90 degree angle");

Delete From CalibrationSetup Where CameraModel = 9585;
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 0,  6, 0.90, 0.90, 35, 30, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 1,  9, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 2, 11, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 3,  9, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 4, 11, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 6, 10, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 7,  7, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 8,  7, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 3, 9,  4, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);

Alter Table CalibrationHistory Drop Column Vavg;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1029

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1029", #11-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1029", "Fix issue where seting exposure gets out of sync");

Alter Table Calibration Drop Column CalibrationOk;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1030

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1030", #11-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1030", "Fix display issues with exposure and digital setings");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1030", "Don't search using red dome or white dome if not authorized");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1031

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1031", #12-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1031", "Add dilate algorithm to improve reading of DPM marks");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1031", "Fix timing issue which interfered with correct calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1032

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1032", #13-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1032", "Improve enclosing rectangle algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1032", "Improve DPM fast clock track thresholding algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1032", "Avoid leaving yellow border live image");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1032", "Cycle through both red and white dome during Admin calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1032", "Update background color of Lighting button in real time");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1033

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1033", #13-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1033", "Undo recent changes that created instability");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1033", "Create duplicate lighting button on grading tab");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1034

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1034", #14-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1034", "Implement DPM trigger via shift and control keys");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1034", "Disable automatic and manual modes for DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1034", "Change default lighting mode");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1035

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1035", #26-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1035", "If final UPC/EAN guard pattern is off, decode anyway to highlight problem");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1035", "Improve QRCode finder pattern locator speed and angle indifference");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1035", "Fix calibration to use white balance when learning lens correction");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1035", "Avoid incorrect uncalibrated image message");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1036

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1036", #26-Apr-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1036", "Reload camera calibration when changing application standards to/from DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1036", "Fix wrong release dates");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1036", "Fix manual exposure adjustment");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1036", "Avoid modal error from lighting form");

Update ReleaseVersions Set ReleaseDate = #10-Apr-2017# Where ReleaseDate = #10-Apr-2018#;
Update ReleaseVersions Set ReleaseDate = #11-Apr-2017# Where ReleaseDate = #11-Apr-2018#;
Update ReleaseVersions Set ReleaseDate = #12-Apr-2017# Where ReleaseDate = #12-Apr-2018#;
Update ReleaseVersions Set ReleaseDate = #13-Apr-2017# Where ReleaseDate = #13-Apr-2018#;
Update ReleaseVersions Set ReleaseDate = #14-Apr-2017# Where ReleaseDate = #14-Apr-2018#;
Update ReleaseVersions Set ReleaseDate = #26-Apr-2017# Where ReleaseDate = #26-Apr-2018#;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1037

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1037", #28-Apr-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1037", "Fix startup error 91");
Update CalibrationSetup Set SmallSharpen = 25 Where LightingMode = 0;
Update CalibrationSetup Set LargeSharpen = 20 Where LightingMode = 0;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1038

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1038", #28-Apr-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1038", "Fix problem where DPM would adjust exposure instead of trying again");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1038", "Prefer red dome light for non-DPM grading");
Update CalibrationSetup Set SmallSharpen = 50 Where LightingMode = 6 And CameraModel = 9585;
Update CalibrationSetup Set LargeSharpen = 45 Where LightingMode = 6 And CameraModel = 9585;
Update CalibrationSetup Set SmallSharpen = 50 Where LightingMode = 6 And CameraModel = 9580;
Update CalibrationSetup Set LargeSharpen = 45 Where LightingMode = 6 And CameraModel = 9580;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1039

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1039", #28-Apr-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1039", "Undo unreliable fix");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1040

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1040", #1-May-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1040", "Improve algorithm for finding rectangle surrounding a DPM Data Matrix code");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1040", "Display current lighting on calibration screen and on grading screen when applicable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1040", "Retain correct lighting configuration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1041

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1041", #3-May-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1041", "Swap 30 degree N/S and E/W to match unit");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1041", "Fix export image");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1041", "Allow graphics close to solid Data Matrix symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1041", "Complain if Mil-Std 130N size limits violated");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1041", "Reload lighting configuration on each trigger pull");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1042

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1042", #3-May-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1042", "Avoid Data Matrix threshold computation at wrong location");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1042", "Improve QRCode ability to read at any angle");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1043

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1043", #4-May-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1043", "Fix compatibility issue with 9570");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1043", "Fix PPN structure error");
Delete From DataIdentifiers Where DataIdentifier = "9N";
Delete From DataIdentifiers Where DataIdentifier = "1T";
Delete From DataIdentifiers Where DataIdentifier = "D";
Delete From DataIdentifiers Where DataIdentifier = "S";
Delete From DataIdentifiers Where DataIdentifier = "16D";
Delete From DataIdentifiers Where DataIdentifier = "8P";
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("9N",  "Pharmacy Product Number (PPN)",   36,  4, 22);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("1T",  "Batch number",                    38,  1, 20);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("D",   "Expiry date",                     10,  6,  6);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("S",   "Serial number",                   36,  1, 20);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("16D", "Date of manufacture",             10,  8,  8);
Insert Into DataIdentifiers (DataIdentifier, Description, PPNCharSet, MinSize, MaxSize) Values ("8P",  "Global Trade Item Number (GTIN)", 10, 14, 14);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1044

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1044", #9-May-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1044", "Rename PPN application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1044", 'Support 1.8" FOV');
Update ApplicationStandards Set LongName = "PPN-Code/NTIN - Germany" Where ShortName = "PPN";
Delete From ApplicationStandards Where ShortName = "GS1 NTIN";
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9580, 1.8, 0,  6, 0.90, 0.90, 35, 30, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9580, 1.8, 6, 10, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 0,  6, 0.90, 0.90, 35, 30, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 1,  9, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 2, 11, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 3,  9, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 4, 11, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 6, 10, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 7,  7, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 8,  7, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.8, 9,  4, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1045

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1045", #5-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1045", "Don't apply lens correction for wrong camera");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1045", "Fix incorrect uncalibrated image warning");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1045", "Change rules for waiting after exposure/lighting change");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1046

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1046", #6-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1046", "Fix display of last calibration date");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1046", "Don't show video when selecting camera");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1047

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1047", #8-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1047", "Undo combining of PPN and NTIN");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1047", "Fix error in PZN check digit calculation for 2D symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1047", "Ignore spaces in Windows MD5 hash");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1047", "Include trying QRCode for DPM");
Delete From ApplicationStandards Where ShortName = "GS1NTIN";
Delete From ApplicationStandards Where ShortName = "PPN";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("GS1NTIN", "GS1 NTIN", 1);
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("PPN",     "PPN-code", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1048

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1048", #9-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1048", "Improve reading of super tiny DPM Data Matrix codes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1049

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1049", #13-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1049", "Fix exposure when going from white light in calibration to red light in grading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1049", "Avoid freezing during DPM grading");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1050

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1050", #14-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1050", "Correct inability to update calibration screen");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1051

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1051", #14-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1051", "Avoid freezing issue when overexposed");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1052

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1052", #16-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1052", "Fix wrong message while stitching");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1052", "Automatically recover from USB dropouts");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.1053

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.1053", #20-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1053", "Improve recovery from USB dropouts");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1053", "Add logic to avoid freezing issue while zoomed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.1053", "Implement changes to defect measurement according to ISO/IEC 15416:2016(E)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3001", #26-Jun-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3001", "Finalize release");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3001", "Fix incorrect reporting of QRCode codeword counts");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3001", "Remove partial DPM QRCode functionality until it is complete");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3001", "Avoid error 9 when DPM symbol is slightly off center");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3002", #3-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3002", "Always show first decoded scan line as line 1 in dimensional analysis");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3002", "Copy recovery MDB to correct folder");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3002", "Improve lens correction calibration algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3002", "Don't include stale structure information in report of newer code");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3002", "Don't misidentify 9585 as 9580 on setup screen and reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3002", "Fix canceling calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3003", #6-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Undo changes which created calibration difficulties");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Change Inno installation to create link to automatically start program when Windows starts");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Fix calibration button label not getting updated");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Fix problem where certain MicroPDF codes did not read all lines properly");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Fix problem where calibration stopped before completion");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Include latest list of data identifiers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3003", "Fix show/hide calibration instructions button labeling");
Delete From DataIdentifiers Where DataIdentifier = "ACT ";
Delete From DataIdentifiers Where DataIdentifier = "ACO ";
Delete From DataIdentifiers Where DataIdentifier = "ACD ";
Delete From DataIdentifiers Where DataIdentifier = "ACR ";
Delete From DataIdentifiers Where DataIdentifier = "AIN ";
Delete From DataIdentifiers Where DataIdentifier = "TDN ";
Delete From DataIdentifiers Where DataIdentifier = "CAG ";
Delete From DataIdentifiers Where DataIdentifier = "CND ";
Delete From DataIdentifiers Where DataIdentifier = "CNT ";
Delete From DataIdentifiers Where DataIdentifier = "ESD ";
Delete From DataIdentifiers Where DataIdentifier = "LTN ";
Delete From DataIdentifiers Where DataIdentifier = "EXP ";
Delete From DataIdentifiers Where DataIdentifier = "EXP ";
Delete From DataIdentifiers Where DataIdentifier = "ECC ";
Delete From DataIdentifiers Where DataIdentifier = "ECI ";
Delete From DataIdentifiers Where DataIdentifier = "FAB ";
Delete From DataIdentifiers Where DataIdentifier = "FCL ";
Delete From DataIdentifiers Where DataIdentifier = "FHL ";
Delete From DataIdentifiers Where DataIdentifier = "HAZ ";
Delete From DataIdentifiers Where DataIdentifier = "HAZ ";
Delete From DataIdentifiers Where DataIdentifier = "IMD ";
Delete From DataIdentifiers Where DataIdentifier = "ICC ";
Delete From DataIdentifiers Where DataIdentifier = "LAC ";
Delete From DataIdentifiers Where DataIdentifier = "LOT ";
Delete From DataIdentifiers Where DataIdentifier = "MNC ";
Delete From DataIdentifiers Where DataIdentifier = "DMF ";
Delete From DataIdentifiers Where DataIdentifier = "STN ";
Delete From DataIdentifiers Where DataIdentifier = "NSN ";
Delete From DataIdentifiers Where DataIdentifier = "NHA ";
Delete From DataIdentifiers Where DataIdentifier = "PNO ";
Delete From DataIdentifiers Where DataIdentifier = "OHM ";
Delete From DataIdentifiers Where DataIdentifier = "OPN ";
Delete From DataIdentifiers Where DataIdentifier = "PDT ";
Delete From DataIdentifiers Where DataIdentifier = "PML ";
Delete From DataIdentifiers Where DataIdentifier = "REM ";
Delete From DataIdentifiers Where DataIdentifier = "RMT ";
Delete From DataIdentifiers Where DataIdentifier = "RTI ";
Delete From DataIdentifiers Where DataIdentifier = "RAP ";
Delete From DataIdentifiers Where DataIdentifier = "RMD ";
Delete From DataIdentifiers Where DataIdentifier = "SEQ ";
Delete From DataIdentifiers Where DataIdentifier = "SHT ";
Delete From DataIdentifiers Where DataIdentifier = "SWI ";
Delete From DataIdentifiers Where DataIdentifier = "SFT ";
Delete From DataIdentifiers Where DataIdentifier = "TIN ";
Delete From DataIdentifiers Where DataIdentifier = "UIC ";
Delete From DataIdentifiers Where DataIdentifier = "UNT ";
Delete From DataIdentifiers Where DataIdentifier = "UNT ";
Delete From DataIdentifiers Where DataIdentifier = "WDT ";
Delete From DataIdentifiers Where DataIdentifier = "WGT ";
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ACT ",  3,    3, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Action Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ACO ",  5,    5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Action Company");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ACD ",  8,   16, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Action Date");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ACR ",  1,   25, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Action Description");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("AIN ",  1,   10, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Aircraft Identification Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("TDN ",  1,   32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Certificate Tracking Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("CAG ",  5,    5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Commercial And Government Entity Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("CND ",  3,    3, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Condition Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("CNT ",  2,    2, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Country Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ESD ",  1,    1, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Electrostatic Sensitive Device Indicator");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("LTN ",  1,   15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Enterprise Lot Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("EXP ",  8,    8, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Expiration Date");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ECC ",  5,   14, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Export Control Classification Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ECI ",  3,    9, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Export Controlled Item");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("FAB ",  5,    5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Fabricator");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("FCL ",  1,    6, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Flight Cycles - Last Count");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("FHL ",  1,    6, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Flight Hours - Last Count");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("HAZ ",  6,    6, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Hazardous Material Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("IMD ",  1,   25, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Inspection Method Description");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("ICC ",  6,    6, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for International Commodity Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("LAC ",  1,   13, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Location on Aircraft");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("LOT ",  1,   15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Lot Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("MNC ",  3,    5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Maintenance Action Station Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("DMF ",  6,    8, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Manufacture Date");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("STN ",  1,   25, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Modification/STC Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("NSN ", 13,   13, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for NATO Stock Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("NHA ", -1,   -1, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Original Part Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("PNO ",  1,   15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Original Part Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("OHM ",  6,   20, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Overhaul Manual Reference Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("OPN ", 16,   32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Overlength Part Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("PDT ",  1,   32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Part Description");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("PML ",  1,   12, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Part Modification Level");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("REM ",  1, 5000, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Removal Reason Text");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("RMT ",  1,   30, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Removal Reason Text");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("RTI ",  1,   50, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Removal Tracking Identifier");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("RAP ",  1,   20, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Repair Approval Reference Text");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("RMD ",  1,   50, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Repair/Modification Description");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SEQ ",  1,   15, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Sequential Part Serial Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SHT ",  1,    5, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Ship-To Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SWI ",  1,    1, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Software Indicator");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("SFT ",  1,   32, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Software Part Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("TIN ", -1,   -1, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for UID Construct Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("UIC ",  1,    1, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for UID Construct Number");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("UNT ",  2,    2, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Unit of Measure Code");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("WDT ",  8,    8, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Warranty Date");
Insert Into DataIdentifiers (DataIdentifier, MinSize, MaxSize, DPMCharSet, Description) Values ("WGT ",  1,    6, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-", "TEI for Weight");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3004", #7-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3004", "Fix missing min/max ranges in newly added data identifiers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3004", "Fix problem where [Cancel] didn't work when logging on");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3004", "Fix error when printing from VbdView");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3004", "Turn off camera before importing images");
Update DataIdentifiers Set MinSize =   1 Where DataIdentifier = "NHA ";
Update DataIdentifiers Set MaxSize =  32 Where DataIdentifier = "NHA ";
Update DataIdentifiers Set MinSize =   1 Where DataIdentifier = "TIN ";
Update DataIdentifiers Set MaxSize = 124 Where DataIdentifier = "TIN ";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3005", #10-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3005", "Fix auto sector not handling composite codes well");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3005", "Fix issue with unreliable reading of certain MicroPDF lines");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3005", "Fix problem where switching cameras caused image to be lost");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3006", #20-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3006", "Allow calibration with 7.5 mil Code 39 calibration label");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3006", "Limit increase to digitial gain to avoid saturation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3006", "Fix spurious quiet zone errors");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3006", "Fix 9570 calibration aborting early");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3006", "Restore dome light when switching away from DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3006", "Fix blurry DPM picture on report");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3007", #20-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3007", "Placeholder for future changes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3008", #24-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3008", "Placeholder for future changes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3009", #24-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3009", "Update manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3009", "Avoid uncalibrated image message with DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3010

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3010", #25-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3010", "Avoid problem calibrating 6.25 FOV");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3011

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3011", #25-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3011", "Avoid additional issues calibrating 6.25 FOV");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3011", "Fix blurry DPM picture on report (different situation from previous fix)");
Update CalibrationSetup Set LargeSharpen = 60 Where FieldOfView = 6.25;
Update CalibrationSetup Set SmallSharpen = 70 Where FieldOfView = 6.25;
Update CalibrationSetup Set MatrixSize   =  9 Where FieldOfView = 6.25;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3012

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3012", #25-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3012", "Add more shortcuts when installing");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3013

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3013", #26-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3013", "Avoid error when releasing trigger early");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3013", "Restore missing FAQ files");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3014

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3014", #31-Jul-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3014", "Fix issue where quiet zone violations were missed");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3015

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3015", #9-Aug-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3015", "Fix spurious and incorrect quiet zone errors in a different way");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3015", "Increase maximum matrix size to 13x13");
Update CalibrationSetup Set FieldOfView = 1.85 Where FieldOfView = 1.8;
Update CalibrationSetup Set MatrixSize = 13 Where FieldOfView = 1.85;
Update CalibrationSetup Set SmallSharpen = 40 Where FieldOfView = 1.85;
Update CalibrationSetup Set LargeSharpen = 30 Where FieldOfView = 1.85;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3016

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3016", #23-Aug-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3016", "Update Japanese translation file");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3016", "Fix HIBC error when code switch occurs inside $$+7 format");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3016", 'Fix 40/50 sharpen settings for 6.25" FOV');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3016", 'Avoid too many dark pixels on 6.25" FOV');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3016", 'Fix error 380 when LvsUsers has only one operator');
Update CalibrationSetup Set LargeSharpen = 50 Where FieldOfView = 6.25;
Update CalibrationSetup Set SmallSharpen = 40 Where FieldOfView = 6.25;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3017

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3017", #31-Aug-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3017", "Undo fix spurious and incorrect quiet zone errors in a different way");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3017", "Undo increase maximum matrix size to 13x13");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3017", 'Change default settings for 6.25" field of view');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3017", "Fix 2D analysis when quiet zones go beyond image");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3017", "Try more possible exposures in DPM mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3017", "Don't waste time on hopelessly over or underexposed images");
Update CalibrationSetup Set SmallXdim            = 13   Where FieldOfView = 6.25;
Update CalibrationSetup Set LargeXdim            = 20   Where FieldOfView = 6.25;
Update CalibrationSetup Set SmallSharpen         = 50   Where FieldOfView = 6.25;
Update CalibrationSetup Set LargeSharpen         = 50   Where FieldOfView = 6.25;
Update CalibrationSetup Set SmallApertureScaling =  0.5 Where FieldOfView = 6.25;
Update CalibrationSetup Set LargeApertureScaling =  1.0 Where FieldOfView = 6.25;
Update CalibrationSetup Set MatrixSize           =  9   Where FieldOfView = 6.25;
Delete From CalibrationSetup Where FieldOfView = 1.85;
Update CalibrationSetup Set SmallSharpen = 70 Where LightingMode = 6 And CameraModel = 9580;
Update CalibrationSetup Set LargeSharpen = 65 Where LightingMode = 6 And CameraModel = 9580;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3018

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3018", #5-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3018", "Verify changes for 3017 implemented and logged correctly");
Update CalibrationSetup Set SmallSharpen = 45 Where FieldOfView = 6.25;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3019

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3019", #8-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3019", "Implement ability to read QR Codes under DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3020

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3020", #11-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3020", "Change DPM operation to operate without zooming");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.0.3021

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.0.3021", #16-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3021", "Implement more sophisticated exposure finding algorithm for DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3021", "Automatically detect and draw blue sector box around symbol in DPM mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3021", "Delay DPM decoding until exposure is within range according to ISO/IEC TR29158");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.0.3021", "Fix occasional no read of valid CC-A code");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3001", #20-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3001", "Add in-progress indicator for DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3001", "Honor > 1X flag for DPM QR Codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3001", "Avoid screen flash after trigger release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3002", #21-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3002", "Redraw screen properly after trigger release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3003", #27-Sep-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3003", "Allow non-integral aperture sizes for tiny DPM codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3003", "Fix 2D analysis to properly show wrong side of global threshold in yellow");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3003", "Ignore trigger pull unless on grading tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3003", "Remember zoom check box setting");
Insert Into Settings (Category, SettingName, SettingValue) Values ("DPM", "VividDisplay", "0");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3004", #4-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3004", "Fix Xdim oscillations which cause some CCA labels to never finish grading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3004", "Complain about missing FNC1s on variable length AIs");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3004", "Fix problem with only one ActiveDirectory user");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3004", "Fix auto-sector sometimes not allowing manual redraw");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3004", "TTP 16306: Gracefully detect and complain about non-numeric camera serial numbers");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3005", #5-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3005", "TTP 16307: Remove obsolete FAQ files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3005", "TTP 16308 and 16309: Disallow Auto-Sector for 9570s");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3006", #5-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3006", "Fix issue with 9570 calibration not working after initial calibration");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.2.1.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.2.1.3007", #12-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.2.1.3007", "Update manuals");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.1001", #18-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1001", "Implement ISO/IEC 15416:2016(E)interpolation rules");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1001", "Enforce compliance with Data Matrix pseudo-random padding");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1001", "Report contrast uniformity for Data Matrix");
Update Settings Set SettingValue = "2" Where SettingName = "DecimalGrading" And SettingValue = "1";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.1002", #18-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1002", "Fix color coding error");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.1003", #19-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1003", "Add extra space between numeric grade and percentage");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1003", "Correct 15416:2016(E) rules for cases < 1.0");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1003", "Update glossary with new ranges");

Update Glossary
    Set Description = "70%->4.0 60%->3.0 50%->2.0 40%->1.0^This is ratio of the minimum edge contrast to the symbol contrast."
    Where Entry = "1D Modulation";
Update Glossary
    Set Description = "6%->4.0 8%->3.0 10%->2.0 12%->1.0^This measures how the X-axis grid is different from the Y-axis grid."
    Where Entry = "Axial nonuniformity";
Update Glossary
    Set Description = "10%->4.0 30%->3.0 50%->2.0 70%->1.0^A blemish is an unwanted mark or void that causes any part of a barcode symbol to not be decodable."
    Where Entry = "Blemish";    
Update Glossary
    Set Description = "70%->4.0 55%->3.0 40%->2.0 20%->1.0^This is the difference between the highest and the lowest reflectance Values found within a barcode symbol."
    Where Entry = "Contrast";
Update Glossary
    Set Description = "62%->4.0 50%->3.0 37%->2.0 25%->1.0^This is a measurement of printing accuracy.  Software measures the difference between a perfect barcode image and the actual image.  This is a measurement of time."
    Where Entry = "Decodability";
Update Glossary
    Set Description = "15%->4.0 20%->3.0 25%->2.0 30%->1.0^Defects are a measurement of deviation in contrast found within a bar / space element.  In order to detect a defect error, the barcode symbol must be decodable."
    Where Entry = "Defects";
Update Glossary
    Set Description = "63%->4.0 50%->3.0 38%->2.0 25%->1.0^This is the largest distance between the actual center of a module and the ideal center of a module."
    Where Entry = "Grid nonuniformity"; 

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.1004", #19-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1004", "Fix contrast uniformity to not be confused by cells on the wrong side of the global threshold");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.1004", "Fix HTML processing to honor strings of multiple consecutive spaces");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.3001", #20-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3001", "Update key on SRP tab");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3001", "Fix blemish and error percentage color coding");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3001", "Include decimal for Rmin, Rmax, and GT");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3001", "Update UPC/EAN guard bar decodability rules to match 15420 exactly");
Update Glossary
    Set Description = "4.0>=70% 3.0>=60% 2.0>=50% 1.0>=40% 0.0<40%^This is ratio of the minimum edge contrast to the symbol contrast."
    Where Entry = "1D Modulation";
Update Glossary
    Set Description = "4.0<=6% 3.0<=8% 2.0<=10% 1.0<=12% 0.0>12%^This measures how the X-axis grid is different from the Y-axis grid."
    Where Entry = "Axial nonuniformity";
Update Glossary
    Set Description = "4.0<=20% 3.0<=40% 2.0<=60% 1.0<=80% 0.0>80%^A blemish is an unwanted mark or void that causes any part of a barcode symbol to not be decodable."
    Where Entry = "Blemish";  
Update Glossary
    Set Description = "4.0>=70% 3.0>=55% 2.0>=40% 1.0>=20% 0.0<20%^This is the difference between the highest and the lowest reflectance Values found within a barcode symbol."
    Where Entry = "Contrast";
Update Glossary
    Set Description = "4.0>=62% 3.0>=50% 2.0>=37% 1.0>=25% 0.0<25%^This is a measurement of printing accuracy.  Software measures the difference between a perfect barcode image and the actual image.  This is a measurement of time."
    Where Entry = "Decodability";
Update Glossary
    Set Description = "4.0<=15% 3.0<=20% 2.0<=25% 1.0<=30% 0.0>30%^Defects are a measurement of deviation in contrast found within a bar / space element.  In order to detect a defect error, the barcode symbol must be decodable."
    Where Entry = "Defects";
Update Glossary
    Set Description = "4.0>=63% 3.0>=50% 2.0>=38% 1.0>=25% 0.0<25%^This is the largest distance between the actual center of a module and the ideal center of a module."
    Where Entry = "Grid nonuniformity"; 

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.3002", #24-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Fix color coding and key on 2D analysis report");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Fix OCR matching causing Processing to get stuck");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Fix 9570 calibration lost when making a longer scan");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Redo report after 9570 scan");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Change text of error message for FTDI com port trouble");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Avoid Error 10: This array is fixed or temporarily locked");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Update sector colors after each grading attempt for multi-sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3002", "Avoid error messages on SRP tab when clicking off symbol");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.3003", #30-Oct-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3003", "Restore 9570 overspeed warning");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3003", "Extend maximum length of AIs 91 through 99 to be 90 characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3003", "Remember automatic program start when upgrading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3003", "Fix typo in glossary for grid nonuniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3003", "Update manuals");
Update ApplicationIdentifiers Set Format = "X1-90" Where ApplicationIdentifier >= "91" And ApplicationIdentifier <= "99" And Element = 1;
Update Glossary
    Set Description = "4.0<=38% 3.0<=50% 2.0<=63% 1.0<=75% 0.0>75%^This is the largest distance between the actual center of a module and the ideal center of a module."
    Where Entry = "Grid nonuniformity"; 

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.3004", #2-Nov-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3004", "Update manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3004", "Fix artifacts when drawing OCR sector during auto-sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3004", "Fix problem which allowed factory calibration by customer");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3004", "Fix color coding and key on 2D analysis report");
Update Glossary
    Set Description = "4.0>=50% 3.0>=40% 2.0>=30% 1.0>=20% 0.0<20%^Modulation measures the uniformity of reflectance of the dark and light modules."
    Where Entry = "2D Modulation"; 

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.3005", #2-Nov-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3005", "Update manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3005", "Fix problem where calibration stopped prematurely");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.0.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.0.3006", #8-Nov-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3006", "Update manuals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3006", "Allow user to change decimal grading back to 2");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.0.3006", "Don't override user lighting choice");
Update AllowedUserChanges Set MaxValue = 2 Where SettingName = "DecimalGrading";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1001", #28-Nov-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Improve non-integral aperture sizes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Alternate blurring and not blurring in DPM mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Don't waste time building DPM debug images unless debug enabled");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Speed up processing of extra large DPM symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Fine tune Data Matrix line detection");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Improve 2D synthetic aperture algorithm");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Report contrast uniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Remove multi-rotation capability");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Remove obsolete logic to handle internal vs. external cameras");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Copy GS1 2D Report.doc on startup");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Support DataBar calibration card");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1001", "Support calibration cards with Code128 markers");
Delete From ApplicationStandards Where ShortName = "MultiDataMatrix";
Delete From ApplicationStandards Where ShortName = "MultiQRCode";
Delete From Settings Where SettingName = "InternalSN";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1002", #4-Dec-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1002", "Use dynamic GT algorithm to better find Data Matrix codes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1003", #26-Dec-2017#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1003", "Add new standards for non-DPM versions of Mil-130");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1003", "Include QR Code for DPM application standards");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1003", "Fix problem with 2D analysis overlay either missing or offset");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1003", "Fix errors in UEC calculation for Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1003", "Implement new calibration methodology for 9585-HD");
Update ApplicationStandards Set ShortName = "MIL"          Where ShortName = "Mil1D";
Update ApplicationStandards Set LongName  = "MIL-STD-130N" Where ShortName = "MIL";
Update ApplicationStandards Set ShortName = "DPM+MIL"      Where ShortName = "TEI";
Update ApplicationStandards Set ShortName = "DPM+UII"      Where ShortName = "UII";
Insert Into ApplicationStandards (LongName, ShortName, Status) Values ("MIL-STD-130N + UII", "MIL+UII", 1);
Update ApplicationStandards Set LongName = "DPM + MIL-STD-130N + UII" Where LongName = "DPM + UII + MIL-STD-130N";
Update Glossary Set Description = "This is the amount of Unused Error Correction in %.  100% means no error correction was used.  This number is determined from the formula:^UEC = 100 - 100 * Corrections / MaxCorrections^^MaxCorrections is (Total CW - Data CW) / 2 rounded down." Where Entry = "Unused EC";
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.3, 6, 3, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9585, 1.3, 0, 3, 0.95, 1.00, 70, 65, 6.0, 13.0, 9);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1004", #7-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1004", "Improve DPM for Data Matrix and QR Code");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1004", "Improve 2D focus");
Update CalibrationSetup Set Exposure = 5 Where FieldOfView = 1.3;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1005", #23-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1005", "Update Imaging Source driver");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1005", "Allow 9510 factory calibration via phone support");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1005", "Include Symbol Grade Letter on report");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1005", "Fine tune Data Matrix implementation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1005", "Fine tune DPM implementation");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1006", #24-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1006", "Avoid blacked-out picture in report for DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1007", #30-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1007", "Ease vibration rules to allow calibration on certain HD units");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1007", "Don't misreport DPM lighting mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1007", "Avoid lockup with screen showing Please wait");
Update CalibrationSetup Set Exposure = 10 Where FieldOfView = 1.3;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.3.1.1008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.3.1.1008", #31-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1008", "Avoid processing forever on certain stacked codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.3.1.1008", "Fix automatic grading mode on 9580/9585s");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1000

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1000", #31-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1000", "Update version number to 4.4 because of new hardware support");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1001", #31-Jan-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1001", "Avoid unnecessary 2D calibration failure");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1002", #3-Feb-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1002", "Avoid bug reporting non-existent Maxicodes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1002", "Add new AIs (714 and 8013) for Gen Spec 18");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1002", "Update max Xdim for Table 6 GS1 Data Matrix (per Gen Spec 18)");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1002", "Fix model number on NIST label generation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1002", "Fix image being displayed on tabs without image display");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1002", "Disable Ctrl-O key sequence");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("714" , 0, ""      , "National Healthcare Reimbursement Number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("714" , 1, "X1-20" , "Portugal National Code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8013", 0, ""     , "Global Model Number (GMN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8013", 1, "X1-30", "Model reference");
Update GS1Limits Set MaxXdim = 0.990 Where SpecificationTable = 6 And Symbology = "GS1 Data Matrix";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1003", #7-Feb-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1003", "Fix model number on NIST label generation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1003", "Fix conflict with automatic mode and cameras with triggers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1003", "Enhance DPM debug logging");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1003", "Fix issue with calibration under MySQL (fixed earlier but not included in this list)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1004", #12-Feb-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Fix issues with 9510s and factory calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Fix issue where Xdim was color-coded by mistake");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Allow either <GS> or <232> as separators in GS1 Data Matrix codes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Update translation files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Fix calibration focus indicator to match prior values");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Generate warning if attempt to calibrate with no camera selected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Use more robust algorithm to find Data Matrix clock track");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1004", "Restore default FOV when calibrating new camera");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1005", #19-Feb-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1005", "Fix issue where auto sector stopped working after manually drawing a sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1005", "Fix issue related to lens correction calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1005", "Improve dome light correlation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1005", "Change wording on new password mismatch");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1005", "Don't complain if lens calibration achieves 0% error");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1005", "Fix CCA symbol not reading due to ambiguity with ITF");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1006", #21-Feb-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Include Omron in system name");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Restore ability for 9570s to use automatic sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Fail Code 39 symbol if narrow wide ratio is outside of range 1.8 to 3.4");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Fix issue with 9510 where auto-sector was ignored until restart");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Generate error message if DPM attempted on non-live image");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Resolve Run Time error when connecting to an existing MS SQL database");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Changed Active Directory: configuration error message to indicate AD connection failed and is not functional until all errors are resolved");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1006", "Allow Code39 for AIAG");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1007", #7-Mar-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Correct issue which prevented ITF symbols from being detected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Change FPMAJ rule to require 95% of the minimum height in order to be compatible with GS1");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Avoid error 5 when right-clicking SRP print button");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Generate warning for extraneous FNC1");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Restore ability for 9570s to use automatic sector");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Grade start and stop characters for PDF-417");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Correct issue with grid non-uniformity detection");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1007", "Remove incorrect trailing <FNC1> from CCA structure");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1008", #14-Mar-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1008", "Fix issue where certain rows of a CCA code would not read reliably");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1008", "Fix issue where Data Matrix trapezoidal correction did not match 16022");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1008", "Update manuals");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.1009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.1009", #14-Mar-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1009", "Fix GNU issue related to trapezoidal change");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.1009", "Make vivid display feature less vivid");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3001", #21-Mar-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3001", "Make release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3002", #23-Mar-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3002", "Update Atmel drivers to 1.2.6");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3002", "Fix issue with Ctrl + Shift trigger timeout");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3002", "Remove problematic translation file 040B.dat");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3002", "Attempt to mitigate issues with serial number zero");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3003", #3-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Fix bug in trapezoidal correction logic which would occasionally cause a crash");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Recompute Data Matrix error correction codewords when correcting pseudo-random padding errors");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Improve logic for for non-breakable spaces in HTML reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Show (9585HD) if camera model is 9585HD");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Check HIBC dates for validity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Enable pulldown for FPMAJ so height warnings can be made optional");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Correct 9585 HD dome light correlation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Allow 9585 HD white balance calibration without factory override");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3003", "Update manuals");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3004", #16-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3004", "Fix incorrect Extraneous FNC1 warning");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3004", "Add new AI 22");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3004", "Change report label from GS1 Pass/Fail to be GS1 Data Structure Pass/Fail");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3004", "Change Symbol ANSI X3.182 Letter Grade scaling");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3004", "Fix 9585-HD calibration issue");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("22"  , 0, ""      , "Consumer product variant (CPV)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("22"  , 1, "X1-20" , "Consumer product variant (CPV)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3005", #17-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3005", "Fix issue with AI calibration card");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3006", #20-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3006", "Show (9580HD) on setup screen if applicable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3006", "Fix incorrect Invalid AI warning shown after <GS>");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3006", 'Solve issue with synthetic aperture aligning with 6 mil aperture on 1.3" FOV');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3007", #20-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3007", 'Fix dome light correction for 1.3" FOV');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3008", #27-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3008", "Fix problem displaying (9580HD) when applicable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3008", "Record minimum passing grade when pass/fail option used");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3008", "Add word break option to avoid truncated display of decoded text");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3008", "Fix signing conflict with new Atmel 1.2.6 driver");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.3009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.3009", #30-Apr-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3009", 'Correct 1.3" FOV calibration issue');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3009", 'Show correct mils on calibrate screen for 1.3" FOV');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.3009", "Add dynamic baud rate adjustment for 9570 units");
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.4101

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.4101", #17-May-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4101", "Fix regional setting conflict with SQL");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4101", "Update Propeller software to support 7.5 MHz crystals");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4101", "Include missing FAQ files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4101", "Fix translation error in French translation file");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4101", "Correct issue which displayed GS11 instead of GS1 when translated");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.4102

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.4102", #18-May-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4102", "Improve ability to communicate with and upgrade older 9570s");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.4103

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.4103", #25-May-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4103", "Fix communications issue with 9580s");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.4104

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.4104", #29-May-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4104", "Fix type mismatch error during calibration when goals don't match regional settings");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.4105

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.4105", #30-May-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4105", "Increase camera watchdog timeout to avoid unnecessary camera reset");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.4106

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.4106", #27-Jun-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.4106", "Update Japanese translation file");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.0.5101

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.0.5101", #27-Jun-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.0.5101", "Update data identifier database to avoid incorrect structure errors");

Delete From DataIdentifiers Where DataIdentifier = "A";

Update DataIdentifiers Set Description = "Container Type (internally assigned or mutually defined)" Where DataIdentifier = "B";
Update DataIdentifiers Set Description = "Container Type as defined in ISO 6346" Where DataIdentifier = "9B";

Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14B", "Tag Status");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15B", "Dangerous Cargo Class");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16B", "UN Code for Dangerous Goods");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17B", "Name Of Transportation Subject");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18B", "Vessel Registration Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19B", "Voyage number/Trip number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20B", "Vessel Country");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21B", "Reserved for Electronic Seal Numbers");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22B", "Entry Number/Type");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23B", "Surety Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24B", "Foreign Port of Lading");
Update DataIdentifiers Set Description = "Identification of a Party to a Transaction" Where DataIdentifier = "25B";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26B", "Unique Returnable Transport Item Identifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27B", "Globally Unique Asset Identifier of a Large Load Carrier (LLC)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("28B", "Globally Unique Asset Identifier of a Small Load Carrier (SLC)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("29B", "Globally Unique Returnable Packaging Item (RPI) identifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30B", "Packaging Item Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31B", "Global Unique Packaging Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("55B", "Global Unique Returnable Packaging Item (RPI)");

Update DataIdentifiers Set Description = "Continuation of an Item Code" Where DataIdentifier = "C";

Update DataIdentifiers Set Description = "Format YYMMDD" Where DataIdentifier = "D";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "1D", "Format DDMMYY");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2D", "Format MMDDYY");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3D", "Format YDDD (Julian)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4D", "Format YYDDD (Julian)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7D", "Format MMYY Note 2");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8D", "Event, Date, And Time ISO format YYYYMMDDHHMM");
Update DataIdentifiers Set Description = "Date (structure and significance mutually defined)" Where DataIdentifier = "9D";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("10D", "Format YYWW");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11D", "Format YYYYWW");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12D", "Format YYYYMMDD");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13D", "Oldest and Newest Manufacturing Date in the format YYWWYYWW");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14D", "Expiration Date (YYYYMMDD) EXP DATE Expiration Date (YYYYMMDD)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15D", "Expiration Date (DDMMYYYY)");
Update DataIdentifiers Set Description = "Production Date (YYYYMMDD) - Date of manufacture" Where DataIdentifier = "16D";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17D", "Production Date (DDMMYYYY)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("18D", "Tag Activation Time YYYYMMDDHHMM");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("19D", "Tag Deactivation Time YYYYMMDDHHMM");
Update DataIdentifiers Set Description = "Inspection Date (DDMMYYYY)" Where DataIdentifier = "20D";
Update DataIdentifiers Set Description = "Required Delivery Date (DDD Julian) or DOD MILSTAMP Code" Where DataIdentifier = "21D";
Update DataIdentifiers Set Description = "Record Time YYYYMMDDHHMM" Where DataIdentifier = "22D";
Update DataIdentifiers Set Description = "Date, represented in modified UTC compliant form" Where DataIdentifier = "23D";
Update DataIdentifiers Set Description = "Qualified Date" Where DataIdentifier = "24D";

Update DataIdentifiers Set Description = "Air Pressure - (altitude)" Where DataIdentifier = "1E";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2E", "Maximum Allowed Temperature");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "3E", "Minimum Allowed Temperature");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "4E", "Maximum Allowed Relative Humidity");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "5E", "Minimum Allowed Relative Humidity");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6E", "Refrigerator Container Temperature");
Update DataIdentifiers Set Description = "Time Temperature Index" Where DataIdentifier = "11E";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12E", "Declaration of Packaging Material Category, Code and Weight");

Update DataIdentifiers Set Description = "Looping Header" Where DataIdentifier = "F";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("4F", "Logical Assignment of a Page of Information");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("5F", "I have ______ children and they are ...");

Delete From DataIdentifiers Where DataIdentifier = "G";

Delete From DataIdentifiers Where DataIdentifier = "H";

Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "2H", "U.S. Social Security Number");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "6H", "Party Name (Line 2)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "7H", "Contact Phone");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "8H", "Contact Email");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ( "9H", "Consignee Number");
Update DataIdentifiers Set Description = "Personal Identification Code" Where DataIdentifier = "10H";
Update DataIdentifiers Set Description = "First Name and Middle Initial" Where DataIdentifier = "11H";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12H", "Military Grade (E1-E9, W1-W5, and O1-O10)");

Delete From DataIdentifiers Where DataIdentifier = "3I";

Update DataIdentifiers Set Description = "Unique license plate number" Where DataIdentifier = "J";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("1J", "Unique license plate number assigned to a transport unit");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("2J", "Unique license plate number assigned to a transport unit");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("3J", "Unique license plate number assigned to a transport unit");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("4J", "Unique license plate number assigned to a transport unit");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("5J", "Unique license plate number assigned to a mixed transport unit");

Update DataIdentifiers Set Description = "Order number assigned by Customer to identify a Purchasing Transaction" Where DataIdentifier = "K";
Update DataIdentifiers Set Description = "Carrier Mode in Free Text format mutually defined between Customer and Supplier" Where DataIdentifier = "7K";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13K", "Bill of Lading Number / Transport Receipt Number");
Update DataIdentifiers Set Description = "Customer data, being data that from a customer perspective" Where DataIdentifier = "21K";
Update DataIdentifiers Set Description = "Global unique identification of groupings of transport units assigned by the carrier" Where DataIdentifier = "25K";
Update DataIdentifiers Set Description = "Global unique identification of groupings of transport units assigned by the shipper" Where DataIdentifier = "26K";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27K", "Supplier Assigned Quotation Number");

Update DataIdentifiers Set Description = "Storage Location" Where DataIdentifier = "L";
Update DataIdentifiers Set Description = "'Ship To:'" Where DataIdentifier = "2L";
Update DataIdentifiers Set Description = "'Ship From:'" Where DataIdentifier = "3L";
Update DataIdentifiers Set Description = "Country of Origin, two-character ISO 3166 country code" Where DataIdentifier = "4L";
Update DataIdentifiers Set Description = "'Ship For:'" Where DataIdentifier = "5L";
Update DataIdentifiers Set Description = "Port of Embarkation" Where DataIdentifier = "8L";
Update DataIdentifiers Set Description = "Port of Debarkation" Where DataIdentifier = "9L";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11L", "Location (Latitude/Longitude/Altitude)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("12L", "Ship To: Location (Latitude/Longitude/Altitude)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13L", "Ship From: Location (Latitude/Longitude/Altitude)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("15L", "Ship For: Location (Latitude/Longitude/Altitude)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("16L", "Tag Activation Location");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("17L", "Tag Deactivation Location");
Update DataIdentifiers Set Description = "First Level (internally assigned)" Where DataIdentifier = "20L";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25L", "Identification of a party to a transaction");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27L", "Event Location UN/LOCODE");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("28L", "Number and Street Address");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("29L", "City Name");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30L", "Country Sub-entity Details");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31L", "Postal Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("32L", "Country Code");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("33L", "Uniform Resource Locator (URL)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("34L", "Pointer to Process URL (P2P URL)");

Delete From DataIdentifiers Where DataIdentifier = "M";
Update DataIdentifiers Set Description = "National/NATO Stock Number (NSN)" Where DataIdentifier = "N";
Update DataIdentifiers Set Description = "Coding Structure and Formats in Accordance with GS1 Application Identifiers" Where DataIdentifier = "4N";
Update DataIdentifiers Set Description = "Coding Structure and Formats in Accordance with AIAG Recommendations" Where DataIdentifier = "5N";
Update DataIdentifiers Set Description = "U.S. DOD Requisition and Issue Procedure Codes" Where DataIdentifier = "6N";
Update DataIdentifiers Set Description = "U.S. Defense Transportation Regulation codes" Where DataIdentifier = "7N";
Update DataIdentifiers Set Description = "Production animal identification codes" Where DataIdentifier = "8N";
Update DataIdentifiers Set Description = "Pharmacy Product Number (PPN)" Where DataIdentifier = "9N";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11N", "The Data construct is defined and controlled by the RLA");
Delete From DataIdentifiers Where DataIdentifier = "O";
Update DataIdentifiers Set Description = "Item Identification Code assigned by Customer" Where DataIdentifier = "P";
Update DataIdentifiers Set Description = "Code assigned to specify the revision level for an Item" Where DataIdentifier = "2P";
Update DataIdentifiers Set Description = "Freight Classification Item Number assigned by Carrier for purposes of rating hazardous materials" Where DataIdentifier = "5P";
Update DataIdentifiers Set Description = "Global Trade Item Number (GTIN)" Where DataIdentifier = "8P";
Update DataIdentifiers Set Description = "Combined manufacturer identification code (9-digit DUNS number assigned by Dun & Bradstreet) and the item code/part number" Where DataIdentifier = "9P";
Update DataIdentifiers Set Description = "Hazardous Material Code" Where DataIdentifier = "10P";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("11P", "10-character CLEI Code for telecommunications equipment");
Update DataIdentifiers Set Description = "Document Type" Where DataIdentifier = "12P";
Update DataIdentifiers Set Description = "Component of an Item (One product contained in multiple packages)" Where DataIdentifier = "19P";
Update DataIdentifiers Set Description = "Identification of a party to a transaction as identified in 18V, followed by the supplier assigned part number" Where DataIdentifier = "25P";
Update DataIdentifiers Set Description = "A code assigned by a customer to the identification number of the manufacturer's Material Safety Data Sheet (MSDS) document" Where DataIdentifier = "40P";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("49P", "Export Controlled Item");
Update DataIdentifiers Set Description = "Manufacturer-assigned item identifier" Where DataIdentifier = "50P";
Update DataIdentifiers Set Description = "Globally unique item identifier" Where DataIdentifier = "51P";

Update DataIdentifiers Set Description = "Quantity, Number of Pieces, or Amount" Where DataIdentifier = "Q";
Update DataIdentifiers Set Description = "Theoretical Length/Weight" Where DataIdentifier = "1Q";
Update DataIdentifiers Set Description = "Actual Weight" Where DataIdentifier = "2Q";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("3Q", "Unit of Measure");
Update DataIdentifiers Set Description = "Where multiple containers comprise a single product" Where DataIdentifier = "6Q";
Update DataIdentifiers Set Description = "Quantity, Amount, or Number of Pieces" Where DataIdentifier = "7Q";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("8Q", "Container Rated Weight");
Update DataIdentifiers Set Description = "Monetary Value established by the Supplier" Where DataIdentifier = "12Q";
Update DataIdentifiers Set Description = "# of # ('this is the nth piece of x pieces in this shipment')" Where DataIdentifier = "13Q";
Update DataIdentifiers Set Description = "Cube expressed in cubic meters or cubic feet" Where DataIdentifier = "18Q";
Update DataIdentifiers Set Description = "Width expressed in linear meters or linear feet" Where DataIdentifier = "19Q";
Update DataIdentifiers Set Description = "Height expressed in linear meters or linear feet" Where DataIdentifier = "20Q";
Update DataIdentifiers Set Description = "Length expressed in linear meters or linear feet" Where DataIdentifier = "21Q";
Update DataIdentifiers Set Description = "Net weight of shipment expressed in pounds or kilograms (kilos)" Where DataIdentifier = "22Q";
Update DataIdentifiers Set Description = "Van length expressed in linear meters or linear feet" Where DataIdentifier = "23Q";
Update DataIdentifiers Set Description = "Inside cube of a van expressed in cubic meters or cubic feet" Where DataIdentifier = "24Q";
Update DataIdentifiers Set Description = "Net explosive weight (a computed value of explosive equivalent expressed in pound of TNT)" Where DataIdentifier = "25Q";
Update DataIdentifiers Set Description = "Packaging Level" Where DataIdentifier = "26Q";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27Q", "Single Product Price Value");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("28Q", "Single Price Charge Value For Postage And Packaging");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("29Q", "Discount Percentage");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30Q", "VAT Percentage");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31Q", "Currency, ISO 4217 currency code");

Delete From DataIdentifiers Where DataIdentifier = "R";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("4R", "U.S. Department of Defense Identification Code (DoDIC)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("5R", "Data in the format and using semantics defined by the holder");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("6R", "ISO/IEC 20248 digital signature data construct");
Update DataIdentifiers Set Description = "Traceability Number for an Entity" Where DataIdentifier = "S";
Update DataIdentifiers Set Description = "Additional code assigned by the Supplier to an entity for its lifetime" Where DataIdentifier = "1S";
Update DataIdentifiers Set Description = "Unique Package Identification assigned by Supplier" Where DataIdentifier = "3S";
Update DataIdentifiers Set Description = "Package Identification assigned by Supplier to master packaging containing like items on a single customer order" Where DataIdentifier = "4S";
Update DataIdentifiers Set Description = "Package Identification assigned by Supplier to master packaging containing unlike items on a single customer order" Where DataIdentifier = "5S";
Update DataIdentifiers Set Description = "Package Identification assigned by Supplier to master packaging containing like items over multiple customer orders" Where DataIdentifier = "6S";
Update DataIdentifiers Set Description = "Package Identification assigned by Supplier to master packaging containing unlike items over multiple customer orders" Where DataIdentifier = "7S";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("8S", "Supplier ID/Unique Container ID presented in the data format");
Update DataIdentifiers Set Description = "Serial Number Assigned by the Vendor Entity" Where DataIdentifier = "15S";
Update DataIdentifiers Set Description = "Version Number" Where DataIdentifier = "16S";
Update DataIdentifiers Set Description = "CAGE Code & Serial Number unique within CAGE American National Standard" Where DataIdentifier = "18S";
Update DataIdentifiers Set Description = "Combined Dun & Bradstreet company identification of the supplier" Where DataIdentifier = "19S";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23S", "Media Access Control (MAC) Address conforming with IEEE 802.11");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24S", "According to ISO/IEC 15963 (value is a conversion of its bit value to 8-bit ASCII values)");
Update DataIdentifiers Set Description = "Identification of a party to a transaction" Where DataIdentifier = "25S";
Update DataIdentifiers Set Description = "Additional traceability code for an entity" Where DataIdentifier = "30S";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("37S", "Unique Item Identifier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("42S", "Unique Item Identifier (UII) in 25S format");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("43S", "Integrated Circuit Card Identifier (ICCID)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("50S", "First Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("51S", "Second Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("52S", "Third Level (Supplier Assigned)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("53S", "Fourth Level (Supplier Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("54S", "Fifth Level (Supplier Assigned");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("96S", "96-bit EPC data structure (EPCglobal)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("97S", "Encrypted serial number assigned by the Supplier to an entity, which");

Update DataIdentifiers Set Description = "Traceability Number assigned by the Customer" Where DataIdentifier = "T";
Update DataIdentifiers Set Description = "Traceability Number assigned by the Supplier" Where DataIdentifier = "1T";
Update DataIdentifiers Set Description = "Identification of a party to a transaction" Where DataIdentifier = "25T";
Update DataIdentifiers Set Description = "First Level (Supplier Assigned) identifier into these components" Where DataIdentifier = "30T";

Delete From DataIdentifiers Where DataIdentifier = "U";
Update DataIdentifiers Set Description = "Specification of a postal service and associated process data" Where DataIdentifier = "5U";
Update DataIdentifiers Set Description = "Licensing post data" Where DataIdentifier = "6U";
Update DataIdentifiers Set Description = "Specification of supplementary postal service and associated process data" Where DataIdentifier = "15U";
Update DataIdentifiers Set Description = "Postal administration identifications" Where DataIdentifier = "16U";

Update DataIdentifiers Set Description = "Supplier Code assigned by Customer" Where DataIdentifier = "V";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("2V", "6-digit Company Code as assigned by the GS1 US");
Update DataIdentifiers Set Description = "Code assigned to a party which has financial liability for an entity or group of entities" Where DataIdentifier = "7V";
Update DataIdentifiers Set Description = "Organization with budget responsibility for an entity, process, or procedure" Where DataIdentifier = "11V";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("13V", "DUNS number identifying supplier DUNS SPLR ID DUNS number identifying supplier");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("14V", "DUNS number identifying customer DUNS CUST ID DUNS number identifying customer");
Update DataIdentifiers Set Description = "Identification of a party to a transaction" Where DataIdentifier = "18V";
Update DataIdentifiers Set Description = "Specification of a party's role(s) in a transaction" Where DataIdentifier = "19V";
Update DataIdentifiers Set Description = "Identification of a party to a transaction" Where DataIdentifier = "20V";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21V", "Identification of a party to a transaction");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22V", "Carrier SCAC");

Update DataIdentifiers Set Description = "Work Order Number" Where DataIdentifier = "W";
Update DataIdentifiers Set Description = "Quality Assurance Inspector" Where DataIdentifier = "11W";
Delete From DataIdentifiers Where DataIdentifier = "X";
Delete From DataIdentifiers Where DataIdentifier = "Y";
Update DataIdentifiers Set Description = "Mutually Defined between Customer and Supplier" Where DataIdentifier = "Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 0 data)" Where DataIdentifier = "10Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 1 data)" Where DataIdentifier = "11Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 2 data)" Where DataIdentifier = "12Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 3 data)" Where DataIdentifier = "13Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 4 data)" Where DataIdentifier = "14Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 5 data)" Where DataIdentifier = "15Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 6 data)" Where DataIdentifier = "16Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 7 data)" Where DataIdentifier = "17Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 8 data)" Where DataIdentifier = "18Z";
Update DataIdentifiers Set Description = "Structured Free Text (Line 9 data)" Where DataIdentifier = "19Z";
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("20Z", "Structured Free Text (Line 10 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("21Z", "Structured Free Text (Line 11 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("22Z", "Structured Free Text (Line 12 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("23Z", "Structured Free Text (Line 13 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("24Z", "Structured Free Text (Line 14 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("25Z", "Structured Free Text (Line 15 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("26Z", "Structured Free Text (Line 16 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("27Z", "Structured Free Text (Line 17 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("28Z", "Structured Free Text (Line 18 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("29Z", "Structured Free Text (Line 19 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("30Z", "Structured Free Text (Line 20 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("31Z", "Structured Free Text (Line 21 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("32Z", "Structured Free Text (Line 22 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("33Z", "Structured Free Text (Line 23 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("34Z", "Structured Free Text (Line 24 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("35Z", "Structured Free Text (Line 25 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("36Z", "Structured Free Text (Line 26 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("37Z", "Structured Free Text (Line 27 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("38Z", "Structured Free Text (Line 28 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("39Z", "Structured Free Text (Line 29 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("40Z", "Structured Free Text (Line 30 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("41Z", "Structured Free Text (Line 31 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("42Z", "Structured Free Text (Line 32 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("43Z", "Structured Free Text (Line 33 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("44Z", "Structured Free Text (Line 34 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("45Z", "Structured Free Text (Line 35 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("46Z", "Structured Free Text (Line 36 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("47Z", "Structured Free Text (Line 37 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("48Z", "Structured Free Text (Line 38 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("49Z", "Structured Free Text (Line 39 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("50Z", "Structured Free Text (Line 40 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("51Z", "Structured Free Text (Line 41 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("52Z", "Structured Free Text (Line 42 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("53Z", "Structured Free Text (Line 43 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("54Z", "Structured Free Text (Line 44 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("55Z", "Structured Free Text (Line 45 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("56Z", "Structured Free Text (Line 46 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("57Z", "Structured Free Text (Line 47 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("58Z", "Structured Free Text (Line 48 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("59Z", "Structured Free Text (Line 49 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("60Z", "Structured Free Text (Line 50 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("61Z", "Structured Free Text (Line 51 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("62Z", "Structured Free Text (Line 52 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("63Z", "Structured Free Text (Line 53 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("64Z", "Structured Free Text (Line 54 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("65Z", "Structured Free Text (Line 55 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("66Z", "Structured Free Text (Line 56 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("67Z", "Structured Free Text (Line 57 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("68Z", "Structured Free Text (Line 58 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("69Z", "Structured Free Text (Line 59 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("70Z", "Structured Free Text (Line 60 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("71Z", "Structured Free Text (Line 61 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("72Z", "Structured Free Text (Line 62 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("73Z", "Structured Free Text (Line 63 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("74Z", "Structured Free Text (Line 64 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("75Z", "Structured Free Text (Line 65 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("76Z", "Structured Free Text (Line 66 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("77Z", "Structured Free Text (Line 67 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("78Z", "Structured Free Text (Line 68 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("79Z", "Structured Free Text (Line 69 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("80Z", "Structured Free Text (Line 70 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("81Z", "Structured Free Text (Line 71 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("82Z", "Structured Free Text (Line 72 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("83Z", "Structured Free Text (Line 73 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("84Z", "Structured Free Text (Line 74 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("85Z", "Structured Free Text (Line 75 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("86Z", "Structured Free Text (Line 76 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("87Z", "Structured Free Text (Line 77 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("88Z", "Structured Free Text (Line 78 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("89Z", "Structured Free Text (Line 79 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("90Z", "Structured Free Text (Line 80 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("91Z", "Structured Free Text (Line 81 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("92Z", "Structured Free Text (Line 82 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("93Z", "Structured Free Text (Line 83 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("94Z", "Structured Free Text (Line 84 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("95Z", "Structured Free Text (Line 85 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("96Z", "Structured Free Text (Line 86 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("97Z", "Structured Free Text (Line 87 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("98Z", "Structured Free Text (Line 88 data)");
Insert Into DataIdentifiers (DataIdentifier, Description) Values ("99Z", "Structured Free Text (Line 89 data)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.1000

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.1000", #9-Jul-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Compact database after factory calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Resolve issue when enabling Active Directory and specifying a AD server name in the LVS-95xx AD configuration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Upgrade Imaging Source Driver to 2.9.5.1977");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", 'Restore 1.75" FOV 9510 operation');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Avoid type mismatch error during calibration due to regional settings");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Improve DPM and Data Matrix reading ability");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Fix optional features shown out of numeric order");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Add timer to detect and correct loss of Windows focus which disabled the shift key trigger");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Avoid FixOldStyleLensCorrection when set for DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1000", "Improve 2D calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.1001", #2-Aug-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1001", "Improve PDF417/MicroPDF417/composite ambiguity logic");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1001", "Use comma as decimal separator for grades based on regional settings");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1001", "Fix incorrect warnings about minimum X dimension");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1001", "Fix Ctrl-P wot work properly with Windows 10");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1001", "Fix round off error in reporting of Data Matrix aperture used");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.1002", #12-Oct-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix program reappearing on top of browser for reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix Aztec Codes not reading at all");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Make Xdim and label height checking configurable for all application standards");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix shortcut keys to change tabs not working correctly");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Require archive permission to delete old reports");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Don't use 20Z results for 2D analysis");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix out of memory condition with MySQL");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Reset auto logoff timer when symbol graded");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Re-enable EAIV");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Allow additional Appendix G command without master password");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix rounding error with Axial Nonuniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Automatically turn on camera if needed when stitching");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix screen update not showing alignment lines during stitching");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix rounding error when applying blemish reduction");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix Data Matrix incorrect latching error causing wrong character");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1002", "Fix error with Micro QR Code");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.1003", #22-Oct-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1003", 'Fix problem where 1.3" FOV parameters interfered with other FOVs');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1003", "Correct round-off error in GNU computation");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1003", "Update Hungarian translation file");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1003", "Fix rounding error related to Data Matrix codes made from light cells on a dark background");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.1004", #10-Dec-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "Always show one decimal place on calibration screen");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "Include latest changes for 7.3728 MHz 9570 units");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "16527# Change export reference report to include both 1D and 2D parameters if needed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "16536# Update Japanese translation file");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "16542# Add additional information to machine not authorized message");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "16545# Fix upside-down PDF-417 not reading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.1004", "16546# Fix incorrect error message about missing FNC1");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3001", #12-Dec-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3001", "Renumber for release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3002", #16-Dec-2018#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3002", "16550# Fix Data Matrix so it can read a symbol surrounded by a complete border");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3003", #4-Jan-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3003", "16551# Fix OCR tip presentation in languages other than English");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3003", "16552# Fix wrong location for transition debug files");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3003", "16553# Color code transition ratio");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3003", "16556# Restore missing file ic_activex_3.2.0.0.exe");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3003", "16557# Change copyright date to be 2019");
Update Glossary Set Description = "0.06->4.0 0.08->3.0 0.10->2.0 0.12->1.0^This is the Transition Ratio.  This is the worst value seen for the entire symbol." Where Entry = "TR";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3004", #7-Jan-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3004", "16558# Update FTDI drivers to 2.12.28");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3005", #21-Jan-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16186# Czech regional setting wakes up in English");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16478# Ctrl+Shift trigger not working after successful decode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16538# Use 50% aperture instead of 80% aperture for non-GS1 Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16527# Fix problem with export of reference report data");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16560# Fix QRCode not decoding when box drawn tight");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16564# Include 2D quiet zones needed on 2D analysis");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16565# Round Rmin and Rmax on 2D analysis screen to one decimal place");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3005", "16571# Fix Imaging Source .ocx error when upgrading from 4.1 or earlier");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3006", #24-Jan-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3006", "16516# Fix issue with multi-sector report wrapping text incorrectly");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3006", "16526# If Pass/Fail mode, show results in report and also show minimum passing grade");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3006", "16541# Don't process <GS> unless 2D symbol has appropriate header");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3006", "16570# Support changes for GS1 General Specification V1.9");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("723" , 0, ""      , "Certification reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("723" , 1, "X1"    , "Suffix letter");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("723" , 2, "X2"    , "Certification scheme");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("723" , 3, "X1-28" , "Certification reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8009", 0, ""      , "Optically readable sensor indicator");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8009", 1, "X1-50" , "Optically readable sensor indicator");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8026", 0, ""      , "Identification of pieces of a trade item (ITIP) contained in a logistic unit");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8026", 1, "K14"   , "Global Trade Item Number (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8026", 2, "N2"    , "Piece number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8026", 3, "N2"    , "Total count");
Update ApplicationIdentifiers Set Description = "Positive offer file coupon code identification for use in North America" Where ApplicationIdentifier = "8112";
Update ApplicationIdentifiers Set Description = "Count of trade items or trade item pieces contained in a logistic unit" Where ApplicationIdentifier = "37" And Element = 0;
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 QR Code",                         0.743,   1.500,   0,         4,         4,          1.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(5,                  "GS1 QR Code",                         0.743,   1.500,   0,         4,         4,          1.5,             20);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3007", #5-Feb-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3007", "16570# Flag improper numeric digits for GS1 structure");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3007", "16575# Fix Microsoft SQL error due to setting being renamed from Action to DimensionChecking");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3008", #8-Feb-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3008", "16575# Resolved a Run time error when using Microsoft SQL server database, resolved failure to create Reference Data Export file using MS SQL or MySQL");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3009", #12-Feb-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3009", "16577# Resolved issue with inconsistent 2D FPD results");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3010

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3010", #19-Feb-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3010", "16579 # Resolved Incorrectly reported structure error detected on a GS1 stacked Databar symbol");
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3011

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3011", #1-Mar-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3011", "16583 # Resolve MicroQR decoding incorrectly");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3012

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3012", #5-Mar-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3012", "16583 # Resolve MicroQR decoding incorrectly");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.3013

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.3013", #7-Mar-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.3013", "16587 # Resolve 2D Analysis Screen displaying incorrectly for QR codes");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.4001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.4001", #1-May-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.4001", "16610 # Resolved Non-US Regional Settings causing incorrect Grades to be reported");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.4002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.4002", #3-May-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.4002", "16611 # Resolved GS1 QR Code is incorrectly failing on the leading FNC1 character");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.4002", "16618 # Resolved TR field in a non-US regional setting is not displaying correctly");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.1.5101

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.1.5101", #9-Sep-2019#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.1.5101", "16649 # Resolved Modulation and defect display distorted for DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.1000

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.1000", #2-Jan-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", "16661 # Add Minimum Reflectance to DPM verification report");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", "16662 # Do not apply MIL-STD-130 validation logic in generic ISO & DPM grading standards");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", "16663 # Do not fail code for structure due to multiple formats (06,07)");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", "16664 # ONLY use 5 mil aperture for ISO 15415 when MIL-STD-130N + UII application standard is selected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", '16665 # Do not label UII value on report for DI 25S as a "Construct 1" or "Construct 2" UII');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", 'Improve ability to read poor quality QR Codes');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1000", 'Round MeanDark and MeanLight results to 1 decimal place');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.1001", #6-Mar-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "Improve Data Matrix consistency");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "16662 # Do not apply MIL-STD-130 validation logic in generic ISO & DPM grading standards");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "16664 # Use 5 mil aperture for non-DPM ISO 15415 MIL-STD-130N + UII");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "Implement aperture override 50% and 80%");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "Warn operator when 80% not used on Data Matrix calibration symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "Round Axial Nonuniformity to one decimal place");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "Create file CellReflectance.csv for debugging Data Matrix");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.1001", "Fix problem where wrong aperture was reported for GS1 Data Matrix");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2001", #17-Mar-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2001", "Create first beta version");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2002", #24-Mar-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2002", "Analyze clock track a second time excluding areas beyond found symbol for consistency");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2002", "Fix arithmetic overflow bug in FindAreaGT");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2003", #2-Apr-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2003", "16636 # Update expired security certificate for Atmel driver");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2003", "16648 # Add GS1 Data Matrix to GS1 table 5");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2003", "16655 # Add GS1 Data Matrix to GS1 table 2");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2003", "16676 # Log manual delete of report in audit trail");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2003", "16736 # DPM grade change after releasing trigger");
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 Data Matrix",                     0.743,   1.500,   0,         4,         4,          1.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(5,                  "GS1 Data Matrix",                     0.743,   1.500,   0,         4,         4,          1.5,             20);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2004", #20-Apr-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2004", "16683 # Implement Strict15415IntegerGrading");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2004", "16686 # Fix missing lot number");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2004", "16695 # Add GS1 Table1.8200 for AI (8200)");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2004", "16698 # Change Propeller reprogramming to work in regions with 16-bit characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2004", "16743 # Update KeyLok driver to a newer version");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2004", "Fix subtle round-off errors in ANU, GNU, and CU algorithms");
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (1.8, 'Table 1.8200 - AI (8200)');
Delete From GS1Limits Where SpecificationTable = 1 And Symbology = "GS1 Data Matrix";
Delete From GS1Limits Where SpecificationTable = 1 And Symbology = "GS1 QR Code";
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 Data Matrix",                     0.375,   0.625,   0,         1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 QR Code",                         0.375,   0.625,   0,         4,         4,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1.8,                "GS1 Data Matrix",                     0.396,   0.743,   0,         1,         1,          1.5,             12);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeight, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1.8,                "GS1 QR Code",                         0.396,   0.743,   0,         4,         4,          1.5,             12);
Delete From Settings           Where SettingName = "DecimalGrading";
Delete From AllowedUserChanges Where SettingName = "DecimalGrading";
Insert Into Settings (Category, SettingName, SettingValue) Values ("Grading", "Strict15415IntegerGrading", "0");
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("Strict15415IntegerGrading", 0,  1);


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2005", #11-May-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "Undo latest KeyLok driver (16743) to avoid Windows 10 issues");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16406 # Incorrectly reporting MIL-130 Structural errors for PDT And REM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16623 # Incorrect NTIN check digit generates wrong message");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16626 # Add new AIs from GS1 General Specifications v20");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16638 # Mailmark Type D not decoding correctly");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16684 # GS1 Limits table values differ from General Specifications");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16749 # Add a DPM Application Standard for HIBC");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2005", "16756 # Codabar misread as DataBar Limited");

Insert Into ApplicationStandards (ShortName, LongName, Status) Values ('DPM+HIBC', 'DPM + HIBC', 1);

Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("235" , 0, ""      , "Third Party Controlled, Serialised Extension of GTIN (TPX)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("235" , 1, "X1-28" , "Third Party Controlled, Serialised Extension of GTIN (TPX)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("417" , 0, ""      , "Party GLN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("417" , 1, "K13"   , "GS1 Company Prefix / Location reference");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7040", 0, ""      , "GS1 UIC with Extension 1 and Importer index");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7040", 1, "N1"    , "GS1 UIC first character");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7040", 2, "X1"    , "GS1 UIC second character");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7040", 3, "X1"    , "Extension 1");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7040", 4, "X1"    , "Importer index");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7240", 0, ""      , "Protocol ID");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7240", 1, "X1-20" , "Protocol ID");

Update ApplicationIdentifiers Set Format = "X0-17" Where ApplicationIdentifier = "253" And Format = "N0-17";

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "394";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("394" , 0, ""      , "Percentage discount of a coupon");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("394" , 1, "P1"    , "Decimal placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("394" , 2, "N4"    , "Percentage discount");

Update ApplicationIdentifiers Set Format = "X-9" Where ApplicationIdentifier = "421" And Format = "X4-12";

Delete From CalibrationSetup Where CameraModel = 9510;
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9510, 1.75, 6, 40, 0.90, 1.00, 50, 90,  6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9510, 3.00, 6, 40, 0.90, 1.00, 50, 50,  6.0, 13.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9510, 4.00, 6, 40, 0.85, 0.85, 40, 50,  8.0, 20.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9510, 4.50, 6, 40, 0.80, 0.80, 50, 45,  8.0, 20.0, 9);
Insert Into CalibrationSetup (CameraModel, FieldOfView, LightingMode, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize) Values (9510, 6.25, 6, 40, 0.50, 1.00, 55, 70, 13.0, 20.0, 9);

Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (12.1, 'Table 12.1 - Trade Items at EU 2018/574 Unit Pack Level');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (12.2, 'Table 12.2 - Trade Item Groupings (unit pack aggregations per at EU 2018/574)');
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (12.3, 'Table 12.3 - Logistic units (unit pack aggregations with a transport unit per at EU 2018/574)');

Drop Table GS1Limits;
Create Table GS1Limits
(
    SpecificationTable  	Decimal(3,1),
    Symbology           	Text,
    MinXdim             	Real,
    MaxXdim             	Real,
    MinHeightForMinXdim		Real,
    MinHeightForMaxXdim		Real,
    MinLeftQZ           	Real,
    MinRightQZ          	Real,
    MinOverallGrade     	Real,
    Aperture            	Integer
);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "EAN-13",                              0.264,   0.660,   18.28,               45.67,               11,        7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "EAN-8",                               0.264,   0.660,   14.58,               36.46,               7,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "UPC-A",                               0.264,   0.660,   18.28,               45.70,               9,         9,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "UPC-E",                               0.264,   0.660,   18.28,               45.70,               9,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Omnidirectional",         0.264,   0.660,   12.14,               30.36,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Stacked Omnidirectional", 0.264,   0.660,   12.14,               30.36,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Expanded",                0.264,   0.660,   8.99,                22.44,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 DataBar Expanded Stacked",        0.264,   0.660,   18.75,               46.86,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 Data Matrix",                     0.375,   0.625,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1,                  "GS1 QR Code",                         0.375,   0.625,   0.00,                0.00,                4,         4,          1.5,             8);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1.8,                "GS1 Data Matrix",                     0.396,   0.743,   0.00,                0.00,                1,         1,          1.5,             12);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(1.8,                "GS1 QR Code",                         0.396,   0.743,   0.00,                0.00,                4,         4,          1.5,             12);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "EAN-13",                              0.495,   0.660,   34.28,               45.70,               11,        7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "EAN-8",                               0.495,   0.660,   27.35,               36.46,               7,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "UPC-A",                               0.495,   0.660,   34.28,               45.70,               9,         9,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "UPC-E",                               0.495,   0.660,   34.28,               45.70,               9,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "ITF-14",                              0.495,   0.634,   31.75,               31.75,               10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "ITF-14",                              0.635,   1.016,   31.75,               31.75,               10,        10,         0.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1-128",                             0.495,   1.016,   31.75,               31.75,               10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Omnidirectional",         0.495,   0.660,   16.34,               21.78,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Stacked Omnidirectional", 0.495,   0.660,   34.16,               45.54,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Expanded",                0.495,   0.660,   16.83,               22.44,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Expanded Stacked",        0.495,   0.660,   35.15,               46.86,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Stacked",                 0.495,   0.660,   6.44,                8.58,                0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Limited",                 0.495,   0.660,   4.95,                6.60,                0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 DataBar Truncated",               0.495,   0.660,   6.44,                8.58,                0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 Data Matrix",                     0.743,   1.500,   0.00,                0.00,                4,         4,          1.5,             20);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "EAN-13",                              0.495,   0.660,   34.28,               45.70,               11,        7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "EAN-8",                               0.495,   0.660,   27.35,               36.46,               7,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "UPC-A",                               0.495,   0.660,   34.28,               45.70,               9,         9,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "UPC-E",                               0.495,   0.660,   34.28,               45.70,               9,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Omnidirectional",         0.495,   0.660,   22.77,               30.36,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Stacked Omnidirectional", 0.495,   0.660,   47.03,               62.70,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Expanded",                0.495,   0.660,   16.83,               22.44,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 DataBar Expanded Stacked",        0.495,   0.660,   35.15,               46.86,               0,         0,          1.5,             6);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "EAN-13",                              0.264,   0.660,   18.28,               45.70,               11,        7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "EAN-8",                               0.264,   0.660,   14.58,               36.46,               7,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "UPC-A",                               0.264,   0.660,   18.28,               45.70,               9,         9,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "UPC-E",                               0.264,   0.660,   18.28,               45.70,               9,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Omnidirectional",         0.264,   0.660,   8.71,                21.78,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Stacked Omnidirectional", 0.264,   0.660,   18.24,               45.54,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Expanded",                0.264,   0.660,   8.99,                22.44,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Expanded Stacked",        0.264,   0.660,   18.75,               46.86,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Stacked",                 0.264,   0.660,   3.43,                8.58,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Limited",                 0.264,   0.660,   2.64,                6.60,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 DataBar Truncated",               0.264,   0.660,   3.43,                8.58,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "ITF-14",                              0.250,   0.495,   12.70,               12.70,               10,        10,         1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1-128",                             0.250,   0.495,   12.70,               12.70,               10,        10,         1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 Data Matrix",                     0.380,   0.495,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(4,                  "GS1 QR Code",                         0.380,   0.495,   0.00,                0.00,                4,         4,          1.5,             8);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(5,                  "GS1-128",                             0.495,   0.940,   31.75,               31.75,               10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(5,                  "GS1 QR Code",                         0.743,   1.500,   0.00,                0.00,                4,         4,          1.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(5,                  "GS1 Data Matrix",                     0.743,   1.500,   0.00,                0.00,                4,         4,          1.5,             20);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1-128",                             0.170,   0.495,   12.70,               12.70,               10,        10,         1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 Data Matrix",                     0.255,   0.990,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Omnidirectional",         0.170,   0.660,   5.61,                21.78,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Truncated",               0.170,   0.660,   2.21,                8.58,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Stacked",                 0.170,   0.660,   2.21,                8.58,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Stacked Omnidirectional", 0.170,   0.660,   11.73,               45.54,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Limited",                 0.170,   0.660,   1.70,                6.60,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Expanded",                0.170,   0.660,   5.78,                22.44,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "GS1 DataBar Expanded Stacked",        0.170,   0.660,   12.07,               46.86,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "EAN-13",                              0.170,   0.660,   18.28,               45.70,               11,        7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "EAN-8",                               0.170,   0.660,   14.58,               36.46,               7,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "UPC-A",                               0.170,   0.660,   18.28,               45.70,               9,         9,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "UPC-E",                               0.170,   0.660,   18.28,               45.70,               9,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(6,                  "ITF-14",                              0.170,   0.495,   12.70,               12.70,               10,        10,         1.5,             6);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7.1,                "GS1 Data Matrix",                     0.254,   0.615,   0.00,                0.00,                1,         1,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7.1,                "GS1 QR Code",                         0.254,   0.615,   0.00,                0.00,                4,         4,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7.2,                "GS1 Data Matrix",                     0.254,   0.615,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7.3,                "GS1 Data Matrix",                     0.100,   0.300,   0.00,                0.00,                1,         1,          1.5,             3);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(7.4,                "GS1 Data Matrix",                     0.200,   0.495,   0.00,                0.00,                1,         1,          1.5,             6);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1-128",                             0.495,   1.016,   31.75,               31.75,               10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 Data Matrix",                     0.750,   1.520,   0.00,                0.00,                1,         1,          1.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "EAN-13",                              0.495,   0.660,   34.28,               45.70,               11,        7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "EAN-8",                               0.495,   0.660,   27.35,               36.46,               7,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "UPC-A",                               0.495,   0.660,   34.28,               45.70,               9,         9,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "UPC-E",                               0.495,   0.660,   34.28,               45.70,               9,         7,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "ITF-14",                              0.495,   1.016,   31.75,               31.75,               10,        10,         1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Omnidirectional",         0.495,   0.660,   16.34,               21.78,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Truncated",               0.495,   0.660,   6.44,                8.58,                0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Stacked",                 0.495,   0.660,   6.44,                8.58,                0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Stacked Omnidirectional", 0.495,   0.660,   34.16,               45.54,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Limited",                 0.495,   0.660,   4.95,                6.60,                0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Expanded",                0.495,   0.660,   16.83,               22.44,               0,         0,          1.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(8,                  "GS1 DataBar Expanded Stacked",        0.495,   0.660,   35.15,               46.86,               0,         0,          1.5,             10);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(9,                  "GS1-128",                             0.250,   0.495,   12.70,               12.70,               10,        10,         1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(9,                  "GS1 Data Matrix",                     0.380,   0.495,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(9,                  "GS1 QR Code",                         0.380,   0.495,   0.00,                0.00,                4,         4,          1.5,             8);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1-128",                             0.264,   0.660,   12.70,               12.70,               10,        10,         1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 Data Matrix",                     0.396,   0.990,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Omnidirectional",         0.264,   0.660,   8.71,                21.78,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Truncated",               0.264,   0.660,   3.43,                8.58,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Stacked",                 0.264,   0.660,   3.43,                8.58,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Stacked Omnidirectional", 0.264,   0.660,   18.22,               45.54,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Limited",                 0.264,   0.660,   2.64,                6.60,                0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Expanded",                0.264,   0.660,   8.98,                22.44,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "GS1 DataBar Expanded Stacked",        0.264,   0.660,   18.74,               46.86,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "EAN-13",                              0.264,   0.660,   18.28,               45.70,               11,        7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "EAN-8",                               0.264,   0.660,   14.58,               36.46,               7,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "UPC-A",                               0.264,   0.660,   18.28,               45.70,               9,         9,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "UPC-E",                               0.264,   0.660,   18.28,               45.70,               9,         7,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(10,                 "ITF-14",                              0.264,   0.660,   12.70,               12.70,               10,        10,         1.5,             6);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1 DataBar Expanded",                0.264,   0.660,   8.98,                22.44,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1 DataBar Expanded Stacked",        0.264,   0.660,   18.74,               46.86,               0,         0,          1.5,             6);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1-128",                             0.170,   0.495,   12.70,               12.70,               10,        10,         1.5,             5);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1 Data Matrix",                     0.255,   0.495,   0.00,                0.00,                1,         1,          1.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(11,                 "GS1 QR Code",                         0.255,   0.495,   0.00,                0.00,                4,         4,          1.5,             8);

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.1,               "GS1 Data Matrix",                     0.380,   0.990,   0.00,                0.00,                1,         1,          3.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.1,               "GS1 QR Code",                         0.380,   0.990,   0.00,                0.00,                4,         4,          3.5,             8);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.2,               "GS1 Data Matrix",                     0.750,   1.520,   0.00,                0.00,                1,         1,          3.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.2,               "GS1 QR Code",                         0.750,   1.520,   0.00,                0.00,                4,         4,          3.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.2,               "GS1-128",                             0.495,   1.016,   31.75,               31.75,               10,        10,         3.5,             10);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.3,               "GS1 Data Matrix",                     0.750,   1.520,   0.00,                0.00,                1,         1,          3.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.3,               "GS1 QR Code",                         0.750,   1.520,   0.00,                0.00,                4,         4,          3.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(12.3,               "GS1-128",                             0.495,   0.940,   31.75,               31.75,               10,        10,         3.5,             10);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2006", #17-May-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2006", "16606 # Support DMRE Data Matrix symbol sizes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2006", "16691 # Fix quiet zone and DataBar Limited");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2006", "16749 # Fix DPM+HIBC");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2006", "16757 # Fix HIBC date display");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2006", "Support version G 2D calibration card");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.2007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.2007", #19-May-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.2007", "Correct memory overflow issue in previous fix for TTP 16606");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3001", #02-June-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3001", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3001", "16605 #  GS1 table 6 corrected Aperture value 8");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3001", "16612 #  Resolved primary Calibration Test Card 10 fails calibration");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3001", "16634 #  Resolved DPM image not displaying correctly");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3002", #08-June-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16758 # Don't check AI 1.8200 table if not using GS1 tables");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16584 # Don't generate warning about wrong symbology if missing FNC1 causes symbology to not include GS1 in the name");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16759 # Honor PDF-417 quiet zones for start and stop characters");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16760 16580 # Don't misidentify QR Code as Data Matrix during DPM");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16736 # DPM grade change after releasing trigger");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16578 # Corrected 2D CCSTC card failing contrast uniformity for all LVS95XX systems");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16668 #  Corrected FPD not grading consistently");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3002", "16747 #  Corrected DM Calibration Card Contrast Uniformity not within 3% of ISO standards");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3003", #18-June-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3003", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3003", '16543 # Adjust parameters for 6.25" FOV and Code 128 calibration label');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3003", "16584	# Restore extraneous FNC1 warning");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3003", "16651 # Fix Japanese translation of error message");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3003", "16692 # Fix slight rounding discrepancies");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3003", "16762 # Fix Japanese translation of OCR");
Update ApplicationIdentifiers Set Format = "X0-9" Where Format = "X-9";
Update GS1Limits Set MinHeightForMinXdim = 25.1  Where SpecificationTable =  1 And Symbology = "GS1 DataBar Stacked Omnidirectional";
Update GS1Limits Set MinHeightForMaxXdim = 62.7  Where SpecificationTable =  1 And Symbology = "GS1 DataBar Stacked Omnidirectional";
Update GS1Limits Set MinHeightForMaxXdim =  8.99 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded";
Update GS1Limits Set MinHeightForMaxXdim = 18.75 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Stacked";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3004", #21-June-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16606 # Remove support for DMRE Data Matrix symbol sizes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16626 # Generate warning if required FNC1 missing for certain fixed-length fields");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16649 # Disable redrawing sector output in DPM mode");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16685 # Compensate for rounding errors in GS1 V20 specifications");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16997 # Fix incorrect duplicated data for unknown TEI");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16999 # Generate warning if overall grade below minimum specified for GS1 table");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3004", "16684 # GS1 Limits table values differ from General Specifications");
Create Table FNC1Required
(
    ApplicationIdentifier   Text,
    Primary Key             (ApplicationIdentifier)
);
Insert Into FNC1Required (ApplicationIdentifier) Values ("394");
Insert Into FNC1Required (ApplicationIdentifier) Values ("402");
Insert Into FNC1Required (ApplicationIdentifier) Values ("422");
Insert Into FNC1Required (ApplicationIdentifier) Values ("424");
Insert Into FNC1Required (ApplicationIdentifier) Values ("426");
Insert Into FNC1Required (ApplicationIdentifier) Values ("7001");
Insert Into FNC1Required (ApplicationIdentifier) Values ("7003");
Insert Into FNC1Required (ApplicationIdentifier) Values ("7006");
Insert Into FNC1Required (ApplicationIdentifier) Values ("7040");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8001");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8005");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8006");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8017");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8018");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8026");
Insert Into FNC1Required (ApplicationIdentifier) Values ("8111");

! Fix Table 1
Update GS1Limits Set MaxXdim = 0.99 Where SpecificationTable = 1 And MaxXdim = 0.625;

! Fix Table 2
Update GS1Limits Set MinHeightForMaxXdim = 45.7 Where MinHeightForMaxXdim = 45.67;
Update GS1Limits Set MinLeftQZ  = 1 Where SpecificationTable = 2 And Symbology = "GS1 Data Matrix";
Update GS1Limits Set MinRightQZ = 1 Where SpecificationTable = 2 And Symbology = "GS1 Data Matrix";
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(2,                  "GS1 QR Code",                         0.743,   1.500,   0.00,                0.00,                4,         4,          1.5,             20);

Flush;

Alter Table GS1Limits Add Column MinXdimInches Real;
Alter Table GS1Limits Add Column MaxXdimInches Real;
Alter Table GS1Limits Add Column MinHeightForMinXdimInches Real;
Alter Table GS1Limits Add Column MinHeightForMaxXdimInches Real;

Update GS1Limits Set MinXdimInches = MinXdim / 25.4 Where MinXdim / 25.4 <  0.01;
Update GS1Limits Set MinXdimInches = MinXdim / 25.4 Where MinXdim / 25.4 >= 0.01;
Update GS1Limits Set MaxXdimInches = MaxXdim / 25.4 Where MaxXdim / 25.4 <  0.01;
Update GS1Limits Set MaxXdimInches = MaxXdim / 25.4 Where MaxXdim / 25.4 >= 0.01;

Update GS1Limits Set MinHeightForMinXdimInches = MinHeightForMinXdim / 25.4 Where MinHeightForMinXdim / 25.4 <  10;
Update GS1Limits Set MinHeightForMinXdimInches = MinHeightForMinXdim / 25.4 Where MinHeightForMinXdim / 25.4 >= 10;
Update GS1Limits Set MinHeightForMaxXdimInches = MinHeightForMaxXdim / 25.4 Where MinHeightForMaxXdim / 25.4 <  10;
Update GS1Limits Set MinHeightForMaxXdimInches = MinHeightForMaxXdim / 25.4 Where MinHeightForMaxXdim / 25.4 >= 10;

! Replicate errors in GS1 tables

Update GS1Limits Set MinXdimInches = 0.0292 Where MinXdimInches = 0.0293;

Update GS1Limits Set MinHeightForMinXdimInches = 0.644 Where MinHeightForMinXdimInches = 0.643;
Update GS1Limits Set MinHeightForMinXdimInches = 1.346 Where MinHeightForMinXdimInches = 1.345;
Update GS1Limits Set MinHeightForMinXdimInches = 1.385 Where MinHeightForMinXdimInches = 1.384;

Update GS1Limits Set MinHeightForMaxXdimInches = 0.858 Where MinHeightForMaxXdimInches = 0.857;
Update GS1Limits Set MinHeightForMaxXdimInches = 0.884 Where MinHeightForMaxXdimInches = 0.883 And SpecificationTable = 1;
Update GS1Limits Set MinHeightForMaxXdimInches = 0.884 Where MinHeightForMaxXdimInches = 0.883 And SpecificationTable = 2;
Update GS1Limits Set MinHeightForMaxXdimInches = 1.794 Where MinHeightForMaxXdimInches = 1.793;
Update GS1Limits Set MinHeightForMaxXdimInches = 1.800 Where MinHeightForMaxXdimInches = 1.799;
Update GS1Limits Set MinHeightForMaxXdimInches = 1.846 Where MinHeightForMaxXdimInches = 1.845 And SpecificationTable = 2;

!fix GS1 Limits tables
Update GS1Limits Set MinHeightForMinXdim =   8.99 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded";
Update GS1Limits Set MinHeightForMaxXdim =  22.44 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded";
Update GS1Limits Set MinHeightForMinXdim =  18.75 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded Stacked";
Update GS1Limits Set MinHeightForMaxXdim =  46.86 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded Stacked";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3005", #28-June-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3005", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3005", "16685 # Fix incorrect 2D minimum xdim values");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3005", "16687 # Fix DPM(ISO TR29158) cell contrast and cell modulation paramater descrptions");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3005", "16696 # Add cell contrast and cell modulation paramater descrptions");																																								 																																				
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3005", "16999 # Don't allow ability to ignore Xdim and height warnings to apply to minimum grade for table");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3005", "17005 # Fix problem where prior grade is used for GS1 minimum grade warning");
Update GS1Limits Set MinXdim = 0.254 Where MinXdim = 0.255;

Insert Into Glossary (Entry, Description) Values ("Cell contrast",       "=>30% = 4.0 ^=>25% = 3.0 ^=>20% = 2.0 ^=>15% = 1.0");
Insert Into Glossary (Entry, Description) Values ("Cell modulation",     "Symbol grade using notional UEC values of 4.0, 3.0, and 0.0");
Insert Into Glossary (Entry, Description) Values ("Minimum reflectance", "=>5% = 4.0(PASS), <5% = 0.0(FAIL)^This makes sure the symbol has enough reflectance to be detected");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3006", #1-July-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3006", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3006", "17018 # Corrected Bar height not being reported correctly when using inches");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3007", #5-July-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3007", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3007", "16584 # Don't fail for structure if extraneous FNC1");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.2.3008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.2.3008", #27-Aug-2020#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3008", "Release Candidate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3008", "17033 # Calibration for the LVS-9580/9585HD requires the using an 80% aperture");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3008", "17065 # Databar Limited with CC does not recognize a CC component is attached");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3008", "17066 # Stop Character being graded as a 0.0 GPA on a PDF attachment");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.2.3008", "Update manuals");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.1001

Update ApplicationIdentifiers Set Description = "Expiration YYMMDDHHMM" Where ApplicationIdentifier = "7003" And Element = 1;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3001

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3002

Insert Into Settings (Category, SettingName, SettingValue) Values ("Grading", "Legacy2DGradingScale", "0");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3003

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3004

Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("Legacy2DGradingScale", 0,  1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3005

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3006

Update Glossary Set Description = "4.0>=62% 3.0>=50% 2.0>=37% 1.0>=25% 0.0<25%^This is the amount of Unused Error Correction in %.  100% means no error correction was used.  This number is determined from the formula:^UEC = 100 - 100 * Corrections / MaxCorrections^^MaxCorrections is (Total CW - Data CW) / 2 rounded down." Where Entry = "Unused EC";
Update Glossary Set Description = "4.0(PASS)>=5% 0.0(FAIL)<5%^This makes sure the symbol has enough reflectance to be detected" Where Entry = "Minimum reflectance";
Update Glossary Set Description = "4.0>=30% 3.0>=25% 2.0>=20% 1.0>=15% 0.0<15%" Where Entry = "Cell contrast";
Update Glossary Set Entry = "2D Axial nonuniformity" Where Entry = "Axial nonuniformity";
Update Glossary Set Entry = "2D Cell contrast" Where Entry = "Cell contrast";
Update Glossary Set Entry = "2D Contrast" Where Entry = "Contrast";
Update Glossary Set Entry = "2D Grid nonuniformity" Where Entry = "Grid nonuniformity";
Update Glossary Set Entry = "2D Unused EC" Where Entry = "Unused EC";
Insert Into Glossary (Entry, Description) Values ("1D Contrast", "4.0>=70% 3.0>=55% 2.0>=40% 1.0>=20% 0.0<20%^This is the difference between the highest and the lowest reflectance Values found within a barcode symbol.");
Insert Into Glossary (Entry, Description) Values ("2D Reflectance margin", "4.0>=50% 3.0>=40% 2.0>=30% 1.0>=20% 0.0<20%^Modulation ignores whether or not a cell should be light or dark, while reflectance margin is adversely affected by cells printed incorrectly.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3007

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3008

Insert Into Glossary (Entry, Description) Values ("Start character", "PDF417 and similar stacked symbologies have an optional start pattern at the beginning of the code.  While optional, it must be graded if used.");
Insert Into Glossary (Entry, Description) Values ("Stop character", "PDF417 and similar stacked symbologies have an optional stop pattern at the end of the code.  While optional, it must be graded if used.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3009

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3011

!Add entry to GS1Limits for USPS Code 128
Insert Into GS1Limits
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(99,               "GS1-128",    0.33,   0.5334,   19.05,               19.05,               10,        10,         2,             10,              0.013,        0.021,                0.75,                0.75);
!Imports from 4.4.2.5004
Update DataIdentifiers Set MinSize = 7 Where DataIdentifier = "25S";
Update DataIdentifiers Set DPMCharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ" Where DataIdentifier = "CAG ";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3012

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3013

!--Change the existing table entry for 99 to 91 (for USPS 91-95), and then insert a new entry for "99", for USPS container code 
Update GS1Limits Set SpecificationTable = 91 Where SpecificationTable = 99;
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(99,               "GS1-128",    0.5715,   0.6985,   19.05,               19.05,               10,        10,         2,             10,              0.0225,        0.0275,                0.75,                1.1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3014
!-- Add support for CC-A, CC-B and CC-C to GS1 tables 6, 8 and 10
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(6,               "CC-A",    	9999,   	9999,   	9999,               9999,               1,        1,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(6,               "CC-B",    	9999,   	9999,   	9999,               9999,               1,        1,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(6,               "CC-C",    	9999,   	9999,   	9999,               9999,               2,        2,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(8,               "CC-A",    	9999,   	9999,   	9999,               9999,               1,        1,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(8,               "CC-B",    	9999,   	9999,   	9999,               9999,               1,        1,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(8,               "CC-C",    	9999,   	9999,   	9999,               9999,               2,        2,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(10,               "CC-A",    	9999,   	9999,   	9999,               9999,               1,        1,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(10,               "CC-B",    	9999,   	9999,   	9999,               9999,               1,        1,         1.5,             6,              9999,        9999,                9999,                9999);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(10,               "CC-C",    	9999,   	9999,   	9999,               9999,               2,        2,         1.5,             6,              9999,        9999,                9999,                9999);

!-- There are duplicate entries for ITF-4 in table 2.  Delete them both and then add the correct info back in
Delete From GS1Limits Where Symbology = "ITF-14" AND SpecificationTable = 2;
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(2,               "ITF-14",    	0.495,   	1.016,   	31.75,               31.75,               10,        10,         1.5,             10,       0.0195,        0.04,                1.25,                1.25);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3015

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3016

!--------------------------------------------------------------------------------------------------------------------------------
VERSION     4.4.3.3017
!-- TTP 17264 This setting was added in 4.4.3.3002 as 0 default but this feature was already running prior so this effectively changed behavior
Delete From Settings Where Category = "Grading" And SettingName = "Legacy2DGradingScale";
Insert Into Settings (Category, SettingName, SettingValue) Values ("Grading", "Legacy2DGradingScale", "1");
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3018

!-- Adding Table 13 from GS1 Specification Version 21.0.1 from Jan 2021
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(13,      "GS1 Data Matrix",   	0.495,   	3.5,   	       0,                   0,               1,        1,         1.5,             -80,       0.0195,        0.1378,                0,                0);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(13,           "GS1 QR Code",   0.495,   	3.5,   	       0,                   0,               4,        4,         1.5,             -80,       0.0195,        0.1378,                0,                0);
Insert Into GS1Limits 
(SpecificationTable, Symbology, MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(13,      		"GS1-128",   	0.495,   0.940,   		12.7,                   12.7,            10,        10,         1.5,           -80,       0.0195,        0.037,                0.5,                0.5);
Insert Into GS1SpecificationTables (SpecificationTable, Description) Values (13, 'Table 13 - Durable labelling and durable marking enabling long distance scanning');
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "RadialAdjustment9510", 0.03);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "RadialAdjustment9570", 0.1);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "RadialAdjustment9580", 0.1);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "RadialAdjustment9585", 0.2);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "RadialAdjustment9585HD", 0.5);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "SampleSize", 3);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "DeblurIterations", 3);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3019

Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "RadialAdjustment9510-6.25", -0.1);
Insert Into Settings (Category, SettingName, SettingValue) Values ("2DReflectance", "DeblurIterations9510-6.25", 6);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3020

Update CalibrationSetup Set LargeSharpen=45 where CameraModel=9580 and LightingMode=6;
Update Settings Set SettingValue=0.01 where Category="2DReflectance" and SettingName="RadialAdjustment9510";
Update Settings Set SettingValue=0.05 where Category="2DReflectance" and SettingName="RadialAdjustment9570";
Update Settings Set SettingValue=0.1 where Category="2DReflectance" and SettingName="RadialAdjustment9580";
Update Settings Set SettingValue=0.1 where Category="2DReflectance" and SettingName="RadialAdjustment9585";
Update Settings Set SettingValue=0.4 where Category="2DReflectance" and SettingName="RadialAdjustment9585HD";
Update Settings Set SettingValue=-0.05 where Category="2DReflectance" and SettingName="RadialAdjustment9510-6.25";
Update Settings Set SettingValue=3 where Category="2DReflectance" and SettingName="DeblurIterations9510-6.25";
Update Settings Set SettingValue=4 where Category="2DReflectance" and SettingName="SampleSize";
!-- Drop the old FNC1Required table, it is being replaced by the AppIdProperties table 
Drop Table FNC1Required;
!-- Create Table for Application ID properties like "FNC1 Required", "Invalid Pairs" and "Mandatory Pairs"
Create Table AppIdProperties
(
    ApplicationIdentifier   Text,
    FNC1Required            Integer,
    InvalidPairs            Text,
    MandatoryPairs          Text,
    Primary Key             (ApplicationIdentifier)
);
!-- Add all the entries for the new AppIdProperties table
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("00", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("01", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("02", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("10", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("11", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("12", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("13", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("15", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("16", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("17", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("20", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("21", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("22", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("235", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("240", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("241", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("242", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("243", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("250", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("251", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("253", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("254", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("255", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("30", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("310", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("311", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("312", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("313", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("314", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("315", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("316", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("320", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("321", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("322", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("323", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("324", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("325", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("326", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("327", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("328", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("329", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("330", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("331", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("332", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("333", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("334", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("335", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("336", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("337", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("340", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("341", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("342", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("343", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("344", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("345", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("346", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("347", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("348", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("349", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("350", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("351", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("352", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("353", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("354", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("355", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("356", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("357", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("360", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("361", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("362", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("363", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("364", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("365", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("366", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("367", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("368", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("369", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("37", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("390", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("391", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("392", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("393", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("394", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("395", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("400", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("401", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("402", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("403", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("410", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("411", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("412", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("413", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("414", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("415", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("416", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("417", 0, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("420", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("421", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("422", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("423", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("424", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("425", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("426", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("427", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4300", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4301", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4302", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4303", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4304", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4305", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4306", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4307", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4308", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4310", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4311", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4312", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4313", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4314", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4315", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4316", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4317", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4318", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4319", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4320", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4321", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4322", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4323", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4324", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4325", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("4326", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7001", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7002", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7003", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7004", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7005", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7006", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7007", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7008", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7009", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7010", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7020", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7021", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7022", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7023", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7030", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7031", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7032", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7033", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7034", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7035", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7036", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7037", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7038", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7039", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7040", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("710", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("711", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("712", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("713", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("714", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("723", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("7240", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8001", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8002", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8003", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8004", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8005", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8006", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8007", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8008", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8009", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8010", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8011", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8012", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8013", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8017", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8018", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8019", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8020", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8026", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8100", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8101", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8102", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8110", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8111", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8112", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("8200", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("90", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("91", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("92", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("93", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("94", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("95", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("96", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("97", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("98", 1, "", "");
Insert Into AppIdProperties (ApplicationIdentifier, FNC1Required, InvalidPairs, MandatoryPairs) Values ("99", 1, "", "");

!-- GS1 Application Identifiers added to support version 21 of the GS1 specification. 
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4300, 0, "", "Ship-to / Deliver-to Company name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4300, 1, "X1-35", "Ship-to / Deliver-to Company name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4301, 0, "", "Ship-to / Deliver-to Contact name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4301, 1, "X1-35", "Ship-to / Deliver-to Contact name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4302, 0, "", "Ship-to / Deliver-to address line 1");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4302, 1, "X1-70", "Ship-to / Deliver-to address line 1");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4303, 0, "", "Ship-to / Deliver-to address line 2");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4303, 1, "X1-70", "Ship-to / Deliver-to address line 2");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4304, 0, "", "Ship-to / Deliver-to suburb");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4304, 1, "X1-70", "Ship-to / Deliver-to suburb");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4305, 0, "", "Ship-to / Deliver-to locality");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4305, 1, "X1-70", "Ship-to / Deliver-to locality");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4306, 0, "", "Ship-to / Deliver-to region");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4306, 1, "X1-70", "Ship-to / Deliver-to region");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4307, 0, "", "Ship-to / Deliver-to country code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4307, 1, "X2", "Ship-to / Deliver-to country code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4308, 0, "", "Ship-to / Deliver-to telephone number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4308, 1, "X1-30", "Ship-to / Deliver-to telephone number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4310, 0, "", "Return-to company name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4310, 1, "X1-35", "Return-to company name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4311, 0, "", "Return-to contact name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4311, 1, "X1-35", "Return-to contact name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4312, 0, "", "Return-to address line 1");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4312, 1, "X1-70", "Return-to address line 1");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4313, 0, "", "Return-to address line 2");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4313, 1, "X1-70", "Return-to address line 2");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4314, 0, "", "Return-to suburb");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4314, 1, "X1-70", "Return-to suburb");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4315, 0, "", "Return-to locality");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4315, 1, "X1-70", "Return-to locality");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4316, 0, "", "Return-to region");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4316, 1, "X1-70", "Return-to region");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4317, 0, "", "Return-to country code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4317, 1, "X2", "Return-to country code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4318, 0, "", "Return-to postal code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4318, 1, "X1-20", "Return-to postal code");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4319, 0, "", "Return-to phone number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4319, 1, "X1-30", "Return-to phone number");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4320, 0, "", "Service code description");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4320, 1, "X1-35", "Service code description");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4321, 0, "", "Dangerous goods flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4321, 1, "N1", "Dangerous goods flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4322, 0, "", "Authority to leave flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4322, 1, "N1", "Authority to leave flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4323, 0, "", "Signature required flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4323, 1, "N1", "Signature required flag");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4324, 0, "", "Not before delivery date/time");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4324, 1, "D10", "Not before delivery date/time");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4325, 0, "", "Not after delivery date/time");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4325, 1, "D10", "Not after delivery date/time");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4326, 0, "", "Release date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4326, 1, "D6", "Release date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (395, 0, "", "Amount payable per unit of measure single monetary area (variable measure trade item)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (395, 1, "P1", "Decimal Placement");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (395, 2, "N6", "Amount payable per unit of measure single monetary area (variable measure trade item)");
Update ApplicationIdentifiers Set Format="L3-25" where ApplicationIdentifier="8013" and Element=1;
!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3021
Insert Into Settings (Category, SettingName, SettingValue) Values ("Etc", "9510ClearWindow", "0");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3022
Insert Into Settings (Category, SettingName, SettingValue) Values ("AutoSave", "EnableReports", "0");
Insert Into Settings (Category, SettingName, SettingValue) Values ("AutoSave", "EnableImages", "0");
Insert Into Settings (Category, SettingName, SettingValue) Values ("AutoSave", "Folder", "C:\Users\Public\Lvs-95xx");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3023
Insert Into Glossary (Entry, Description) Values ("Structure", "The syntax of the encoded data (element string) within a barcode as defined by an Application Specification.");
Insert Into Glossary (Entry, Description) Values ("Contrast Uniformity", "The minimum MOD value found in any module contained in the data region of the symbol.  CU can be used for process control and does not affect the overall grade.");
Insert Into Glossary (Entry, Description) Values ("Size", "Matrix size stated as the number of rows and columns of modules.");
Insert Into Glossary (Entry, Description) Values ("DDG", "(Distributed Damage Grade)  The average grade for all graded segments (L1, L2, QLZ1, QLZ2, & OCTASA).  DDG accounts for the cumulative effects of damage that is relatively minor in individual segments.");
Insert Into Glossary (Entry, Description) Values ("Mean Dark", "Average of the grid-center point histogram of the dark elements.");
Insert Into Glossary (Entry, Description) Values ("Mean Light", "Average of the grid-center point histogram of the light elements.");
Insert Into Glossary (Entry, Description) Values ("Bar Height", "This is a measurement in inches (or mm) perpendicular to the bar width indicating how much of the 95XX application's blue region of interest (or window) has a decoded barcode.");
Insert Into Glossary (Entry, Description) Values ("Bar Growth", "A measurement of the actual bar width compared to the nominal (or target) bar width.  It can be positive or negative.");

VERSION     4.4.3.3024
Insert Into Glossary (Entry, Description) Values ("Guard Pattern", "Elements in a 1D symbol designed for delineation rather than identification or encoding of data.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3025
Update Glossary Set Entry="MeanDark" where Entry="Mean Dark";
Update Glossary Set Entry="MeanLight" where Entry="Mean Light";
Insert Into Glossary (Entry, Description) Values ("Version", "Size of the symbol represented in terms of its position in the sequence of permissible sizes.  For MicroQRcodes = M1-M4.  For QRcodes = 1-40 .  The error correction level (L,M,Q,H) applied to the symbol is suffixed to the version designation: e.g. Version M3-Q  or Version 4-L.");
Insert Into Glossary (Entry, Description) Values ("DataBar type", "There are 7 versions of DataBar symbologies; Omni, Truncated, Stacked, Stacked-Omni, Limited, Expanded, and Expanded-Stacked.");
Insert Into Glossary (Entry, Description) Values ("Symbol Rotation", "The rotation angle of the symbol in the field of view. Clockwise rotation is expressed as a positive value, and counterclockwise is expressed as a negative value. The value range is between -180 and 180 degrees");
Insert Into Glossary (Entry, Description) Values ("Sensor Angle", "The minimum angle between the edge of the image sensor and corresponding edge of the symbol. Always between 0 and 45 degrees");
Insert Into Glossary (Entry, Description) Values ("Light Direction", "The lighting direction relative to the symbol rotation. If the 30 degree lighting bank on the left is used on a symbol with zero rotation, then direction is 30West. If the symbol is rotated 90 degrees, then direction is 30South");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3026
Insert Into Glossary (Entry, Description) Values ("Expansion", "UPC-E symbols use a compressed arrangement of numbers.  The Expansion number is the uncompressed equivalent value stated as a 12-digit number.");
Insert Into Glossary (Entry, Description) Values ("NW ratio", "Narrow bar to wide bar elements widths.");
Update ApplicationStandards Set LongName="DPM (ISO/IEC 29158:2020)" Where ShortName="DPM";
Insert Into Glossary (Entry, Description) Values ("Stick Used", "Indicates whether final results were obtained using dot connecting algorithms (Stick Algorithm)");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3027
Insert Into Settings (Category, SettingName, SettingValue) Values ("DPM", "BetterQRDotSearch", "1");
Insert Into Glossary (Entry, Description) Values ("ECMin", "The minimum Edge Contrast (EC) measured. Individual scans grade either 4.0 or 0.0 if the EC is >= 15% respectively. This is an average value calculated over multiple scans in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("Stacked SRP", "Stacked SRP is the grade resulting from the analysis of the Scan Reflectance Profile (SRP) according to ISO/IEC 15415 for symbologies with cross row scanning ability. The measurements and methodologies of the ISO/IEC 15416 specification applied over the inspection region to the start and stop, or equivalent patterns only.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3028
Update Glossary
    Set Description = "Stacked SRP is the grade resulting from the analysis of the Scan Reflectance Profile (SRP) according to ISO/IEC 15415 for symbologies with cross row scanning ability. This analysis applies measurements and methodologies of the ISO/IEC 15416 specification over the inspection region to the start and stop, or equivalent patterns only."
    Where Entry = "Stacked SRP";
Update Glossary
    Set Description = "The nominal size of the narrow element (1x) in the symbol."
    Where Entry = "Xdim";
Update Glossary
    Set Description = "The Codeword PQ (Print Quality) grade is calculated using a process defined by ISO/IEC 15415 for symbologies with cross row scanning ability. This process combines ISO/IEC 15416 modulation, decodability, and defect measurements from both data codewords, and adjacent row recognition patterns to formulate an overall Codeword PQ grade."
    Where Entry = "Codeword PQ";
Insert Into Glossary (Entry, Description) Values ("STK RMin", "The minimum reflectance value and grade. Individual scan lines are graded 4.0 or 0.0 if RMin <= 0.5 RMax respectively. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK RMax", "The maximum reflectance value measured. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK ECMin", "The minimum Edge Contrast (EC) measured. Individual scan lines grade 4.0 or 0.0 if the EC is >= 15% respectively. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK Contrast", "4.0>=70% 3.0>=55% 2.0>=40% 1.0>=20% 0.0<20%^Contrast is the difference between the highest (RMax) and the lowest (RMin) reflectance measured. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK Decode", "The decode grade as determined by applying the appropriate portions of ISO/IEC reference decode algorithms. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK Modulation", "4.0>=70% 3.0>=60% 2.0>=50% 1.0>=40% 0.0<40%^This is ratio of the minimum edge contrast to the symbol contrast. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK Decodability", "4.0>=62% 3.0>=50% 2.0>=37% 1.0>=25% 0.0<25%^This is a measurement of printing accuracy. Software measures the difference between a perfect barcode image and the actual image. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");
Insert Into Glossary (Entry, Description) Values ("STK Defects", "4.0<=15% 3.0<=20% 2.0<=25% 1.0<=30% 0.0>30%^Defects are a measurement of deviation in contrast found within a bar / space element. This is an average value calculated over multiple scan lines in the inspection region during SRP processing and applies to the start and stop or equivalent patterns only.");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3029

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3030

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3031

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3032
Update Glossary Set Description = "4.0>=30% 3.0>=25% 2.0>=20% 1.0>=15% 0.0<=10%" Where Entry = "2D Cell contrast";
Update Glossary Set Description = "4.0>=20% 3.5>=15% 2.5>=10% 1.5>=5% 0.0=0%^This makes sure the symbol has enough reflectance to be detected" Where Entry = "Minimum reflectance";
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("SeparateDecodedText", 0, 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3033

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3034

Delete From Settings Where Category = "Grading" And SettingName = "Legacy2DGradingScale";
Insert Into Settings (Category, SettingName, SettingValue) Values ("Grading", "Legacy2DGradingScale", "0");
Insert Into Settings (Category, SettingName, SettingValue) Values ("DPM", "StartingExposure", "6");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3035

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3036

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3037

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.3038

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.3.3038", #25-Oct-2021#);
!-- Update version history with latest in 3038
Delete From ReleaseDetails Where Version = "4.4.3.3037";
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Added Feature: Conformance to GS1 General Specification 2021");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Added Feature: ISO/IEC 29158:2020 - Update TR29158 to 29158:2020");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Added Feature: Auto-Save of reports to PDF file format");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: Grading DMRE codes per ISO/IEC 21471:2020");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: PDF417, Micro-PDF, and composite CC grading and reporting enhancements");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: Clarification of AI 7003 for date and time");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: DataBar guard pattern reporting");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: Updated FAQs including new language translations");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: New decimal grading options for 2D matrix symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: MIL-STD-130N reporting and acceptance criteria improvements");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: USPS Code 128 Intelligent Mail Barcodes for Containers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: Detected GS1 symbols are subject to GS1 grading rules when using ISO/IEC 15415/15416 application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: FPMAJ application standard automatically applies GS1 Table 6");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "General Enhancement: UI text field sizing for improved UX");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Default aperture changed to 50% for 2D symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: QR AutoSector now properly handles expanded Quiet Zone");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Resolved Non-English translation errors and omissions throughout the UI");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Resolved errors with GS1 Table 7 under French regional settings");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Improved UI handling of text wrapping");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Allow Chinese characters to be entered into Setup Screen Reference field");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Improved UI descriptions for grading parameters and calibration instructions");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Resolved issue with Code 39 not consistent in all symbol rotations");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: HIBC - Correctly validate four digit year in date format and Secondary Supplemental Data serial number length");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: A superfluous FNC1 character occurring at the end of GS1 symbols is now reported");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: GS1-128 version B symbols are now correctly reporting all AIs enclosed in parenthesis");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: GS1-128 Aperture - Resolve incorrect value due to missing updates for tables 11, 12.2 and 12.3");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: GS1 Databar Stacked Omnidirectional - Permit under tables 1-4,6,8,10, and exclude from 5,7,9, and 11-13");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: GS1 ITF-14 dimensional verification updated for all supported tables");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Composite codes for GS1 applications will report an error for tables other than 6,8, or 10");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Incorrect data appearing during a switch from DPM GS1 and non DPM GS1 grading modes has been resolved");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: MIL-STD-130N - Various additional structure errors are now detected and reported.");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: MIL-STD-130N - ITF-14 is flagged as not a valid symbology for MIL-STD-130N");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: A UII that includes Base256 encodation is no longer flagged as an error");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: AIAG Code 128 - Properly enforce and report quiet zone errors for Code 128 symbol with AIAG standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: USPS Code 128 - Proper Code 128 aperture selection without requiring GS1 table selection");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Runtime error - Resolve Runtime Error 2 when a LVS device is disconnected and reconnected to the host");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", 'Resolved Defect: Runtime error - Resolve Runtime Error when exporting reference data as "Export All"');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Exposure control - Exposure controls are improved when grading a symbol with either the 9580-DPM-HD or 9585-DPM-HD unit");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.3038", "Resolved Defect: Structure reporting - The structure status is now included in the output report when DontFailIfStructureError is ON");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.4101

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.3.4101", #5-Jan-2022#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.4101", "Resolved Defect: Fixed security issue with developer login");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.4.3.4102

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.4.3.4102", #20-Jan-2022#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.4102", "Resolved Defect: Include translatation of 'Red Dome' and 'degrees'");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.4102", "Resolved Defect: Updated French translation file");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.4102", "Resolved Defect: Include release notes in Manuals folder");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.4.3.4102", "Resolved Defect: Translate North/South/East/West on reports to French if needed");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1000

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1000", #22-Nov-2022#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1000", "Implement faster mirror and flip functions");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1000", "LVS-191: Add AIs 4309 and 715, remove AIs 8100, 8101, and 8102");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1000", "Implement GS1 decodability rules for ITF-14");
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8100";
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8101";
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8102";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4309, 0, "",      "Ship-to / Deliver-to GEO");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (4309, 1, "N20",   "Ship-to / Deliver-to GEO");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (715,  0, "",      "National Healthcare Reimbursement Number (NHRN) US");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (715,  1, "X1-20", "National Healthcare Reimbursement Number (NHRN) US");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1001", #6-Jan-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1001", "LVS-190: Implement and interface with GS1 syntax engine");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1001", "LVS-270: All Languagee: Lighting dialog displays last item in list with smaller font size");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1001", "Resolved Defect: French, there is an extra parentheses for Recent reports");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1001", "Add application standard for 15434");
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("ISO15434", "ISO/IEC 15415/15416 (with 15434 DIs)", 1);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1002", #17-Feb-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", 'LVS-13: Software is not catching a format error using DI "D" (date) structure');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-39: AIAG Data Structure Failure for DI (P)");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-191: Add GS1-2022 AND GS1-2023 changes to 95xx");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-196: Make on-screen calibration results match what is in the calibration history");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-247: There is a 50% blemish error being reported on a DataBar Expanded Stacked symbol");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-248: Update MailMark application standard");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-256: UPC-E with CCA component does not grade the 1D portion");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-264: Warning regarding DPM requiring a different camera says to contact Microscan support");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", 'LVS-267: When override aperture is disabled on setup tab, Data Matrix warning message on grading screen has "overridden" spelled wrong');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1002", "LVS-272: Add support for additional DIs (metadata and date format DIs / data validation of DIs)"); 
Alter Table DataIdentifiers Add Column CharSet Text;
Update DataIdentifiers Set CharSet = DPMCharSet;
Alter Table DataIdentifiers Drop Column DPMCharSet;
Update DataIdentifiers Set CharSet = "0123456789"                             Where PPNCharSet = 10;
Update DataIdentifiers Set CharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"   Where PPNCharSet = 36;
Update DataIdentifiers Set CharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/" Where PPNCharSet = 38;
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "5B";
Update DataIdentifiers Set MinSize = 11, MaxSize = 11 Where DataIdentifier = "7B";
Update DataIdentifiers Set MinSize = 3, MaxSize = 3 Where DataIdentifier = "8B";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4 Where DataIdentifier = "9B";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4 Where DataIdentifier = "10B";
Update DataIdentifiers Set MinSize = 1, MaxSize = 1, CharSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" Where DataIdentifier = "14B";
Update DataIdentifiers Set MinSize = 1, MaxSize = 4 Where DataIdentifier = "15B";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4 Where DataIdentifier = "16B";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "17B";
Update DataIdentifiers Set MinSize = 10, MaxSize = 10 Where DataIdentifier = "18B";
Update DataIdentifiers Set MinSize = 18, MaxSize = 18 Where DataIdentifier = "19B";
Update DataIdentifiers Set MinSize = 2, MaxSize = 2 Where DataIdentifier = "20B";
Update DataIdentifiers Set MinSize = 6, MaxSize = 6 Where DataIdentifier = "21B";
Update DataIdentifiers Set MinSize = 13, MaxSize = 13 Where DataIdentifier = "22B";
Update DataIdentifiers Set MinSize = 3, MaxSize = 3, CharSet = "0123456789" Where DataIdentifier = "23B";
Update DataIdentifiers Set MinSize = 5, MaxSize = 5, CharSet = "0123456789" Where DataIdentifier = "24B";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "25B";
Update DataIdentifiers Set MinSize = 20, MaxSize = 50 Where DataIdentifier = "27B";
Update DataIdentifiers Set MinSize = 20, MaxSize = 50 Where DataIdentifier = "28B";
Update DataIdentifiers Set MinSize = 1, MaxSize = 50 Where DataIdentifier = "29B";
Update DataIdentifiers Set MinSize = 2, MaxSize = 35 Where DataIdentifier = "30B";
Update DataIdentifiers Set MinSize = 6, MaxSize = 35 Where DataIdentifier = "31B";
Update DataIdentifiers Set MinSize = 1, MaxSize = 50 Where DataIdentifier = "55B";
Update DataIdentifiers Set MinSize = 6, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "D";
Update DataIdentifiers Set MinSize = 6, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "1D";
Update DataIdentifiers Set MinSize = 6, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "2D";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4, CharSet = "0123456789" Where DataIdentifier = "3D";
Update DataIdentifiers Set MinSize = 5, MaxSize = 5, CharSet = "0123456789" Where DataIdentifier = "4D";
Update DataIdentifiers Set MinSize = 9, MaxSize = 9 Where DataIdentifier = "5D";
Update DataIdentifiers Set MinSize = 11, MaxSize = 11 Where DataIdentifier = "6D";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4, CharSet = "0123456789" Where DataIdentifier = "7D";
Update DataIdentifiers Set MinSize = 14, MaxSize = 15, CharSet = "0123456789" Where DataIdentifier = "8D";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4, CharSet = "0123456789" Where DataIdentifier = "10D";
Update DataIdentifiers Set MinSize = 6, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "11D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "12D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "13D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "14D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "15D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "16D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "17D";
Update DataIdentifiers Set MinSize = 12, MaxSize = 12, CharSet = "0123456789" Where DataIdentifier = "18D";
Update DataIdentifiers Set MinSize = 12, MaxSize = 12, CharSet = "0123456789" Where DataIdentifier = "19D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "20D";
Update DataIdentifiers Set MinSize = 12, MaxSize = 12, CharSet = "0123456789" Where DataIdentifier = "22D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "25D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "26D";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "27D";
Update DataIdentifiers Set MinSize = 16, MaxSize = 16, CharSet = "0123456789" Where DataIdentifier = "28D";
Update DataIdentifiers Set MinSize = 1, MaxSize = 4, CharSet = "0123456789" Where DataIdentifier = "2E";
Update DataIdentifiers Set MinSize = 1, MaxSize = 4, CharSet = "0123456789" Where DataIdentifier = "3E";
Update DataIdentifiers Set MinSize = 1, MaxSize = 2, CharSet = "0123456789" Where DataIdentifier = "4E";
Update DataIdentifiers Set MinSize = 1, MaxSize = 2, CharSet = "0123456789" Where DataIdentifier = "5E";
Update DataIdentifiers Set MinSize = 1, MaxSize = 4, CharSet = "0123456789" Where DataIdentifier = "6E";
Update DataIdentifiers Set MinSize = 9, MaxSize = 15 Where DataIdentifier = "12E";
Update DataIdentifiers Set MinSize = 1, MaxSize = 60 Where DataIdentifier = "H";
Update DataIdentifiers Set MinSize = 9, MaxSize = 9, CharSet = "0123456789" Where DataIdentifier = "2H";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "6H";
Update DataIdentifiers Set MinSize = 10, MaxSize = 15, CharSet = "0123456789" Where DataIdentifier = "7H";
Update DataIdentifiers Set MinSize = 3, MaxSize = 35 Where DataIdentifier = "8H";
Update DataIdentifiers Set MinSize = 10, MaxSize = 12 Where DataIdentifier = "9H";
Update DataIdentifiers Set MinSize = 2, MaxSize = 2 Where DataIdentifier = "12H";
Update DataIdentifiers Set MinSize = 3, MaxSize = 2 Where DataIdentifier = "15H";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "J";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "1J";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "2J";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "3J";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "4J";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "5J";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "6J";
Update DataIdentifiers Set MinSize = 9, MaxSize = 9, CharSet = "0123456789" Where DataIdentifier = "8J";
Update DataIdentifiers Set MinSize = 5, MaxSize = 29 Where DataIdentifier = "12K";
Update DataIdentifiers Set MinSize = 5, MaxSize = 16 Where DataIdentifier = "13K";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "27K";
Update DataIdentifiers Set MinSize = 2, MaxSize = 2, CharSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" Where DataIdentifier = "4L";
Update DataIdentifiers Set MinSize = 6, MaxSize = 6 Where DataIdentifier = "7L";
Update DataIdentifiers Set MinSize = 5, MaxSize = 27, CharSet = "0123456789" Where DataIdentifier = "11L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 60 Where DataIdentifier = "16L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 60 Where DataIdentifier = "17L";
Update DataIdentifiers Set MinSize = 2, MaxSize = 12 Where DataIdentifier = "18L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "25L";
Update DataIdentifiers Set MinSize = 6, MaxSize = 8 Where DataIdentifier = "27L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "28L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "29L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 9 Where DataIdentifier = "30L";
Update DataIdentifiers Set MinSize = 4, MaxSize = 11 Where DataIdentifier = "31L";
Update DataIdentifiers Set MinSize = 2, MaxSize = 2, CharSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" Where DataIdentifier = "32L";
Update DataIdentifiers Set MinSize = 5, MaxSize = 29 Where DataIdentifier = "35L";
Update DataIdentifiers Set MinSize = 5, MaxSize = 29 Where DataIdentifier = "36L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 9 Where DataIdentifier = "51L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 9 Where DataIdentifier = "52L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 9 Where DataIdentifier = "54L";
Update DataIdentifiers Set MinSize = 1, MaxSize = 9 Where DataIdentifier = "55L";
Update DataIdentifiers Set MinSize = 13, MaxSize = 15 Where DataIdentifier = "N";
Update DataIdentifiers Set MinSize = 5, MaxSize = 22 Where DataIdentifier = "9N";
Update DataIdentifiers Set MinSize = 13, MaxSize = 14, CharSet = "0123456789" Where DataIdentifier = "3P";
Update DataIdentifiers Set MinSize = 14, MaxSize = 14, CharSet = "0123456789" Where DataIdentifier = "8P";
Update DataIdentifiers Set MinSize = 10, MaxSize = 10 Where DataIdentifier = "11P";
Update DataIdentifiers Set MinSize = 7, MaxSize = 12, CharSet = "0123456789" Where DataIdentifier = "27P";
Update DataIdentifiers Set MinSize = 1, MaxSize = 100 Where DataIdentifier = "28P";
Update DataIdentifiers Set MinSize = 5, MaxSize = 5, CharSet = "0123456789" Where DataIdentifier = "29P";
Update DataIdentifiers Set MinSize = 3, MaxSize = 9 Where DataIdentifier = "49P";
Update DataIdentifiers Set MinSize = 3, MaxSize = 35 Where DataIdentifier = "50P";
Update DataIdentifiers Set MinSize = 1, MaxSize = 50 Where DataIdentifier = "52P";
Update DataIdentifiers Set MinSize = 10, MaxSize = 25 Where DataIdentifier = "53P";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "54P";
Update DataIdentifiers Set MinSize = 2, MaxSize = 2 Where DataIdentifier = "3Q";
Update DataIdentifiers Set MinSize = 3, MaxSize = 10 Where DataIdentifier = "7Q";
Update DataIdentifiers Set MinSize = 4, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "8Q";
Update DataIdentifiers Set MinSize = 4, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "11Q";
Update DataIdentifiers Set MinSize = 4, MaxSize = 13 Where DataIdentifier = "12Q";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "27Q";
Update DataIdentifiers Set MinSize = 1, MaxSize = 10 Where DataIdentifier = "28Q";
Update DataIdentifiers Set MinSize = 1, MaxSize = 6, CharSet = "0123456789" Where DataIdentifier = "29Q";
Update DataIdentifiers Set MinSize = 1, MaxSize = 5 Where DataIdentifier = "30Q";
Update DataIdentifiers Set MinSize = 3, MaxSize = 3 Where DataIdentifier = "31Q";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4 Where DataIdentifier = "4R";
Update DataIdentifiers Set MinSize = 1, MaxSize = 3 Where DataIdentifier = "7R";
Update DataIdentifiers Set MinSize = 1, MaxSize = 10 Where DataIdentifier = "8R";
Update DataIdentifiers Set MinSize = 2, MaxSize = 2 Where DataIdentifier = "9R";
Update DataIdentifiers Set MinSize = 2, MaxSize = 30 Where DataIdentifier = "2S";
Update DataIdentifiers Set MinSize = 6, MaxSize = 25 Where DataIdentifier = "18S";
Update DataIdentifiers Set MinSize = 12, MaxSize = 12 Where DataIdentifier = "23S";
Update DataIdentifiers Set MinSize = 6, MaxSize = 26, CharSet = "0123456789" Where DataIdentifier = "24S";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "26S";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "50S";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "51S";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "52S";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "53S";
Update DataIdentifiers Set MinSize = 1, MaxSize = 20 Where DataIdentifier = "54S";
Update DataIdentifiers Set MinSize = 16, MaxSize = 0 Where DataIdentifier = "96S";
Update DataIdentifiers Set MinSize = 8, MaxSize = 8, CharSet = "0123456789" Where DataIdentifier = "2V";
Update DataIdentifiers Set MinSize = 9, MaxSize = 9, CharSet = "0123456789" Where DataIdentifier = "3V";
Update DataIdentifiers Set MinSize = 10, MaxSize = 15 Where DataIdentifier = "10V";
Update DataIdentifiers Set MinSize = 9, MaxSize = 13, CharSet = "0123456789" Where DataIdentifier = "12V";
Update DataIdentifiers Set MinSize = 9, MaxSize = 13, CharSet = "0123456789" Where DataIdentifier = "13V";
Update DataIdentifiers Set MinSize = 9, MaxSize = 13, CharSet = "0123456789" Where DataIdentifier = "14V";
Update DataIdentifiers Set MinSize = 5, MaxSize = 5 Where DataIdentifier = "17V";
Update DataIdentifiers Set MinSize = 1, MaxSize = 35 Where DataIdentifier = "21V";
Update DataIdentifiers Set MinSize = 4, MaxSize = 4 Where DataIdentifier = "22V";
Update DataIdentifiers Set MinSize = 5, MaxSize = 20 Where DataIdentifier = "23V";
Update DataIdentifiers Set MinSize = 5, MaxSize = 20 Where DataIdentifier = "24V";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1003", #10-Mar-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", "LVS-8: 100% UPC symbol is being flagged as an error using GS1 Table 6");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", "LVS-149: Bar height reported incorrectly on 95XX");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", "LVS-197: Auto-Sector No Valid Barcode Found when Datamatrix has a box around it");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", "LVS-379: Issues with Device Identifiers: 12E and REM (TEI)");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", 'LVS-380: "Operator" misspelled in the Operator ID Not Allowed alert dialog');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", "Fix Postnet");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1003", "Fix DI MaxSize=0 for 15H and 96S");

Update DataIdentifiers Set MaxSize = 22 Where DataIdentifier = "15H";
Update DataIdentifiers Set MaxSize = 26 Where DataIdentifier = "96S";

Create Table GS1TableOrder
(
    SpecificationTable  Real,
    Symbology           Text
);

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "EAN-8");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "GS1 DataBar Expanded Stacked");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1.8, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1.8, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (1, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "ITF-14");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Limited");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 DataBar Truncated");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (2, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "EAN-8");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (3, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "EAN-8");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Limited");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 DataBar Truncated");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "ITF-14");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (4, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (5, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (5, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (5, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Truncated");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Limited");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "EAN-8");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (6, "ITF-14");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (7.1, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (7.1, "GS1 QR Code");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (7.2, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (7.3, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (7.4, "GS1 Data Matrix");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "EAN-8");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "ITF-14");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Truncated");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Limited");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "CC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "CC-B");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (8, "CC-C");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (9, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (9, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (9, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Truncated");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Stacked Omnidirectional");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Limited");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "EAN-13");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "EAN-8");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "UPC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "UPC-E");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "ITF-14");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "CC-A");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "CC-B");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (10, "CC-C");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (11, "GS1 DataBar Expanded");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (11, "GS1 DataBar Expanded Stacked");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (11, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (11, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (11, "GS1 QR Code");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.1, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.1, "GS1 QR Code");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.2, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.2, "GS1 QR Code");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.2, "GS1-128");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.3, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.3, "GS1 QR Code");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (12.3, "GS1-128");

Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (13, "GS1 Data Matrix");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (13, "GS1 QR Code");
Insert Into GS1TableOrder (SpecificationTable, Symbology) Values (13, "GS1-128");

Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 Data Matrix",                     0.743,   0.990,   0.00,                0.00,                1,         1,          1.5,             20);
Insert Into GS1Limits
(SpecificationTable, Symbology,                             MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture) Values
(3,                  "GS1 QR Code",                         0.743,   0.990,   0.00,                0.00,                4,         4,          1.5,             20);

Update GS1Limits Set MinXdim = 0.396 Where SpecificationTable = 1 And Symbology = "GS1 Data Matrix";
Update GS1Limits Set MinXdim = 0.396 Where SpecificationTable = 1 And Symbology = "GS1 QR Code";

! Do a reset to make sure later code actually works properly
Update GS1Limits Set MinXdimInches = 0;
Update GS1Limits Set MaxXdimInches = 0;
Update GS1Limits Set MinHeightForMinXdimInches = 0;
Update GS1Limits Set MinHeightForMaxXdimInches = 0;
Flush;

! Fix GS1 Limits tables to match V23
Update GS1Limits Set MinHeightForMinXdim =   8.99 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded";
Update GS1Limits Set MinHeightForMaxXdim =  22.44 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded";
Update GS1Limits Set MinHeightForMinXdim =  18.75 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded Stacked";
Update GS1Limits Set MinHeightForMaxXdim =  46.86 Where SpecificationTable = 11 And Symbology = "GS1 DataBar Expanded Stacked";

! Convert mm to inches
Update GS1Limits Set MinXdimInches = Round(MinXdim / 25.4, 5) Where MinXdim / 25.4 <  0.01;
Update GS1Limits Set MinXdimInches = Round(MinXdim / 25.4, 4) Where MinXdim / 25.4 >= 0.01;
Update GS1Limits Set MaxXdimInches = Round(MaxXdim / 25.4, 5) Where MaxXdim / 25.4 <  0.01;
Update GS1Limits Set MaxXdimInches = Round(MaxXdim / 25.4, 4) Where MaxXdim / 25.4 >= 0.01;
Update GS1Limits Set MinHeightForMinXdimInches = Round(MinHeightForMinXdim / 25.4, 3) Where MinHeightForMinXdim / 25.4 <  10;
Update GS1Limits Set MinHeightForMinXdimInches = Round(MinHeightForMinXdim / 25.4, 2) Where MinHeightForMinXdim / 25.4 >= 10;
Update GS1Limits Set MinHeightForMaxXdimInches = Round(MinHeightForMaxXdim / 25.4, 3) Where MinHeightForMaxXdim / 25.4 <  10;
Update GS1Limits Set MinHeightForMaxXdimInches = Round(MinHeightForMaxXdim / 25.4, 2) Where MinHeightForMaxXdim / 25.4 >= 10;

! Replicate errors in GS1 tables
Update GS1Limits Set MinXdimInches = 0.0292 Where MinXdimInches = 0.0293;

Update GS1Limits Set MinHeightForMinXdimInches = 0.644 Where MinHeightForMinXdimInches = 0.643;
Update GS1Limits Set MinHeightForMinXdimInches = 0.897 Where MinHeightForMinXdimInches = 0.896;
Update GS1Limits Set MinHeightForMinXdimInches = 1.346 Where MinHeightForMinXdimInches = 1.345;
Update GS1Limits Set MinHeightForMinXdimInches = 1.385 Where MinHeightForMinXdimInches = 1.384;
Update GS1Limits Set MinHeightForMinXdimInches = 1.853 Where MinHeightForMinXdimInches = 1.852;

Update GS1Limits Set MinHeightForMaxXdimInches = 0.858 Where MinHeightForMaxXdimInches = 0.857;
Update GS1Limits Set MinHeightForMaxXdimInches = 0.884 Where MinHeightForMaxXdimInches = 0.883 And SpecificationTable In (2, 3, 6, 8, 10);
Update GS1Limits Set MinHeightForMaxXdimInches = 1.196 Where MinHeightForMaxXdimInches = 1.195 And SpecificationTable = 3;
Update GS1Limits Set MinHeightForMaxXdimInches = 1.794 Where MinHeightForMaxXdimInches = 1.793;
Update GS1Limits Set MinHeightForMaxXdimInches = 1.800 Where MinHeightForMaxXdimInches = 1.799;
Update GS1Limits Set MinHeightForMaxXdimInches = 1.846 Where MinHeightForMaxXdimInches = 1.845 And SpecificationTable In (2, 3, 6, 8, 10);
Update GS1Limits Set MinHeightForMaxXdimInches = 2.470 Where MinHeightForMaxXdimInches = 2.469 And SpecificationTable = 3;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1004", #21-Apr-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1004", "LVS-248: Update MailMark application standard (additional fixes)");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1004", "LVS-327: Codeword yield grade for CC-A not performing well");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1004", "LVS-445: No error when verifying DMRE symbol using GS1");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1004", "LVS-456: Stop statement encountered");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1004", "Undo unreliable fix for LVS-197: Auto-Sector No Valid Barcode");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1005", #5-May-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1005", "Add experimental timeout during calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1006", #11-May-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1006", "Enhance experimental timeout during calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1007", #9-Jul-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-182: Support DEF-STAN-05-132");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-185: Make LVS-95XX language selection persistent");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-221: Calibration for Data Matrix Conformance test card Round off UEC to integer value");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-273: Change MIL-STD-130N label to MIL-STD-130N1");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-326: Effective Aperture values are being reported as fractions");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", 'LVS-395: Fails to catch incorrect R/S position in "07" formatted free text in IUID Data Matrix');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-434: Incorrectly passing MIL-STD-130N symbols with space after a DI");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-455: Higher resolution images in LVS-95XX reports");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-457: The module size of 2D Mailmark barcode must be in the range of 0.50 - 0.70mm");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-469: DMRE size 8 x 144 cannot be decoded by ISO");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-484: HIBC Intermittent structure error");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1007", "LVS-498: Correct translation file errors");

Update ApplicationStandards Set LongName =       "MIL-STD-130N1"       Where LongName =       "MIL-STD-130N";
Update ApplicationStandards Set LongName =       "MIL-STD-130N1 + UII" Where LongName =       "MIL-STD-130N + UII";
Update ApplicationStandards Set LongName = "DPM + MIL-STD-130N1"       Where LongName = "DPM + MIL-STD-130N";
Update ApplicationStandards Set LongName = "DPM + MIL-STD-130N1 + UII" Where LongName = "DPM + MIL-STD-130N + UII";
Insert Into ApplicationStandards (ShortName, LongName, Status) Values ("DEFSTAN+UII", "Defence Standard 05-132 + UII", 1);

Update ApplicationIdentifiers Set Description = "NATO Stock Number (NSN)" Where ApplicationIdentifier = "7001";

Update DataIdentifiers Set MinSize = 0, MaxSize = 0, CharSet = "" Where DataIdentifier = "1T";

Insert Into Settings (Category, SettingName, SettingValue) Values ("Report", "FullResImage", "0");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.1008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.1008", #13-Jul-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1008", "LVS-22:  Light Direction reported incorrectly when using LVS-9510");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1008", "LVS-205: AI Dependency checks");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1008", "LVS-326: Effective Aperture values are being reported as fractions (QRCode)");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1008", "LVS-520: Do not flag an Aperture Warning if ISO15415 is being used and 50% or 80% Aperture is selected");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.1008", "LVS-524: The Schweiz (CH) language is broken");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3001", #13-Jul-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3001", "Make release");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3002", #27-Jul-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3002", "LVS-395: Additional fixes");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3002", "LVS-514: 95XX Table 7.3 is not following the Gen. Spec. aperture range selection");
Update GS1Limits Set Aperture = 0 Where SpecificationTable = 7.3 or SpecificationTable = 7.4;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3003", #2-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", "LVS-263: Auto-Save failed message for Invalid UII requires clicking OK twice");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", "LVS-535: There is an Extraneous Error being reported in a symbol that looks correct");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", "LVS-541: FNC1 in the first position for MIL-STD-130N1 + UII is not allowed");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", "LVS-546: New Imaging Source cameras fail calibration");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", "LVS-548: AI (7011) is not in the software's database");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", 'LVS-549: AI (3nnn) and AI (723) produce an "unrecognised AI" warning banner');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3003", "LVS-550: Reported aperture sometimes does not match with x-dimension");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (7011, 0, "",      "Test by date");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values (7011, 1, "D6-10", "Test by date");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3004", #10-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-388: DI MaxSize=0 for DI 15H and DI 96S is wrong");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-429: The ability to use the PASS/FAIL feature is not available when using DPM Grading");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-438: Second message envelope in MIL-STD-130N message not parsed correctly");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", 'LVS-458: For MailMark, change what the 95XX had as "Return Mail Flag" to "Service Type"');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-483: DPM grading getting stuck");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", 'LVS-493: Localization: "OperatorID" is not translated for most languages');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-535: REPEAT: There is an Extraneous Error being reported in a symbol that looks correct");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-537: Data Structure is not being analyzed correctly");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-543: When using DPM mode, software is allowing the lights to change when image is in motion");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", 'LVS-549: REPEAT: AI (3nnn) and AI (723) produce an "unrecognised AI" warning banner');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3004", "LVS-588: Warning flag for GS1 mandatory associations and invalid pairs are not persistent");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3005", #14-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3005", "LVS-588: Warning flag for GS1 mandatory associations and invalid pairs do nout cause a failing grade");


!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3006", #16-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3006", "LVS-326: REPEAT: Effective Aperture values are being reported as fractions (QRCode)");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3006", "LVS-543: REPEAT: When using DPM mode, software is allowing the lights to change when image is in motion");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3007", #17-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3007", "LVS-615: Composite codes are not being parsed correctly when using GS1");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3008", #22-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", "LVS-589: AI (390) through AI (395) is giving invalid warnings");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", "LVS-590: Regression: FUNC1 in the first position is giving a structure error for ISO/IEC 15415/15416");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", "LVS-609: Regression: Expected <EOT> error for Code 128's <Stop> character");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", "LVS-610: The symbol should not have invalid UII. That is incorrect.");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", 'LVS-611: Need to remove flag for PDF417 latch in header in upcoming "ISO15415 w/ISO15434" Application Standard option');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", 'LVS-612: Regression: "Extraneous <FNC1> detected" for FNC1s after AIs for GS1-128 symbols and after Text/C40 encoding for Data Matrix');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3008", "LVS-614: Regression: Non-compliant FPMAJ barcodes are getting passing scores");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3009", #23-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3009", "LVS-541: Regression: FNC1 in the first position for MIL-STD-130N1 + UII is not allowed");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3009", "LVS-590: Regression: FUNC1 in the first position is giving a structure error for ISO/IEC 15415/15416");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3010

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3010", #30-Aug-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3010", "LVS-266: Cannot achieve 4.0 SRP grade on PDF or MicroPDF symbols");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3010", "LVS-627: MIL-STD-130N1 is not parsing data correctly");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3010", "LVS-628: When using 15415/6, software is suggesting to use a GS1 standard, but symbol is a MIL STD");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3010", "LVS-631: Application Standard 15415/15416 with 15434 is not parsing the data correctly");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3011

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3011", #21-Sep-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3011", "LVS-537: Regression: Data Structure is not being analyzed correctly");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3011", 'LVS-632: EAN-13 and UPC-A symbols with supplemental data are producing "WARNING: AI (01) value is too long" warning flags');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3011", 'LVS-641: New Imaging Source camera is not working with 6.25" FOV');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3011", 'LVS-696: Data Identifier "1T" is not being parsed correctly');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3011", "LVS-705: DPM grading of QR and DM symbols are reporting a 3mil Aperture size for all sizes of symbols");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3011", "Make ReportImageReduction user-configurable");

Insert Into Settings (Category, SettingName, SettingValue) Values ("Camera", "MotionTweak", 12);
Insert Into Settings (Category, SettingName, SettingValue) Values ("Report", "ReportImageReduction", 6);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("ReportImageReduction", 1, 10);
Update DataIdentifiers Set CharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/" Where DataIdentifier = "1T";
Delete From Settings Where SettingName = "FullResImage";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3012

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3012", #28-Sep-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3012", 'LVS-711: White balance calibration detects motion while calibrating the LVS-9510 1.75" and 3" FOV verifiers');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3012", "LVS-712: UPC-E w/ supplemental data is not being converted to GTIN-12");

Update Settings Set SettingValue = "15" Where SettingName = "MotionTweak";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3013

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3013", #9-Oct-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3013", 'LVS-632: Regression: EAN-13 and UPC-A symbols with supplemental data are producing "WARNING: AI (01) value is too long" warning flags');

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3014

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3014", #12-Oct-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3014", "LVS-586: Remove MIL-STD-130N from applications drop-down in LVS-95XX");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3015

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3015", #3-Nov-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3015", "LVS-734: Smart quotes in SQL queries casing error on 1st startup after install");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3015", "LVS-737: Continue to adjust exposure on calibration tab if no factory calibration");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3016

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3016", #20-Nov-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3016", "LVS-753: Regression: Camera motion detection value has to be changed");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3016", "LVS-760: Make (49P) optional");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3016", "LVS-761: Allow '-' and '/' for data identifier S");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3016", "LVS-762: Make folders for Manuals and FAQs external to the installation Setup.exe");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3016", "LVS-763: Install driver for 33U cameras");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3016", "LVS-764: Don't use GS1 syntax library for non-GS1 application standard");

Update DataIdentifiers Set CharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/" Where DataIdentifier = "S";
Update DataIdentifiers Set PPNCharSet = 38 Where CharSet Like "%-/";
Delete From Settings Where SettingName = "MotionTweak";

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3017

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3017", #29-Nov-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-766: Don't require FNC1 for GS1 Digital Link QR Codes");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-767: Fix FAQ button on Welcome screen");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-768: Incorrect Japanese text in GS1 warning");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-769: Grading mode: Performance degradation when on Automatic or Manual");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-770: Start Menu shortcuts to FAQs and Manuals are missing/broken on clean installs");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-771: Add improved Polish DAT file (0415.dat)");
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3017", "LVS-772: CCA reporting UEC of 0% in error");

Insert Into Settings (Category, SettingName, SettingValue) Values ("Camera", "MotionTweak", 15);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3018

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3018", #8-Dec-2023#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3018", 'LVS-777: When parsing the data structure, change the phrase: "Stem not checked" to "URI not checked"');
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3018", "LVS-???: Improve PDF tilt compensation algorithm");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3020

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3020", #11-Dec-2023#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.3021

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.3021", #18-Dec-2023#);
!LVS-788: Structure is a PASS but 3 structure errors are being reported
!LVS-792: Digital Link parameter missing for GS1 Digital Link QR codes
!LVS-793: <254> Unlatch is embedded in the Digital link URI description value
!LVS-794: Capitalized URLs are causing issues for GS1 Digital Link symbols
!update FAQ0409.pdf
!fix typo in manual with word "instructions"

Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Added Feature: Conformance to GS1 General Specification 2022 & 2023");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Added Feature: Report image resolution is configurable");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Added Feature: Added ISO/IEC 15434 as a separate application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Added Feature: Added DEF-STAN-05-132 application standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Added Feature: Added GS1 AI dependency checks");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Aperture override warning not shown for 50% and 80% aperture selection");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Language selection is persistent");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: MailMark application standard updated");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Added over 100 Data Identifiers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: GS1 Decodability rules for ITF-14 added");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: DMRE symbols not allowed for GS1 application Standard");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Composite Code (CC-A, CC-B, CC-C), PDF417 and MicroPDF417 grading improved");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Multiple language translations I9500mproved");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Usability - lights no longer cycle when a DPM image is moving");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Usability - image updates are more predictable while grading DPM symbols");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Usability - data structure errors are more clearly indicated");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "General Enhancement: Performance - grading speed is improved when using Automatic or Manual grading modes");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Schweiz (CH) language setting fixed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Apertures are now reported as whole Numbers");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Angle of light report for 9510 Corrected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Cosmetic - Font sizes are more appropriate for dialog box");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Cosmetic - Spelling and punction errors Corrected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Cosmetic - Decimal precision shown on screen is more appropriate");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Cosmetic - Double-click on Auto-save failed message resolved");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Cosmetic - Persistence of warning messages is more consistent");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Data Identier - 'P' analysis corrected for AIAG application");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Data Identifier - 'D' (Date) format error checking corrected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Data Identifier - Value length checking for DIs 96S, 12E and REM implemented");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Data Identifier - Maximum size checks for DIs 15H and 96S corrected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Data Identifier - Check for invalid <space> character after the DI added");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Application Identifier - AIs 3nnn and 723 are correctly recognized");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Application Identifier - AI 7011 recognized as a valid AI");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: UPC-E with CC-A now grades both 1D and 2D portions of the symbol");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Blemish errors for Databar Expanded Stacked symbols fixed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: On-screen calibration results match calibration history");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Bar height calculations improved");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: MailMark software crash fixed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: MailMark module size checking enhanced");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: HIBC intermittent structure error eliminated");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: DMRE 8x144 decoding fixed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: GS1 - Incorrect AI warnings corrected");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", 'Resolved Defect: MIL-STD-130N - <R/S> in "07" formatted free text now identified as a terminator for the message envelope');
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: MIL-STD-130N - Application standard now identified as MIL-STD-130N1 to indicate that Change 1 is included");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: MIL-STD-130N - Parsing of a second message envelope correctly processed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: MIL-STD-130N - FNC1 in first position identified as an error");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: MIL-STD-130N - Issue with repeated DIs in the structure analysis fixed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Reported aperture agreement with x-dimension fixed");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.3021", "Resolved Defect: Erroneous 'Extraneous Error' report eliminated");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.4101

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.4101", #5-Feb-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4101", "Resolved Defect: Don't force F grade for GS1-128 codes with missing GS1 AI associations");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4101", "Resolved Defect: Do force F grade for GS1-128 codes with missing GS1 AI associations if composite code included");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4101", "Resolved Defect: Improve checking of final terminator bar and quiet zones for PDF and CC codes");
!LVS-848: White balance does not work for certain cameras
!LVS-859: Do force F Grade for GS1-128 codes with missing GS1 AI association if composite code included
!LVS-860: Improve checking of final terminator bar QZ's for PDF and CC codes
!LVS-861: Don't force F Grade for GS1-128 codes with missing GS1 AI association

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.4102

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.4102", #26-Feb-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4102", "Resolved Defect: Left RAP error in MicroPDF symbol causes the symbol to not decode");
!LVS-883: Left RAP error in MicroPDF symbol causes the symbol to not decode

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.4103

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.4103", #14-Mar-2024#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4103", 'Resolved Defect: Wrong CU values for 6.25" FOV');
Delete From Settings Where Category = "2DReflectance";
Update CalibrationSetup Set SmallSharpen = 50 Where FieldOfView > 6;
Update CalibrationSetup Set LargeSharpen = 55 Where FieldOfView > 6;
Create Table DeblurCorrection
(
    FieldOfView             Real,
	SampleSize              Integer,
	DeblurAttempts			Integer,
	DeblurIterations		Integer,
	DeblurFactor			Real,
	UnblurFactor			Real
);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, UnblurFactor) Values (6.25, 13, 1, 5, 1.00, 0.15);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.4104

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.4104", #21-Mar-2024#);
!Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4104", 'Resolved Defect: Wrong CU values for 6.25" FOV');
Update DeblurCorrection Set DeblurIterations = 4;

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.4105

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.4105", #4-Apr-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4105", "Resolved Defect: Improve Contrast Uniformity and Rmin conformance for symbols that don't include a 'dark widow' cell");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4105", "Resolved Defect: Add data rule checking for 17V");
Delete From DeblurCorrection;
Alter Table DeblurCorrection Add Column DeblurOffset Integer;
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (1.3,  13, 1, 5, 1.86, -3, 0.64);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (3.0,  11, 1, 4, 1.00,  0, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (4.0,  11, 1, 4, 1.00,  0, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (4.5,  11, 1, 4, 1.00, -5, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (6.25, 13, 1, 4, 1.00, -3, 0.15);
!LVS-884: Add data rule checking for 17V

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.4106

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.4106", #29-Apr-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4106", "Resolved Defect: Improve Contrast Uniformity and Rmin conformance");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.4106", "Resolved Defect: Make forcing the grade to 0 optional for missing AI associations");
Drop Table DeblurCorrection;
Create Table DeblurCorrection
(
    FieldOfView             Real,
	SampleSize              Integer,
	DeblurAttempts			Integer,
	DeblurIterations		Integer,
	DeblurFactor			Real,
	DeblurOffset            Real,
	UnblurFactor			Real
);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (1.3,  13, 1, 6, 1.91, -3.2, 0.49);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (3.0,  13, 1, 5, 0.66, -3.4, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (4.0,  11, 1, 5, 0.84,  1.0, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (4.5,  11, 1, 6, 0.73, -4.1, 0.03);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (6.25,  9, 1, 6, 0.81, -1.1, 0.14);
Insert Into Settings (Category, SettingName, SettingValue) Values ('GS1', 'EnforceAssociations', 0);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("EnforceAssociations", 0,  1);
!LVS-901: Modulation and Defects feature broken on Grading tab for QR codes
!LVS-908: Contrast Uniformity and Rmin compliance issues

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5101

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5101", #13-May-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.5101", "Resolved Defect: Restore GS1 syntax library warnings");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.5101", "Resolved Defect: Don't enforce optional 17V rules");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5102

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5102", #1-Jul-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.5.0.5102", "Resolved Defect: Report RDA failure on L pattern unless DPM");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5103

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5103", #2-Jul-2024#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5104

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5104", #7-Jul-2024#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5105

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5105", #9-Jul-2024#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5106

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5106", #18-Jul-2024#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.5.0.5107

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.5.0.5107", #24-Jul-2024#);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1001", #16-May-2024#);
Update ApplicationStandards Set Status = "0" Where ShortName = "ITF2";
Update Gs1Limits Set Symbology = "GS1 ITF-14" Where Symbology = "ITF-14";
!LVS-866: Clarify ITF and ITF-14 identification and reporting
!LVS-868: Make 'ITF including 2 digits' a hidden application standard option
!Upgrade to Visual Studio 2022
!Switch .dat and .sql files from UTF-16 to UTF-8
!Enhance Ctrl-Q automated testing functionality
!Eliminate unneeded Report##.bmp and Report##.jpg files

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1002", #3-Jun-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.6.0.1002", "Resolved Defect: Fix QR Code axial nonuniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.6.0.1002", "Resolved Defect: Fix QR Code grid nonuniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.6.0.1002", "Resolved Defect: Report QR Code contrast uniformity");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.6.0.1002", "Update to GS1 2024");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4330", 0, ""      , "Max temp in F");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4330", 1, "X6-7"  , "Max temp in F");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4331", 0, ""      , "Max temp in C");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4331", 1, "X6-7"  , "Max temp in C");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4332", 0, ""      , "Min temp in F");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4332", 1, "X6-7"  , "Min temp in F");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4333", 0, ""      , "Min temp in C");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("4333", 1, "X6-7"  , "Min temp in C");
!LVS-869 Comply with GS1 2024
!LVS-914 Grade FPD on QR Codes

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1003", #18-Jun-2024#);
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.6.0.1003", "Resolved Defect: Automatic logout causing Runtime Error 91");
Insert Into ReleaseDetails  (Version, Comment)     Values ("4.6.0.1003", "Resolved Defect: Days before calibration needed ignoring specified days");
!LVS-199: Days before calibration needed ignoring specified days
!LVS-882: Automatic logout causing Runtime Error 91
!LVS-951: Allow Factory Calibration without using Graph Paper

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1004", #27-Aug-2024#);
Update GS1TableOrder Set Symbology = "GS1 ITF-14" Where Symbology = "ITF-14";
Update GS1Limits Set Aperture = 12 Where SpecificationTable = 1 And Symbology = "GS1 Data Matrix";
Update GS1Limits Set Aperture = 12 Where SpecificationTable = 1 And Symbology = "GS1 QR Code";
Insert Into Settings (Category, SettingName, SettingValue) Values ('Grading', 'EnforceL1L2Score', '0');
Insert Into Settings (Category, SettingName, SettingValue) Values ('Grading', 'MinimumL1L2Score', '50');
Insert Into Settings (Category, SettingName, SettingValue) Values ('Grading', 'CCQuietZone', '100');
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("EnforceL1L2Score", 0, 1);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("CCQuietZone", 50, 100);
Delete From GS1Limits Where SpecificationTable = 2 And Symbology = "EAN-8";

Delete From DeblurCorrection;
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-1.3,  13, 1, 6, 1.91,  -3.2, 0.49);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-1.45, 11, 3, 4, 1.07, -25.3, 0.49);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-3.0,  13, 1, 5, 0.66,   5.3, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 3.0,  13, 1, 5, 0.66,  -3.4, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 4.0,  11, 1, 5, 0.84,   1.0, 0.06);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 4.5,  11, 1, 6, 0.73,  -4.1, 0.03);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 6.25,  9, 1, 6, 0.81,  -1.1, 0.14);

!LVS-939: Left side Quiet Zone check on Databar Limited not working
!LVS-948: Add ability to set/alter the inspection tolerance for QZ checking on CC-A
!LVS-952: GS1 Table 1 - 2D symbols effective aperture should be 12 mils
!LVS-953: EAN-8 symbology should not be allowed for GS1 Table 2
!LVS-954: Remove the GS1 Table 1.8200 application standard
!LVS-962: CU is out of tolerance for both 1.45 and 1.35
!LVS-964: Deblur values in the MDB need to change between the 3" 9510 and the 3" 9585
!LVS-967: MIL-STD-130 Quality Acceptance Criteria
!LVS-968: Add setting for the new L-Finder decode vs. RDA
!LVS-981: Create a new shortkey for Calibration Screen

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1005", #9-Sep-2024#);

Delete From GS1Limits Where SpecificationTable = 2 And Symbology = "ITF-14";
Insert Into GS1Limits 
(SpecificationTable, Symbology,    MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(2,                  "GS1 ITF-14", 0.495,   0.634,   31.75,               31.75,               10,        10,         1.5,             10,       0.0195,        0.025,         1.25,                      1.25);
Insert Into GS1Limits 
(SpecificationTable, Symbology,    MinXdim, MaxXdim, MinHeightForMinXdim, MinHeightForMaxXdim, MinLeftQZ, MinRightQZ, MinOverallGrade, Aperture, MinXdimInches, MaxXdimInches, MinHeightForMinXdimInches, MinHeightForMaxXdimInches) Values
(2,                  "GS1 ITF-14", 0.635,   1.016,   31.75,               31.75,               10,        10,         0.5,             20,       0.025,         0.04,          1.25,                      1.25);

!LVS-101: The PASS/FAIL criteria for those who select "Generate warning but don't change the grade..." is wrong
!LVS-222: LVS-95XX LDAP connections to Active Directory
!LVS-635: "AI (x) value is too long" structure error occur when alpha characters are combined with non-alphanumeric characters
!LVS-942: Auto-logoff software crash
!LVS-948: Add ability to set/alter the inspection tolerance for QZ checking on CC-A (allow 3 digits)
!LVS-947: Update DAT and FAQ0415.pdf files for the Polish language
!LVS-958: Calibrating while on a GS1 DPM table causes issues with grading
!LVS-978: LVS-95XX v4.5.0.4106 counts "<" twice when used in the GS1 AI (91)
!LVS-990: Aperture for ITF with Xdim greater than 0,635 mm (0.025)
!LVS-991: Unwanted User access on Setup Tab when Setup Tab permission is not provided

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1006", #17-Sep-2024#);

!LVS-948:  Add ability to set/alter the inspection tolerance for QZ checking on CC-A (new problem)
!LVS-998:  QR CODE ANU symbol #2 on Calibration Test Card does not read
!LVS-999:  QR Codes are not being graded accurately according to ISO
!LVS-1006: New TIS driver (33U) does not always load correctly
!LVS-1007: Need ability to detect video noise (dropped USB lines) during white balance

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1007", #17-Sep-2024#);

!LVS-721:  The Calibration Print button activates the Snipping Tool
!LVS-1005: QR codes without AI (8200) are passing with the GS1 Table 1 standard

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1008

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1008", #19-Sep-2024#);

!LVS-9:    Extend password expiration range to 365 days
!LVS-966:  Dome Lighting on 95xx report for imported images
!LVS-969:  Pass/Fail remains on report after switching back to Full ISO from Pass/Fail
!LVS-993:  ITF-14 not being reported correctly
!LVS-1001: Software does not accept 7-digit serial numbers when no camera is detected
!LVS-1008: Software fails to launch for Asian and Slavic languages

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1009

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1009", #23-Sep-2024#);

!LVS-940:  Extended area around symbol contains extremes of reflectance
!LVS-1007: Need ability to detect video noise (dropped USB lines) during white balance (improvement)

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.1010

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.1010", #11-Oct-2024#);

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7241";
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7242";
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8030";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7241", 0, ""      , "AIDC media type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7241", 1, "N2"    , "AIDC media type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7242", 0, ""      , "VCN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7242", 1, "X0-25" , "VCN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8030", 0, ""      , "Digital signature");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8030", 1, "X0-90" , "Digital signature");

!LVS-1023: ITF-14 symbols with 16.45 mils or less are not grading
!LVS-1026: GS1 2024 update: AI titles/descriptions are incorrect

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3001", #21-Oct-2024#);

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7241";
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7242";
Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8030";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7241", 0, ""      , "AIDC media type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7241", 1, "N2"    , "AIDC media type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7242", 0, ""      , "VCN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7242", 1, "X0-25" , "VCN");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8030", 0, ""      , "Digital signature");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8030", 1, "X0-90" , "Digital signature");

!LVS-216:  Software doesn't return to DPM (TR29158) application standard after restart'
!LVS-635:  "AI (x) value is too long" structure error occur when alpha characters are combined with non-alphanumeric characters
!LVS-958:  Calibrating while on a GS1 DPM table causes issues with grading
!LVS-965:  Change Renton Address on 95XX report
!LVS-967:  MIL-STD-130 Quality Acceptance Criteria
!LVS-993:  ITF-14 not being reported correctly (additional)
!LVS-998:  QR CODE ANU symbol #2 on Calibration Test Card does not read
!LVS-1005: QR codes without AI (8200) are passing with the GS1 Table 1 standard
!LVS-1024: Hide Defence Standard 05-132+UII in dongle code 9598 application standard masking
!LVS-1039: GS1-128 is failing as not valid for MIL-STD-130N1
!LVS-1040: Data Identifiers are not properly decoded for Code-128 symbology
!LVS-1041: Manufacturing address update for Verification Report
!LVS-1050: Micro QR Codes are giving incorrect GS1 warning flags
!LVS-1052: Structure Table listing part of the 25S UII string twice

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3002", #23-Oct-2024#);

!LVS-635:  "AI (x) value is too long" structure error occur when alpha characters are combined with non-alphanumeric characters
!LVS-965:  Change Renton Address on 95XX report
!LVS-1055: Incorrect GS1 AI error

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3003", #7-Nov-2024#);

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "03";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("03", 0, ""   , "Identification of a Made-to-Order (MtO) trade item (GTIN)");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("03", 1, "N14", "Identification of a Made-to-Order (MtO) trade item (GTIN)");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7041";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7041", 0, ""      , "UN/CEFACT freight unit type");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7041", 1, "X1-X14", "UN/CEFACT freight unit type");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "716";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("716",  0, ""      , "National Healthcare Reimbursement Number (NHRN) – Italy AIFA");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("716",  1, "X0-X20", "National Healthcare Reimbursement Number (NHRN) – Italy AIFA");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7250";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7250",  0, ""  , "Date of birth");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7250",  1, "D8", "Date of birth");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7251";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7251",  0, ""  ,  "Date and time of birth");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7251",  1, "D10", "Date and time of birth");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7252";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7252",  0, ""  , "Biological sex");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7252",  1, "N1", "Biological sex");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7253";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7253",  0, ""  ,    "Family name of person");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7253",  1, "X0-40", "Family name of person");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7254";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7254",  0, ""  ,    "Given name of person");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7254",  1, "X0-40", "Given name of person");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7255";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7255",  0, ""  ,    "Name suffix of person");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7255",  1, "X0-41", "Name suffix of person");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7256";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7256",  0, ""  ,    "Full name of person");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7256",  1, "X0-90", "Full name of person");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7257";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7257",  0, ""  ,    "Address of person");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7257",  1, "X0-90", "Address of person");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7258";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7258",  0, ""  , "Baby birth sequence indicator");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7258",  1, "N1", "Sequence of birth of the baby");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7258",  2, "X1", "Sequence seperator using solidus character");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7258",  3, "N1", "Total number of babies in the series");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "7259";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7259",  0, ""  ,    "Baby of family name");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("7259",  1, "X0-40", "Baby of family name");

Delete From ApplicationIdentifiers Where ApplicationIdentifier = "8014";
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8014",  0, ""  ,    "Highly Individualised Device Registration Identifier");
Insert Into ApplicationIdentifiers (ApplicationIdentifier, Element, Format, Description) Values ("8014",  1, "X0-25", "Highly Individualised Device Registration Identifier");

Update ApplicationIdentifiers Set Description = "UNECE Meat Carcasses and Cuts Classification" Where Description = "UN/ECE Meat Carcasses and Cuts Classification";

!LVS-958:  Calibrating while on a GS1 DPM table causes issues with grading
!LVS-1064: ITF-14 is incorrectly listing min X-dim for GS1 Table 2
!LVS-1075: EAN-13/EAN-8 fails to parse AI data
!LVS-1077: Add descriptions to the LVS-95XX database for 2025 GS1 Application Identifiers

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3004", #8-Nov-2024#);

Update ApplicationIdentifiers Set Description = "UNECE Meat Carcasses and Cuts Classification" Where ApplicationIdentifier = "7002";

Update ApplicationIdentifiers Set Format = "X1-9"  Where ApplicationIdentifier = "421"  And Element = 2;
Update ApplicationIdentifiers Set Format = "X1-20" Where ApplicationIdentifier = "716"  And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-4"  Where ApplicationIdentifier = "7041" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-25" Where ApplicationIdentifier = "7242" And Element = 1;
Update ApplicationIdentifiers Set Format = "D8-8"  Where ApplicationIdentifier = "7250" And Element = 1;
Update ApplicationIdentifiers Set Format = "D12"   Where ApplicationIdentifier = "7251" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-40" Where ApplicationIdentifier = "7253" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-40" Where ApplicationIdentifier = "7254" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-10" Where ApplicationIdentifier = "7255" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-90" Where ApplicationIdentifier = "7256" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-70" Where ApplicationIdentifier = "7257" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-40" Where ApplicationIdentifier = "7259" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-25" Where ApplicationIdentifier = "8014" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-90" Where ApplicationIdentifier = "8030" And Element = 1;
Update ApplicationIdentifiers Set Format = "X1-27" Where Format = "X0-27";

!LVS-958:  Calibrating while on a GS1 DPM table causes issues with grading
!LVS-1074: ITF-14 symbols failing structure analysis for ISO/IEC 15415/15416
!LVS-1077: Add descriptions to the LVS-95XX database for 2025 GS1 Application Identifiers
!LVS-1078: Data Identifiers incorrectly failing for missing spaces

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3005", #21-Nov-2024#);

Alter Table AppIdProperties Drop Column InvalidPairs;
Alter Table AppIdProperties Drop Column MandatoryPairs;

Update ApplicationIdentifiers Set Format = "D12-12" Where ApplicationIdentifier = "7251" And Element = 1;

!LVS-1077: Add descriptions to the LVS-95XX database for 2025 GS1 Application Identifiers
!LVS-1080: Update 0415.dat file for the Polish language
!LVS-1081: Remove "GS1" and "-14" for ITF symbology without the correct check digit
!LVS-1082: Auto-save fails when a slash is in the data string for MIL-STD-130N1 + UII
!LVS-1086: The EnforceAssociations setting does not effect GS1 invalid AI pairs

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3006", #22-Nov-2024#);

!Update CAM33 driver from 5.1.0.1719 to 5.2.0.2765

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.3007

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.3007", #13-Dec-2024#);

Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1008", "Extend password expiration range to 365 days");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1005", "The PASS/FAIL criteria for those who select Generate warning but don't change the grade... is wrong");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1003", 'LVS-958X DPM "Days before calibration needed" ignoring specified days');
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "Software doesn't return to DPM (TR29158) application standard after restart");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3002", '"AI (x) value is too long" structure error occur when alpha characters are combined with non-alphanumeric characters');
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1007", "The Calibration Print button activates the Snipping Tool. Allow user to print the calibration report");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3002", "To develop a way to update GS1 Library changes without the need to change software");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1001", "Clarify ITF and ITF-14 identification and reporting");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1002", "Comply with GS1 2024");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1003", "Automatic logout causing Runtime Error 91");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1007", "Add CU measurement for QR Code");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1002", "Grade FPD on QR Codes");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1004", "Left side Quiet Zone check on Databar Limited not working");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1009", "Extended area aroud symbol contains extremes of reflectance");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1005", "Auto-logoff software crash");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1005", "Update DAT and FAQ0415.pdf files for the Polish language");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1004", "GS1 Table 1 - 2D symbols effective aperture should be 12 mils");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1004", "EAN-8 symbology should not be allowed for GS1 Table 2");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "Remove the GS1 Table 1.8200 application standard");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3004", "Calibrating while on a GS1 DPM table causes issues with grading");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "Change Renton Address on 95XX report");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1008", "Dome Lighting on 95xx report for imported images");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1004", "MIL-STD-130 Quality Acceptance Criteria");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1008", "Pass/Fail remains on report after switching back to Full ISO from Pass/Fail");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1005", 'LVS-95XX v4.5.0.4106 counts "<" twice when used in the GS1 AI (91)');
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1005", 'Aperture for ITF with Xdim greater than 0,635 mm (0.025")');
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.1005", "Unwanted User access on Setup Tab when Setup Tab permission isn't provided");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "QR codes without AI (8200) are passing with the GS1 Table 1 standard");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "GS1-128 is failing as not valid for MIL-STD-130N1");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "Manufacturing address update for Verification Report");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "Micro QR Codes are giving incorrect GS1 warning flags");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3001", "Structure Table listing part of the 25S UII string twice");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3003", "ITF-14 is incorrectly listing min X-dim for GS1 Table 2");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3004", "Data Identifiers incorrectly failing for missing spaces");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3005", "Update 0415.dat file for the Polish language");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3005", 'Remove "GS1" and "-14" for ITF symbology without the correct check digit');
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3005", "Auto-save fails when a slash is in the data string for MIL-STD-130N1 + UII");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3005", "The EnforceAssociations setting does not effect GS1 invalid AI pairs");

Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3006", "Update CAM33 driver from 5.1.0.1719 to 5.2.0.2765");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", "The EnforceAssociations setting does not effect GS1 invalid AI pairs");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", "GS1-128 should not fail due to missing mandatory associations");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", "Memory Error crash when grading a QR Code");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", "QR Codes w/ AI (8200) are failing the GS1 Table 1 application standard");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", "The Software version history is missing content of the changes in v4.6");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", "If Table 1 is selected for GS1, QR Codes on other application standards fail");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.3007", 'Defence Standard is failing symbols with AI (7001) with "Required NSN (N) was missing"');

!LVS-1086: The EnforceAssociations setting does not effect GS1 invalid AI pairs
!LVS-1090: GS1-128 should not fail due to missing mandatory associations
!LVS-1091: Memory Error crash when grading a QR Code
!LVS-1092: QR Codes w/ AI (8200) are failing the GS1 Table 1 application standard
!LVS-1094: The Software version history is missing content of the changes in v4.6
!LVS-1095: If Table 1 is selected for GS1, QR Codes on other application standards fail
!LVS-1096: Defence Standard is failing symbols with AI (7001) with "Required NSN (N) was missing"

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.4001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.4001", #12-Jun-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4001", "Rmin/Rmax drastically increased for 1D symbols in 4.6.0.3007");
!LVS-1122: Rmin/Rmax drastically increased for 1D symbols in 4.6.0.3007

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.4002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.4002", #17-Jun-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4002", "Modulation is too low for HD systems");
!LVS-1151: Modulation is too low for HD systems

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.4003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.4003", #18-Jun-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4003", "Fix remnant DAT files will cause a UTF-8 fatal error");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4003", "Change TEI PNO and PNR MaxSize to 32 characters");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4003", "Fix inline update to LVS-95XX v4.6.0.3007 breaks existing SQL server connection");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4003", "Fix a Code 128 symbol is producing GS1 warning flags");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4003", "Fix GS1 application standard fails to grade 2D symbols");

Update DataIdentifiers Set MaxSize = 32 Where DataIdentifier = "PNO";
Update DataIdentifiers Set MaxSize = 32 Where DataIdentifier = "PNR";
Update DataIdentifiers Set CharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-/" Where DataIdentifier = "PNO";

!LVS-1114: Remnant DAT files will cause a UTF-8 fatal error
!LVS-1119: Change TEI PNO and PNR MaxSize to 32 characters
!LVS-1121: Inline update to LVS-95XX v4.6.0.3007 breaks existing SQL server connection
!LVS-1128: A Code 128 symbol is producing GS1 warning flags
!LVS-1144: GS1 application standard fails to grade 2D symbols

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.4004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.4004", #18-Jun-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4004", "Additional fix GS1 application standard fails to grade 2D symbols");
!LVS-1144: GS1 application standard fails to grade 2D symbols

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.4005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.4005", #20-Jun-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4005", "Remove obsolete files");
!LVS-1152: Extra files are in the installation folder

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.6.0.4006

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.6.0.4006", #3-Jul-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4006", "Fix issue with incorrect deblur values being used");
Insert Into ReleaseDetails (Version, Comment) Values ("4.6.0.4006", "Fix Data Matrix Calibration Card grading is too high for R-max");
Delete From DeblurCorrection Where FieldOfView = -1.45;
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-1.45, 13, 1, 6, 1.91, -3.2, 0.49);
!LVS-1154: Data Matrix Calibration Card grading is too high for R-max

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.0.1001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.0.1001", #3-Sep-2025#);

Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Implement new 1D threshold algorithm from ISO IEC 15416 (2025)");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Implement new Rmin and Rmax algorithm from ISO IEC 15416 (2025)");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Implement new decimal grading algorithm from ISO IEC 15416 (2025)");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 15415:2024 continuous (or decimal) grading");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 15415:2024 more optimal threshold calculation");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 15415:2024 more stable symbol contrast calculation");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 15415:2024 print growth grading");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 15415:2024 combine modulation and reflectance margin");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 15415:2024 remove 20Z extreme reflectance check");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Change Contrast Uniformity to only include data cells and not fixed pattern cells");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "ISO/IEC 16022 ed 3: Implement transition ratio grading cutoffs");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Fix decimal grading for FPD and related parameters");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Add Threshold parameter to the Verification Report for DM and QR codes");
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1001", "Feature to disable all photo corrections");

Update AllowedUserChanges Set MinValue = 0 Where SettingName = "ReportImageReduction";
Delete From Settings Where SettingName = "Legacy2DGradingScale";
Delete From Settings Where SettingName = "Strict15415IntegerGrading";
Update Glossary Set Description = "The global threshold (GT) is roughly half-way between the minimum (Rmin) and the maximum (Rmax).  Older specifications used the exact half-way point.  Newer specification use a more sophisticated algorithm to find the best threshold to use." Where Entry =  "GT";
Update Glossary Set Description = "This is roughly the largest reflectance value seen throughout the barcode.  Older specifications used the extreme value.  New specifications ignore the most extreme 3% (for 1D) or 1% (for 2D)." Where Entry = "Rmax";
Update Glossary Set Description = "This is roughly the smallest reflectance value seen throughout the barcode.  Older specifications used the extreme value.  New specifications ignore the most extreme 3% (for 1D) or 1% (for 2D)." Where Entry = "Rmin";
Update Glossary Set Description = "0.06->4.0 0.095->3.0 0.13->2.0 0.16.5->1.0^This is the Transition Ratio.  This is the worst value seen for the entire symbol." Where Entry = "TR";
Update Glossary Set Description = "This is the Average Grade, which is the truncated average of the following 5 values: L1, L2, QZL1, QZL2, and OCTASA." Where Entry = "AG";
Insert Into Glossary (Entry, Description) Values
(
    "DFPD",
    "This is Distributed Fixed Pattern Damage.  This is somewhat harsher than the average grade."
);
Update CalibrationSetup Set SmallSharpen = 40 Where FieldOfView = 4.5;
Update CalibrationSetup Set SmallApertureScaling = 1 Where FieldOfView = 4.5;
Update CalibrationSetup Set LargeApertureScaling = 1 Where FieldOfView = 4.5;
Insert Into Settings (Category, SettingName, SettingValue) Values ("Grading", "UseGTforGrowth", 0);

Delete From DeblurCorrection;
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 0.97, 0, 0, 0, 0.00,  0.0, 0.00);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-1.45, 0, 1, 5, 0.60,  0.0, 0.80);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 1.75, 0, 1, 5, 0.18, -1.6, 0.85);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-3.0,  0, 1, 8, 0.61,  2.2, 0.16);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 3.0,  0, 1, 8, 0.43, -0.9, 0.28);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 4.0,  0, 1, 8, 0.38, -2.6, 0.52);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 4.5,  0, 1, 8, 0.41, -1.9, 0.26);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values ( 6.25, 0, 1, 3, 1.21, -4.0, 0.00);

!LVS-421:  Audit Trail Report duplicates SQL queries
!LVS-1065: QR Codes w/ ANU distortion is failing to read when rotated to 90 and 270 degrees
!LVS-1102: Modulation and Defects are too high with latest camera
!LVS-1104: Software saves calibration values when no barcode is present
!LVS-1131: Add Threshold parameter to the Verification Report for DM and QR codes
!LVS-1134: Feature to disable all photo corrections
!LVS-1150: ISO/IEC 15415/15416 (with 15434 DIs) uses the incorrect aperture for grading EAN/UPC symbols
!LVS-1158: Use of FNC1 in Digital Link Symbols

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.0.1002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.0.1002", #10-Sep-2025#);

Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1002", "Fix missing multi-sector report");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1002", "Repair broken Control Sequence");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1002", "4-State Barcode reads under previous 95XX software no longer reads");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.1002", "Customer requests control over Auto-Save option");

!LVS-602:  Multi-sector report missing
!LVS-1160: Repair broken Control Sequence
!LVS-1172: 4-State Barcode reads under previous 95XX software no longer reads
!LVS-1178: Customer requests control over Auto-Save option

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.0.2001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.0.2001", #30-Sep-2025#);
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.2001", 'Sharpen values for the LVS-9510 1.75" FOV is still set at 90 for Large');
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.2001", "Rmax/Rmin are at extremes after an upgrade for new cameras");
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.2001", "Rmax and contrast differ widely for the new and old cameras on the HD units");
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.2001", 'The 1.45" FOV (new camera) is not using the correct sharpen values');

Update Settings Set SettingName = "UseGTforEdges" Where SettingName = "Strict 15415:2024";
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("Strict 15415:2024", 0, 1);
Update CalibrationSetup Set LargeSharpen = 50 Where FieldOfView =  1.75;
Update DeblurCorrection Set DeblurOffset = 6  Where FieldOfView = -1.45;
Insert Into CalibrationSetup (FieldOfView, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize, LightingMode, CameraModel) Values (1.45, 10, 0.95, 1.00, 70, 65, 6.0, 13.0, 9, 0, 9585);
Insert Into CalibrationSetup (FieldOfView, Exposure, SmallApertureScaling, LargeApertureScaling, SmallSharpen, LargeSharpen, SmallXdim, LargeXdim, MatrixSize, LightingMode, CameraModel) Values (1.45, 10, 0.95, 1.00, 70, 65, 6.0, 13.0, 9, 6, 9585);
!Update Calibration Set DigitalGain  = 1    Where MilsPerPixel > 0.54 And MilsPerPixel < 0.58;
!Update Calibration Set DigitalGain  = 0.93 Where MilsPerPixel > 0.54 And MilsPerPixel < 0.58 And LightingMode = 6;
!Update Calibration Set DigitalShift = 0    Where MilsPerPixel > 0.54 And MilsPerPixel < 0.58;

!LVS-1154: Data Matrix Calibration Card grading is too high for R-max
!LVS-1166: Sharpen values for the LVS-9510 1.75" FOV is still set at 90 for Large
!LVS-1206: Rmax/Rmin are at extremes after an upgrade for new cameras
!LVS-1210: Rmax and contrast differ widely for the new and old cameras on the HD units
!LVS-1212: The 1.45" FOV (new camera) is not using the correct sharpen values

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.0.2002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.0.2002", #7-Oct-2025#);
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.2002", 'Adjust 1.45" HD dome correction');
Delete From DeblurCorrection Where FieldOfView = -1.3;
Delete From DeblurCorrection Where FieldOfView = -1.45;
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-1.3,  0, 1, 6, 1.91,  -3.2, 0.49);
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (-1.45, 0, 1, 7, 0.61,  -3.2, 0.62);

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.0.5001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.0.5001", #9-Oct-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.0.5001", "Rebrand 4.7.0.5001");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.3001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.3001", #20-Oct-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", "Rebrand 4.7.1.3001");
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", "Print Growth is causing MaxiCode symbols to fail");
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", 'Rmin noticeably lower on the 3" FOV handhelds');
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", 'Primary Reference Symbols defect card 17 failing for the 4.5" FOV w/ legacy cameras');
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", "Imported images are using the incorrect sharpen values");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", "Upgrade to 29158:2025");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3001", "Hide required AI warning flags for GS1-128");

Update AllowedUserChanges Set MaxValue = 2 Where SettingName = "EnforceAssociations";
Update ApplicationStandards Set LongName="DPM (ISO/IEC 29158)" Where ShortName="DPM";
Update DeblurCorrection Set DeblurOffset = 4.7 Where FieldOfView = -3;
Update CalibrationSetup Set SmallApertureScaling = 0.85 Where FieldOfView = 4.5;
Update CalibrationSetup Set LargeApertureScaling = 0.85 Where FieldOfView = 4.5;
Update CalibrationSetup Set LargeSharpen = 50 Where FieldOfView = 4.5;
Delete From Settings Where SettingName = "UseGTforGrowth";
Delete From AllowedUserChanges Where SettingName = "Legacy2DGradingScale";
Delete From AllowedUserChanges Where SettingName = "Strict15415IntegerGrading";

!LVS-1202: Hide required AI warning flags for GS1-128
!LVS-1227: Print Growth is causing MaxiCode symbols to fail
!LVS-1228: Rmin noticeably lower on the 3" FOV handhelds
!LVS-1229: Primary Reference Symbols' defect card 17 failing for the 4.5" FOV w/ legacy cameras
!LVS-1230: Imported images are using the incorrect sharpen values

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.3002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.3002", #23-Oct-2025#);
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3002", "Rmax/Rmin are at extremes after an upgrade for new cameras");
!Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3002", "Rmax and contrast differ widely for the new and old cameras on the HD units");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3002", 'Unable to calibrate the 1.45" FOV verifiers in French');

!LVS-1206: Rmax/Rmin are at extremes after an upgrade for new cameras
!LVS-1210: Rmax and contrast differ widely for the new and old cameras on the HD units
!LVS-1233: Unable to calibrate the 1.45" FOV verifiers in French

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.3003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.3003", #3-Nov-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3003", "Rename 2D GT to be Threshold");
Insert Into Glossary (Entry, Description) Values
(
    "Threshold",
    "The threshold (formerly called GT or global threshold) is roughly half-way between the minimum (Rmin) and the maximum (Rmax).  The exact value depends on the distribution of pixel values."
);
Delete From Settings Where SettingName = "Strict 15415:2024";
Delete From AllowedUserChanges Where SettingName = "Strict 15415:2024";
Insert Into Settings (Category, SettingName, SettingValue) Values ("Grading", "Use15416ForPrintGrowth", 0);
Insert Into AllowedUserChanges (SettingName, MinValue, MaxValue) Values ("Use15416ForPrintGrowth", 0, 1);

!LVS-1237: DPM grading performance degradation

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.3004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.3004", #7-Nov-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3004", "Remove unnecessary warning messages");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3004", "Update manuals and FAQs");

!LVS-1241: Remove unnecessary warning messages

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.3005

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.3005", #21-Nov-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.3005", "Fix crash while attempting to grade certain QR Codes");

!LVS-1249: Crash while attempting to grade QR Codes

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.4001

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.4001", #1-Dec-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4001", "ISO/IEC application standard no longer giving warnings for 1D GS1 symbols");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4001", "Quiet Zone warning flags not present for some FPMAJ symbols");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4001", "Add broadband light temperature in the Overall Grade section of the Grading Tab");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4001", 'The Digital Link parameter should show "FAIL" for failing symbols');
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4001", "Reactivate EnforceAssociations for GS1 except for GS1-128 symbols");

Delete From Glossary Where Entry = "X Print Growth";
Delete From Glossary Where Entry = "Y Print Growth";
Insert Into Glossary (Entry, Description) Values ("PG-X", "Print growth (PG) tests that the graphical features comprising the symbol have not grown or shrunk from its nominal state.  PG-X measures the horizontal.");
Insert Into Glossary (Entry, Description) Values ("PG-Y", "Print growth (PG) tests that the graphical features comprising the symbol have not grown or shrunk from its nominal state.  PG-Y measures the vertical.");

Update Settings Set SettingValue = 4 Where SettingName = "EnforceAssociations";
Update AllowedUserChanges Set MaxValue = 4 Where SettingName = "EnforceAssociations";

!LVS-1244: ISO/IEC application standard no longer giving warnings for 1D GS1 symbols
!LVS-1245: Quiet Zone warning flags not present for some FPMAJ symbols
!LVS-1246: Add broadband light temperature in the Overall Grade section of the Grading Tab
!LVS-1247: The Digital Link parameter should show "FAIL" for failing symbols
!LVS-1255: Reactivate EnforceAssociations for GS1 except for GS1-128 symbols

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.4002

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.4002", #3-Dec-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4002", "Update translation files");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.4003

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.4003", #8-Dec-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4003", 'Correct 4.5" camera settings');
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4003", "Correct error in FPD computation");
Delete From DeblurCorrection Where FieldOfView = 4.5;
Insert Into DeblurCorrection (FieldOfView, SampleSize, DeblurAttempts, DeblurIterations, DeblurFactor, DeblurOffset, UnblurFactor) Values (4.5, 0, 1, 5, 1.08, -3.5, 0.17);

!LVS-1271: ISO/IEC 15415/15416 (with 15434 DIs) and ISO/IEC 15415/15416 using incorrect Aperture
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4002", "Update translation files");

!--------------------------------------------------------------------------------------------------------------------------------

VERSION     4.7.1.4004

Insert Into ReleaseVersions (Version, ReleaseDate) Values ("4.7.1.4004", #11-Dec-2025#);
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4004", "Correct 2D grade interpolation error when grade < 1.0");
Insert Into ReleaseDetails (Version, Comment) Values ("4.7.1.4004", "Correct incorrect scaling for 2D UEC");

!LVS-1272: Print Growth above 40% is getting a 0.0 grade
!LVS-1274: Verify the accuracy of Modulation in relation to UEC
